<?php

/**
 * PHP versions 4 and 5
 *
 * LICENSE: This source file is subject to version 3.0 of the PHP license
 * that is available through the world-wide-web at the following URI:
 * http://www.php.net/license. If you did not receive a copy of
 * the PHP License and are unable to obtain it through the web, please
 * send a note to license@php.net so we can mail you a copy immediately.
 *
 * @category   Safety
 * @package    QT-registrations
 * @author     Philippe Vandenberghe <info@qt-cute.org>
 * @copyright  2008-2012 The PHP Group
 * @version    2.1 build:20090416
 * @link       http://www.qt-cute/doc/package/qtg
 * @since      File available since Release 1.0.0
 * @deprecated File deprecated in Release 3.0.0
 */

session_start();
require_once('bin/qtr_init.php');
include(Translate('qtr_adm.php'));
if ( $oVIP->role!='A' ) die($L['E_admin']);

// INITIALISE

$strVersion='v2.1';
$oVIP->selfurl = 'qtrm_import_xml_install.php';
$oVIP->selfname = 'Installation module IMPORT QTR '.$strVersion;

$bStep1 = true;
$bStep2 = true;

// STEP 1

if ( empty($error) )
{
  $strFile = 'qtrm_import_xml_adm.php';
  if ( !file_exists($strFile) ) $error="Missing file: $strFile. Check installation instructions.<br/>This module cannot be used.";
  if ( !empty($error) ) $bStep1 = false;
}

// STEP 2

if ( empty($error) )
{
  $oDB->Query('DELETE FROM '.TABSETTING.' WHERE param="module_import_xml"');
  $oDB->Query('INSERT INTO '.TABSETTING.' (param,setting) VALUES ("module_import_xml","Import xml")');
}

// --------
// Html start
// --------

include('qtr_adm_p_header.php');

echo '
<h1>',$oVIP->selfname,'</h1>
';

echo '<h2>Checking components</h2>';
if ( !$bStep1 )
{
  echo '<p class="error">',$error,'</p>';
  include('qtr_adm_p_footer.php');
  exit;
}
echo '
<p>Ok</p>
<h2>Database settings</h2>
<p>Ok</p>
<h2>Installation completed</h2>
';

include('qtr_adm_p_footer.php');

?>
