<?php

/*
 * PHP versions 4 and 5
 *
 * LICENSE: This source file is subject to version 3.0 of the PHP license
 * that is available through the world-wide-web at the following URI:
 * http://www.php.net/license. If you did not receive a copy of
 * the PHP License and are unable to obtain it through the web, please
 * send a note to license@php.net so we can mail you a copy immediately.
 *
 * @category   Safety
 * @package    QT-registrations
 * @author     Philippe Vandenberghe <info@qt-cute.org>
 * @copyright  2008-2012 The PHP Group
 * @license    http://www.php.net/license  PHP License 3.0
 * @version    2.1 build:20090416
 * @link       http://www.qt-cute/doc/package/qtr
 * @since      File available since Release 1.0.0
 * @deprecated File deprecated in Release 3.0.0
 *
 */

session_start();
require_once('bin/qtr_init.php');
include(Translate('qtr_adm.php'));
include(Translate('qtrm_import_xml.php'));
if ( $oVIP->role!='A' ) die($L['E_admin']);

// FUNCTIONS

function startElement($parser, $strTag, $arrTagAttr) 
{
  $strTag = strtolower($strTag);
  global $arrTopic,$arrPosts,$arrDatas,$arrDocs;
  global $t,$p,$f,$ft,$d,$L;
  
  switch($strTag)
  {
  case 'topic':
    $arrTopic = array();
    $arrPosts = array();
    $arrDatas = array();
    $arrDocs  = array();
    if ( isset($arrTagAttr['ID']) ) { $t=intval($arrTagAttr['ID']); } else { $t=0; }
    $arrTopic['id'] = $t;
    $arrTopic['type'] = (isset($arrTagAttr['TYPE']) ? $arrTagAttr['TYPE'] : 'T');
    break;
  case 'post':
    if ( isset($arrTagAttr['ID']) ) { $p=intval($arrTagAttr['ID']); } else { $p=0; }
    $arrPosts[$p] = array();
    $arrPosts[$p]['id'] = $p;
    $arrPosts[$p]['type'] = (isset($arrTagAttr['TYPE']) ? $arrTagAttr['TYPE'] : 'P');
    break;
  case 'data':
    $f = strtolower($arrTagAttr['ID']);
    $ft = strtolower($arrTagAttr['TYPE']);
    break;
  case 'doc':
    $d++;
    $arrDocs[$d] = array();
    break;
  }
}
function characterData($parser, $data) 
{
  global $strValue;
  $strValue = $data;
}
function endElement($parser, $strTag) 
{
  $strTag = strtolower($strTag);

  global $arrTopic,$arrPosts,$arrDatas,$arrDocs,$arrFieldDest,$arrAllTabs,$arrAllFields;
  global $t,$p,$f,$ft,$d,$intTopicInsertId,$intPostInsertId;
  global $strValue;
  global $oDB;

  switch($strTag)
  {
  case 'x':         $arrTopic['x']=$strValue; break;
  case 'y':         $arrTopic['y']=$strValue; break;
  case 'z':         $arrTopic['z']=$strValue; break;
  case 'tags':      if ( !$_SESSION['m_import_xml']['droptags'] ) { $arrTopic['tags']=$strValue; } break;
  case 'eventdate': $arrTopic['eventdate']=$strValue; break;
  case 'wisheddate':$arrTopic['wisheddate']=$strValue; break;
  case 'firstpostdate': if ( $_SESSION['m_import_xml']['dropdate'] ) { $arrTopic['firstpostdate']=date('Ymd His'); } else { $arrTopic['firstpostdate']=$strValue; } break;
  case 'lastpostdate': if ( $_SESSION['m_import_xml']['dropdate'] ) { $arrTopic['lastpostdate']=date('Ymd His'); } else { $arrTopic['lastpostdate']=$strValue; } break;
  
  case 'icon':     $arrPosts[$p]['icon']=$strValue; break;
  case 'title':    $arrPosts[$p]['title']=$strValue; break;
  case 'userid':   $arrPosts[$p]['userid']=$strValue; break;
  case 'username': $arrPosts[$p]['username']=$strValue; break;
  case 'issuedate':if ( $_SESSION['m_import_xml']['dropdate'] ) { $arrPosts[$p]['issuedate']=date('Ymd His'); } else { $arrPosts[$p]['issuedate']=$strValue; } break;
  case 'modifdate':$arrPosts[$p]['modifdate']=$strValue; break;
  case 'modifuser':$arrPosts[$p]['modifuser']=$strValue; break;
  case 'modifname':$arrPosts[$p]['modifname']=$strValue; break;
  case 'textmsg':  $arrPosts[$p]['textmsg']=$strValue; break;  
  case 'posts':    $arrTopic['posts']=$arrPosts; break;

  case 'data':     $arrDatas[$f]['value']=$strValue;
                   $arrDatas[$f]['tabid']=$ft;
                   break;
  case 'datas':    $arrTopic['datas']=$arrDatas; break;
  
  case 'docdate':  $arrDocs[$d]['docdate']=$strValue; break;
  case 'docname':  $arrDocs[$d]['docname']=$strValue; break;
  case 'docpath':  $arrDocs[$d]['docpath']=$strValue; break;
  case 'docfile':  $arrDocs[$d]['docfile']=$strValue; break;
  case 'docs':     $arrTopic['docs']=$arrDocs; break;

  case 'topic': 

    // Process topic
      
    $oTopic = new cTopic($arrTopic);
    $oTopic->section = $_SESSION['m_import_xml']['dest'];
    $oTopic->id = $intTopicInsertId; $intTopicInsertId++;
    $oTopic->status = $_SESSION['m_import_xml']['status'];
    
    $oTopic->InsertTopic(false,false,false);
    
    // Process posts

    foreach ($arrTopic['posts'] as $arrPost)
    {
      $oPost = new cPost($arrPost); if ( $_SESSION['m_import_xml']['dropreply'] && $oPost->type!='P' ) break;
      $oPost->id = $intPostInsertId; $intPostInsertId++;
      $oPost->topic = $oTopic->id;
      $oPost->section = $_SESSION['m_import_xml']['dest'];
      if ( $_SESSION['m_import_xml']['dropbbc'] ) $oPost->text = QTbbc($oPost->text,'drop');
      
      $oPost->InsertPost(false);
    }
    
    UpdateSectionStats($_SESSION['m_import_xml']['dest'],false,true);

    // Process data

    if ( !$_SESSION['m_import_xml']['dropdata'] )
    {
      foreach ($arrTopic['datas'] as $strKey=>$arrData ) //$strValue)
      {
        // import data

        $oDB->Query( 'INSERT INTO '.TABDATA.' (id,tabid,fieldid,fieldvalue,fielddate,fielduserid,fieldusername) VALUES ('.$oTopic->id.',"'.$arrData['tabid'].'","'.$strKey.'","'.$arrData['value'].'","'.date('Ymd His').'",1,"Imported data")' );

        // create tab (if required)

        if ( !isset($arrAllTabs[$arrData['tabid']]) ) 
        {
          cTab::Add(-1,$arrData['tabid']);
          $arrAllTabs[$arrData['tabid']] = $arrData['tabid'];
        }

        // create field in tab (if required)

        if ( !isset($arrAllFields[$strKey]) ) 
        {
          cField::Add($arrData['tabid'],$strKey);
          $arrAllFields[$strKey] = $strKey;
        }

      }
    }
    
    // Process docs
    
    if ( !$_SESSION['m_import_xml']['dropdocs'] )
    {
      foreach ($arrTopic['docs'] as $arr)
      {
        if ( isset($arr['docfile']) && isset($arr['docpath']) ) {
        if ( !empty($arr['docfile']) && !empty($arr['docpath']) ) {
          if ( !isset($arr['docdate']) ) $arr['docdate']='0';
          if ( !isset($arr['docname']) ) $arr['docname']=$arr['docfile'];
          if ( empty($arr['docname']) ) $arr['docname']=$arr['docfile'];
          $oDB->Query( 'INSERT INTO '.TABDOC.' (id,docdate,docname,docfile,docpath) VALUES ('.$oTopic->id.',"'.$arr['docdate'].'","'.$arr['docname'].'","'.$arr['docfile'].'","'.$arr['docpath'].'")' );
        }}
      }
    }
    
    break;

  default:
    if ( trim($strValue)!='' ) $arrTopic[$strTag]=$strValue;
    break;
  }
}

// INITIALISE

$intDest   = -1;
$strStatus = 'Z';
$bDropbbc  = false;
$bDropdata = false;
$bDropdocs = false;
$bDropreply= false;
$bDroptags = false;
$bDropdate = false;

$oVIP->selfurl = 'qtrm_import_xml_adm.php';
$oVIP->selfname = $L['import_xml']['Admin'];
$oVIP->exiturl = $oVIP->selfurl;
$oVIP->exitname = $oVIP->selfname;
$strPageversion = $L['import_xml']['Version'].' 2.1';

// --------
// SUBMITTED
// --------

if ( isset($_POST['ok']) )
{
  // check file
  
  if (!is_uploaded_file($_FILES['title']['tmp_name'])) $error = $L['import_xml']['E_nofile'];

  // check form value
  
  if ( empty($error) )
  {
    if ( isset($_POST['dropbbc']) ) $bDropbbc=true;
    if ( isset($_POST['dropdata']) ) $bDropdata=true;
    if ( isset($_POST['dropdocs']) ) $bDropdocs=true;
    if ( isset($_POST['dropreply']) ) $bDropreply=true;
    if ( isset($_POST['droptags']) ) $bDroptags=true;
    if ( isset($_POST['dropdate']) ) $bDropdate=true;
    $intDest = intval($_POST['section']);
    $strStatus = $_POST['status'];
    $_SESSION['m_import_xml']=array('dest'=>$intDest,'status'=>$strStatus,'dropbbc'=>$bDropbbc,'dropdata'=>$bDropdata,'dropdocs'=>$bDropdocs,'dropreply'=>$bDropreply,'droptags'=>$bDroptags,'dropdate'=>$bDropdate);
  }

  // check format

  if ( empty($error) )
  {
    if ( $_FILES['title']['type']!='text/xml' )
    {
    $error = $L['import_xml']['E_format'];
    unlink($_FILES['title']['tmp_name']);
    }
  }

  // import xml
  
  if ( empty($error) )
  {
    $arrTopic = array();
    $arrPosts = array();
    $arrDatas = array();
    $arrDocs = array();
    $arrAllTabs = array_keys(GetSectionTabs(-1));
    $arrAllFields = cTab::GetFields($oDB);
    $t = 0;
    $p = 0;
    $f = '0'; $ft='untitled';
    $d = 0;
    $strValue = '';
    $intTopicInsertId = Nextid(TABTOPIC);
    $intPostInsertId = Nextid(TABPOST);

    $arrFieldDest = array();
    $oDB->Query('SELECT fieldid,tabid FROM '.TABFIELD);
    while($row=$oDB->Getrow()) { $arrFieldDest[$row['fieldid']] = $row['tabid']; }

    $xml_parser = xml_parser_create();
    xml_parser_set_option($xml_parser, XML_OPTION_CASE_FOLDING, true);
    xml_set_element_handler($xml_parser, 'startElement', 'endElement');
    xml_set_character_data_handler($xml_parser, 'characterData');
    if ( !($fp = fopen($_FILES['title']['tmp_name'],'r')) ) die('could not open XML input');
    while ($data = fread($fp,4096))
    {
      if ( !xml_parse($xml_parser, $data, feof($fp)) ) die(sprintf('XML error: %s at line %d', xml_error_string(xml_get_error_code($xml_parser)), xml_get_current_line_number($xml_parser)));
    }
    xml_parser_free($xml_parser);
  }

  if ( empty($error) )
  {
    unlink($_FILES['title']['tmp_name']);
    $oVIP->EndMessage(NULL,$L['import_xml']['S_import'],'admin',0);
  }
}

// --------
// HTML START
// --------

$strHeadScript = '
<script type="text/javascript">
<!--
function ValidateForm(theForm)
{
  if (theForm.title.value.length==0) { alert("'.$L['E_mandatory'].': File"); return false; }
  return null;
}
-->
</script>
';
include('qtr_adm_p_header.php');
include('qtr_adm_p_title.php');

if ( isset($_SESSION['m_import_xml']['dest']) )      $intDest   = $_SESSION['m_import_xml']['dest'];
if ( isset($_SESSION['m_import_xml']['status']) )    $strStatus = $_SESSION['m_import_xml']['status'];
if ( isset($_SESSION['m_import_xml']['dropbbc']) )   $bDropbbc  = $_SESSION['m_import_xml']['dropbbc'];
if ( isset($_SESSION['m_import_xml']['dropdata']) )  $bDropdata = $_SESSION['m_import_xml']['dropdata'];
if ( isset($_SESSION['m_import_xml']['dropdocs']) )  $bDropdocs = $_SESSION['m_import_xml']['dropdocs'];
if ( isset($_SESSION['m_import_xml']['dropreply']) ) $bDropreply= $_SESSION['m_import_xml']['dropreply'];
if ( isset($_SESSION['m_import_xml']['droptags']) )  $bDroptags = $_SESSION['m_import_xml']['droptags'];
if ( isset($_SESSION['m_import_xml']['dropdate']) )  $bDropdate = $_SESSION['m_import_xml']['dropdate'];


echo '<form method="post" action="',$oVIP->selfurl,'" enctype="multipart/form-data" onsubmit="return ValidateForm(this);">
<input type="hidden" name="maxsize" value="5242880"/>
<table class="data_o" cellspacing="0">
';
echo '<tr class="data_o">
<td class="th_o th_o_all" colspan="2">',$L['import_xml']['File'],'</td>
</tr>
';
echo '<tr class="data_o">
<td class="th_o th_o_first" style="width:200px"><label for="title">',$L['import_xml']['File'],'</label></td>
<td class="td_o"><input type="file" id="title" name="title" size="32"/></td>
</tr>
';
echo '<tr class="data_o">
<td class="th_o th_o_all" colspan="2">',$L['import_xml']['Content'],'</td>
</tr>
';
echo '<tr class="data_o">
<td class="th_o th_o_first">',$L['import_xml']['Drop_tags'],'</td>
<td class="td_o"><input type="checkbox" id="droptags" name="droptags"',($bDroptags ? QCHE : ''),'/> <label for="droptags">',$L['import_xml']['HDrop_tags'],'</label></td>
</tr>
';
echo '<tr class="data_o">
<td class="th_o th_o_first">',$L['import_xml']['Drop_data'],'</td>
<td class="td_o"><input type="checkbox" id="dropdata" name="dropdata"',($bDropdata ? QCHE : ''),'/> <label for="dropdata">',$L['import_xml']['HDrop_data'],'</label></td>
</tr>
';
echo '<tr class="data_o">
<td class="th_o th_o_first">',$L['import_xml']['Drop_doc'],'</td>
<td class="td_o"><input type="checkbox" id="dropdocs" name="dropdocs"',($bDropdocs ? QCHE : ''),'/> <label for="dropdocs">',$L['import_xml']['HDrop_doc'],'</label></td>
</tr>
';
echo '<tr class="data_o">
<td class="th_o th_o_first">',$L['import_xml']['Drop_reply'],'</td>
<td class="td_o"><input type="checkbox" id="dropreply" name="dropreply"',($bDropreply ? QCHE : ''),'/> <label for="dropreply">',$L['import_xml']['HDrop_reply'],'</label></td>
</tr>
';
echo '<tr class="data_o">
<td class="th_o th_o_first">',$L['import_xml']['Drop_bbc'],'</td>
<td class="td_o"><input type="checkbox" id="dropbbc" name="dropbbc"',($bDropbbc ? QCHE : ''),'/> <label for="dropbbc">',$L['import_xml']['HDrop_bbc'],'</label></td>
</tr>
';
echo '<tr class="data_o">
<td class="th_o th_o_all" colspan="2">',$L['Destination'],'</td>
</tr>
';
echo '<tr class="data_o">
<td class="th_o th_o_first" style="width:200px"><label for="section">',$L['import_xml']['Destination'],'</label></td>
<td class="td_o"><select id="section" name="section">',QTastags(GetSectionTitles('A'),null,$intDest),'</select> <a href="qtr_adm_sections.php">',$L['Section_add'],'</a></td>
</tr>
';
echo '<tr class="data_o">
<td class="th_o th_o_first"><label for="status">',$L['Status'],'</label></td>
<td class="td_o"><select id="status" name="status">
';
foreach ($oSYS->statuses as $strKey=>$arrStatus)
{
echo '<option value="',$strKey,'"',($strStatus==$strKey ? QSEL : ''),'>',$strKey.' '.$arrStatus['name'].'</option>',N;
}
echo '</select></td>
</tr>
';
echo '<tr class="data_o">
<td class="th_o th_o_first">',$L['import_xml']['Drodate'],'</td>
<td class="td_o"><input type="checkbox" id="dropdate" name="dropdate"',($bDropdate ? QCHE : ''),'/> <label for="dropdate">',$L['import_xml']['HDrodate'],'</label></td>
</tr>
';
echo '<tr class="data_o">
<td class="th_o th_o_all" colspan="2" style="padding:6px; text-align:center"><input type="submit" name="ok" value="',$L['Ok'],'"/></td>
</tr>
</table>
</form>
';

// HTML END

include('qtr_adm_p_footer.php');

?>