<?php

/*
 * PHP versions 4 and 5
 *
 * LICENSE: This source file is subject to version 3.0 of the PHP license
 * that is available through the world-wide-web at the following URI:
 * http://www.php.net/license.  If you did not receive a copy of
 * the PHP License and are unable to obtain it through the web, please
 * send a note to license@php.net so we can mail you a copy immediately.
 *
 * @category   Adressbook
 * @package    QuickTeam
 * @author     Philippe Vandenberghe <info@qt-cute.org>
 * @copyright  2008-2012 The PHP Group
 * @license    http://www.php.net/license  PHP License 3.0
 * @version    2.0 build:20090311
 * @link       http://www.qt-cute/doc/package/qte
 * @since      File available since Release 1.0.0
 * @deprecated File deprecated in Release 3.0.0
 */

//session_start();

// Check application path

if ( !isset($qte_web_path) ) die('Missing variable $qte_web_path in your web page.');
if ( empty($qte_web_path) ) { $qte_web_path=''; } else { if ( substr($qte_web_path,-1,1)!='/' ) $qte_web_path .= '/';}
$qte_root = $qte_web_path;

// include ini

require_once($qte_root.'bin/qte_init.php');
if ( !$oVIP->CanAccess('MUV',2,true) ) HtmlPage(101);

// ---------
// INITIALISE
// ---------

$intLimit = 0;
$strGroup = 'all';
$strOrder = 'lastname';
$strDirec = 'ASC';
$intPage  = 1;

// security check 1
if ( isset($_GET['s']) )     $qte_web_team = strip_tags($_GET['s']);
if ( isset($_GET['group']) ) $strGroup = strip_tags($_GET['group']);
if ( isset($_GET['order']) ) $strOrder = strip_tags($_GET['order']);
if ( isset($_GET['dir']) )   $strDirec = strip_tags($_GET['dir']);
if ( isset($_GET['page']) )  $intPage = intval(strip_tags($_GET['page']));

// security check 2 (no long argument)
if ( strlen($strGroup)>4 ) die('Invalid argument #group');
if ( strlen($strOrder)>12 ) die('Invalid argument #order');
if ( strlen($strDirec)>4 ) die('Invalid argument #dir');

// web setting
if ( !isset($qte_web_team) ) die('Missing team id...');
if ( !isset($qte_web_head) ) $qte_web_head = true;
if ( !isset($qte_web_skin) ) $qte_web_skin = 'default';
if ( !isset($qte_web_view) ) $qte_web_view = 'N';
if ( !isset($qte_web_banner) ) $qte_web_banner = true;
if ( !isset($qte_web_logo) ) $qte_web_logo = false;

// view setting
$_SESSION[QT]['viewmode'] = substr(strtoupper($qte_web_view),0,1);
$intLimit = ($intPage-1)*$_SESSION[QT]['items_per_page'];
$strShowZ = ''; if ( !$_SESSION[QT]['show_Z'] ) $strShowZ = ' AND u.status<>"Z"';

require_once($qte_root.'bin/qte_fn_limitsql.php');

$oSEC = new cSection($qte_web_team);

if ( $oSEC->type==1 && ($oVIP->role=='V' || $oVIP->role=='U') )
{
  // exit
  $oVIP->selfname = $L['Section'];
  $oVIP->exitname = ObjTrans('index','i',$_SESSION[QT]['index_name']);
  $oVIP->EndMessage(NULL,$L['R_staff'],$qte_root.'skin/default',0);
}
if ( $oSEC->type==2 && $oVIP->role=='V' )
{
  // exit
  $oVIP->selfname = $L['Section'];
  $oVIP->exitname = ObjTrans('index','i',$_SESSION[QT]['index_name']);
  $oVIP->EndMessage(NULL,$L['R_user'],$qte_root.'skin/default',0);
}

$oVIP->selfurl = 'qte_web.php';
$oVIP->selfname = $L['Section'].': '.$oSEC->name;

// COUNT Members

$strWhereGroup = '';
Switch ($strGroup)
{
  Case 'all': $strWhereGroup .= ' AND u.id>0'; Break;
  Case '0':   $strWhereGroup .= ' AND '.FirstCharCase('u.lastname','a-z'); Break;
  Default:    $strWhereGroup .= ' AND '.FirstCharCase('u.lastname','u').'="'.$strGroup.'"'; Break;
}
$oDB->Query('SELECT count(*) as countid FROM '.TABUSER.' u INNER JOIN '.TABS2U.' l ON l.userid=u.id WHERE l.sid='.$oSEC->id.$strShowZ.$strWhereGroup);
$row = $oDB->Getrow();
$intCount = $row['countid'];

// LETTRES BAR [$strGroups]

if ( $intCount>$_SESSION[QT]['items_per_page'] || isset($_GET['group']) )
{
  $strGroups = '<td class="lettres" style="width:35px;">'.($strGroup=='all' ? '<b>'.$L['All'].'</b>' : '<a class="lettres" href="'.$oVIP->selfurl.'?s='.$qte_web_team.'&amp;group=all">'.$L['All'].'</a>' ).'</td>';
  for ($g='A';$g!='AA';$g++)
  {
  $strGroups .= '<td class="lettres" style="width:18px;">'.($strGroup==$g ? '<b>'.$g.'</b>' : '<a class="lettres" href="'.$oVIP->selfurl.'?s='.$qte_web_team.'&amp;group='.$g.'">'.$g.'</a>' ).'</td>';
  }
  $strGroups .= '<td class="lettres" style="width:18px;">'.($strGroup=='0' ? '<b>#</b>' : '<a class="lettres" href="'.$oVIP->selfurl.'?s='.$qte_web_team.'&amp;group=0">#</a>' ).'</td>';
  $strGroups .= '<td class="hidden">&nbsp; '.$intCount.($strGroup!='all' ? ' / '.$oSEC->members : '' ).S.LangS('User',$oSEC->members,$L,false).'</td>'.N;
}

// --------
// Pager
// --------

$strPager = MakePager("$oVIP->selfurl?s={$oSEC->id}&group=$strGroup",$intCount,$_SESSION[QT]['items_per_page'],$intPage); 
if ( $strPager!='' ) $strPager = $L['Page'].$strPager;

// --------
// HTML START
// --------

if ( $qte_web_head )
{
  HtmlHead($qte_root,'skin/'.$qte_web_skin,'','',true);
  echo '<body>';
}
else
{
  echo '
  <link rel="stylesheet" type="text/css" href="',$qte_root,'skin/',$qte_web_skin,'/qte_main.css"/>
  <link rel="shortcut icon" href="',$qte_root,'skin/',$qte_web_skin,'/qte_icon.ico"/>
  <script type="text/javascript" src="',$qte_root,'bin/qte_j_common.js"></script>
  ';
}

// --------
// Display banner
// --------

if ( $qte_web_banner ) HtmlBanner(0,$qte_root.'skin/'.$qte_web_skin);

// --------
// Display logo
// --------

if ( $qte_web_logo )
{
  $oSEC->ShowInfo('si_w','si_w','si_w_desc','left','',$qte_root);
}

// --------
// Display letters bar
// --------

if ( $intCount>$_SESSION[QT]['items_per_page'] || isset($_GET['group']) ) echo '<br/><table class="lettres" cellspacing="0"><tr class="lettres">',N,$strGroups,N,'</tr></table><br/>',N;

// --------
// Display no members
// --------

if ( $intCount==0 )
{
  echo '<p>',$L['E_no_member'],'</p>';
  if ( $qte_web_head ) echo '</body></html>';
  exit;
}

// --------
// Display top pager
// --------

if ( $strPager )
{
echo '
<table class="hidden" cellspacing="0"><tr class="hidden"><td id="pager_zt">',$strPager,'</td></tr></table>
';
}

// --------
// Display members
// --------

echo '<table class="data_t" cellspacing="0">',N;
echo '<tr class="data_t">',N;

  // ----------
  $arrPageFields = GetFieldsUsable($oSEC->forder,'nid');
  // Add infofield (if exist)
  if ( isset($_SESSION[QT]['infofield']) ) {
  if ( !empty($_SESSION[QT]['infofield']) ) {
    $arrPageFields[]=$_SESSION[QT]['infofield'];
  }}

  // ----------
  // Prepare fields

  $arrFields = array();
  foreach($arrPageFields as $i => $strField)
  {
    // extraclass
    $strExtraclass = '';
    if ( $i==0 ) $strExtraclass=' th_t_first';
    if ( $i>=(count($arrPageFields)-1) ) $strExtraclass=' th_t_last';

    // define the fields (sort must be false in webpage rendering)
    switch ($strField)
    {
    case 'fullname':$arrFields[$strField]=array('sort'=>false,'dir'=>'ASC', 'text'=>ObjTrans('field',$strField),'class'=>'th_t th_t_'.$strField.$strExtraclass, 'classhref'=>'th_t'); break;
    case 'status_i':$arrFields[$strField]=array('sort'=>false,'dir'=>'ASC', 'text'=>' &bull; ',                 'class'=>'th_t th_t_'.$strField.$strExtraclass, 'classhref'=>'th_t'); break;
    case 'address': $arrFields[$strField]=array('sort'=>false,'dir'=>'ASC', 'text'=>ObjTrans('field',$strField),'class'=>'th_t th_t_'.$strField.$strExtraclass, 'classhref'=>'th_t'); break;
    case 'descr':   $arrFields[$strField]=array('sort'=>false,'dir'=>'ASC', 'text'=>ObjTrans('field',$strField),'class'=>'th_t th_t_'.$strField.$strExtraclass, 'classhref'=>'th_t'); break;
    case 'picture': $arrFields[$strField]=array('sort'=>false,'dir'=>'ASC', 'text'=>ObjTrans('field',$strField),'class'=>'th_t th_t_'.$strField.$strExtraclass, 'classhref'=>'th_t'); break;
    case 'phones':  $arrFields[$strField]=array('sort'=>false,'dir'=>'ASC', 'text'=>ObjTrans('field',$strField),'class'=>'th_t th_t_'.$strField.$strExtraclass, 'classhref'=>'th_t'); break;
    case 'age':     $arrFields[$strField]=array('sort'=>false,'dir'=>'DESC','text'=>ObjTrans('field',$strField),'class'=>'th_t th_t_'.$strField.$strExtraclass, 'classhref'=>'th_t'); break;
    case 'emails':  $arrFields[$strField]=array('sort'=>false,'dir'=>'ASC', 'text'=>ObjTrans('field',$strField),'class'=>'th_t th_t_'.$strField.$strExtraclass, 'classhref'=>'th_t'); break;
    case 'emails_i':$arrFields[$strField]=array('sort'=>false,'dir'=>'ASC', 'text'=>ObjTrans('field','emails'), 'class'=>'th_t th_t_'.$strField.$strExtraclass, 'classhref'=>'th_t'); break;
    default:        $arrFields[$strField]=array('sort'=>false,'dir'=>'ASC', 'text'=>ObjTrans('field',$strField),'class'=>'th_t th_t_'.$strField.$strExtraclass, 'classhref'=>'th_t'); break;
    }      
  }
  // ----------
  TableHeader($arrFields,$intCount,"$oVIP->selfurl?s=$qte_web_team&amp;page=1",$strOrder,$strDirec);
  // ----------

echo '</tr>',N;

  foreach ($arrFields as $strKey => $arrValues) { $arrFields[$strKey]['class']=str_replace('th_','td_',$arrFields[$strKey]['class']); }
  // ----------
  $strState  = 'u.* FROM '.TABUSER.' u INNER JOIN '.TABS2U.' l ON l.userid=u.id WHERE l.sid='.$oSEC->id.$strShowZ.$strWhereGroup;
  if ( $strOrder=='fullname' ) $strOrder='lastname';
  $oDB->Query( LimitSQL($strState,$strOrder.' '.$strDirec,$intLimit,$_SESSION[QT]['items_per_page'],$intCount) );
  // ----------
  $strSkin = 'skin/'.$qte_web_skin;
  include($qte_root.'qte_member_inc.php');
  // ----------

echo '<tr class="data_t">',N;
echo '<td class="tf_t tf_t_first"></td>',N;
For ($i=0;$i<(count($arrFields)-2);$i++)
{
echo '<td class="tf_t"></td>',N;
}
echo '<td class="tf_t tf_t_last"></td>',N;
echo '</tr>',N;
echo '</table>',N,N;

// --------
// Display bottom pager
// --------

if ( $strPager )
{
echo '
<table class="hidden" cellspacing="0"><tr class="hidden"><td id="pager_zb">',$strPager,'</td></tr></table>
';
}

// --------
// HTML END
// --------

echo '
<!-- COPYRIGHT LINE -->
<div class="footer">
<table class="hidden">
<tr class="hidden">
<td class="hidden" id="footer_zl">&nbsp;</td>
<td class="hidden" id="footer_zr"><a href="',$_SESSION[QT]['site_url'],'/qte_index.php" class="footer_copy">',$_SESSION[QT]['site_name'],'</a></td>
</tr>
</table>
</div>
<!-- END COPYRIGHT LINE -->
';

if ( $qte_web_head ) echo '</body></html>';

?>