<?php

/*
 * PHP versions 4 and 5
 *
 * LICENSE: This source file is subject to version 3.0 of the PHP license
 * that is available through the world-wide-web at the following URI:
 * http://www.php.net/license.  If you did not receive a copy of
 * the PHP License and are unable to obtain it through the web, please
 * send a note to license@php.net so we can mail you a copy immediately.
 *
 * @category   Team
 * @package    QuickTeam
 * @author     Philippe Vandenberghe <info@qt-cute.org>
 * @copyright  2008-2012 The PHP Group
 * @license    http://www.php.net/license  PHP License 3.0
 * @version    2.0 build:20090311
 * @link       http://www.qt-cute/doc/package/qte
 * @since      File available since Release 1.0.0
 * @deprecated File deprecated in Release 3.0.0
 *
 */

session_start();
require_once('bin/qte_init.php');
if ( !$oVIP->CanAccess('MU',0,true) ) HtmlPage(101);

// --------
// INITIALISE
// --------

include('bin/qt_lib_smtp.php');
Include($_SESSION[QT]['language'].'/qte_reg.php');

$id = -1;
if (isset($_GET['id'])) $id = intval(strip_tags($_GET['id']));
if (isset($_POST['id'])) $id = intval(strip_tags($_POST['id']));
if ($id<0) die('Missing parameters');

$oUser = new cUser($id);

$oVIP->selfurl = 'qte_usr_rename.php';
$oVIP->selfname = $L['Change_name'];
$oVIP->exiturl = 'qte_usr.php?id='.$id.'&amp;tt=s';
$oVIP->exitname = '&laquo; '.$L['Profile'];

// --------
// SUBMITTED
// --------

if ( isset($_POST['ok']) )
{
  // check name
  if ( empty($error) )
  {
    $strName = trim(strip_tags($_POST['title'])); if ( get_magic_quotes_gpc() ) $strName = stripslashes($strName);
    if ( !QTislogin($strName) ) $error = ObjTrans('field','username').S.$L['E_invalid'];
    if ( empty($error) )
    {
    $oDB->Query('SELECT count(*) as countid FROM '.TABUSER.' WHERE username="'.$strName.'"');
    $row = $oDB->Getrow();
    if ( $row['countid']!=0 ) $error = ObjTrans('field','username').S.$L['E_already_used'];
    }
  }

  // execute and exit
  if ( empty($error) )
  {
    $oDB->Query('UPDATE '.TABUSER.' SET username="'.$strName.'" WHERE id='.$id);
    // index
    $oDB->query('DELETE FROM '.TABINDEX.' WHERE userid='.$id.' AND ufield="username"');
    $oDB->query('INSERT INTO '.TABINDEX.' (userid,ufield,ukey) VALUES ('.$id.',"username","'.$strName.'")');

    $oVIP->exiturl = 'qte_usr_login.php?dfltname='.$strName;
    $oVIP->exitname = '&laquo; '.$L['Login'];
    $oVIP->EndMessage(NULL,$L['S_update'],$_SESSION[QT]['skin_dir'],2);
  }
}

// --------
// HTML START
// --------

$strHeadScript = '
<script type="text/javascript" src="bin/qt_jquery.js"></script>
<script type="text/javascript">
<!--
function ValidateForm(theForm)
{
  if (theForm.title.value.length==0) { alert(html_entity_decode("'.$L['E_mandatory'].': '.$L['Name'].'")); return false; }
  return null;
}
$(function() {
  $("#title").blur(function() {
    $.post("qte_j_exists.php",
           {f:"username",v:$("#title").val(),e1:"'.$L['E_min_4_char'].'",e2:"'.$L['E_already_used'].'"},
           function(data)
           { 
             if ( data.length>0 ) document.getElementById("title_err").innerHTML=data;
           }
          );
  });
});
-->
</script>
';

include('qte_p_header.php');

// DISPLAY

if ( !empty($error) ) echo '<p id="infomessage" class="error">',$error,'</p>';

echo '
<table class="hidden" cellspacing="0">
<tr class="hidden">
<td class="hidden" style="width:175px;">',AsImgBox(AsImg($oUser->picture,'',$oUser->fullname),'picbox','',$oUser->fullname),'</td>
<td class="hidden">
';

HtmlMsg(0,'350px','',$oVIP->selfname);

/*
<div class="msgboxtitle" id="login_header" style="width: 350px;">',$oVIP->selfname,'</div>
<div class="msgbox" id="login" style="width: 350px;">
';
*/
echo '<form method="post" action="',$oVIP->selfurl,'" onsubmit="return ValidateForm(this);">';
echo '<input type="hidden" name="id" value="',$id,'"/>';
echo '<h2>',$oUser->username,'</h2>';
if ( $oUser->username!=$oUser->fullname ) echo '<p class="bold">('.$oUser->fullname.')</p><br/>';
echo '<p>',$L['Choose_name'],'</p>';
echo '<p><input type="text" id="title" name="title" size="20" maxlength="32" onfocus="document.getElementById(\'title_err\').innerHTML=\'\';"/> <input type="submit" name="ok" value="',$L['Save'],'"/> <span id="title_err" class="error"></span></p>';
echo '</form>';
echo '<a href="',$oVIP->exiturl,'">',$oVIP->exitname,'</a>';
echo '</div>
';

HtmlMsg(1);

echo '
</td>
</tr>
</table>
';

// --------
// HTML END
// --------

include('qte_p_footer.php');

?>