<?php

/*
 * PHP versions 4 and 5
 *
 * LICENSE: This source file is subject to version 3.0 of the PHP license
 * that is available through the world-wide-web at the following URI:
 * http://www.php.net/license.  If you did not receive a copy of
 * the PHP License and are unable to obtain it through the web, please
 * send a note to license@php.net so we can mail you a copy immediately.
 *
 * @category   Team
 * @package    QuickTeam
 * @author     Philippe Vandenberghe <info@qt-cute.org>
 * @copyright  2008-2012 The PHP Group
 * @license    http://www.php.net/license  PHP License 3.0
 * @version    2.0 build:20090311
 * @link       http://www.qt-cute/doc/package/qte
 * @since      File available since Release 1.0.0
 * @deprecated File deprecated in Release 3.0.0
 *
 */

session_start();
require_once('bin/qte_init.php');
if ( !$oVIP->CanAccess('MU',0,true) ) HtmlPage(101);

// --------
// INITIALISE
// --------

include('bin/qt_lib_smtp.php');
Include($_SESSION[QT]['language'].'/qte_reg.php');

$id = -1;
if (isset($_GET['id'])) $id = intval(strip_tags($_GET['id']));
if (isset($_POST['id'])) $id = intval(strip_tags($_POST['id']));
if ($id<0) die('Missing parameters');

$oVIP->selfurl = 'qte_usr_pwd_chg.php';
$oVIP->selfname = $L['Change_password'];
$oVIP->exiturl = 'qte_usr.php?id='.$id.'&amp;tt=s';
$oVIP->exitname = '&laquo; '.$L['Profile'];

// --------
// SUBMITTED
// --------

if ( isset($_POST['ok']) )
{
  // check value
  if ( !QTispassword($_POST['title']) ) $error=$L['Old_password'].S.$L['E_invalid'];
  if ( !QTispassword($_POST['newpwd']) ) $error=$L['New_password'].S.$L['E_invalid'];
  if ( !QTispassword($_POST['conpwd']) ) $error=$L['Confirm_password'].S.$L['E_invalid'];
  if ( $_POST['title']==$_POST['newpwd'] ) $error=$L['New_password'].S.$L['E_invalid'];
  if ( $_POST['conpwd']!=$_POST['newpwd'] ) $error=$L['Confirm_password'].S.$L['E_invalid'];

  // check old pwd
  if ( empty($error) )
  {
    $oDB->Query('SELECT count(*) as countid FROM '.TABUSER.' WHERE id='.$id.' AND pwd="'.sha1($_POST['title']).'"');
    $row = $oDB->Getrow();
    if ($row['countid']==0) $error=$L['Old_password'].S.$L['E_invalid'];
  }

  // execute and exit
  if ( empty($error) )
  {
    $oDB->Query('UPDATE '.TABUSER.' SET pwd="'.sha1($_POST['newpwd']).'" WHERE id='.$id);

    // send parent email (if coppa)
    if ($_POST['children']!='0') {
    if ( $_SESSION[QT]['register_coppa']=='1') {
      $oDB->Query('SELECT parentmail FROM '.TABCHILD.' WHERE id='.$id);
      $row = $oDB->Getrow();
      $strSubject = $_SESSION[QT]['site_name'].' - New password';
      $strMessage = "We inform you that your children has changed his/her password on the board {$_SESSION[QT]['site_name']}.\nLogin: %s\nPassword: %s";
      $strFile = $_SESSION[QT]['language'].'/mail_pwd_coppa.php';
      if ( file_exists($strFile) ) include($strFile);
      $strMessage = sprintf($strMessage,$_POST['username'],$_POST['newpwd']);
      QTmail($row['parentmail'],QTconv($strSubject,'-4'),QTconv($strMessage,'-4'),QTE_HTML_CHAR);
    }}

    $oVIP->EndMessage(NULL,$L['S_update'],$_SESSION[QT]['skin_dir'],2);
  }
}

// --------
// HTML START
// --------

include('qte_p_header.php');

// CHECK ACCESS RIGHT

if ( ( $oVIP->role!='A' ) && ($oVIP->id!=$id) ) die($L['R_user']);

// QUERY

$oUser = new cUser($id);
    
// DISPLAY

echo '<br/>
<table class="hidden" cellspacing="0">
<tr class="hidden">
<td class="hidden" style="width:175px;">',AsImgBox(AsImg($oUser->picture,'',$oUser->fullname),'picbox','',$oUser->fullname),'</td>
<td class="hidden">
';
HtmlMsg(0,'350px','login_header',$oVIP->selfname,'login');

echo '
<script type="text/javascript">
<!--
function ValidateForm(theForm)
{
  if (theForm.title.value.length==0) { alert(html_entity_decode("',$L['E_mandatory'],': ',$L['Old_password'],'")); return false; }
  if (theForm.newpwd.value.length==0) { alert(html_entity_decode("',$L['E_mandatory'],': ',$L['New_password'],'")); return false; }
  if (theForm.conpwd.value.length==0) { alert(html_entity_decode("',$L['E_mandatory'],': ',$L['Confirm_password'],'")); return false; }
  return null;
}
-->
</script>
';

echo '<form method="post" action="',$oVIP->selfurl,'" onsubmit="return ValidateForm(this);">
<p style="text-align:right">',$L['Old_password'],'&nbsp;<input type="password" id="title" name="title" size="20" maxlength="24"/></p>
<p style="text-align:right">',$L['New_password'],'&nbsp;<input type="password" id="newpwd" name="newpwd" size="20" maxlength="24"/></p>
<p style="text-align:right">',$L['Confirm_password'],'&nbsp;<input type="password" id="conpwd" name="conpwd" size="20" maxlength="24" onkeyup="handle_keypress(event,\'ok\')"/></p>
<p style="text-align:right">';
if ( !empty($error) ) echo '<span class="error">',$error,' </span>';
echo '<input type="submit" id="ok" name="ok" value="',$L['Save'],'"/></p>
<input type="hidden" name="id" value="',$id,'"/>
<input type="hidden" name="username" value="',$oUser->username,'"/>
<input type="hidden" name="children" value="',$oUser->coppa,'"/>
</form>
';
HtmlMsg(1);

echo '
</td>
</tr>
</table>
<p><a href="',$oVIP->exiturl,'">',$oVIP->exitname,'</a></p>
';

// --------
// HTML END
// --------

$strFooterAddScript = 'document.getElementById("title").focus();';

include('qte_p_footer.php');

?>