<?php

/*
 * PHP versions 4 and 5
 *
 * LICENSE: This source file is subject to version 3.0 of the PHP license
 * that is available through the world-wide-web at the following URI:
 * http://www.php.net/license.  If you did not receive a copy of
 * the PHP License and are unable to obtain it through the web, please
 * send a note to license@php.net so we can mail you a copy immediately.
 *
 * @category   Team
 * @package    QuickTeam
 * @author     Philippe Vandenberghe <info@qt-cute.org>
 * @copyright  2008-2012 The PHP Group
 * @license    http://www.php.net/license  PHP License 3.0
 * @version    2.0 build:20090311
 * @link       http://www.qt-cute/doc/package/qte
 * @since      File available since Release 1.0.0
 * @deprecated File deprecated in Release 3.0.0
 *
 */

session_start();
require_once('bin/qte_init.php');
$oSYS->output='print';
if ( !$oVIP->CanAccess('MUV',4,true) ) HtmlPage(101);

// --------
// INITIALISE
// --------

include('bin/qt_lib_smtp.php');
include($_SESSION[QT]['language'].'/qte_reg.php');

$oVIP->selfurl = 'qte_usr_prt.php';
$oVIP->selfname = $L['PProfile'];

$id = -1;
if ( isset($_GET['id']) ) $id = intval(strip_tags($_GET['id']));
if ( $id<0 )  die('Wrong id in '.$oVIP->selfurl);

$bEdit = false;

$oUser = new cUser($id,true); // privatise

$arrTeamFields = GetFieldsUsable(GetFields('team'));

$bMap = UseModule('map');
if ( $bMap ) { if ( empty($_SESSION[QT]['m_map_gkey']) ) $bMap=false; }
if ( $bMap ) { require_once('qtem_map_lib.php'); include(Translate('qtem_map.php')); }
$strPosition='';

// --------
// HTML START
// --------

if ( $bMap )
{ 
  $arrMapPoints = array();
  $strHeadScript = QTgmapheader('http://gmaps-utility-library.googlecode.com/svn/trunk/markermanager/release/src/markermanager.js');
  $strBodyAddOnunload='GUnload()';
}
include('qte_p_header.php');

// -- QUERY USER --

$strBirth_y = '';
$strBirth_m = '';
$strBirth_d = '';
if ( !empty($oUser->birthdate) )
{
  $strBirth_y = intval(substr(strval($oUser->birthdate),0,4));
  $strBirth_m = intval(substr(strval($oUser->birthdate),4,2));
  $strBirth_d = intval(substr(strval($oUser->birthdate),6,2));
}

// -- DISPLAY PROFILE --

if ( !empty($error) ) echo '<span class="error">',$error,'</span>',N;
echo '<table class="data_o" cellspacing="0">',N;
echo '<colgroup span="3">',N;
echo '<col width="150"></col>',N;
echo '<col></col>',N;
echo '<col width="50"></col>',N;
echo '</colgroup>',N;

echo '<tr>',N;
echo '<td class="th_u">',AsImg($oUser->picture),'</td>',N;
echo '<td class="td_o"><h2 style="margin:4px">',AsFormat($oUser->fullname,ObjTrans('ffield','fullname')),'</h2></td>',N;
echo '<td class="td_o"></td>',N;
echo '</tr>',N;

echo '<tr><td class="th_u" colspan="3"><h2 style="margin:4px">',$L['PProfile'],'</h2></td></tr>';

echo '<tr>',N;
echo '<td class="th_u">',ObjTrans('field','username'),'</td>',N;
echo '<td class="td_o">',AsFormat($oUser->username,ObjTrans('ffield','username'));
if ( $oUser->role=='A' || $oUser->role=='M' ) echo ' <span class="small">(',$L['Userrole'][$oUser->role],')</span>';
echo '</td>',N;
echo '<td class="td_o"></td>',N;
echo '</tr>',N;

echo '<tr>',N;
echo '<td class="th_u">',$L['Status'],'</td>',N;
echo '<td class="td_o">',$oSYS->statuses[$oUser->status]['statusname'],S,AsImg($_SESSION[QT]['skin_dir'].'/'.$oSYS->statuses[$oUser->status]['icon'],'ico i_status'),'</td>',N;
echo '<td class="td_o">';
echo '</td>',N;
echo '</tr>',N;

$arr = GetFieldsUsable(array('title','firstname','midname','lastname','alias','phones'));

foreach ($arr as $strField)
{
  echo '<tr><td class="th_u">',ObjTrans('field',$strField),'</td>',N;
  echo '<td class="td_o">',AsFormat(AsTextList($oUser->$strField),ObjTrans('ffield',$strField)),'</td>',N;
  echo '<td class="td_o">&nbsp;</td>',N;
  echo '</tr>';
}

$arr = GetFieldsUsable(array('address','emails','www','birthdate'));

if ( in_array('address',$arr) )
{
  echo '<tr><td class="th_u">',ObjTrans('field','address'),'</td>',N;
  echo '<td class="td_o">',AsFormat(AsTextList($oUser->address),ObjTrans('ffield',$strField)),'</td>',N;
  echo '<td class="td_o">&nbsp;</td>',N;
  echo '</tr>',N;
}

if ( in_array('emails',$arr) )
{
  echo '<tr><td class="th_u">',ObjTrans('field','emails'),'</td>',N;
  echo '<td class="td_o">',AsFormat(AsTextList($oUser->emails),ObjTrans('ffield',$strField)),'</td>',N;
  echo '<td class="td_o">&nbsp;</td>',N;
  echo '</tr>';
}

if ( in_array('www',$arr) )
{
  echo '<tr><td class="th_u">',ObjTrans('field','www'),'</td>',N;
  echo '<td class="td_o">',AsFormat($oUser->www,ObjTrans('ffield','www')),'</td>',N;
  echo '<td class="td_o">&nbsp;</td>',N;
  echo '</tr>';
}

if ( in_array('birthdate',$arr) )
{
  echo '<tr><td class="th_u">',ObjTrans('field','birthdate'),'</td>',N;
  echo '<td class="td_o">',(!empty($oUser->birthdate) ? AsFormat(QTdatestr($oUser->birthdate,'$','',false),ObjTrans('ffield','birthdate')).' ('.AsFormat($oUser->age,ObjTrans('ffield','age')).')' : S),'</td>',N;
  echo '<td class="td_o">&nbsp;</td>',N;
  echo '</tr>',N;
}

// CHILD

if ( $oUser->coppa!='0' ) {
if ( $_SESSION[QT]['register_coppa']=='1' ) {
if ( $oVIP->role=='A' || $oVIP->role=='M' ) {

echo '<tr><td class="th_u" colspan="3"><h2 style="margin:4px">',$L['Coppa_status'],' ',$L['H_Coppa_status'],'</h2></td></tr>';

  echo '<tr>',N;
  echo '<td class="th_u">',$L['Coppa_status'],'</td>',N;
  echo '<td class="td_o">',$L['Coppa_child'][$oUser->coppa],'</td>',N;
  echo '<td class="td_o">&nbsp;</td>',N;
  echo '</tr>',N;

  $oDB->Query('SELECT * FROM '.TABCHILD.' WHERE id='.$id);
  $row = $oDB->Getrow();
  //if ( $row['countid']!=1 ) $error = 'Unidentified child.';

  $strChilddate_y = '';
  $strChilddate_m = '';
  $strChilddate_d = '';
  if ( !empty($row['childdate']) )
  {
    $strChilddate_y = intval(substr(strval($row['childdate']),0,4));
    $strChilddate_m = intval(substr(strval($row['childdate']),4,2));
    $strChilddate_d = intval(substr(strval($row['childdate']),6,2));
  }
  $strParentdate_y = '';
  $strParentdate_m = '';
  $strParentdate_d = '';
  if ( !empty($row['Parentdate']) )
  {
    $strParentdate_y = intval(substr(strval($row['Parentdate']),0,4));
    $strParentdate_m = intval(substr(strval($row['Parentdate']),4,2));
    $strParentdate_d = intval(substr(strval($row['Parentdate']),6,2));
  }

  echo '<tr>',N;
  echo '<td class="th_u">Registration date</td>',N;
  echo '<td class="td_o">',(!empty($row['childdate']) ? QTdatestr($row['childdate'],'$','',false) : ''),'</td>',N;
  echo '<td class="td_o">&nbsp;</td>',N;
  echo '</tr>',N;

  echo '<tr>',N;
  echo '<td class="th_u">Parent agreement</td>',N;
  echo '<td class="td_o">',(!empty($row['parentdate']) ? QTdatestr($row['parentdate'],'$','',false) : ''),'</td>',N;
  echo '<td class="td_o">&nbsp;</td>',N;
  echo '</tr>',N;

  echo '<tr>',N;
  echo '<td class="th_u">Parent email</td>',N;
  echo '<td class="td_o"><a href="mailto:',$row['parentmail'],'" class="small">',$row['parentmail'],'</a></td>',N;
  echo '<td class="td_o">&nbsp;</td>',N;
  echo '</tr>',N;

}}}

echo '<tr><td class="th_u" colspan="3"><h2 style="margin:4px">',$L['TProfile'],'</h2></td></tr>';

foreach ($arrTeamFields as $strField)
{
  echo '<tr>';
  echo '<td class="th_u">',ObjTrans('field',$strField),'</td>';

  switch($strField)
  {
  case 'teamdate1':
    echo '<td class="td_o">',(!empty($oUser->$strField) ? QTdatestr($oUser->$strField,'$','',false) : S),'</td>';
    break;
  case 'teamdate2':
    echo '<td class="td_o">',(!empty($oUser->$strField) ? QTdatestr($oUser->$strField,'$','',false) : S),'</td>';
    break;
  default:
    echo '<td class="td_o">',(!empty($oUser->$strField) ? AsFormat($oUser->$strField,ObjTrans('ffield',$strField)) : S),'</td>';
    break;
  }
  echo '<td class="td_o">&nbsp;</td>',N;
  echo '</tr>',N;
}

// -- QUERY MEMBERSHIP --

echo '<tr>';
echo '<td class="th_u">',$L['MProfile'],'</td>';
echo '<td class="td_o">';

$arrMembership = array();
$oDB->Query('SELECT s.id,s.title,s.picture,s.members FROM '.TABSECTION.' s INNER JOIN '.TABS2U.' l  ON l.sid=s.id WHERE l.userid='.$id.' ORDER BY l.sid DESC');
while ( $row=$oDB->Getrow() )
{
  $arrMembership[$row['id']] = $row;
}

foreach ($arrMembership as $intId => $arrSection)
{
  $oSEC = new cSection($arrSection);
  echo '<b>',$oSEC->name,'</b> &middot; ',$oSEC->descr,' <span class="small">('.LangS('User',$oSEC->members).')</span><br/>';
}
if ( count($arrMembership)==0 ) echo $L['E_no_membership'];

echo '</td>',N;
echo '<td class="td_o">&nbsp;</td>',N;
echo '</tr>',N;

// -- QUERY DOCUMENTS --

$arrDocs = array();
$oDB->Query('SELECT * FROM '.TABDOC.' WHERE id='.$id.' ORDER BY docname DESC');
while ( $row=$oDB->Getrow() )
{ 
  $arrDocs[] = $row;
}

echo '<td class="th_u">',$L['DProfile'],'</td>';
echo '<td class="td_o">';
if ( count($arrDocs)==0 ) 
{
  echo $L['None'];
}
else
{
  foreach ($arrDocs as $intId => $arrDoc)
  {
  echo '<span class="small">(',QTdatestr($arrDoc['docdate'],'$','$',false),')</span> ',$arrDoc['docname'],', ';
  }
}
echo '</td>
<td class="td_o">&nbsp;</td>
</tr>
</table>',N;


// MAP
if ( $bMap )
{
  $strPosition = '<div id="map_canvas" style="width:100%; height:340px;"></div>';
  if ( empty($oUser->x) || empty($oUser->y) ) $strPosition = '<span class="gmap">'.$L['map']['E_noposition'].'</span>';
  if ( $row['privacy']=='0' && $oVIP->role!='A' ) $strPosition = S;
  if ( $row['privacy']=='1' && $oVIP->role=='V' ) $strPosition = S;
  echo '<div class="gmap" style="margin-top:10px;width:550px">',$strPosition,'</div>';
}

// ---------
// HTML END
// ---------

if ( $bMap )
{

  if ( !empty($oUser->x) && !empty($oUser->y) )
  {
    $strUsername = QTconv($oUser->name,'-4');
    $x = floatval($oUser->x);
    $y = floatval($oUser->y);
    $arrMapPoints = array( array(
    'y'=>$y,
    'x'=>$x,
    'title'=>$strUsername,
    'icon'=>$_SESSION[QT]['m_map']['U']['icon'],
    'shadow'=>$_SESSION[QT]['m_map']['U']['shadow'],
    'printicon'=>$_SESSION[QT]['m_map']['U']['printicon'],
    'printshadow'=>$_SESSION[QT]['m_map']['U']['printshadow']
    ) );
  }

  if ( count($arrMapPoints)>0 ) $strFooterAddScript = QTgmappoints($L['map'],$y,$x,'',$arrMapPoints,false,false).N.'mapload();';

}

include('qte_p_footer.php');

?>