<?php

/*
 * PHP versions 4 and 5
 *
 * LICENSE: This source file is subject to version 3.0 of the PHP license
 * that is available through the world-wide-web at the following URI:
 * http://www.php.net/license.  If you did not receive a copy of
 * the PHP License and are unable to obtain it through the web, please
 * send a note to license@php.net so we can mail you a copy immediately.
 *
 * @category   Team
 * @package    QuickTeam
 * @author     Philippe Vandenberghe <info@qt-cute.org>
 * @copyright  2008-2012 The PHP Group
 * @license    http://www.php.net/license  PHP License 3.0
 * @version    2.0.1 build:20090517
 * @link       http://www.qt-cute/doc/package/qte
 * @since      File available since Release 1.0.0
 * @deprecated File deprecated in Release 3.0.0
 *
 */

session_start();
require_once('bin/qte_init.php');
if ( $_SESSION[QT]['picture']=='0' ) HtmlPage(0);
if ( !$oVIP->CanAccess('MU',0,true) ) HtmlPage(101);

// --------
// INITIALISE
// --------

include('bin/qt_lib_smtp.php');
include('bin/qte_fn_edit.php');
Include($_SESSION[QT]['language'].'/qte_reg.php');

$id = -1;
if ( isset($_GET['id']) ) $id = intval(strip_tags($_GET['id']));
if ( isset($_POST['id']) ) $id = intval(strip_tags($_POST['id']));
if ( $id<0 ) die('Missing parameters');

$oVIP->selfurl = 'qte_usr_img.php';
$oVIP->selfname = $L['Change_picture'];
$oVIP->exiturl = 'qte_usr.php?id='.$id.'&amp;tt=s';
$oVIP->exitname = $L['Profile'];

$oUser = new cUser($id);

// --------
// SUBMITTED FOR DELETE
// --------

if ( isset($_POST['del']) )
{
  if ( file_exists(QTE_DIR_PIC.$oUser->picture) ) unlink(QTE_DIR_PIC.$oUser->picture);
  $oDB->Query('UPDATE '.TABUSER.' SET picture="0" WHERE id='.$id);
  $oVIP->EndMessage(NULL,$L['S_delete'],$_SESSION[QT]['skin_dir'],2);
}

// --------
// SUBMITTED FOR UPLOAD
// --------

if ( isset($_POST['ok']) )
{
  // Check uploaded document
  
  $error = InvalidUpload($_FILES['title'],$_SESSION[QT]['picture'],'',intval($_SESSION[QT]['picture_size']),intval($_SESSION[QT]['picture_width']),intval($_SESSION[QT]['picture_height']));

  // Save

  if ( empty($error) )
  {
    $strDir = TargetDir(QTE_DIR_PIC,$id);
    $strExt = strtolower(substr(strrchr($_FILES['title']['name'],'.'),1));

    copy($_FILES['title']['tmp_name'],QTE_DIR_PIC.$strDir.$id.'.'.$strExt);
    $oDB->Query('UPDATE '.TABUSER.' SET picture="'.QTE_DIR_PIC.$strDir.$id.'.'.$strExt.'" WHERE id='.$id);
    unlink($_FILES['title']['tmp_name']);

    // Send parent email (if coppa)

    if ( $oUser->coppa=='1' ) {
    if ( $_SESSION[QT]['register_coppa']=='1') {
      $oDB->Query('SELECT parentmail FROM '.TABCHILD.' WHERE id='.$id);
      $row = $oDB->Getrow();
      $strSubject = $_SESSION[QT]['site_name'].' - New picture';
      $strMessage = "We inform you that your children has changed his/her picture on the board {$_SESSION[QT]['site_name']}.\nLogin: %s\nPassword: %s";
      $strFile = $_SESSION[QT]['language'].'/mail_img_coppa.php';
      if ( file_exists($strFile) ) include($strFile);
      $strMessage = sprintf($strMessage,$_POST['username']);
      QTmail($row['parentmail'],QTconv($strSubject,'-4'),QTconv($strMessage,'-4'),QTE_HTML_CHAR);
    }}

    // Exit

    $oVIP->EndMessage(NULL,$L['S_update'],$_SESSION[QT]['skin_dir'],2);
  }
}

// --------
// HTML START
// --------

if ( $oVIP->role!='A' ) { if ($oVIP->id!=$id) die($L['R_user']); }

include('qte_p_header.php');

echo '<br/>',N;
echo '<table class="hidden" cellspacing="0">',N;
echo '<tr class="hidden">',N;
echo '<td class="hidden" style="width:175px;">',AsImgBox(AsImg($oUser->picture),'picbox','',$oUser->firstname.' '.$oUser->lastname),'</td>',N;
echo '<td class="hidden">',N;

HtmlMsg(0,'350px','',$oVIP->selfname);

echo '
<script type="text/javascript">
<!--
function ValidateForm(theForm)
{
  if (theForm.title.value.length==0) { alert(html_entity_decode("',$L['E_mandatory'],': File")); return false; }
  return null;
}
-->
</script>
';

echo '<form method="post" action="',$oVIP->selfurl,'" enctype="multipart/form-data" onsubmit="return ValidateForm(this);">',N;
if ( !empty($error) ) echo '<span class="error">',$error,'</span>',N;
echo '<p class="small" style="text-align:right">',$L['H_Change_picture'],'</p>',N;
echo '<p style="text-align:right">',N;
echo '<input type="file" id="title" name="title" size="32"/>',N;
echo '<input type="hidden" name="max_file_size" value="10000"/>',N;
echo '<input type="hidden" name="username" value="',$oUser->username,'"/>',N;
echo '<input type="hidden" name="id" value="',$id,'"/>',N;
echo '<input type="hidden" name="children" value="',$oUser->coppa,'"/>',N;
echo '<input type="submit" name="ok" value="',$L['Save'],'"/></p>',N;
echo '</form><br/>',N;
echo '<form method="post" action="',$oVIP->selfurl,'">',N;
echo '<p style="text-align:right">',N;
echo $L['Delete_picture'],S,N;
echo '<input type="hidden" name="id" value="',$id,'"/>',N;
echo '<input type="submit" name="del" value="',$L['Delete'],'"/></p>',N;
echo '</form>';

HtmlMsg(1);

echo '
</td>
</tr>
</table>
<p><a href="',$oVIP->exiturl,'">&laquo; ',$oVIP->exitname,'</a></p>';

// --------
// HTML END
// --------

include('qte_p_footer.php');

?>