<?php

/*
 * PHP versions 4 and 5
 *
 * LICENSE: This source file is subject to version 3.0 of the PHP license
 * that is available through the world-wide-web at the following URI:
 * http://www.php.net/license.  If you did not receive a copy of
 * the PHP License and are unable to obtain it through the web, please
 * send a note to license@php.net so we can mail you a copy immediately.
 *
 * @category   Team
 * @package    QuickTeam
 * @author     Philippe Vandenberghe <info@qt-cute.org>
 * @copyright  2008-2012 The PHP Group
 * @license    http://www.php.net/license  PHP License 3.0
 * @version    2.0 build:20090311
 * @link       http://www.qt-cute/doc/package/qte
 * @since      File available since Release 1.0.0
 * @deprecated File deprecated in Release 3.0.0
 *
 */ 

session_start();
require_once('bin/qte_init.php');
if ( !$oVIP->CanAccess('MUV',4,true) ) HtmlPage(101);

// --------
// INITIALISE
// --------

include('bin/qt_lib_smtp.php');
Include($_SESSION[QT]['language'].'/qte_reg.php');

$oVIP->selfurl = 'qte_usr.php';
$oVIP->selfname = $L['PProfile'];

$id = -1;
if ( isset($_GET['id']) ) $id = intval(strip_tags($_GET['id']));
if ( isset($_POST['id']) ) $id = intval(strip_tags($_POST['id']));
if ( $id<0 ) die('Wrong id in '.$oVIP->selfurl);

$tt = 'p';
if ( isset($_GET['tt']) ) $tt = $_GET['tt'];
if ( isset($_POST['tt']) ) $tt = $_POST['tt'];

$strHeadScript = '';

if ( !isset($_SESSION[QT]['willedit']) ) $_SESSION[QT]['willedit']=false;
if ( isset($_GET['editstart']) ) $_SESSION[QT]['willedit']=true;
if ( isset($_GET['editstop']) ) $_SESSION[QT]['willedit']=false;

$bEdit = false;
if ( $oVIP->role=='A' || $oVIP->role=='M' ) $bEdit=true;
if ( $oVIP->id==$id && $_SESSION[QT]['member_right']!='0' ) $bEdit=true;
if ( $id<1 ) $bEdit=false;

$oUser = new cUser($id,true); // privatise

$strOldname = $oUser->firstname.' '.$oUser->lastname;
$arrTabs = array('p'=>$L['PProfile'],'t'=>$L['TProfile'],'m'=>$L['MProfile'],'d'=>$L['DProfile'],'s'=>$L['SProfile']);
$arrTeamFields = array();
if ($tt=='t') $arrTeamFields = GetFieldsUsable(GetFields('team'));
if ($tt=='p') $arrTeamFields = GetFieldsUsable(GetFields('personnal'));

$bMap = UseModule('map');
if ( $bMap ) { if ( $tt!='p' ) $bMap=false; }
if ( $bMap ) { if ( empty($_SESSION[QT]['m_map_gkey']) ) $bMap=false; }
if ( $bMap ) { require_once('qtem_map_lib.php'); include(Translate('qtem_map.php')); }
$strPosition='';

// --------
// HTML START
// --------

if ( $bMap )
{ 
  $strHeadScript .= QTgmapheader();
  $strBodyAddOnunload='GUnload()';
}
if ( $bEdit && $_SESSION[QT]['willedit'] ) {
if ( $tt=='s' || in_array('teamdate1',$arrTeamFields) || in_array('teamdate2',$arrTeamFields) || in_array('birthdate',$arrTeamFields) || in_array('childdate',$arrTeamFields) || in_array('parentdate',$arrTeamFields) ) {
  $arrCss = array('qt_jquery.css');
  $strHeadScript .= '
  <script type="text/javascript" src="bin/qt_jquery.js"></script>
  <script type="text/javascript" src="bin/qt_jquery_date.js"></script>
  <script type="text/javascript">
  <!--
  $(document).ready(function() {
    '.($tt=='s' ? '$("#regdate").datepicker({ dateFormat: "yy-mm-dd", monthNames: ["'.implode('","',$L['dateMMM']).'"], dayNames: ["'.implode('","',$L['dateDDD']).'"], dayNamesMin: ["'.implode('","',$L['dateD']).'"] });' : '').
    (in_array('teamdate1',$arrTeamFields) ? '$("#teamdate1").datepicker({ dateFormat: "yy-mm-dd", monthNames: ["'.implode('","',$L['dateMMM']).'"], dayNames: ["'.implode('","',$L['dateDDD']).'"], dayNamesMin: ["'.implode('","',$L['dateD']).'"] });' : '').
    (in_array('teamdate2',$arrTeamFields) ? '$("#teamdate2").datepicker({ dateFormat: "yy-mm-dd", monthNames: ["'.implode('","',$L['dateMMM']).'"], dayNames: ["'.implode('","',$L['dateDDD']).'"], dayNamesMin: ["'.implode('","',$L['dateD']).'"] });' : '').
    (in_array('birthdate',$arrTeamFields) ? '$("#birthdate").datepicker({ dateFormat: "yy-mm-dd", monthNames: ["'.implode('","',$L['dateMMM']).'"], dayNames: ["'.implode('","',$L['dateDDD']).'"], dayNamesMin: ["'.implode('","',$L['dateD']).'"] });' : '').
    (in_array('childdate',$arrTeamFields) ? '$("#childdate").datepicker({ dateFormat: "yy-mm-dd", monthNames: ["'.implode('","',$L['dateMMM']).'"], dayNames: ["'.implode('","',$L['dateDDD']).'"], dayNamesMin: ["'.implode('","',$L['dateD']).'"] });' : '').
    (in_array('parentdate',$arrTeamFields) ? '$("#parentdate").datepicker({ dateFormat: "yy-mm-dd", monthNames: ["'.implode('","',$L['dateMMM']).'"], dayNames: ["'.implode('","',$L['dateDDD']).'"], dayNamesMin: ["'.implode('","',$L['dateD']).'"] });' : '').'
  });
  -->
  </script>
  ';
}}
include('qte_p_header.php');

// -- BUTTON BAR & TITLE --

if ( $oVIP->role=='A' || $oVIP->role=='M' ) 
{
echo '
<form method="get" action="qte_cmd.php" id="modaction">
<div class="modboard">
<span class="modboard">',$L['Userrole'][$oVIP->role],' 
<select name="a" class="small" onchange="',"if (this.value!='') { document.getElementById('modaction').submit(); }",'">
<option value="">',S,'</option>
<option value="pwdreset">',$L['Reset_pwd'],'...</option>',($id>1 ? '<option value="userrole">'.$L['Change_role'].'...</option><option value="deleteuser">'.$L['User_del'].'...</option>' :''),'
<input type="submit" name="Mok" value="',$L['Ok'],'" class="small" id="action_ok"/>
<input type="hidden" name="u" value="',$id,'"/>
<script type="text/javascript">document.getElementById("action_ok").style.visibility="hidden";document.getElementById("action_ok").value="";</script>
</span>
</div>
</form>
';
}

// DISPLAY TABS

echo '<h1>',$oUser->fullname,'</h1>
';

echo HtmlTabs($arrTabs,$oVIP->selfurl.'?id='.$id,$tt);

// DISPLAY TAB PANEL

echo '<table class="pan" cellspacing="0">
<tr class="pan">
<td class="pan">
<div class="pan_top">',(isset($L[strtoupper($tt).'Profile']) ? $L[strtoupper($tt).'Profile'] : $L['Profile']),'</div>
';

if ( $bEdit )
{
  if ( $_SESSION[QT]['willedit'] ) 
  {
  echo '<p style="text-align:right"><a href="',$oVIP->selfurl,'?id=',$id,'&amp;tt=',$tt,'&amp;editstop" onclick="return warningedited(bEdited,\''.$L['E_data_not_saved'].'\');">',$L['Edit_stop'],'</a></p>';
  }
  else
  {
  echo '<p style="text-align:right"><a href="',$oVIP->selfurl,'?id=',$id,'&amp;tt=',$tt,'&amp;editstart">',$L['Edit_start'],'</a></p>';
  }
}

switch($tt)
{
case 't': include('qte_usr_t.php'); break;
case 'd': include('qte_usr_d.php'); break;
case 'm': include('qte_usr_m.php'); break;
case 's': include('qte_usr_s.php'); break;
default:  include('qte_usr_p.php');
}

echo '
</td>
</tr>
</table>
';

if ( $bEdit && $_SESSION[QT]['willedit'] && isset($strInfo) )
{
echo '
<script type="text/javascript">
<!--
setTimeout(\'document.getElementById("infomessage").style.color="#bbbbbb"\',3000);
setTimeout(\'document.getElementById("infomessage").style.color="#cccccc"\',3300);
setTimeout(\'document.getElementById("infomessage").style.color="#dddddd"\',3600);
setTimeout(\'document.getElementById("infomessage").innerHTML="&nbsp;"\',3900);
-->
</script>
';
}

// --------
// HTML END
// --------

if ( $bMap )
{
  if ( !empty($oUser->x) && !empty($oUser->y) )
  {
    $strUsername = QTconv($oUser->fullname,'-4');
    $x = floatval($oUser->x);
    $y = floatval($oUser->y);
    $oMapPoint = new cMapPoint($y,$x,$strUsername);
    $arrMapPoints = array( $oMapPoint );
  }
  else
  {
  $x = QTgetx($_SESSION[QT]['m_map_gcenter']);
  $y = QTgety($_SESSION[QT]['m_map_gcenter']);
  $arrMapPoints = array();
  }

  if ( $bEdit && $_SESSION[QT]['willedit'] )
  {
  $strFooterAddScript = QTgmappoints($L['map'],$y,$x,'drag',$arrMapPoints,true,false).N.'mapload();';
  }
  else
  {
  $strFooterAddScript = QTgmappoints($L['map'],$y,$x,'',$arrMapPoints,false,false).N.'mapload();';
  }
}

include('qte_p_footer.php');

?>