<?php

/*
 * PHP versions 4 and 5
 *
 * LICENSE: This source file is subject to version 3.0 of the PHP license
 * that is available through the world-wide-web at the following URI:
 * http://www.php.net/license.  If you did not receive a copy of
 * the PHP License and are unable to obtain it through the web, please
 * send a note to license@php.net so we can mail you a copy immediately.
 *
 * @category   Forum
 * @package    QuickTalk
 * @author     Philippe Vandenberghe <info@qt-cute.org>
 * @copyright  2008-2012 The PHP Group
 * @license    http://www.php.net/license  PHP License 3.0
 * @version    2.0 build:20090311
 * @link       http://www.qt-cute.org/doc/package/qte
 * @since      File available since Release 1.0.0
 * @deprecated File deprecated in Release 3.0.0
 *
 */

session_start();
require_once('bin/qte_init.php');
$oSYS->output='print';
if ( !$oVIP->CanAccess('MUV',4) ) HtmlPage(101);

// INITIALISE

$intYear = date('Y');
  if ( intval(date('n'))<2 ) $intYear--; 
  if ( isset($_GET['year']) ) $intYear = intval($_GET['year']);

$s = -1; if ( isset($_GET['s']) ) $s = intval($_GET['s']);
if ( $s>=0 ) { $strWhere = ' INNER JOIN '.TABS2U.' s ON u.id=s.userid WHERE u.firstdate>"1" AND s.sid='.$s; } else { $strWhere=' WHERE u.firstdate>"1"'; }

  // FIRST/LAST DATE

  $oDB->Query( 'SELECT min(u.firstdate) as startdate, max(u.firstdate) as lastdate FROM '.TABUSER.' u '.$strWhere );
  $row = $oDB->Getrow();
  if ( empty($row['startdate']) ) $row['startdate']=strval($intYear-1).'0101';
  if ( empty($row['lastdate']) )  $row['lastdate']=strval($intYear).'1231';

  $strFirstdate = QTdatestr($row['startdate'],'$','$',false);
  $strLastdate  = QTdatestr($row['lastdate'],'$','$',false);

$intStartyear  = intval(date('Y',strtotime($row['startdate'])));
$intStartmonth = intval(date('n',strtotime($row['startdate'])));
$intEndyear    = intval(date('Y'));
$intEndmonth   = intval(date('n'));

$arrAllYears = array();
for ($i=$intStartyear;$i<=$intEndyear;$i++) 
{
  $arrAllYears[$i]=$i;
}
$arrYears = array($intEndyear-1=>$intEndyear-1,$intEndyear=>$intEndyear);

$arrGraphM = array();
$arrGraphU = array();
$arrGraphT = array();
$arrGraphR = array();
for ($i=1;$i<13;$i++)
{
  $arrGraphM[$L['dateMMM'][$i]]=0;
  $arrGraphU[$L['dateMMM'][$i]]=0;
  $arrGraphT[$L['dateMMM'][$i]]=0;
  $arrGraphR[$L['dateMMM'][$i]]=0;
}

$oVIP->selfurl = 'qte_stats.php';
$oVIP->selfname = $L['Statistics'];

// --------
// HTML START
// --------

include('qte_p_header.php');

// USERS

$oDB->Query( 'SELECT count(id) as countid FROM '.TABUSER );
$row = $oDB->Getrow();

$intUsers = $row['countid'];

$iTotalPost = 0;

echo '<h1>',$L['Statistics'],'</h1>
<h2>',$L['General_site'],'</h2>
<table class="data_o" style="width:370px;" cellspacing="0">
<tr class="data_o">
<td class="th_o" style="width:150px;"><span class="texthead">',$L['Users'],'</span></td>
<td class="td_o">',$intUsers,'</td>
</tr>
<tr class="data_o">
<td class="th_o" style="width:150px;"><span class="texthead">',$L['Section_start_date'],'</span></td>
<td class="td_o">',$strFirstdate,'</td>
</tr>
<tr class="data_o">
<td class="th_o" style="width:150px;"><span class="texthead">',$L['Last_registration'],'</span></td>
<td class="td_o">',$strLastdate,'</td>
</tr>
</table>
';

$arrSections = GetSectionTitles($oVIP->role);

echo '<h2>',$L['Items_per_month'],S,($s>=0 ? '('.$arrSections[$s].')' : ''),'</h2>';
echo '<table class="data_o" cellspacing="0">',N;
echo '<tr class="data_o">',N;
echo '<td class="th_o" style="width:50px">&nbsp;</td>',N;
for ($i=1;$i<13;$i++)
{
  echo '<td class="th_o" style="text-align:center;">',$L['dateMM'][$i],'</td>',N;
}
echo '<td class="th_o" style="text-align:center;"><b>',$L['Year'],'</b></td>
</tr>',N;

Foreach ($arrYears as $valYear)
{
  echo '<tr class="data_o">',N;
  echo '<td class="th_o">',$valYear,'</td>',N;

  $iTotalPost = 0;
  for ($intMonth=1;$intMonth<13;$intMonth++)
  {
    if ( $valYear<$intStartyear )
    {
    echo '<td class="td_o" style="text-align:center;">&middot;</td>',N;
    continue;
    }
    if ( $valYear==$intStartyear && $intMonth<$intStartmonth)
    {
    echo '<td class="td_o" style="text-align:center;">&middot;</td>',N;
    continue;
    }
    if ( $valYear>=$intEndyear && $intMonth>$intEndmonth )
    {
    echo '<td class="td_o" style="text-align:center;">&middot;</td>',N;
    continue;
    }

    $oDB->Query( 'SELECT count(id) as countid FROM '.TABUSER.' WHERE firstdate LIKE "'.$valYear.$intMonth.'%"' );
    $row = $oDB->Getrow();
    echo '<td class="td_o" style="text-align:center;">',$row['countid'],'</td>',N;
    $iTotalPost = $iTotalPost + $row['countid'];
    $arrGraphM[$L['dateMMM'][$intMonth]] = $row['countid'];
  }
  echo '<td class="td_o" style="text-align:center;padding:5px"><b>',$iTotalPost,'</b></td>',N,'</tr>',N;
}

echo '</table>',N;


// GRAPH
if ( file_exists('bin/qt_lib_graph.php') && file_exists($_SESSION[QT]['skin_dir'].'/qte_main2.css') )
{
  include('bin/qt_lib_graph.php');
  echo '<h2>',$intYear,S,($s>=0 ? '('.$arrSections[$s].')' : ''),'</h2>';
  echo '<div style="width:450px;">',N;
  QTsimplegraph($arrGraphT,false,320,100,2,true,$L['Items_per_month']);
  echo '<br/>';
  QTsimplegraph($arrGraphT,false,350,100,2,'P',$L['Items_per_month'].' (%)');
  echo '<br/>';
  QTsimplegraph($arrGraphT,true,320,100,2,true,$L['Items_per_month_cumul']);
  echo '<br/>';
  QTsimplegraph($arrGraphT,true,350,100,2,'P',$L['Items_per_month_cumul'].' (%)');
  echo '</div>',N;
}
else
{
  echo '<p class="small">Graphs cannot be displayed because one of these files is missing: bin/qt_lib_graph.php, ',$_SESSION[QT]['skin_dir'].'/qte_main2.css</p>';
}

// HTML END

include('qte_p_footer.php');

?>