<?php

/*
 * PHP versions 4 and 5
 *
 * LICENSE: This source file is subject to version 3.0 of the PHP license
 * that is available through the world-wide-web at the following URI:
 * http://www.php.net/license.  If you did not receive a copy of
 * the PHP License and are unable to obtain it through the web, please
 * send a note to license@php.net so we can mail you a copy immediately.
 *
 * @category   Team
 * @package    QuickTeam
 * @author     Philippe Vandenberghe <info@qt-cute.org>
 * @copyright  2008-2012 The PHP Group
 * @license    http://www.php.net/license  PHP License 3.0
 * @version    2.0 build:20090311
 * @link       http://www.qt-cute/doc/package/qte
 * @since      File available since Release 1.0.0
 * @deprecated File deprecated in Release 3.0.0
 *
 */

session_start();
require_once('bin/qte_init.php');
if ( !$oVIP->CanAccess('MUV',3,true) ) HtmlPage(101);

// --------
// INITIALISE
// --------

$oVIP->selfurl = 'qte_search.php';
$oVIP->selfname = $L['Search'];

// --------
// HTML START
// --------

$arrCss = array('qt_jquery.css'); 
$strHeadScript = '
<script type="text/javascript" src="bin/qt_jquery.js"></script>
<script type="text/javascript" src="bin/qt_jquery_auto.js"></script>
<script type="text/javascript">
<!--
function ValidateForm(theForm)
{
  if (theForm.title.value.length<2) { alert(html_entity_decode("'.$L['E_min_2_char'].'")); return false; }
  return null;
}
$(document).ready(function() {
  $("#title").autocomplete("qte_j_index.php", {
    selectFirst: false,
    minChar:2,
    formatItem: function(value) { return value[0] + " (" + value[1] + ")"; },
    formatResult: function(value) { return value[0]; }
  });

});
-->
</script>';

include('qte_p_header.php');

// advanced search

if ( isset($_GET['a']) || isset($_GET['s']) || isset($_GET['status']) || isset($_GET['role']) || isset($_GET['age']))
{
  if ( isset($_GET['s']) ) { $s = intval(strip_tags($_GET['s'])); } else { $s = null; }
  if ( isset($_GET['status']) ) { $strStatus = strip_tags($_GET['status']); } else { $strStatus = null; }
  if ( isset($_GET['age_criteria']) ) { $strCriteria = strip_tags($_GET['age_criteria']); } else { $strCriteria = null; }
  
  echo '<h2>',$L['Search_by_key'],'</h2>',N;
  echo '<form method="get" action="qte_result.php" onsubmit="return ValidateForm(this);">',N;
  echo '<table class="data_s" cellspacing="0">',N;  
  echo '<tr class="data_s">',N;
  echo '<td class="th_s th_s_first th_s_empty"></td>',N;
  echo '<td class="th_s th_s_empty"></td>',N;
  echo '<td class="th_s th_s_last th_s_empty"></td>',N;
  echo '</tr>',N;
  echo '<tr class="data_s">',N;
  echo '<td class="td_s td_s_first" style="text-align:center; width:50px">',AsImg($_SESSION[QT]['skin_dir'].'/ico_section_search.gif','search',$L['Search'],'ico i_sec'),'</td>',N;
  echo '<td class="td_s">',N;
  echo '<input type="text" id="title" name="title" size="30" maxlength="32" value="',(isset($_GET['title']) ? $_GET['title'] : ''),'" onkeyup="handle_keypress(event,\'okref\')"/> ',
  $L['In_section'],'  
  <select id="sk" name="s" size="1">
  <option value="-1"> </option>',QTastags($oSYS->sections,null,$s),'
  </select></td>
  <td class="td_s td_s_last" style="text-align:right; width:100px"><input type="submit" id="okref" name="ok" value="',$L['Search'],'"/>&nbsp;</td>
  </tr>
  <tr class="data_s">
  <td class="tf_s tf_s_first"></td>
  <td class="tf_s"></td>
  <td class="tf_s tf_s_last"></td>
  </tr>
  </table>
  </form>
  ';
  echo '<h2>',$L['Search_by_status'],'</h2>',N;
  echo '<form method="get" action="qte_result.php">',N;
  echo '<table class="data_s" cellspacing="0">',N;
  echo '<tr class="data_s">',N;
  echo '<td class="th_s th_s_first th_s_empty"></td>',N;
  echo '<td class="th_s th_s_empty"></td>',N;
  echo '<td class="th_s th_s_last th_s_empty"></td>',N;
  echo '</tr>',N;
  echo '<tr class="data_s">',N;
  echo '<td class="td_s td_s_first" style="text-align:center; width:50px">',AsImg($_SESSION[QT]['skin_dir'].'/ico_section_search.gif','search',$L['Search'],'ico i_sec'),'</td>',N;
  echo '<td class="td_s">',N;
  echo $L['Status'],' <select id="status" name="status" size="1">',QTastags($oSYS->statuses,null,$strStatus),'</select> ',
  $L['In_section'],' 
  <select id="s" name="s" size="1">
  <option value="-1"> </option>',QTastags($oSYS->sections,null,$s),'
  </select></td>
  <td class="td_s td_s_last" style="text-align:right; width:100px"><input type="submit" name="ok" value="',$L['Search'],'"/>&nbsp;</td>
  </tr>
  <tr class="data_s">
  <td class="tf_s tf_s_first"></td>
  <td class="tf_s"></td>
  <td class="tf_s tf_s_last"></td>
  </tr>
  </table>  
  </form>
  ';
  echo '<h2>',$L['Search_by_age'],'</h2>',N;
  echo '<form method="get" action="qte_result.php">',N;
  echo '<table class="data_s" cellspacing="0">',N;
  echo '<tr class="data_s">',N;
  echo '<td class="th_s th_s_first th_s_empty"></td>',N;
  echo '<td class="th_s th_s_empty"></td>',N;
  echo '<td class="th_s th_s_last th_s_empty"></td>',N;
  echo '</tr>',N;
  echo '<tr class="data_s">',N;
  echo '<td class="td_s td_s_first" style="text-align:center; width:50px">',AsImg($_SESSION[QT]['skin_dir'].'/ico_section_search.gif','search',$L['Search'],'ico i_sec'),'</td>',N;
  echo '<td class="td_s">',N;
  echo ObjTrans('field','age').' <select id="age_criteria" name="age_criteria" size="1">',QTastags(array('l'=>'&lt;','u'=>'&gt;=','e'=>'='),null,$strCriteria),'</select> 
  <input type="text" id="age" name="age" size="2" maxlength="2" value="',(isset($_GET['age']) ? $_GET['age'] : 13),'" onkeyup="handle_keypress(event,\'okage\')"/> ',
  $L['In_section'],' 
  <select id="sa" name="s" size="1">
  <option value="-1"> </option>',QTastags($oSYS->sections,null,$s),'
  </select></td>
  <td class="td_s td_s_last" style="text-align:right; width:100px"><input type="submit" id="okage" name="ok" value="',$L['Search'],'"/>&nbsp;</td>
  </tr>
  <tr class="data_s">
  <td class="tf_s tf_s_first"></td>
  <td class="tf_s"></td>
  <td class="tf_s tf_s_last"></td>
  </tr>
  </table>  
  </form>
  <p style="text-align:right"><a href="qte_result.php?role=A">',$L['Userroles']['A'],'</a> | <a href="qte_result.php?role=M">',$L['Userroles']['M'],'</a></p>
  ';
}
else // simple search
{
  echo '<h2>',$L['Search_by_key'],'</h2>',N;
  echo '<form method="get" action="qte_result.php" onsubmit="return ValidateForm(this);">',N;
  echo '<table class="data_s" cellspacing="0">',N;  
  echo '<tr class="data_s">',N;
  echo '<td class="th_s th_s_first th_s_empty"></td>',N;
  echo '<td class="th_s th_s_empty"></td>',N;
  echo '<td class="th_s th_s_last th_s_empty"></td>',N;
  echo '</tr>',N;
  echo '<tr class="data_s">',N;
  echo '<td class="td_s td_s_first" style="text-align:center; width:50px">',AsImg($_SESSION[QT]['skin_dir'].'/ico_section_search.gif','search',$L['Search'],'ico i_sec'),'</td>',N;
  echo '<td class="td_s">',N;
  echo '<input type="text" id="title" name="title" size="30" maxlength="32" value="',(isset($_GET['title']) ? $_GET['title'] : ''),'" onkeyup="handle_keypress(event,\'ok\')"/> 
  <input type="submit" id="ok" name="ok" value="',$L['Search'],'"/>
  </td>
  <td class="td_s td_s_last" style="text-align:right"><a id="advanced" href="',$oVIP->selfurl,'?a=1&amp;title=" onclick="document.getElementById(\'advanced\').href += document.getElementById(\'title\').value;">',$L['Advanced'],'...</a>&nbsp;</td>
  </tr>
  <tr class="data_s">
  <td class="tf_s tf_s_first"></td>
  <td class="tf_s"></td>
  <td class="tf_s tf_s_last"></td>
  </tr>
  </table>
  </form>
  ';
}

// --------
// HTML END
// --------

echo '<script type="text/javascript">document.getElementById("title").focus();</script>';

include('qte_p_footer.php');
?>
