<?php

/**
 * PHP versions 4 and 5
 *
 * LICENSE: This source file is subject to version 3.0 of the PHP license
 * that is available through the world-wide-web at the following URI:
 * http://www.php.net/license.  If you did not receive a copy of
 * the PHP License and are unable to obtain it through the web, please
 * send a note to license@php.net so we can mail you a copy immediately.
 *
 * @category   Team
 * @package    QuickTeam
 * @author     Philippe Vandenberghe <info@qt-cute.org>
 * @copyright  2008-2012 The PHP Group
 * @license    http://www.php.net/license  PHP License 3.0
 * @version    2.0 build:20090311
 * @link       http://www.qt-cute/doc/package/qte
 * @since      File available since Release 1.0.0
 * @deprecated File deprecated in Release 3.0.0
 */

session_start();
require_once('bin/qte_init.php');
$oSYS->output='csv';
if ( $_SESSION[QT]['visitor_right']<2 && $oVIP->role=='V' ) HtmlPage(101);
if ( !$oVIP->CanAccess('MUV',2,true) ) HtmlPage(101);

function ToCsv($str)
{
  if ( $str=='' ) return '"";';
  $str = str_replace('&nbsp;',' ',$str);
  $str = QTconv($str,'-4');
  $str = str_replace('"',"'",$str);
  $str = str_replace(';',',',$str);
  return '"'.$str.'";';
}

// ---------
// INITIALISE
// ---------

// Check arguments

$size = strip_tags($_GET['size']);
$intCount = intval($_GET['n']);

if ( empty($size) || $intCount <= $_SESSION[QT]['items_per_page'] ) $size='all';
if ( strlen($size)>6 || strlen($size)<2 ) die('Invalid argument');
if ( substr($size,0,1)!='p' && substr($size,0,1)!='m' && $size!='all') die('Invalid argument');
if ( substr($size,0,1)=='p' )
{
  $i = intval(substr($size,1));
  if ( empty($i) ) die('Invalid argument');
  if ( ($i-1) > $intCount/$_SESSION[QT]['items_per_page'] ) die('Invalid argument');
}
if ( substr($size,0,1)=='m' )
{
  if ( $size!='m1' && $size!='m2' && $size!='m5' && $size!='m10' ) die('Invalid argument');
}
if ( $intCount>1000 && $size=='all' ) die('Invalid argument');
if ( $intCount<=1000 && substr($size,0,1)=='m' ) die('Invalid argument');
if ( $intCount>1000 && substr($size,0,1)=='p' ) die('Invalid argument');

// apply page argument

if ( substr($size,0,1)=='p' ) $_GET['page'] = substr($size,1);

// Initialise

$strCSV = '';

include('bin/qte_fn_limitsql.php');

$oVIP->selfurl = 'qte_result.php';
$oVIP->selfname = $L['Search_result'];
$oVIP->exiturl = 'qte_search.php';
$oVIP->exitname = $L['Search'];

$strCommand = '';
$numid = '';

$strOrder = 'lastname';
$strDirec = 'DESC';
$intPage = 1;
$intLimit = 0;
$intLen = $_SESSION[QT]['items_per_page'];
if ( isset($_GET['page']) ) { $intLimit = (intval($_GET['page'])-1)*$intLen; $intPage = intval($_GET['page']); }
if ( isset($_GET['order']) ) $strOrder = $_GET['order'];
if ( isset($_GET['dir']) ) $strDirec = $_GET['dir'];

// apply argument

if ( $size=='all') { $intLimit=0; $intLen=$intCount; }
if ( $size=='m1' ) { $intLimit=0; $intLen=999; }
if ( $size=='m2' ) { $intLimit=1000; $intLen=1000; }
if ( $size=='m5' ) { $intLimit=0; $intLen=4999; }
if ( $size=='m10') { $intLimit=5000; $intLen=5000; }

if ( isset($_GET['title']) ) {
if ( strlen($_GET['title'])<2 ) {
  // exit
  $oVIP->exiturl = 'qte_search.php?';
  if ( isset($_GET['title']) ) $oVIP->exiturl .= '?title='.$_GET['title'];
  if ( isset($_GET['role']) ) $oVIP->exiturl .= '&amp;role='.$_GET['role'];
  if ( isset($_GET['status']) ) $oVIP->exiturl .= '&amp;status='.$_GET['status'];
  if ( isset($_GET['s']) ) $oVIP->exiturl .= '&amp;s='.$_GET['s'];
  $oVIP->EndMessage(NULL,$L['E_min_2_char'],$_SESSION[QT]['skin_dir'],2);
}}

if ( isset($_GET['role']) )
{  
  $strSelect = '"role" as ufield,"'.$L['Userrole'][$_GET['role']].'" as ukey,u.id,u.username,u.title,u.firstname,u.midname,u.lastname,u.picture,u.status,u.phones,u.emails,u.privacy,u.y,u.x';
  $strFrom = TABUSER.' u';
  $strWhere = 'u.id>0 AND u.role="'.$_GET['role'].'"';
  if ( isset($_GET['s']) )
  {  
    if ( $_GET['s']>=0 )
    {  
    $strFrom = TABUSER.' u INNER JOIN '.TABS2U.' l ON l.userid = u.id';
    $strWhere = 'u.id>0 AND l.sid='.$_GET['s'];
    }
  }  
}
if ( isset($_GET['age_criteria']) && isset($_GET['age']) )
{  
  $strFrom = TABUSER.' u';
  $intDate = date('Ymd');
  $intDate = intval($intDate)-intval($_GET['age'].'0000');
  switch ($_GET['age_criteria'])
  {
  case 'l':
    $strSelect = '"age" as ufield,"< '.$_GET['age'].'" as ukey,u.id,u.username,u.title,u.firstname,u.midname,u.lastname,u.picture,u.status,u.phones,u.emails,u.birthdate,u.privacy,u.y,u.x';
    $strWhere = 'birthdate <> "0" AND "'.$intDate.'" < birthdate';
    break;
  case 'u':
    $strSelect = '"age" as ufield,">= '.$_GET['age'].'" as ukey,u.id,u.username,u.title,u.firstname,u.midname,u.lastname,u.picture,u.status,u.phones,u.emails,u.birthdate,u.privacy,u.y,u.x';
    $strWhere = 'birthdate <> "0" AND "'.$intDate.'" >= birthdate';
    break;
  case 'e':
    $strSelect = '"age" as ufield,"= '.$_GET['age'].'" as ukey,u.id,u.username,u.title,u.firstname,u.midname,u.lastname,u.picture,u.status,u.phones,u.emails,u.birthdate,u.privacy,u.y,u.x';
    if ( $_GET['age']=="0" )
    {
    $strWhere = 'birthdate = "0"';
    }
    else
    {
    $strWhere = 'birthdate <> "0" AND "'.$intDate.'" >= birthdate AND "'.($intDate-10000).'" < birthdate';
    }
    break;
  }    
  if ( isset($_GET['s']) )
  {  
    if ( $_GET['s']>=0 )
    {  
    $strFrom = TABUSER.' u INNER JOIN '.TABS2U.' l ON l.userid = u.id';
    $strWhere = 'u.id>0 AND l.sid='.$_GET['s'];
    }
  }  
}
if ( isset($_GET['status']) )
{  
  $strSelect = '"status" as ufield,"'.$oSYS->statuses[$_GET['status']]['statusname'].'" as ukey,u.id,u.username,u.title,u.firstname,u.midname,u.lastname,u.picture,u.status,u.phones,u.emails,u.privacy,u.y,u.x';
  $strFrom = TABUSER.' u';
  $strWhere = 'u.id>0  AND u.status="'.$_GET['status'].'"';
  if ( isset($_GET['s']) )
  {  
    if ( $_GET['s']>=0 )
    {  
    $strFrom = TABUSER.' u INNER JOIN '.TABS2U.' l ON l.userid = u.id';
    $strWhere = 'u.id>0 AND l.sid='.$_GET['s'];
    }
  }  
}
if ( isset($_GET['title']) )
{
  $strSelect = 'i.ufield,i.ukey,u.id,u.username,u.title,u.firstname,u.midname,u.lastname,u.picture,u.status,u.phones,u.emails,u.privacy,u.y,u.x';
  $strFrom = TABINDEX.' i INNER JOIN '.TABUSER.' u ON i.userid=u.id';
  $str = trim($_GET['title']); if ( get_magic_quotes_gpc() ) $str = stripslashes($str);
  $str = strtoupper($str);
  $strWhere = 'i.userid>0 AND UPPER(i.ukey) LIKE "%'.$str.'%"';
  if ( isset($_GET['s']) )
  {  
    if ( $_GET['s']>=0 )
    {  
    $strFrom = TABINDEX.' i INNER JOIN '.TABUSER. ' u ON i.userid=u.id INNER JOIN '.TABS2U.' l ON l.userid = u.id';
    $strWhere .= ' AND l.sid='.$_GET['s'];
    }
  }
}

if (isset($_GET['page'])) { $intLimit = ($_GET['page']-1)*$_SESSION[QT]['items_per_page']; $intPage=$_GET['page']; } else { $intLimit=0; $intPage=1; }
if (isset($_GET['order'])) $strOrder = $_GET['order'];
if (isset($_GET['dir']))   $strDirec = $_GET['dir'];

// --------
// QUERY PREPARATION
// --------

// Order
$strFullOrder = 'u.'.$strOrder.' '.$strDirec;
if ( $strOrder=='fullname' ) $strFullOrder='u.lastname'.' '.$strDirec;
  // second order
  if ( $strOrder!='firstname' ) $strFullOrder .= ',u.firstname ASC';

// --------
// HTML START
// --------

  // ----------
  // Prepare fields

  $arrFields = array();
  $arrPageFields = array('ufield','status_i','fullname','phones','emails_i','picture');
  
  foreach($arrPageFields as $i => $strField)
  {
    // extraclass
    $strExtraclass = '';
    if ( $i==0 ) $strExtraclass=' th_t_first';
    if ( $i>=(count($arrPageFields)-1) ) $strExtraclass=' th_t_last';

    switch ($strField)
    {
    case 'status_i':$arrFields[$strField]=ObjTrans('field','status'); break;
    case 'emails_i':$arrFields[$strField]=ObjTrans('field','emails'); break;
    case 'ufield':  $arrFields[$strField]=$L['Result']; break;
    default:        $arrFields[$strField]=ObjTrans('field',$strField); break;
    }
  }

  // ----------
  // Header
  
  foreach($arrFields as $str)
  {
  $strCSV .= ToCsv($str);
  }
  $strCSV .= "UID\r\n";
  
  // ----------
  $oDB->Query( LimitSQL( $strSelect.' FROM '.$strFrom.' WHERE '.$strWhere, $strFullOrder,$intLimit,$_SESSION[QT]['items_per_page'],$intCount) );
  // ----------
  include('qte_member_inc.php');
  // ----------

// OUPUT

if ( isset($_GET['debug']) )
{
  echo $strCSV;
  exit;
}

if ( !headers_sent() )
{
  header('Content-Type: text/csv; charset='.QTE_HTML_CHAR);
  header('Content-Disposition: attachment; filename="qte_'.date('YmdHi').'.csv"');
}

echo $strCSV;
