<?php

/**
 * PHP versions 4 and 5
 *
 * LICENSE: This source file is subject to version 3.0 of the PHP license
 * that is available through the world-wide-web at the following URI:
 * http://www.php.net/license.  If you did not receive a copy of
 * the PHP License and are unable to obtain it through the web, please
 * send a note to license@php.net so we can mail you a copy immediately.
 *
 * @category   Team
 * @package    QuickTeam
 * @author     Philippe Vandenberghe <info@qt-cute.org>
 * @copyright  2008-2012 The PHP Group
 * @license    http://www.php.net/license  PHP License 3.0
 * @version    2.0 build:20090311
 * @link       http://www.qt-cute/doc/package/qte
 * @since      File available since Release 1.0.0
 * @deprecated File deprecated in Release 3.0.0
 */

session_start();
require_once('bin/qte_init.php');
if ( !$oVIP->CanAccess('MUV',3,true) ) HtmlPage(101);

// ---------
// INITIALISE
// ---------

$bMap = UseModule('map');
if ( $bMap ) { if ( empty($_SESSION[QT]['m_map_gkey']) ) $bMap=false; }
if ( $bMap ) { require_once('qtem_map_lib.php'); if ( !QTgcanmap('S',$oVIP->role) ) $bMap=false; }
if ( $bMap ) include(Translate('qtem_map.php'));

include('bin/qte_fn_limitsql.php');

$strOrder = 'username';
$strDirec = 'ASC';
$intPage  = 1;
$intLimit = 0;
$intCount = 0;
if ( isset($_GET['view'])) $_SESSION[QT]['viewmode'] = strip_tags($_GET['view']);
$s = 'S';

$oVIP->selfurl = 'qte_result.php';
$oVIP->selfname = $L['Search_result'];
$oVIP->exiturl = 'qte_search.php';
$oVIP->exitname = $L['Search'];

// --------
// SUBMITTED
// --------

if ( isset($_GET['title']) ) {
if ( strlen($_GET['title'])<2 ) {
  // exit
  $oVIP->exiturl = 'qte_search.php?';
  if ( isset($_GET['title']) ) $oVIP->exiturl .= '?title='.$_GET['title'];
  if ( isset($_GET['role']) ) $oVIP->exiturl .= '&amp;role='.$_GET['role'];
  if ( isset($_GET['status']) ) $oVIP->exiturl .= '&amp;status='.$_GET['status'];
  if ( isset($_GET['s']) ) $oVIP->exiturl .= '&amp;s='.$_GET['s'];
  $oVIP->EndMessage(NULL,$L['E_min_2_char'],$_SESSION[QT]['skin_dir'],2);
}}

$strInfo = '';
$strParam = '';

if ( isset($_GET['role']) )
{  
  $strSelect = '"role" as ufield,"'.$L['Userrole'][$_GET['role']].'" as ukey,u.id,u.username,u.title,u.firstname,u.midname,u.lastname,u.picture,u.status,u.phones,u.emails,u.privacy,u.y,u.x';
  $strFrom = TABUSER.' u';
  $strWhere = 'u.id>0 AND u.role="'.$_GET['role'].'"';
  $strInfo .= $L['Userroles'][$_GET['role']];
  $strParam .= (!empty($strParam) ? '&amp;' : '').'a=1&amp;role='.$_GET['role'];
  if ( isset($_GET['s']) )
  {  
    if ( $_GET['s']>=0 )
    {  
    $strFrom = TABUSER.' u INNER JOIN '.TABS2U.' l ON l.userid = u.id';
    $strWhere = 'u.id>0 AND l.sid='.$_GET['s'];
    $strInfo .= ' '.$L['In_section'].' "'.$oSYS->sections[$_GET['s']].'"';
    $strParam .= (!empty($strParam) ? '&amp;' : '').'s='.$_GET['s'];
    }
  }  
}
if ( isset($_GET['age_criteria']) && isset($_GET['age']) )
{  
  $strFrom = TABUSER.' u';
  $intDate = date('Ymd');
  $intDate = intval($intDate)-intval($_GET['age'].'0000');
  switch ($_GET['age_criteria'])
  {
  case 'l':
    $strSelect = '"age" as ufield,"< '.$_GET['age'].'" as ukey,u.id,u.username,u.title,u.firstname,u.midname,u.lastname,u.picture,u.status,u.phones,u.emails,u.birthdate,u.privacy,u.y,u.x';
    $strWhere = 'birthdate <> "0" AND "'.$intDate.'" < birthdate';
    $strInfo .= $L['Age'].' < '.$_GET['age'];
    break;
  case 'u':
    $strSelect = '"age" as ufield,">= '.$_GET['age'].'" as ukey,u.id,u.username,u.title,u.firstname,u.midname,u.lastname,u.picture,u.status,u.phones,u.emails,u.birthdate,u.privacy,u.y,u.x';
    $strWhere = 'birthdate <> "0" AND "'.$intDate.'" >= birthdate';
    $strInfo .= $L['Age'].' >= '.$_GET['age'];
    break;
  case 'e':
    $strSelect = '"age" as ufield,"= '.$_GET['age'].'" as ukey,u.id,u.username,u.title,u.firstname,u.midname,u.lastname,u.picture,u.status,u.phones,u.emails,u.birthdate,u.privacy,u.y,u.x';
    $strInfo .= $L['Age'].' = '.$_GET['age'];
    if ( $_GET['age']=="0" )
    {
    $strWhere = 'birthdate = "0"';
    }
    else
    {
    $strWhere = 'birthdate <> "0" AND "'.$intDate.'" >= birthdate AND "'.($intDate-10000).'" < birthdate';
    }
    break;
  }    
  $strParam .= (!empty($strParam) ? '&amp;' : '').'age_criteria='.$_GET['age_criteria'].'&amp;age='.$_GET['age'];
  if ( isset($_GET['s']) )
  {  
    if ( $_GET['s']>=0 )
    {  
    $strFrom = TABUSER.' u INNER JOIN '.TABS2U.' l ON l.userid = u.id';
    $strWhere = 'u.id>0 AND l.sid='.$_GET['s'];
    $strInfo .= ' '.$L['In_section'].' "'.$oSYS->sections[$_GET['s']].'"';
    $strParam .= (!empty($strParam) ? '&amp;' : '').'s='.$_GET['s'];
    }
  }  
}
if ( isset($_GET['status']) )
{  
  $strSelect = '"status" as ufield,"'.$oSYS->statuses[$_GET['status']]['statusname'].'" as ukey,u.id,u.username,u.title,u.firstname,u.midname,u.lastname,u.picture,u.status,u.phones,u.emails,u.privacy,u.y,u.x';
  $strFrom = TABUSER.' u';
  $strWhere = 'u.id>0  AND u.status="'.$_GET['status'].'"';
  $strInfo .= $L['Status'].' "'.$oSYS->statuses[$_GET['status']]['statusname'].'"';
  $strParam .= (!empty($strParam) ? '&amp;' : '').'a=1&amp;status='.$_GET['status'];
  if ( isset($_GET['s']) )
  {  
    if ( $_GET['s']>=0 )
    {  
    $strFrom = TABUSER.' u INNER JOIN '.TABS2U.' l ON l.userid = u.id';
    $strWhere = 'u.id>0 AND l.sid='.$_GET['s'];
    $strInfo .= ' '.$L['In_section'].' "'.$oSYS->sections[$_GET['s']].'"';
    $strParam .= (!empty($strParam) ? '&amp;' : '').'s='.$_GET['s'];
    }
  }  
}
if ( isset($_GET['title']) )
{
  $strSelect = 'i.ufield,i.ukey,u.id,u.username,u.title,u.firstname,u.midname,u.lastname,u.picture,u.status,u.phones,u.emails,u.privacy,u.y,u.x';
  $strFrom = TABINDEX.' i INNER JOIN '.TABUSER.' u ON i.userid=u.id';
  $str = trim($_GET['title']); if ( get_magic_quotes_gpc() ) $str = stripslashes($str);
  $str = strtoupper($str);
  $strWhere = 'i.userid>0 AND UPPER(i.ukey) LIKE "%'.$str.'%"';
  $strInfo .= $L['Users_with'].' "'.$str.'"';
  $strParam .= (!empty($strParam) ? '&amp;' : '').'title='.$str;
  if ( isset($_GET['s']) )
  {  
    if ( $_GET['s']>=0 )
    {  
    $strFrom = TABINDEX.' i INNER JOIN '.TABUSER. ' u ON i.userid=u.id INNER JOIN '.TABS2U.' l ON l.userid = u.id';
    $strWhere .= ' AND l.sid='.$_GET['s'];
    $strInfo .= ' '.$L['In_section'].' "'.$oSYS->sections[$_GET['s']].'"';
    $strParam .= (!empty($strParam) ? '&amp;' : '').'s='.$_GET['s'];
    }
  }
}

if ( empty($strInfo) ) die('Missing parameters');
if (isset($_GET['page'])) { $intLimit = ($_GET['page']-1)*$_SESSION[QT]['items_per_page']; $intPage=$_GET['page']; } else { $intLimit=0; $intPage=1; }
if (isset($_GET['order'])) $strOrder = $_GET['order'];
if (isset($_GET['dir']))   $strDirec = $_GET['dir'];

// --------
// QUERY PREPARATION
// --------

// Order
$strFullOrder = 'u.'.$strOrder.' '.$strDirec;
if ( $strOrder=='fullname' ) $strFullOrder='u.lastname'.' '.$strDirec;
  // second order
  if ( $strOrder!='firstname' ) $strFullOrder .= ',u.firstname ASC';

// -----
// COUNT
// -----

$oDB->Query('SELECT count(id) as countid FROM '.$strFrom.' WHERE '.$strWhere);
$row = $row = $oDB->Getrow();
$intCount = $row['countid'];

// --------
// HTML START
// --------

if ( $bMap )
{ 
  $arrMapPoints = array();
  $strHeadScript = QTgmapheader('http://gmaps-utility-library.googlecode.com/svn/trunk/markermanager/release/src/markermanager.js');
  $strBodyAddOnunload='GUnload()';
}

include('qte_p_header.php');

// --------
// Display info
// --------

echo '<h2>'.$oVIP->selfname.'</h2>',N;
echo '<p>'.$strInfo,' &middot; ',LangS('Result',$intCount),S,'&middot; <a href="qte_search.php?',$strParam,'">',$L['Search'],'</a></p>',N;

// --------
// Display no member
// --------

if ( $intCount==0 )
{
  include('qte_p_footer.php');
  exit;
}

// --------
// Pager
// --------

$strPager = MakePager("$oVIP->selfurl?$strParam",$intCount,$_SESSION[QT]['items_per_page'],$intPage);
if ( $strPager ) $strPager = $L['Page'].$strPager;

// --------
// Display top pager
// --------

if ( $strPager )
{
echo '
<table class="hidden" cellspacing="0"><tr class="hidden"><td id="pager_zt">',$strPager,'</td></tr></table>
';
}
else
{
echo '<p></p>';
}

// --------
// Display members
// --------

echo '<table class="data_t" cellspacing="0">',N;
echo '<tr class="data_t">',N;

  // ----------
  // Prepare fields

  $arrFields = array();
  $arrPageFields = array('ufield','status_i','fullname','phones','emails_i','picture');
  
  foreach($arrPageFields as $i => $strField)
  {
    // extraclass
    $strExtraclass = '';
    if ( $i==0 ) $strExtraclass=' th_t_first';
    if ( $i>=(count($arrPageFields)-1) ) $strExtraclass=' th_t_last';

    switch ($strField)
    {
    case 'fullname':$arrFields[$strField]=array('sort'=>'fullname','dir'=>'ASC', 'text'=>ObjTrans('field',$strField), 'class'=>'th_t th_t_'.$strField.$strExtraclass, 'classhref'=>'th_t'); break;
    case 'status_i':$arrFields[$strField]=array('sort'=>'status',  'dir'=>'ASC', 'text'=>' &bull; ',                  'class'=>'th_t th_t_'.$strField.$strExtraclass, 'classhref'=>'th_t'); break;
    case 'address': $arrFields[$strField]=array('sort'=>false,     'dir'=>'ASC', 'text'=>ObjTrans('field',$strField), 'class'=>'th_t th_t_'.$strField.$strExtraclass, 'classhref'=>'th_t'); break;
    case 'descr':   $arrFields[$strField]=array('sort'=>false,     'dir'=>'ASC', 'text'=>ObjTrans('field',$strField), 'class'=>'th_t th_t_'.$strField.$strExtraclass, 'classhref'=>'th_t'); break;
    case 'picture': $arrFields[$strField]=array('sort'=>false,     'dir'=>'ASC', 'text'=>ObjTrans('field',$strField), 'class'=>'th_t th_t_'.$strField.$strExtraclass, 'classhref'=>'th_t'); break;
    case 'phones':  $arrFields[$strField]=array('sort'=>false,     'dir'=>'ASC', 'text'=>ObjTrans('field',$strField), 'class'=>'th_t th_t_'.$strField.$strExtraclass, 'classhref'=>'th_t'); break;
    case 'age':     $arrFields[$strField]=array('sort'=>$strField, 'dir'=>'DESC','text'=>ObjTrans('field',$strField), 'class'=>'th_t th_t_'.$strField.$strExtraclass, 'classhref'=>'th_t'); break;
    case 'emails':  $arrFields[$strField]=array('sort'=>false,     'dir'=>'ASC', 'text'=>ObjTrans('field',$strField), 'class'=>'th_t th_t_'.$strField.$strExtraclass, 'classhref'=>'th_t'); break;
    case 'emails_i':$arrFields[$strField]=array('sort'=>false,     'dir'=>'ASC', 'text'=>ObjTrans('field','emails'),  'class'=>'th_t th_t_'.$strField.$strExtraclass, 'classhref'=>'th_t'); break;
    case 'ufield':  $arrFields[$strField]=array('sort'=>false,     'dir'=>'ASC', 'text'=>$L['Result'],                'class'=>'th_t th_t_'.$strField.$strExtraclass, 'classhref'=>'th_t'); break;
    default:        $arrFields[$strField]=array('sort'=>$strField, 'dir'=>'ASC', 'text'=>ObjTrans('field',$strField), 'class'=>'th_t th_t_'.$strField.$strExtraclass, 'classhref'=>'th_t'); break;
    }
  }
  // ---------
  TableHeader($arrFields,$intCount,"$oVIP->selfurl?page=1&amp;$strParam",$strOrder,$strDirec);
  // ---------

echo '</tr>',N;

  foreach($arrFields as $strKey => $arrValues) { $arrFields[$strKey]['class']=str_replace('th_','td_',$arrFields[$strKey]['class']); }
  // ----------
  $oDB->Query( LimitSQL( $strSelect.' FROM '.$strFrom.' WHERE '.$strWhere, $strFullOrder,$intLimit,$_SESSION[QT]['items_per_page'],$intCount) );
  // ----------
  include('qte_member_inc.php');
  // ----------

echo '<tr class="data_t">',N;
echo '<td class="tf_t tf_t_first"></td>',N;
For ($i=0;$i<(count($arrFields)-2);$i++)
{
echo '<td class="tf_t"></td>',N;
}
echo '<td class="tf_t tf_t_last"></td>',N;
echo '</tr>',N;

echo '</table>',N;

// --------
// Display bottom pager
// --------

// define csv options according to $intCount (max 10000)

$strCsv ='';
if ( $oVIP->role!='V' )
{
  if ( $intCount<=$_SESSION[QT]['items_per_page'] )
  {
  $strCsv = '<a href="qte_result_csv.php?'.$strParam.'&amp;size=all&amp;n='.$intCount.'" class="csv">csv</a>';
  }
  else
  {
  $strCsv = '<a href="qte_result_csv.php?'.$strParam.'&amp;size=p'.$intPage.'&amp;n='.$intCount.'" class="csv">csv <span class="small">('.strtolower($L['Page']).')</span></a>';
  if ( $intCount<=1000 )                   $strCsv .= ' &middot; <a href="qte_result_csv.php?'.$strParam.'&amp;size=all&amp;n='.$intCount.'" class="csv">csv <span class="small">('.strtolower($L['All']).')</span></a>';
  if ( $intCount>1000 && $intCount<=2000 ) $strCsv .= ' &middot; <a href="qte_result_csv.php?'.$strParam.'&amp;size=m1&amp;n='.$intCount.'" class="csv">csv <span class="small">(1-1000)</span></a> &middot; <a href="qte_result_csv.php?'.$strParam.'&amp;size=m2&amp;n='.$intCount.'" class="csv">csv <span class="small">(1000-'.$intCount.')</span></a>';
  if ( $intCount>2000 && $intCount<=5000 ) $strCsv .= ' &middot; <a href="qte_result_csv.php?'.$strParam.'&amp;size=m5&amp;n='.$intCount.'" class="csv">csv <span class="small">(1-5000)</span></a>';
  if ( $intCount>5000 )                    $strCsv .= ' &middot; <a href="qte_result_csv.php?'.$strParam.'&amp;m=5&amp;n='.$intCount.'" class="csv">csv <span class="small">(1-5000)</span></a> &middot; <a href="qte_result_csv.php?'.$strParam.'&amp;m=10&amp;n='.$intCount.'" class="csv">csv <span class="small">(5000-10000)</span></a>';
  }
}
if ( !empty($strCsv) )
{
  $strPager = $strCsv.( $strPager==S || empty($strPager) ? '' : ' &middot; '.$strPager );
}

if ( $strPager )
{
echo '
<table class="hidden" cellspacing="0"><tr class="hidden"><td id="pager_zb">',$strPager,'</td></tr></table>
';
}

// MAP MODULE

if ( $bMap )
{
  if ( count($arrMapPoints)==0 )
  {
  echo '<p class="gmap">'.$L['map']['E_noposition'].'</p>';
  }
  else
  {
     //select zoomto (maximum 15 items in the list)
     if ( count($arrMapPoints)>1 )
     {
       $str = '<p class="gmap" style="margin:0 0 4px 0"><a class="gmap" href="javascript:void(0)" onclick="zoomToFullExtend(); return false;">'.$L['map']['zoomtoall'].'</a> | '.$L['Goto'].' <select class="gmap" id="zoomto" name="zoomto" size="1" onchange="map.setCenter(eval(this.value));">';
       $str .= '<option class="gmap" value="new GLatLng('.QTgety($_SESSION[QT]['m_map_gcenter']).','.QTgetx($_SESSION[QT]['m_map_gcenter']).')"> </option>';
       $i=0;
       foreach ( $arrMapPoints as $intKey => $oMapPoint )
       {
       $str .= '<option class="gmap" value="new GLatLng('.$oMapPoint->y.','.$oMapPoint->x.')">'.$oMapPoint->title.'</option>';
       $i++; if ( $i>15 ) break;       
       }
       $str .= '</select></p>';
     }
  echo '
  <table class="hidden" style="margin-top:5px;">
  <tr class="hidden">
  <td class="gmap">
  ',( count($arrMapPoints)>1 ? $str :'' ),'
  <div id="map_canvas" style="width:100%; height:350px;"></div>
  <p class="gmap" style="margin:4px 0 0 0">',sprintf($L['map']['items'],strtolower( LangS('User',count($arrMapPoints))),strtolower(LangS('User',$intCount)) ),'</p>
  </td>
  </tr>
  </table>
  ';
  }
}

// --------
// HTML END
// --------

if ( $bMap ) {
if ( count($arrMapPoints)>0 ) {

  $x = QTgetx($_SESSION[QT]['m_map_gcenter']);
  $y = QTgety($_SESSION[QT]['m_map_gcenter']);

  // override symbol
  if ( $_SESSION[QT]['m_map']['S']['icon']!='S' ) $arrMapPoints = QTgoverridesymbol($arrMapPoints,$_SESSION[QT]['m_map']['S']['icon']);

  // center on the first item

  foreach ($arrMapPoints as $intKey => $oMapPoint)
  {
    if ( !empty($oMapPoint->y) && !empty($oMapPoint->x) )
    {
    $y=$oMapPoint->y;
    $x=$oMapPoint->x;
    break;
    }
  }
    
  $strFooterAddScript = QTgmappoints($L['map'],$y,$x,'click',$arrMapPoints).N.'mapload();';

  // add zoom full extend if option is set
  
  if ( count($arrMapPoints)>1 ) {
  if ( isset($_SESSION[QT]['m_map']['S']['zoom']) ) {  
  if ( $_SESSION[QT]['m_map']['S']['zoom'] ) {
    $strFooterAddScript .= ' zoomToFullExtend();';
  }}}

}}

include('qte_p_footer.php');