<?php

/*
 * PHP versions 4 and 5
 *
 * LICENSE: This source file is subject to version 3.0 of the PHP license
 * that is available through the world-wide-web at the following URI:
 * http://www.php.net/license.  If you did not receive a copy of
 * the PHP License and are unable to obtain it through the web, please
 * send a note to license@php.net so we can mail you a copy immediately.
 *
 * @category   Adressbook
 * @package    QuickTeam
 * @author     Philippe Vandenberghe <info@qt-cute.org>
 * @copyright  2008-2012 The PHP Group
 * @license    http://www.php.net/license  PHP License 3.0
 * @version    2.0 build:20090311
 * @link       http://www.qt-cute/doc/package/qte
 * @since      File available since Release 1.0.0
 * @deprecated File deprecated in Release 3.0.0
 */

session_start();
require_once('bin/qte_init.php');
$oSYS->output='print';
if ( !$oVIP->CanAccess('MUV',2,true) ) HtmlPage(101);

// ---------
// INITIALISE
// ---------

$s = -1;
if ( isset($_GET['s']) ) $s = intval(strip_tags($_GET['s']));
if ( $s<0 )  die('Missing team id...');

$strGroup = 'all';
$strOrder = 'lastname';
$strDirec = 'ASC';
$intLimit = 0;
$intPage  = 1;

// security check 1
if ( isset($_GET['group']) ) $strGroup = strip_tags($_GET['group']);
if ( isset($_GET['order']) ) $strOrder = strip_tags($_GET['order']);
if ( isset($_GET['dir']) ) $strDirec = strip_tags($_GET['dir']);
if ( isset($_GET['page']) ) $intPage = intval(strip_tags($_GET['page']));
if ( isset($_GET['view']) ) $_SESSION[QT]['viewmode'] = strip_tags($_GET['view']);

// security check 2 (no long argument)
if ( strlen($strGroup)>4 ) die('Invalid argument #group');
if ( strlen($strOrder)>12 ) die('Invalid argument #order');
if ( strlen($strDirec)>4 ) die('Invalid argument #dir');

$intLimit = ($intPage-1)*$_SESSION[QT]['items_per_page'];

$_SESSION[QT]['section']= $s;

include('bin/qte_fn_limitsql.php');

$oSEC = new cSection($s);

if ( $oSEC->type==1 && ($oVIP->role=='V' || $oVIP->role=='U') )
{
  // exit
  $oVIP->selfname = $L['Section'];
  $oVIP->exitname = ObjTrans('index','i',$_SESSION[QT]['index_name']);
  $oVIP->EndMessage(NULL,$L['R_staff'],$_SESSION[QT]['skin_dir'],0);
}
if ( $oSEC->type==2 && $oVIP->role=='V' )
{
  // exit
  $oVIP->selfname = $L['Section'];
  $oVIP->exitname = ObjTrans('index','i',$_SESSION[QT]['index_name']);
  $oVIP->EndMessage(NULL,$L['R_user'],$_SESSION[QT]['skin_dir'],0);
}

$oVIP->selfurl = 'qte_member_prt.php';
$oVIP->selfname = $L['Section'].': '.$oSEC->name;

$strShowZ   = ''; if ( !$_SESSION[QT]['show_Z'] ) $strShowZ = ' AND u.status<>"Z"';

// COUNT Members

$strWhereGroup = '';
Switch ($strGroup)
{
  Case 'all': $strWhereGroup .= ' AND u.id>0'; Break;
  Case '0':   $strWhereGroup .= ' AND '.FirstCharCase('u.lastname','a-z'); Break;
  Default:    $strWhereGroup .= ' AND '.FirstCharCase('u.lastname','u').'="'.$strGroup.'"'; Break;
}
$oDB->Query('SELECT count(*) as countid FROM '.TABUSER.' u INNER JOIN '.TABS2U.' l ON l.userid=u.id WHERE l.sid='.$oSEC->id.$strShowZ.$strWhereGroup);
$row = $oDB->Getrow();
$intCount = $row['countid'];

// LETTRES BAR [$strGroups]

if ( $intCount>$_SESSION[QT]['items_per_page'] || isset($_GET['group']) )
{
  $strGroups = '<td class="lettres" style="width:35px;">'.($strGroup=='all' ? '<b>'.$L['All'].'</b>' : '<a class="lettres" href="'.$oVIP->selfurl.'?s='.$s.'&amp;group=all">'.$L['All'].'</a>' ).'</td>';
  for ($g='A';$g!='AA';$g++)
  {
  $strGroups .= '<td class="lettres" style="width:18px;">'.($strGroup==$g ? '<b>'.$g.'</b>' : '<a class="lettres" href="'.$oVIP->selfurl.'?s='.$s.'&amp;group='.$g.'">'.$g.'</a>' ).'</td>';
  }
  $strGroups .= '<td class="lettres" style="width:18px;">'.($strGroup=='0' ? '<b>#</b>' : '<a class="lettres" href="'.$oVIP->selfurl.'?s='.$s.'&amp;group=0">#</a>' ).'</td>';
  $strGroups .= '<td class="hidden">&nbsp;</td>'.N;
}

// --------
// Pager
// --------

$strPager = MakePager("$oVIP->selfurl?s={$oSEC->id}&group=$strGroup",$intCount,$_SESSION[QT]['items_per_page'],$intPage); 
if ( !empty($strPager) ) { $strPager = $L['Page'].$strPager; } else { $strPager=S; }
if ( $intCount<$oSEC->members ) $strPager = '<span class="small">'.$intCount.' '.$L['Selected_from'].' '.$oSEC->members.' '.strtolower($L['Users']).'</span>'.($strPager==S ? '' : ' | '.$strPager);

// MAP MODULE

$bMap = UseModule('map');
if ( $bMap ) { if ( empty($_SESSION[QT]['m_map_gkey']) ) $bMap=false; }
if ( $bMap ) { require_once('qtem_map_lib.php'); if ( !QTgcanmap($s) ) $bMap=false; }
if ( $bMap ) include(Translate('qtem_map.php'));

// --------
// HTML START
// --------

if ( $bMap )
{ 
  $arrMapPoints = array();
  $strHeadScript = QTgmapheader('http://gmaps-utility-library.googlecode.com/svn/trunk/markermanager/release/src/markermanager.js');
  $strBodyAddOnunload='GUnload()';
}
include('qte_p_header.php');

// --------
// Display description
// --------

if ( $_SESSION[QT]['section_descr']=='1' )
{
  $oSEC->descr .= (empty($oSEC->descr) ? '' : '<br/>').'<span class="small">('.LangS('User',$oSEC->members).')</span>';
  $oSEC->ShowInfo('si_t','si_t','si_t_desc','left');
}

// --------
// Display letters bar
// --------

if ( $intCount>$_SESSION[QT]['items_per_page'] || isset($_GET['group']) ) echo '<table class="lettres" cellspacing="0"><tr class="lettres">',N,$strGroups,N,'</tr></table>',N;

// --------
// Display no member
// --------

if ( $intCount==0 )
{
  echo '<br/>',$L['E_no_member'],'<br/><br/>';
  echo '
  <!-- COPYRIGHT LINE -->
  <div class="footer">
  <table class="hidden">
  <tr class="hidden">
  <td class="hidden" id="footer_zl"> </td>
  <td class="hidden" id="footer_zr">powered by <a href="http://www.qt-cute.org" class="footer_copy">QT-cute</a> v',QTEVERSION,'</td>
  </tr>
  </table>
  </div>
  <!-- END COPYRIGHT LINE -->

  </body>
  </html>';
  exit;
}

// --------
// Display top pager
// --------

if ( $strPager )
{
echo '
<table class="hidden" cellspacing="0"><tr class="hidden"><td id="pager_zt">',$strPager,'</td></tr></table>
';}

// --------
// Display members
// --------

echo '<table class="data_t" cellspacing="0">',N;
echo '<tr class="data_t">',N;

  // ----------
  $arrPageFields = GetFieldsUsable($oSEC->forder,'nid');
  // Add infofield (if exist)
  if ( isset($_SESSION[QT]['infofield']) ) {
  if ( !empty($_SESSION[QT]['infofield']) ) {
    $arrPageFields[]=$_SESSION[QT]['infofield'];
  }}

  // ----------
  // Prepare fields

  $arrFields = array();
  foreach($arrPageFields as $i => $strField)
  {
    if ( isset($_SESSION['L']['field'][$strField]) )
    {
      // extraclass
      $strExtraclass = '';
      if ( $i==0 ) $strExtraclass=' th_t_first';
      if ( $i>=(count($arrPageFields)-1) ) $strExtraclass=' th_t_last';
      
      // define the fields 
      switch ($strField)
      {
      case 'fullname':$arrFields[$strField]=array('sort'=>'fullname','dir'=>'ASC', 'text'=>ObjTrans('field',$strField), 'class'=>'th_t th_t_'.$strField.$strExtraclass, 'classhref'=>'th_t'); break;
      case 'status_i':$arrFields[$strField]=array('sort'=>'status',  'dir'=>'ASC', 'text'=>' &bull; ',                  'class'=>'th_t th_t_'.$strField.$strExtraclass, 'classhref'=>'th_t'); break;
      case 'address': $arrFields[$strField]=array('sort'=>false,     'dir'=>'ASC', 'text'=>ObjTrans('field',$strField), 'class'=>'th_t th_t_'.$strField.$strExtraclass, 'classhref'=>'th_t'); break;
      case 'descr':   $arrFields[$strField]=array('sort'=>false,     'dir'=>'ASC', 'text'=>ObjTrans('field',$strField), 'class'=>'th_t th_t_'.$strField.$strExtraclass, 'classhref'=>'th_t'); break;
      case 'picture': $arrFields[$strField]=array('sort'=>false,     'dir'=>'ASC', 'text'=>ObjTrans('field',$strField), 'class'=>'th_t th_t_'.$strField.$strExtraclass, 'classhref'=>'th_t'); break;
      case 'phones':  $arrFields[$strField]=array('sort'=>false,     'dir'=>'ASC', 'text'=>ObjTrans('field',$strField), 'class'=>'th_t th_t_'.$strField.$strExtraclass, 'classhref'=>'th_t'); break;
      case 'age':     $arrFields[$strField]=array('sort'=>$strField, 'dir'=>'DESC','text'=>ObjTrans('field',$strField), 'class'=>'th_t th_t_'.$strField.$strExtraclass, 'classhref'=>'th_t'); break;
      case 'emails':  $arrFields[$strField]=array('sort'=>false,     'dir'=>'ASC', 'text'=>ObjTrans('field',$strField), 'class'=>'th_t th_t_'.$strField.$strExtraclass, 'classhref'=>'th_t'); break;
      case 'emails_i':$arrFields[$strField]=array('sort'=>false,     'dir'=>'ASC', 'text'=>ObjTrans('field','emails'),  'class'=>'th_t th_t_'.$strField.$strExtraclass, 'classhref'=>'th_t'); break;
      default:        $arrFields[$strField]=array('sort'=>$strField, 'dir'=>'ASC', 'text'=>ObjTrans('field',$strField), 'class'=>'th_t th_t_'.$strField.$strExtraclass, 'classhref'=>'th_t'); break;
      }      
    }
  }
  // ----------
  TableHeader($arrFields,$intCount,"$oVIP->selfurl?s=$s&amp;page=1",$strOrder,$strDirec);
  // ----------

echo '</tr>',N;

  foreach ($arrFields as $strKey => $arrValues) { $arrFields[$strKey]['class']=str_replace('th_','td_',$arrFields[$strKey]['class']); }
  // ----------
  $strState  = 'u.* FROM '.TABUSER.' u INNER JOIN '.TABS2U.' l ON l.userid=u.id WHERE l.sid='.$oSEC->id.$strShowZ.$strWhereGroup;
  if ( $strOrder=='fullname' ) $strOrder='lastname';
  $oDB->Query( LimitSQL($strState,$strOrder.' '.$strDirec,$intLimit,$_SESSION[QT]['items_per_page'],$intCount) );
  // ----------
  include('qte_member_inc.php');
  // ----------

echo '
</table>
';

if ( $bMap )
{
  if ( count($arrMapPoints)==0 )
  {
  echo '<p class="gmap">'.$L['map']['E_noposition'].'</p>';
  }
  else
  {
     //select zoomto (maximum 15 items in the list)
     if ( count($arrMapPoints)>1 )
     {
       $str = '<p class="gmap" style="margin:0 0 4px 0"><a class="gmap" href="javascript:void(0)" onclick="zoomToFullExtend(); return false;">'.$L['map']['zoomtoall'].'</a> | '.$L['Goto'].' <select class="gmap" id="zoomto" name="zoomto" size="1" onchange="map.setCenter(eval(this.value));">';
       $str .= '<option class="gmap" value="new GLatLng('.QTgety($_SESSION[QT]['m_map_gcenter']).','.QTgetx($_SESSION[QT]['m_map_gcenter']).')"> </option>';
       $i=0;
       foreach ( $arrMapPoints as $intKey => $oMapPoint )
       {
       $str .= '<option class="gmap" value="new GLatLng('.$oMapPoint->y.','.$oMapPoint->x.')">'.$oMapPoint->title.'</option>';
       $i++; if ( $i>15 ) break;       
       }
       $str .= '</select></p>';
     }
      
  echo '
  <div class="gmap" style="margin-top:10px;width:550px">
  ',( count($arrMapPoints)>1 ? $str :'' ),'
  <div id="map_canvas" style="width:100%; height:350px;"></div>
  <p class="gmap" style="margin:4px 0 0 0">',sprintf($L['map']['items'],strtolower( LangS('User',count($arrMapPoints))),strtolower(LangS('User',$oSEC->members)) ),'</p>
  </div>
  ';
  }
}

// --------
// Display bottom pager
// --------

if ( $strPager )
{
echo '
<table class="hidden" cellspacing="0"><tr class="hidden"><td id="pager_zb">',$strPager,'</td></tr></table>
';
}

// ---------
// HTML END
// ---------

if ( $bMap ) {
if ( count($arrMapPoints)>0 ) {

  $x = floatval(QTgetx($_SESSION[QT]['m_map_gcenter']));
  $y = floatval(QTgety($_SESSION[QT]['m_map_gcenter']));
  
  // center on the user

  foreach ($arrMapPoints as $intKey => $oMapPoint)
  {
    if ( !empty($oMapPoint->y) && !empty($oMapPoint->x) )
    {
    $y = $oMapPoint->y;
    $x = $oMapPoint->x;
    break;
    }
  }
    
  $strFooterAddScript = QTgmappoints($L['map'],$y,$x,'',$arrMapPoints).N.'mapload();';

  // add zoom full extend if option is set

  if ( count($arrMapPoints)>1 ) {
  if ( isset($_SESSION[QT]['m_map'][$s]['zoom']) ) {  
  if ( $_SESSION[QT]['m_map'][$s]['zoom'] ) {
    $strFooterAddScript .= ' zoomToFullExtend();';
  }}}

}}

include('qte_p_footer.php');

?>