<?php

/**
 * PHP versions 4 and 5
 *
 * LICENSE: This source file is subject to version 3.0 of the PHP license
 * that is available through the world-wide-web at the following URI:
 * http://www.php.net/license.  If you did not receive a copy of
 * the PHP License and are unable to obtain it through the web, please
 * send a note to license@php.net so we can mail you a copy immediately.
 *
 * @category   Adressbook
 * @package    QuickTeam
 * @author     Philippe Vandenberghe <info@qt-cute.org>
 * @copyright  2008-2012 The PHP Group
 * @license    http://www.php.net/license  PHP License 3.0
 * @version    2.0 build:20090311
 * @link       http://www.qt-cute/doc/package/qte
 * @since      File available since Release 1.0.0
 * @deprecated File deprecated in Release 3.0.0
 */

session_start();
require_once('bin/qte_init.php');
$oSYS->output='csv';
if ( $_SESSION[QT]['visitor_right']<2 && $oVIP->role=='V' ) HtmlPage(101);
if ( !$oVIP->CanAccess('MUV',2,true) ) HtmlPage(101);

$s = -1;
if ( isset($_GET['s']) ) $s = intval(strip_tags($_GET['s']));
if ( $s<0 )  die('Missing team id...');

function ToCsv($str)
{
  if ( $str=='' ) return '"";';
  $str = str_replace('&nbsp;',' ',$str);
  $str = QTconv($str,'-4');
  $str = str_replace('"',"'",$str);
  $str = str_replace(';',',',$str);
  return '"'.$str.'";';
}

// ---------
// INITIALISE
// ---------

// Check arguments

$size = strip_tags($_GET['size']);
$intCount = intval($_GET['n']);

if ( empty($size) || $intCount <= $_SESSION[QT]['items_per_page'] ) $size='all';
if ( strlen($size)>6 || strlen($size)<2 ) die('Invalid argument');
if ( substr($size,0,1)!='p' && substr($size,0,1)!='m' && $size!='all') die('Invalid argument');
if ( substr($size,0,1)=='p' )
{
  $i = intval(substr($size,1));
  if ( empty($i) ) die('Invalid argument');
  if ( ($i-1) > $intCount/$_SESSION[QT]['items_per_page'] ) die('Invalid argument');
}
if ( substr($size,0,1)=='m' )
{
  if ( $size!='m1' && $size!='m2' && $size!='m5' && $size!='m10' ) die('Invalid argument');
}
if ( $intCount>1000 && $size=='all' ) die('Invalid argument');
if ( $intCount<=1000 && substr($size,0,1)=='m' ) die('Invalid argument');
if ( $intCount>1000 && substr($size,0,1)=='p' ) die('Invalid argument');

// apply page argument

if ( substr($size,0,1)=='p' ) $_GET['page'] = substr($size,1);

// Initialise

$strCSV = '';

include('bin/qte_fn_limitsql.php');

$oSEC = new cSection($s);

if ( $oSEC->type==1 && ($oVIP->role=='V' || $oVIP->role=='U') )
{
  // exit
  $oVIP->selfname = $L['Section'];
  $oVIP->exitname = ObjTrans('index','i',$_SESSION[QT]['index_name']);
  $oVIP->EndMessage(NULL,$L['R_staff'],$_SESSION[QT]['skin_dir'],0);
}
if ( $oSEC->type==2 && $oVIP->role=='V' )
{
  // exit
  $oVIP->selfname = $L['Section'];
  $oVIP->exitname = ObjTrans('index','i',$_SESSION[QT]['index_name']);
  $oVIP->EndMessage(NULL,$L['R_user'],$_SESSION[QT]['skin_dir'],0);
}

$oVIP->selfurl = 'qte_member.php';
$oVIP->selfname = $L['Section'].': '.$oSEC->name;

$strCommand = '';
$numid = '';

$strGroup = 'all';
$strOrder = 'lastname';
$strDirec = 'DESC';
$intPage = 1;
$intLimit = 0;
$intLen = $_SESSION[QT]['items_per_page'];
if ( isset($_GET['group']) ) $strGroup = strip_tags($_GET['group']); if ( strlen($strGroup)>4 ) die('Invalid argument #group');
if ( isset($_GET['page']) ) { $intLimit = (intval($_GET['page'])-1)*$intLen; $intPage = intval($_GET['page']); }
if ( isset($_GET['order']) ) $strOrder = $_GET['order'];
if ( isset($_GET['dir']) ) $strDirec = $_GET['dir'];

// apply argument

if ( $size=='all') { $intLimit=0; $intLen=$intCount; }
if ( $size=='m1' ) { $intLimit=0; $intLen=999; }
if ( $size=='m2' ) { $intLimit=1000; $intLen=1000; }
if ( $size=='m5' ) { $intLimit=0; $intLen=4999; }
if ( $size=='m10') { $intLimit=5000; $intLen=5000; }

// refine query

$strShowZ   = ''; if ( !$_SESSION[QT]['show_Z'] ) $strShowZ = ' AND u.status<>"Z"';
switch($strGroup)
{
  Case 'all': $strWhereGroup = ' AND id>=0'; Break;
  Case '0':   $strWhereGroup = ' AND '.FirstCharCase('name','a-z'); Break;
  Default:    $strWhereGroup = ' AND '.FirstCharCase('name','u').'="'.$strGroup.'"'; Break;
}

// --------
// HTML START
// --------

  // ----------
  $arrPageFields = GetFieldsUsable($oSEC->forder,'nid');
  // Add infofield (if exist)
  if ( isset($_SESSION[QT]['infofield']) ) {
  if ( !empty($_SESSION[QT]['infofield']) ) {
    $arrPageFields[]=$_SESSION[QT]['infofield'];
  }}

  // ----------
  // Prepare fields

  $arrFields = array();
  foreach($arrPageFields as $i => $strField)
  {
    if ( isset($_SESSION['L']['field'][$strField]) )
    {
      // extraclass
      $strExtraclass = '';
      if ( $i==0 ) $strExtraclass=' th_t_first';
      if ( $i>=(count($arrPageFields)-1) ) $strExtraclass=' th_t_last';
      
      // define the fields 
      switch ($strField)
      {
      case 'status_i':$arrFields[$strField]=ObjTrans('field','status'); break;
      case 'emails_i':$arrFields[$strField]=ObjTrans('field','emails') ; break;
      default:        $arrFields[$strField]=ObjTrans('field',$strField); break;
      }      
    }
  }

  // ----------
  // Header
  
  foreach($arrFields as $str)
  {
  $strCSV .= ToCsv($str);
  }
  $strCSV .= "UID\r\n";

  // ----------
  $strState = 'u.* FROM '.TABUSER.' u INNER JOIN '.TABS2U.' l ON l.userid=u.id WHERE l.sid='.$oSEC->id.$strShowZ.$strWhereGroup;
  if ( $strOrder=='fullname' ) $strOrder='lastname';
  $oDB->Query( LimitSQL($strState,$strOrder.' '.$strDirec,$intLimit,$_SESSION[QT]['items_per_page'],$intCount) );
  // ----------
  include('qte_member_inc.php');
  // ----------

// OUPUT

if ( isset($_GET['debug']) )
{
  echo $strCSV;
  exit;
}

if ( !headers_sent() )
{
  header('Content-Type: text/csv; charset='.QTE_HTML_CHAR);
  header('Content-Disposition: attachment; filename="qte_'.date('YmdHi').'.csv"');
}

echo $strCSV;

?>