<?php

/**
 * PHP versions 4 and 5
 *
 * LICENSE: This source file is subject to version 3.0 of the PHP license
 * that is available through the world-wide-web at the following URI:
 * http://www.php.net/license.  If you did not receive a copy of
 * the PHP License and are unable to obtain it through the web, please
 * send a note to license@php.net so we can mail you a copy immediately.
 *
 * @category   Adressbook
 * @package    QuickTeam
 * @author     Philippe Vandenberghe <info@qt-cute.org>
 * @copyright  2008-2012 The PHP Group
 * @license    http://www.php.net/license  PHP License 3.0
 * @version    2.0 build:20090311
 * @link       http://www.qt-cute/doc/package/qte
 * @since      File available since Release 1.0.0
 * @deprecated File deprecated in Release 3.0.0
 */

session_start();
require_once('bin/qte_init.php');
if ( !$oVIP->CanAccess('MUV',2,true) ) HtmlPage(101);

$s = -1;
if ( isset($_GET['s']) ) $s = intval(strip_tags($_GET['s']));
if ( isset($_POST['s']) ) $s = intval(strip_tags($_POST['s']));
if ( $s<0 )  die('Missing team id...');

// ---------
// SUBMITTED
// ---------

if ( isset($_POST['Maction']) )
{
  if ( $_POST['Maction']=='add' )
  {
    if ( headers_sent() )
    {
    echo '<a href="qte_adm_users_move.php?s=',$s,'">',$L['User_man'],'</a><meta http-equiv="REFRESH" content="0;url=qte_adm_users_move.php?s=',$s,'">';
    }
    else
    {
    header('Location: qte_adm_users_move.php?s='.$s);
    }
    exit;
  }
  if ( $_POST['Maction']=='new' )
  {
    if ( headers_sent() )
    {
    echo '<a href="qte_adm_users.php?s=',$s,'">',$L['User_add'],'</a><meta http-equiv="REFRESH" content="0;url=qte_adm_users.php?s=',$s,'">';
    }
    else
    {
    header('Location: qte_adm_users.php?s='.$s);
    }
    exit;
  }
  if ( $_POST['Maction']=='show_Z' ) $_SESSION[QT]['show_Z']='1';
  if ( $_POST['Maction']=='hide_Z' ) $_SESSION[QT]['show_Z']='0';
  if ( isset($_POST['infofield']) )
  {
    $_SESSION[QT]['infofield']=$_POST['infofield']; // can be ""
  }
  if ( $_POST['Maction']=='email' )
  {
    if ( headers_sent() )
    {
    echo '<a href="qte_email.php?s=',$s,'">',$L['User_man'],'</a><meta http-equiv="REFRESH" content="0;url=qte_email.php?s=',$s,'">';
    }
    else
    {
    header('Location: qte_email.php?s='.$s);
    }
    exit;
  }
}

// ---------
// INITIALISE
// ---------

$strGroup = 'all';
$strOrder = 'lastname';
$strDirec = 'ASC';
$intLimit = 0;
$intPage  = 1;

// security check 1
if ( isset($_GET['group']) ) $strGroup = strip_tags($_GET['group']);
if ( isset($_GET['order']) ) $strOrder = strip_tags($_GET['order']);
if ( isset($_GET['dir']) ) $strDirec = strip_tags($_GET['dir']);
if ( isset($_GET['page']) ) $intPage = intval(strip_tags($_GET['page']));
if ( isset($_GET['view']) ) $_SESSION[QT]['viewmode'] = strip_tags($_GET['view']);

// security check 2 (no long argument)
if ( strlen($strGroup)>4 ) die('Invalid argument #group');
if ( strlen($strOrder)>12 ) die('Invalid argument #order');
if ( strlen($strDirec)>4 ) die('Invalid argument #dir');

$intLimit = ($intPage-1)*$_SESSION[QT]['items_per_page'];

$_SESSION[QT]['section']= $s;

include('bin/qte_fn_limitsql.php');

$oSEC = new cSection($s);

if ( $oSEC->type==1 && ($oVIP->role=='V' || $oVIP->role=='U') )
{
  // exit
  $oVIP->selfname = $L['Section'];
  $oVIP->exitname = ObjTrans('index','i',ObjTrans('index','i',$_SESSION[QT]['index_name']));
  $oVIP->EndMessage(NULL,$L['R_staff'],$_SESSION[QT]['skin_dir'],0);
}
if ( $oSEC->type==2 && $oVIP->role=='V' )
{
  // exit
  $oVIP->selfname = $L['Section'];
  $oVIP->exitname = ObjTrans('index','i',ObjTrans('index','i',$_SESSION[QT]['index_name']));
  $oVIP->EndMessage(NULL,$L['R_user'],$_SESSION[QT]['skin_dir'],0);
}

$oVIP->selfurl = 'qte_member.php';
$oVIP->selfname = $L['Section'].': '.$oSEC->name;

$strShowZ = ''; if ( !$_SESSION[QT]['show_Z'] ) $strShowZ = ' AND u.status<>"Z"';

// COUNT Members

$strWhereGroup = '';
Switch ($strGroup)
{
  Case 'all': $strWhereGroup .= ' AND u.id>0'; Break;
  Case '0':   $strWhereGroup .= ' AND '.FirstCharCase('u.lastname','a-z'); Break;
  Default:    $strWhereGroup .= ' AND '.FirstCharCase('u.lastname','u').'="'.$strGroup.'"'; Break;
}
$oDB->Query('SELECT count(*) as countid FROM '.TABUSER.' u INNER JOIN '.TABS2U.' l ON l.userid=u.id WHERE l.sid='.$oSEC->id.$strShowZ.$strWhereGroup);
$row = $oDB->Getrow();
$intCount = $row['countid'];

// --------
// Letters bar
// --------

if ( $intCount>$_SESSION[QT]['items_per_page'] || isset($_GET['group']) )
{
  $strGroups = '<td class="lettres" style="width:35px;">'.($strGroup=='all' ? '<b>'.$L['All'].'</b>' : '<a class="lettres" href="'.$oVIP->selfurl.'?s='.$s.'&amp;group=all">'.$L['All'].'</a>' ).'</td>';
  for ($g='A';$g!='AA';$g++)
  {
  $strGroups .= '<td class="lettres" style="width:18px;">'.($strGroup==$g ? '<b>'.$g.'</b>' : '<a class="lettres" href="'.$oVIP->selfurl.'?s='.$s.'&amp;group='.$g.'">'.$g.'</a>' ).'</td>';
  }
  $strGroups .= '<td class="lettres" style="width:18px;">'.($strGroup=='0' ? '<b>#</b>' : '<a class="lettres" href="'.$oVIP->selfurl.'?s='.$s.'&amp;group=0">#</a>' ).'</td>';
  $strGroups .= '<td class="hidden">&nbsp;</td>';
}

// --------
// Pager
// --------

$strPager = MakePager("$oVIP->selfurl?s={$oSEC->id}&group=$strGroup",$intCount,$_SESSION[QT]['items_per_page'],$intPage); 
if ( $strPager!='' ) { $strPager = $L['Page'].$strPager; } else { $strPager=S; }
if ( $intCount<$oSEC->members ) $strPager = '<span class="small">'.$intCount.' '.$L['Selected_from'].' '.$oSEC->members.' '.strtolower($L['Users']).'</span>'.($strPager==S ? '' : ' | '.$strPager);

// MAP MODULE

$bMap = UseModule('map');
if ( $bMap ) { if ( empty($_SESSION[QT]['m_map_gkey']) ) $bMap=false; }
if ( $bMap ) { require_once('qtem_map_lib.php'); if ( !QTgcanmap($s) ) $bMap=false; }
if ( $bMap ) include(Translate('qtem_map.php'));

// --------
// HTML START
// --------

if ( $bMap )
{ 
  $Xs = 0;
  $Ys = 0;
  $arrMapPoints = array();
  $strHeadScript = QTgmapheader('http://gmaps-utility-library.googlecode.com/svn/trunk/markermanager/release/src/markermanager.js');
  $strBodyAddOnunload='GUnload()';
  if ( isset($_GET['hidemap']) ) $_SESSION[QT]['m_map_hidelist']=true;
  if ( isset($_GET['showmap']) ) $_SESSION[QT]['m_map_hidelist']=false;
  if ( !isset($_SESSION[QT]['m_map_hidelist']) ) $_SESSION[QT]['m_map_hidelist']=false;
}
include('qte_p_header.php');

  // --------
  // Staff Actions
  // --------
  if ( $oVIP->role=='M' || $oVIP->role=='A' )
  {
    // get the usable field list
    $arrInfofields = GetFieldsUsable(array('status_i','fullname'),'name');
    $arrInfofields['-'] = '--------';
    $arr = GetFieldsUsable(array('title','firstname','midname','lastname','alias','picture','address','phones','emails','www','birthdate','nationality','sexe'),'name');
    $arrInfofields = array_merge($arrInfofields, $arr);
    $arrInfofields['--'] = '--------';
    $arr = GetFieldsUsable(GetFields('team'),'name');
    $arrInfofields = array_merge($arrInfofields, $arr);
    $arrInfofields['---'] = '--------';
    $arr = GetFieldsUsable(array('id','username','role','status','children','firstdate'),'name');
    $arrInfofields = array_merge($arrInfofields, $arr);

    // get current infofield (if exist)
    $strCurrentInfofield=''; if ( isset($_SESSION[QT]['infofield']) ) $strCurrentInfofield=$_SESSION[QT]['infofield'];
    // build listing and disabled used fields
    $strInfofields = QTastags($arrInfofields,null,$strCurrentInfofield);
    $strInfofields = str_replace('-">','-" disabled="disabled">',$strInfofields);
    $arrUsedfields = GetFieldsUsable($oSEC->forder,'nid');
    foreach ($arrUsedfields as $intField=>$strField)
    {
      if ( strstr($strInfofields,'value="'.$strField.'">') )
      {
      $strInfofields = str_replace('value="'.$strField.'">','value="'.$strField.'" disabled="disabled">',$strInfofields);
      }
    }
    echo '
    <form method="post" action="qte_member.php" id="modaction">
    <div class="modboard">
    <span class="modboard">',$L['Userrole'][$oVIP->role],' 
    <select name="Maction" class="small" onchange="',"document.getElementById('modaction').submit();",'">
    <option value="">',S,'</option>
    <optgroup label="Action">
    ';
    if ( $oSEC->status==1 && $oVIP->role=='M' ) 
    {
    echo '<option value="add" disabled="disabled">',$L['User_man'],'...</option>',N;
    }
    else
    {
    echo '<option value="add">',$L['User_man'],'...</option>',N;
    }
    if ( $oVIP->role=='A' ) echo '<option value="new">',$L['User_add'],'...</option>';
    echo '
    <option value="email">',$L['Emails'],'...</option>
    </optgroup>
    <optgroup label="Option">
    <option value="show_Z"',($_SESSION[QT]['show_Z'] ? ' class="bold"' : ''),'>',$L['Show'],': ',$oSYS->statuses['Z']['statusname'],'</option>
    <option value="hide_Z"',(!$_SESSION[QT]['show_Z'] ? ' class="bold"' : ''),'>',$L['Hide'],': ',$oSYS->statuses['Z']['statusname'],'</option>
    </optgroup>
    </select> ',$L['Last_column'],S;
    echo '<select id="infofield" name="infofield" class="small" onchange="',"document.getElementById('modaction').submit();",'">';
    echo '<option value="">',S,'</option>';
    echo $strInfofields;
    echo '</select><input type="submit" name="Mok" value="',$L['Ok'],'" class="small" id="action_ok"/>
    <input type="hidden" name="s" value="',$oSEC->id,'"/>
    <script type="text/javascript">document.getElementById("action_ok").style.visibility="hidden";document.getElementById("action_ok").value="";</script>
    </span>
    </div>
    </form>',N;
  }
  // --------
  // End staff Actions
  // --------

// --------
// Display description
// --------

if ( $_SESSION[QT]['section_descr']=='1' )
{
  $oSEC->descr .= (empty($oSEC->descr) ? '' : '<br/>').'<span class="small">('.LangS('User',$oSEC->members).')</span>';
  $oSEC->ShowInfo('si_t','si_t','si_t_desc','left');
}

// --------
// Display letters bar
// --------

if ( $intCount>$_SESSION[QT]['items_per_page'] || isset($_GET['group']) ) echo '<table class="lettres" cellspacing="0"><tr class="lettres">',N,$strGroups,N,'</tr></table>',N;

// --------
// Display no member
// --------

if ( $intCount==0 )
{
  echo '<p>',$L['E_no_member'],'</p>';
  if ( $oSEC->members>0 && ( $oVIP->role=='A' || $oVIP->role=='M' ) && !empty($strShowZ) )
  {
    $oDB->Query( 'SELECT count(*) as countid FROM '.TABUSER.' u INNER JOIN '.TABS2U.' l ON l.userid=u.id WHERE l.sid='.$oSEC->id.' AND u.status="Z"' );
    $row = $oDB->Getrow();
    $i = intval($row);
    if ( $i>0 ) echo '<p class="disabled">',$L['Hidden'],': ',strtolower(LangS('User',$i).' ('.$L['Status'].' '.$oSYS->statuses['Z']['statusname']),')</p>';
  }
  include('qte_p_footer.php');
  exit;
}

// --------
// Display top pager
// --------

if ( $strPager )
{
echo '
<table class="hidden" cellspacing="0"><tr class="hidden"><td id="pager_zt">',$strPager,'</td></tr></table>
';}
else
{
echo '<br/>',N;
}

// --------
// Display members
// --------

echo '<table class="data_t" cellspacing="0">',N;
echo '<tr class="data_t">',N;

  // ----------
  $arrPageFields = GetFieldsUsable($oSEC->forder,'nid');
  // Add infofield (if exist)
  if ( isset($_SESSION[QT]['infofield']) ) {
  if ( !empty($_SESSION[QT]['infofield']) ) {
    $arrPageFields[]=$_SESSION[QT]['infofield'];
  }}
  
  // ----------
  // check current order (if using default)
  if ( $strOrder=='lastname' ) {
  if (!in_array('lastname',$arrPageFields)) {
    $strOrder='fullname';
    if ( !in_array('fullname',$arrPageFields)) $strOrder='username';
  }}

  // ----------
  // Prepare fields

  $arrFields = array();
  foreach($arrPageFields as $i => $strField)
  {
    // extraclass
    $strExtraclass = '';
    if ( $i==0 ) $strExtraclass=' th_t_first';
    if ( $i>=(count($arrPageFields)-1) ) $strExtraclass=' th_t_last';

    // define the fields 
    switch ($strField)
    {
    case 'status_i':$arrFields[$strField]=array('sort'=>'status',  'dir'=>'ASC', 'text'=>' &bull; ',                  'class'=>'th_t th_t_'.$strField.$strExtraclass); break;
    case 'address': $arrFields[$strField]=array('sort'=>false,     'dir'=>'ASC', 'text'=>ObjTrans('field',$strField), 'class'=>'th_t th_t_'.$strField.$strExtraclass); break;
    case 'descr':   $arrFields[$strField]=array('sort'=>false,     'dir'=>'ASC', 'text'=>ObjTrans('field',$strField), 'class'=>'th_t th_t_'.$strField.$strExtraclass); break;
    case 'picture': $arrFields[$strField]=array('sort'=>false,     'dir'=>'ASC', 'text'=>ObjTrans('field',$strField), 'class'=>'th_t th_t_'.$strField.$strExtraclass); break;
    case 'phones':  $arrFields[$strField]=array('sort'=>false,     'dir'=>'ASC', 'text'=>ObjTrans('field',$strField), 'class'=>'th_t th_t_'.$strField.$strExtraclass); break;
    case 'age':     $arrFields[$strField]=array('sort'=>$strField, 'dir'=>'DESC','text'=>ObjTrans('field',$strField), 'class'=>'th_t th_t_'.$strField.$strExtraclass); break;
    case 'emails':  $arrFields[$strField]=array('sort'=>false,     'dir'=>'ASC', 'text'=>ObjTrans('field',$strField), 'class'=>'th_t th_t_'.$strField.$strExtraclass); break;
    case 'emails_i':$arrFields[$strField]=array('sort'=>false,     'dir'=>'ASC', 'text'=>ObjTrans('field','emails'),  'class'=>'th_t th_t_'.$strField.$strExtraclass); break;
    default:        $arrFields[$strField]=array('sort'=>$strField, 'dir'=>'ASC', 'text'=>ObjTrans('field',$strField), 'class'=>'th_t th_t_'.$strField.$strExtraclass); break;
    }
  }
  // ----------
  TableHeader($arrFields,$intCount,"$oVIP->selfurl?s=$s&amp;page=1",$strOrder,$strDirec);
  // ----------

echo '</tr>',N;

  foreach ($arrFields as $strKey => $arrValues)
  {
  if ( isset($arrFields[$strKey]['class']) ) $arrFields[$strKey]['class'] = str_replace('th_','td_',$arrFields[$strKey]['class']);
  }
  // ----------
  $strState  = 'u.* FROM '.TABUSER.' u INNER JOIN '.TABS2U.' l ON l.userid=u.id WHERE l.sid='.$oSEC->id.$strShowZ.$strWhereGroup;
  if ( substr($strOrder,0,2)!='u.' ) $strOrder = 'u.'.$strOrder;
  if ( $strOrder=='u.fullname' ) $strOrder = 'u.lastname';
  if ( $strOrder=='u.status_i' ) $strOrder = 'u.status, u.lastname';
  $oDB->Query( LimitSQL($strState,$strOrder.' '.$strDirec,$intLimit,$_SESSION[QT]['items_per_page'],$intCount) );
  // ----------
  $strSection = strval($oSEC->id);
  include('qte_member_inc.php');
  // ----------

echo '<tr class="data_t">',N;
echo '<td class="tf_t tf_t_first"></td>',N;
For ($i=0;$i<(count($arrFields)-2);$i++)
{
echo '<td class="tf_t"></td>',N;
}
echo '<td class="tf_t tf_t_last"></td>
</tr>
</table>
';

// --------
// Display bottom pager
// --------

// define csv options according to $intCount (max 10000)

$strCsv ='';
if ( $oVIP->role!='V' )
{
  if ( $intCount<=$_SESSION[QT]['items_per_page'] )
  {
  $strCsv = '<a href="qte_member_csv.php?s='.$s.'&amp;size=all&amp;n='.$intCount.'" class="csv">csv</a>';
  }
  else
  {
  $strCsv = '<a href="qte_member_csv.php?s='.$s.'&amp;size=p'.$intPage.'&amp;n='.$intCount.'" class="csv">csv <span class="small">('.strtolower($L['Page']).')</span></a>';
  if ( $intCount<=1000 )                   $strCsv .= ' &middot; <a href="qte_member_csv.php?s='.$s.'&amp;size=all&amp;n='.$intCount.'" class="csv">csv <span class="small">('.strtolower($L['All']).')</span></a>';
  if ( $intCount>1000 && $intCount<=2000 ) $strCsv .= ' &middot; <a href="qte_member_csv.php?s='.$s.'&amp;size=m1&amp;n='.$intCount.'" class="csv">csv <span class="small">(1-1000)</span></a> &middot; <a href="qte_member_csv.php?s='.$s.'&amp;size=m2&amp;n='.$intCount.'" class="csv">csv <span class="small">(1000-'.$intCount.')</span></a>';
  if ( $intCount>2000 && $intCount<=5000 ) $strCsv .= ' &middot; <a href="qte_member_csv.php?s='.$s.'&amp;size=m5&amp;n='.$intCount.'" class="csv">csv <span class="small">(1-5000)</span></a>';
  if ( $intCount>5000 )                    $strCsv .= ' &middot; <a href="qte_member_csv.php?s='.$s.'&amp;m=5&amp;n='.$intCount.'" class="csv">csv <span class="small">(1-5000)</span></a> &middot; <a href="qte_member_csv.php?s='.$s.'&amp;m=10&amp;n='.$intCount.'" class="csv">csv <span class="small">(5000-10000)</span></a>';
  }
}
if ( !empty($strCsv) )
{
  $strPager = $strCsv.( $strPager==S || empty($strPager) ? '' : ' &middot; '.$strPager );
}

if ( !empty($strPager) && $strPager!=S )
{
echo '
<table class="hidden" cellspacing="0"><tr class="hidden"><td id="pager_zb">',$strPager,'</td></tr></table>
';
}

// --------
// Map module
// --------

if ( $bMap )
{
  if ( count($arrMapPoints)==0 )
  {
  echo '<p class="gmap">'.$L['map']['E_noposition'].'</p>';
  }
  else
  {
     //select zoomto (maximum 15 items in the list)
     if ( count($arrMapPoints)>1 )
     {
       $str = '<p class="gmap" style="margin:0 0 4px 0"><a class="gmap" href="javascript:void(0)" onclick="zoomToFullExtend(); return false;">'.$L['map']['zoomtoall'].'</a> | '.$L['Goto'].' <select class="gmap" id="zoomto" name="zoomto" size="1" onchange="map.setCenter(eval(this.value));">';
       $str .= '<option class="gmap" value="new GLatLng('.QTgety($_SESSION[QT]['m_map_gcenter']).','.QTgetx($_SESSION[QT]['m_map_gcenter']).')"> </option>';
       $i=0;
       foreach ( $arrMapPoints as $intKey => $oMapPoint )
       {
       $str .= '<option class="gmap" value="new GLatLng('.$oMapPoint->y.','.$oMapPoint->x.')">'.$oMapPoint->title.'</option>';
       $i++; if ( $i>15 ) break;       
       }
       $str .= '</select></p>';
     }
      
  echo '
  <table class="hidden" style="margin-top:5px;">
  <tr class="hidden">
  <td class="gmap">
  ';
  if ( count($arrMapPoints)>1 && !$_SESSION[QT]['m_map_hidelist'] ) echo $str;
  if ( !$_SESSION[QT]['m_map_hidelist'] )
  {
  echo '<div id="map_canvas" style="width:100%; height:350px;"></div>';
  }
  echo '
  <p class="gmap" style="margin:4px 0 0 0">',sprintf($L['map']['items'],strtolower( LangS('User',count($arrMapPoints))),strtolower(LangS('User',$oSEC->members)) ),'</p>
  </td>
  </tr>
  </table>
  ';
  }
  if ( count($arrMapPoints)!=0 )
  {
    if ( $_SESSION[QT]['m_map_hidelist'] )
    {
    echo '<p style="margin:2px"><a href="',$oVIP->selfurl,'?s=',$s,'&amp;showmap">',$L['map']['Show_map'],'</a></p>';
    }
    else
    {
    echo '<p style="margin:2px"><a href="',$oVIP->selfurl,'?s=',$s,'&amp;hidemap">',$L['map']['Hide_map'],'</a></p>';
    }
  }
}

// --------
// HTML END
// --------

if ( $bMap ) {
if ( count($arrMapPoints)>0 ) {

  $y = floatval(QTgety($_SESSION[QT]['m_map_gcenter']));
  $x = floatval(QTgetx($_SESSION[QT]['m_map_gcenter']));
    
  // center on the user
  
  foreach ($arrMapPoints as $intKey => $oMapPoint)
  {
    if ( !empty($oMapPoint->y) && !empty($oMapPoint->x) )
    {
    $y = $oMapPoint->y;
    $x = $oMapPoint->x;
    break;
    }
  }

  $strFooterAddScript = QTgmappoints($L['map'],$y,$x,'click',$arrMapPoints).N.'mapload();';
  
  // add zoom full extend if option is set
  
  if ( count($arrMapPoints)>1 ) {
  if ( isset($_SESSION[QT]['m_map'][$s]['zoom']) ) {  
  if ( $_SESSION[QT]['m_map'][$s]['zoom'] ) {
    $strFooterAddScript .= ' zoomToFullExtend();';
  }}}
  

}}

include('qte_p_footer.php');

?>