<?php

/* PHP versions 4 and 5
 *
 * LICENSE: This source file is subject to version 3.0 of the PHP license
 * that is available through the world-wide-web at the following URI:
 * http://www.php.net/license.  If you did not receive a copy of
 * the PHP License and are unable to obtain it through the web, please
 * send a note to license@php.net so we can mail you a copy immediately.
 *
 * @category   Team
 * @package    QuickTeam team
 * @author     Philippe Vandenberghe <info@qt-cute.org>
 * @copyright  2008-2012 The PHP Group
 * @license    http://www.php.net/license  PHP License 3.0
 * @version    2.0 build:20090311
 * @link       http://www.qt-cute/doc/package/qte
 * @since      File available since Release 1.0.0
 * @deprecated File deprecated in Release 3.0.0
 */

session_start();
require_once('bin/qte_init.php');
$oVIP->selfurl = 'qte_index.php';

// --------
// SECURITY
// --------

if ( $_SESSION[QT]['board_offline']=='1' ) HtmlPage(0);
if ( $_SESSION[QT]['visitor_right']<1 && $oVIP->role=='V' ) HtmlPage(101);

// --------
// INITIALIZE
// --------

$arrDomains = GetDomains();
if ( isset($_SESSION[QT]['section']) )  unset($_SESSION[QT]['section']);

// --------
// HTML START
// --------

$bJava = false;

include('qte_p_header.php');

// --------
// DOMAIN / SECTIONS
// --------

$intDom = 0;
$intSec = 0;
foreach($arrDomains as $intDomid=>$strDomtitle)
{
  $arrSections = GetSections($oVIP->role,$intDomid);

  if ( count($arrSections)>0 )
  {
    $intDom++;
    if ( $intDom>1 ) echo '<!-- domain separator -->',N,'<div class="dom_separator"></div>',N;
    echo '<!-- domain ',$intDomid,': ',$strDomtitle,' -->',N;
    echo '<table class="data_s" cellspacing="0">',N;
    echo '<colgroup span="4"><col style="width:50px"></col><col></col><col style="width:200px"></col><col style="width:60px"></col></colgroup>',N;
    echo '<tr class="data_s data_s0">',N;
    echo '<td class="th_s th_s_ico th_s_first">',S,'</td>',N;
    echo '<td class="th_s th_s_tit">',$strDomtitle,'</td>',N;
    echo '<td class="th_s th_s_sta">',S,'</td>',N;
    echo '<td class="th_s th_s_sta th_s_last">',$L['Users'],'</td>',N;
    echo '</tr>',N;

    // SHOW SECTIONS

    $strAlt='1';

    foreach($arrSections as $intSection=>$arrSection)
    {
      $intSec++;
      $oSEC = new cSection($arrSection,true);

      echo '<tr class="data_s data_s',$strAlt,'">',N;
      echo '<td class="td_s td_s_ico',$strAlt,' td_s_first">',AsImg($_SESSION[QT]['skin_dir'].'/ico_section_'.$oSEC->type.'_'.$oSEC->status.'.gif','[+]',$L['Ico_section_'.$oSEC->type.'_'.$oSEC->status],'ico i_sec','','qte_member.php?s='.$oSEC->id),'</td>',N;
      echo '<td class="td_s td_s_tit',$strAlt,'"><a class="section" href="qte_member.php?s=',$oSEC->id,'">',$oSEC->name,'</a><br/><span class="sectiondesc">',$oSEC->descr,'</span></td>',N;
      echo '<td class="td_s td_s_sta',$strAlt,'">',(!empty($oSEC->picture) ? AsImg($oSEC->picture,'logo',$oSEC->name,'section','','qte_member.php?s='.$oSEC->id) : S),'</td>',N;
      echo '<td class="td_s td_s_sta',$strAlt,' td_s_last">',$oSEC->members,'</td>',N;
      echo '</tr>',N;
      if ( $strAlt=='1' ) { $strAlt='2'; } else { $strAlt='1'; }
    }

    // no data
    echo '<tr class="tf_s">',N;
    echo '<td class="tf_s tf_s_first"></td>',N;
    echo '<td class="tf_s"></td>',N;
    echo '<td class="tf_s"></td>',N;
    echo '<td class="tf_s tf_s_last"></td>',N;
    echo '</tr>',N;
    echo '</table>',N;
  }
}

// No public section

if ( $intSec==0 )
{
  echo '<p>',( $oVIP->role=='V' ? $L['E_no_public_section'] : $L['E_no_visible_section'] ),'</p>';
}

// --------
// HTML END
// --------

if ( isset($oSEC) ) unset($oSEC);
include('qte_p_footer.php');

?>