<?php

/*
 * PHP versions 4 and 5
 *
 * LICENSE: This source file is subject to version 3.0 of the PHP license
 * that is available through the world-wide-web at the following URI:
 * http://www.php.net/license.  If you did not receive a copy of
 * the PHP License and are unable to obtain it through the web, please
 * send a note to license@php.net so we can mail you a copy immediately.
 *
 * @category   Adressbook
 * @package    QuickTeam
 * @author     Philippe Vandenberghe <info@qt-cute.org>
 * @copyright  2008-2012 The PHP Group
 * @license    http://www.php.net/license  PHP License 3.0
 * @version    2.0 build:20090311
 * @link       http://www.qt-cute/doc/package/qte
 * @since      File available since Release 1.0.0
 * @deprecated File deprecated in Release 3.0.0
 */

session_start();
require_once('bin/qte_init.php');
if ( !$oVIP->CanAccess('MUV',2,true) ) HtmlPage(101);

// ---------
// INITIALISE
// ---------
// Note: This returns pages of 100 items ($_SESSION[QT]['items_per_page'] replaced by 100)

$s = -1;
if ( isset($_GET['s']) ) $s = intval(strip_tags($_GET['s']));
if ( $s<0 )  die('Missing team id...');

$strGroup = 'all';
$strOrder = 'lastname';
$strDirec = 'ASC';
$intLimit = 0;
$intPage  = 1;

// security check 1
if ( isset($_GET['group']) ) $strGroup = strip_tags($_GET['group']);
if ( isset($_GET['order']) ) $strOrder = strip_tags($_GET['order']);
if ( isset($_GET['dir']) ) $strDirec = strip_tags($_GET['dir']);
if ( isset($_GET['page']) ) $intPage = intval(strip_tags($_GET['page']));
if ( isset($_GET['view']) ) $_SESSION[QT]['viewmode'] = strip_tags($_GET['view']);

// security check 2 (no long argument)
if ( strlen($strGroup)>4 ) die('Invalid argument #group');
if ( strlen($strOrder)>12 ) die('Invalid argument #order');
if ( strlen($strDirec)>4 ) die('Invalid argument #dir');

$intLimit = ($intPage-1)*100;

$_SESSION[QT]['section'] = $s;

include('bin/qte_fn_limitsql.php');

$oSEC = new cSection($s);

if ( $oSEC->type==1 && ($oVIP->role=='V' || $oVIP->role=='U') )
{
  // exit
  $oVIP->selfname = $L['Section'];
  $oVIP->exitname = ObjTrans('index','i',$_SESSION[QT]['index_name']);
  $oVIP->EndMessage(NULL,$L['R_staff'],$_SESSION[QT]['skin_dir'],0);
}
if ( $oSEC->type==2 && $oVIP->role=='V' )
{
  // exit
  $oVIP->selfname = $L['Section'];
  $oVIP->exitname = ObjTrans('index','i',$_SESSION[QT]['index_name']);
  $oVIP->EndMessage(NULL,$L['R_user'],$_SESSION[QT]['skin_dir'],0);
}

$oVIP->selfurl = 'qte_email.php';
$oVIP->selfname = $L['Section'].': '.$oSEC->name;

$strShowZ   = ''; if ( !$_SESSION[QT]['show_Z'] ) $strShowZ = ' AND u.status<>"Z"';

// COUNT Members

$strWhereGroup = '';
Switch ($strGroup)
{
  Case 'all': $strWhereGroup .= ' AND u.id>0'; Break;
  Case '0':   $strWhereGroup .= ' AND '.FirstCharCase('u.username','a-z'); Break;
  Default:    $strWhereGroup .= ' AND '.FirstCharCase('u.username','u').'="'.$strGroup.'"'; Break;
}
$oDB->Query('SELECT count(*) as countid FROM '.TABUSER.' u INNER JOIN '.TABS2U.' l ON l.userid=u.id WHERE l.sid='.$oSEC->id.$strShowZ.$strWhereGroup);
$row = $oDB->Getrow();
$intCount = $row['countid'];

// --------
// Letters bar
// --------

$strGroups='';

if ( $oSEC->members>100 )
{
  $strGroups = '<td class="lettres" style="width:35px;">'.($strGroup=='all' ? '<b>'.$L['All'].'</b>' : '<a class="lettres" href="'.$oVIP->selfurl.'?s='.$s.'&amp;group=all">'.$L['All'].'</a>' ).'</td>';
  for ($g='A';$g!='AA';$g++)
  {
  $strGroups .= '<td class="lettres" style="width:18px;">'.($strGroup==$g ? '<b>'.$g.'</b>' : '<a class="lettres" href="'.$oVIP->selfurl.'?s='.$s.'&amp;group='.$g.'">'.$g.'</a>' ).'</td>';
  }
  $strGroups .= '<td class="lettres" style="width:18px;">'.($strGroup=='0' ? '<b>#</b>' : '<a class="lettres" href="'.$oVIP->selfurl.'?s='.$s.'&amp;group=0">#</a>' ).'</td>';
  $strGroups .= '<td class="hidden">&nbsp;</td>'.N;
}

// --------
// Pager
// --------

$strPager = MakePager("$oVIP->selfurl?s={$oSEC->id}&group=$strGroup",$intCount,100,$intPage);
if ( !empty($strPager) ) { $strPager = $L['Page'].$strPager; } else { $strPager=S; }
if ( $intCount<$oSEC->members ) $strPager = '<span class="small">'.$intCount.' '.$L['Selected_from'].' '.$oSEC->members.' '.strtolower($L['Users']).'</span>'.($strPager==S ? '' : ' | '.$strPager);

// --------
// HTML START
// --------

include('qte_p_header.php');

// --------
// Display description
// --------

if ( $_SESSION[QT]['section_descr']=='1' )
{
  $oSEC->descr .= (empty($oSEC->descr) ? '' : '<br/>').'<span class="small">('.LangS('User',$oSEC->members).')</span>';
  $oSEC->ShowInfo('si_e','si_e','si_e_desc','left');
}

// --------
// Display letters bar
// --------

if ( $oSEC->members>100 || isset($_GET['group']) ) echo '<table class="lettres" cellspacing="0"><tr class="lettres">',N,$strGroups,N,'</tr></table>',N;

// --------
// Display no member
// --------
if ( $intCount==0 )
{
  echo '<br/>',$L['E_no_member'],'<br/><br/>';
  include('qte_p_footer.php');
  exit;
}

// --------
// Display top pager
// --------

if ( $strPager )
{
echo '
<table class="hidden" cellspacing="0"><tr class="hidden"><td id="pager_zt">',$strPager,'</td></tr></table>
';
}
else
{
echo '<br/>';
}

// --------
// Query members
// --------

$arrFields[0]       = array('sort'=>false, 'text'=>'&nbsp;',                  'class'=>'th_t th_t_first', 'style'=>'', 'classhref'=>'th_t');
$arrFields['email'] = array('sort'=>false, 'text'=>ObjTrans('field','emails'),'class'=>'th_t',            'style'=>'', 'classhref'=>'th_t');
$arrFields['dinst'] = array('sort'=>false, 'text'=>ObjTrans('field','emails'),'class'=>'th_t',            'style'=>'', 'classhref'=>'th_t');
$arrFields[9]       = array('sort'=>false, 'text'=>'&nbsp;',                  'class'=>'th_t th_t_last',  'style'=>'', 'classhref'=>'th_t');

// ----------
$strState  = 'u.id,u.title,u.firstname,u.midname,u.lastname,u.alias,u.privacy,u.emails FROM '.TABUSER.' u INNER JOIN '.TABS2U.' l ON l.userid=u.id WHERE l.sid='.$oSEC->id.$strShowZ.$strWhereGroup;
if ( substr($strOrder,0,2)!='u.' ) $strOrder = 'u.'.$strOrder;
if ( $strOrder=='u.fullname' ) $strOrder = 'u.lastname';
$oDB->Query( LimitSQL($strState,$strOrder.' '.$strDirec,$intLimit,100,$intCount) );
// ----------
$strCell='';
$strText='';
$i=0;
while ( $row=$oDB->Getrow() )
{
  $oUser = new cUser($row,true);  // privatise
  if ( !empty($oUser->emails) )
  {
  $strCell .= $oUser->fullname.'&nbsp;&nbsp;<a class="small" href="mailto:'.strip_tags($oUser->emails).'" title="'.$oUser->fullname.'">'.$oUser->emails.'</a>'.(strstr($oUser->privacy,'emails') ? ' ('.$L['Hidden'].')' : '').'<br/>';
  $strText .= trim(strip_tags($oUser->emails)).';'; // strip_tags because privatise adds <span>
  $i++;
  }
}
// remove duplicate
if ( !empty($strText) )
{
$strText = str_replace(' ','',$strText);
$strText = str_replace(';;',';',$strText);
if ( substr($strText,-1,1)==';' ) $strText=substr($strText,0,-1);
$arrText = explode(';',$strText);
$arrText = array_unique($arrText);
}
// ----------

// --------
// Display members
// --------

echo '<table class="data_t" cellspacing="0">',N;
echo '<tr class="data_o">',N;
// ----------
TableHeader($arrFields,$intCount,"$oVIP->selfurl?s=$s&amp;page=1",$strOrder,$strDirec);
// ----------
echo '</tr>',N;

echo '<tr class="data_o">
<td class="td_s td_s_first">&nbsp;</td>
<td class="td_s td_s_last" style="vertical-align:top">',sprintf($L['Emails_from'],$i,$intCount),'</td>
<td class="td_s td_s_last" style="vertical-align:top">',sprintf($L['Emails_dist_from'],count($arrText),$intCount),'</td>
<td class="td_s td_s_last">&nbsp;</td>
</tr>
';
echo '<tr class="data_o">
<td class="td_s td_s_first">&nbsp;</td>
<td class="td_s" style="vertical-align:top">
',$strCell,'
</td>
<td class="td_s" style="vertical-align:top"><textarea class="small" rows="',(count($arrText)>20 ? '40' : '15'),'" cols="50">',( empty($arrText) ? '' : implode('; ',$arrText) ),'</textarea></td>
<td class="td_s td_s_last">&nbsp;</td>
</tr>
';
echo '<tr class="data_o">
<td class="tf_s tf_s_first"></td>
<td class="tf_s"></td>
<td class="tf_s"></td>
<td class="tf_s tf_s_last"></td>
</tr>
</table>
';

// --------
// Display bottom pager
// --------

if ( $strPager )
{
echo '
<table class="hidden" cellspacing="0"><tr class="hidden"><td id="pager_zb">',$strPager,'</td></tr></table>
';
}

// --------
// HTML END
// --------

include('qte_p_footer.php');

?>