<?php

/*
 * PHP versions 4 and 5
 *
 * LICENSE: This source file is subject to version 3.0 of the PHP license
 * that is available through the world-wide-web at the following URI:
 * http://www.php.net/license.  If you did not receive a copy of
 * the PHP License and are unable to obtain it through the web, please
 * send a note to license@php.net so we can mail you a copy immediately.
 *
 * @category   Team
 * @package    QuickTeam
 * @author     Philippe Vandenberghe <info@qt-cute.org>
 * @copyright  2008-2012 The PHP Group
 * @license    http://www.php.net/license  PHP License 3.0
 * @version    2.0 build:20090311
 * @link       http://www.qt-cute/doc/package/qte
 * @since      File available since Release 1.0.0
 * @deprecated File deprecated in Release 3.0.0
 *
 */

session_start();
require_once('bin/qte_init.php');
if ( !$oVIP->CanAccess('AM',4,true) ) $oVIP->EndMessage('!',$L['R_staff'],$_SESSION[QT]['skin_dir'],0);

// ---------
// INITIALISE
// ---------

include('bin/qt_lib_smtp.php');
include(Translate('qte_adm.php'));

$oVIP->selfurl = 'qte_adm_users_move.php';
$oVIP->selfname = $L['User_man'];
$oVIP->exiturl  = 'qte_adm_sections.php';
$oVIP->exitname = '&laquo; '.$L['Sections'];

$s = -1;
if ( isset($_GET['s']) ) $s = intval(strip_tags($_GET['s']));
if ( isset($_POST['s']) ) $s = intval(strip_tags($_POST['s']));
if ( $s<0 ) die('Wrong id in '.$oVIP->selfurl);

$strShowsection = 'all'; if ( isset($_POST['showsection']) ) $strShowsection = strval($_POST['showsection']); // must be a string
$strShowusers = 'all'; if ( isset($_POST['showusers']) ) $strShowusers = strval($_POST['showusers']); // must be a string
$strMoveInfo = '';

$oSEC = new cSection($s);
if ( $oSEC->status==1 && $oVIP->role=='M' ) $oVIP->EndMessage('!',$L['R_admin'],$_SESSION[QT]['skin_dir'],0);

// --------
// SUBMITTED
// --------

if ( isset($_POST['add']) && isset($_POST['sec_add']) )
{
  $i = 0;
  foreach($_POST['sec_add'] as $intKey)
  {
  if ( cUser::InSection($s,'add',$intKey) ) $i++;
  }
  if ( $i>1 ) 
  {
  $strMoveInfo .= $i.' '.sprintf($L['Members_added'],$oSEC->name);
  }
  else
  {
  $strMoveInfo .= $i.' '.sprintf($L['Member_added'],$oSEC->name);
  }
  $oSEC->UpdateStats($s);
}
if ( isset($_POST['rem']) && isset($_POST['sec_del']) )
{
  $i = 0;
  foreach($_POST['sec_del'] as $intKey)
  {
  if ( cUser::InSection($s,'rem',$intKey) ) $i++;
  }
  if ( $i>1 ) 
  {
  $strMoveInfo .= $i.' '.sprintf($L['Members_removed'],$oSEC->name);
  }
  else
  {
  $strMoveInfo .= $i.' '.sprintf($L['Member_removed'],$oSEC->name);
  }
  $oSEC->UpdateStats($s);
}

// --------
// LISTS
// --------

$arrShowsection = array();
switch($strShowsection)
{
case 'A': $arrShowsection = GetUsers('A',$s); break;
case 'M': $arrShowsection = GetUsers('M-',$s); break;
case 'U': $arrShowsection = GetUsers('U',$s); break;
default : $arrShowsection = GetUsers('all',$s); break;
}
$arrShowusers = array();
switch($strShowusers)
{
case 'all': $arrShowusers = GetUsers('all'); break;
case 'A': $arrShowusers = GetUsers('A'); break;
case 'M': $arrShowusers = GetUsers('M-'); break;
case 'U': $arrShowusers = GetUsers('U'); break;
case 'lost': $arrShowusers = GetUsers('lost'); break;
default :
  // Section id must be string with a S prefix
  if ( substr($strShowusers,0,1)!='S' ) die('Wrong parameter');
  $arrShowusers = GetUsers('all',intval(substr($strShowusers,1)));
  break;
}

$arr = GetSectionTitles('A',-1,$s); // list of other teams (attention, key id must be string)
$arrSections = array();
foreach ($arr as $intKey => $strValue)
{
$arrSections['S'.$intKey]=$strValue;
}

// --------
// HTML START
// --------

$strHeadScript = '
<script type="text/javascript" src="bin/qt_jquery.js"></script>
<script type="text/javascript">
<!--
$(function() {
  $("#sec_del").change(function() {
    $.post("qte_j_user.php",
           {id:this.value,lang:"'.$_SESSION[QT]['language'].'"},
           function(data)
           { 
             if ( data.length>0 ) document.getElementById("title_err").innerHTML=data;
           }
          );
  });
  $("#sec_add").change(function() {
    $.post("qte_j_user.php",
           {id:this.value,lang:"'.$_SESSION[QT]['language'].'"},
           function(data)
           { 
             if ( data.length>0 ) document.getElementById("title_err").innerHTML=data;
           }
          );
  });
});
-->
</script>
';

include('qte_adm_p_header.php');
include('qte_adm_p_title.php');

$oSEC->descr .= (empty($oSEC->descr) ? '' : '<br/>' ).'<span class="small">('.LangS('User',$oSEC->members).')</span>';
$oSEC->ShowInfo('si_t','si_t','si_t_desc','left');

// -- DISPLAY --

echo '<form method="post" action="',$oVIP->selfurl,'"><input type="hidden" id="s" name="s" value="',$s,'"/>
<table class="data_s" cellspacing="0">
<colgroup span="3"><col width="250"></col><col width="250"></col><col></col></colgroup>
';
echo '<tr>
<td class="th_o" style="padding-left:6px">',$L['Section_members'],'</td>
<td class="th_o" style="padding-left:6px">',$L['Registered_members'],'</td>
<td class="th_o" style="padding-left:6px">Info</td>
</tr>
';

echo '<tr>';

// COL 1: Section

echo '<td class="td_s" style="padding:0 0 6px 6px; background-color:#EEEEEE">';
echo '<span class="small">',$L['Show'],':</span><br/>';
echo '<select name="showsection" id="showsection" size="1" class="small" style="width:200px" onchange="document.getElementById(\'filtersection\').click();">';
echo '<option class="small" value="all"',($strShowsection=='all' ? QSEL : ''),'>',$L['Users_section'],'</option>';
echo '<option class="small" value="-" disabled="disabled">------------------</option>';
echo '<option class="small" value="A"',($strShowsection=='A' ? QSEL : ''),'>',$L['Userroles']['A'],'</option>';
echo '<option class="small" value="M"',($strShowsection=='M' ? QSEL : ''),'>',$L['Userroles']['M'],'</option>';
echo '</select><input type="submit" id="filtersection" name="filtersection" value="',$L['Ok'],'" class="small"/>
<script type="text/javascript">document.getElementById("filtersection").style.visibility="hidden";document.getElementById("filtersection").value="";</script>
<br/><br/>',N;
echo '<select name="sec_del[]" id="sec_del" size="20" class="small" style="width:200px" multiple="multiple">';
echo QTastags($arrShowsection,null,null,null,null,null,'small');
echo '</select><br/><br/>',N;
echo '<input type="submit" id="rem" name="rem" value="',$L['User_section_del'],' &gt;" style="width:190px"/><br/><br/>';
if ( $oSEC->members==0 )
{
  echo '<span class="disabled">'.$L['Members_moveall'].'...</span>',N;
}
else
{
  echo '<a href="qte_cmd.php?a=moveallmembers&amp;s='.$s.'&amp;exit2" class="small">'.$L['Members_moveall'].'...</a>',N;
}
echo '</td>',N;

// COL 2: All users

echo '<td class="hidden" style="padding-left:6px">',N;
echo '<span class="small">',$L['Show'],':</span><br/>';
echo '<select name="showusers" id="showusers" size="1" class="small" style="width:200px" onchange="document.getElementById(\'filtermembers\').click();">';
echo '<option class="small" value="all"',($strShowusers=='all' ? QSEL : ''),'>',$L['Users_reg'],'</option>';
echo '<option class="small" value="-" disabled="disabled">------------------</option>';
echo QTastags($arrSections,$L['Section'].': %s',$strShowusers,null,null,null,'small');
echo '<option class="small" value="lost"',($strShowusers=='lost' ? QSEL : ''),'>',$L['Users_not_in_team'],'</option>';
echo '<option class="small" value="-" disabled="disabled">------------------</option>';
echo '<option class="small" value="A"',($strShowusers=='A' ? QSEL : ''),'>',$L['Userroles']['A'],'</option>';
echo '<option class="small" value="M"',($strShowusers=='M' ? QSEL : ''),'>',$L['Userroles']['M'],'</option>';
echo '</select><input type="submit" id="filtermembers" name="filtermembers" value="',$L['Ok'],'" class="small"/>
<script type="text/javascript">document.getElementById("filtermembers").style.visibility="hidden";document.getElementById("filtermembers").value="";</script>
<br/><br/>',N;
echo '<select name="sec_add[]" id="sec_add" size="20" class="small" style="width:200px" multiple="multiple">';
echo QTastags($arrShowusers,null,null,null,null,null,'small');
echo '</select><br/><br/>',N;
echo '<input type="submit" id="add" name="add" value="&lt; ',$L['User_section_add'],'" style="width:190px"/><br/><br/>',N;
echo '</td>',N;

// COL 3: Preview/Info

echo '<td class="hidden" style="padding:6px">';

  // DISPLAY Preview
  echo '<p style="font-weight:bold;color:#555555">',$L['Selected_user'],'</p>';
  echo '<script type="text/javascript"></script><noscript class="small">No preview...<br/>Your browser does not support JavaScript</noscript>';
  echo '<div style="width:250px" id="title_err"></div>',N;
  
echo '</td>',N;

// END COL

echo '</tr>
</table>
</form>
';

// animation of the infomessage (errors remains on screen)
if ( !empty($strMoveInfo) ) 
{
echo '
<script type="text/javascript">
<!--
setTimeout(\'document.getElementById("infomessage").style.color="#bbbbbb"\',3000);
setTimeout(\'document.getElementById("infomessage").style.color="#cccccc"\',3300);
setTimeout(\'document.getElementById("infomessage").style.color="#dddddd"\',3600);
setTimeout(\'document.getElementById("infomessage").innerHTML="&nbsp;"\',3900);
-->
</script>
';
}

// --------
// HTML END
// --------

if ( !$bShowtoc ) { $oVIP->exiturl='qte_index.php'; $oVIP->exitname=ObjTrans('index','i',$_SESSION[QT]['index_name']); }

echo '<p><a href="',$oVIP->exiturl,'">',$oVIP->exitname,'</a> &middot; ',$L['Goto'],' <a href="qte_member.php?s=',$oSEC->id,'" target="_top">',$oSEC->name,'</a></p>';

include('qte_adm_p_footer.php');

?>