<?php

/*
 * PHP versions 4 and 5
 *
 * LICENSE: This source file is subject to version 3.0 of the PHP license
 * that is available through the world-wide-web at the following URI:
 * http://www.php.net/license.  If you did not receive a copy of
 * the PHP License and are unable to obtain it through the web, please
 * send a note to license@php.net so we can mail you a copy immediately.
 *
 * @category   Team
 * @package    QuickTeam
 * @author     Philippe Vandenberghe <info@qt-cute.org>
 * @copyright  2008-2012 The PHP Group
 * @license    http://www.php.net/license  PHP License 3.0
 * @version    2.0 build:20090311
 * @link       http://www.qt-cute/doc/package/qte
 * @since      File available since Release 1.0.0
 * @deprecated File deprecated in Release 3.0.0
 *
 */

session_start();
require_once('bin/qte_init.php');
include(Translate('qte_adm.php'));

if ( $oVIP->role!='A' ) die($L['R_admin']);

// ---------
// INITIALISE
// ---------

$strTitle   = '';
$strDelimit = ',';
$strEnclose = '"';
$strSkip    = 'N';

$oVIP->selfurl = 'qte_adm_users_imp.php';
$oVIP->selfname = $L['Users_import_csv'];
$oVIP->exiturl = 'qte_adm_users.php';
$oVIP->exitname = '&laquo;&nbsp;'.$L['User_man'];

// --------
// SUBMITTED
// --------

if ( isset($_POST['ok']) )
{
  // check file
  
  if (!is_uploaded_file($_FILES['title']['tmp_name'])) $error = 'File not found';

  // check form value
  
  if ( empty($error) )
  {
    $strDelimit = trim($_POST['delimit']);
    if ( isset($_POST['skip']) ) $strSkip='Y';
    if ( empty($strDelimit) ) $error="{$L['Separator']} {$L['E_invalid']}";
    if ( ereg("[0-9A-Za-z]",$strDelimit) ) $error="{$L['Separator']} {$L['E_invalid']}";
    $strStatus = 'Z'; if ( isset($_POST['status']) ) $strStatus = substr($_POST['status'],0,1);
  }

  // check format
  
  if ( empty($error) )
  {
    if ( $_FILES['title']['type']!='text/plain' && $_FILES['title']['type']!='text/csv' )
    {
    $error = 'Unknown file format ('.$_FILES['title']['type'].')';
    unlink($_FILES['title']['tmp_name']);
    }
  }

  // read file
  
  if ( empty($error) )
  {
    if ( $handle = fopen($_FILES['title']['tmp_name'],'r') )
    {
      $i = 0;
      $intCountUser = 0;
      $intNextUser = Nextid(TABUSER);
      while( ($row=fgetcsv($handle,500,$strDelimit))!==FALSE )
      {
        $i++;
        if ( $strSkip=='Y' && $i==1 ) continue;
        if ( count($row)==1 ) continue;
        if ( count($row)==4 )
        {
          $strRole = 'U'; if ( $row[0]=='A' || $row[0]=='M' || $row[0]=='a' || $row[0]=='m') $strRole=strtoupper($row[0]);
          $strLog = trim($row[1]); if ( !empty($strLog) ) $strLog=utf8_decode($strLog);
          $strPwd = trim($row[2]);
          if ( substr($strPwd,0,3)=='SHA' || substr($strPwd,0,3)=='sha' ) $strPwd = sha1($strPwd);
          if ( empty($strPwd) ) $strPwd=sha1($strLog);
          $strMail = $row[3];
          // insert (must insert username and lastname)
          if ( !empty($strLog) )
          {
            if ( $oDB->Query( 'INSERT INTO '.TABUSER.' (id,role,username,lastname,pwd,status,emails,children,firstdate) VALUES ('.$intNextUser.',"'.$strRole.'","'.$strLog.'","'.$strLog.'","'.$strPwd.'","'.$strStatus.'","'.$strMail.'","0","'.date('Ymd').'")' ) )
            {
              $oDB->Query( 'INSERT INTO '.TABS2U.' (sid,userid,issuedate) VALUES (0,'.$intNextUser.',"'.date('Ymd').'")' );
              if ( $_POST['section']!=0 )
              {
              $oDB->Query( 'INSERT INTO '.TABS2U.' (sid,userid,issuedate) VALUES ('.$_POST['section'].','.$intNextUser.',"'.date('Ymd').'")' );
              }
              $intNextUser++;
              $intCountUser++;
            }
            else
            {
              echo ' - Cannot insert a new user with username ',$strLog,'<br/>';
            }
          }
        }
        else
        {
          $error='Number of parameters ('.count($row).') not matching in line '.$i;
        }
      }
    }
    fclose($handle);
    // Unregister global sys (will be recomputed on next page)
    Unset($_SESSION[QT]['sys_members']);
    Unset($_SESSION[QT]['sys_states']);
    cSection::UpdateStats(0);
    if ( $_POST['section']!=0 ) cSection::UpdateStats($_POST['section']);
  }

  // End message

  if ( empty($error) )
  {
    unlink($_FILES['title']['tmp_name']);
   $oVIP->selfname = $L['Users_import_csv'];
    if ( $intCountUser==0 ) 
    {
    $oVIP->EndMessage(NULL, 'No user inserted... Check the file and check that you don\'t have duplicate usernames.', 'admin',0);
    }
    else
    {
    $oVIP->EndMessage(NULL,"$intCountUser {$L['Users']}<br/>".$L['S_insert'],'admin',0);
    }
  }
}

// --------
// HTML START
// --------

include('qte_adm_p_header.php');
include('qte_adm_p_title.php');

echo '
<script type="text/javascript">
<!--
function ValidateForm(theForm)
{
  if (theForm.title.value.length==0) { alert(html_entity_decode("',$L['E_mandatory'],': File")); return false; }
  if (theForm.delimit.value.length==0) { alert(html_entity_decode("',$L['E_mandatory'],': ',$L['Separator'],'")); return false; }
  return null;
}
-->
</script>
';

echo '<form method="post" action="',$oVIP->selfurl,'" enctype="multipart/form-data" onsubmit="return ValidateForm(this);">
<input type="hidden" name="maxsize" value="5242880"/>
<table class="data_o" cellspacing="0">
';
echo '<tr class="tr">
<td class="th_o th_o_all" colspan="2">File</td>
</tr>
';
echo '<tr class="tr">
<td class="th_o th_o_first" style="width:200px"><label for="title">CSV file</label></td>
<td class="td_o"><input type="file" id="title" name="title" size="32" value="',$strTitle,'"/></td>
</tr>
';
echo '<tr class="tr">
<td class="th_o th_o_all" colspan="2">',$L['Adm_settings'],'</td>
</tr>
';
echo '<tr class="tr">
<td class="th_o th_o_first"><label for="delimit">',$L['Separator'],'</label></td>
<td class="td_o"><input type="text" id="delimit" name="delimit" size="1" maxlength="5" value="',$strDelimit,'"/></td>
</tr>
';
echo '<tr class="tr">
<td class="th_o th_o_first">',$L['First_line'],'</td>
<td class="td_o"><input type="checkbox" id="skip" name="skip"',($strSkip=='Y' ? QCHE : ''),'/><label for="skip">',$L['Skip_first_line'],'</label></td>
</tr>
';
echo '<tr class="tr">
<td class="th_o th_o_all" colspan="2">',$L['User_man'],'</td>
</tr>
';
echo '<tr class="tr">
<td class="th_o th_o_first">',$L['Status'],'</td>
<td class="td_o"> <select name="status" size="1">',QTastags($oSYS->statuses,null,'Z'),'</select></td>
</tr>
';
echo '<tr class="tr">
<td class="th_o th_o_first">',$L['Destination'],'</td>
<td class="td_o"> <select name="section" size="1">',QTastags($oSYS->sections,null,0),'</select></td>
</tr>
';
echo '<tr class="tr">
<td class="th_o th_o_all" colspan="2"><input type="submit" name="ok" value="',$L['Ok'],'"/></td>
</tr>
';
echo '</table>
</form>
';

// HTML END

include('qte_adm_p_footer.php');

?>