<?php

/*
 * PHP versions 4 and 5
 *
 * LICENSE: This source file is subject to version 3.0 of the PHP license
 * that is available through the world-wide-web at the following URI:
 * http://www.php.net/license.  If you did not receive a copy of
 * the PHP License and are unable to obtain it through the web, please
 * send a note to license@php.net so we can mail you a copy immediately.
 *
 * @category   People management
 * @package    QuickTeam
 * @author     Philippe Vandenberghe <info@qt-cute.org>
 * @copyright  2008-2012 The PHP Group
 * @license    http://www.php.net/license  PHP License 3.0
 * @version    2.0 build:20090311
 * @link       http://www.qt-cute.org/doc/package/qte
 * @since      File available since Release 1.0.0
 * @deprecated File deprecated in Release 3.0.0
 *
 */

session_start();
require_once('bin/qte_init.php');
if ( $oVIP->role!='A' ) die($L['R_admin']);

// ---------
// INITIALISE
// ---------

include(Translate('qte_adm.php'));
include(Translate('qte_reg.php'));
include('bin/qte_fn_limitsql.php');

$strGroups='';
$s = 0;
if ( isset($_GET['s']) ) $s = intval($_GET['s']) ;
if ( isset($_POST['s']) ) $s = intval($_POST['s']) ;

$oVIP->selfurl = 'qte_adm_users.php';
$oVIP->selfname = '<span class="upper">'.$L['Adm_content'].'</span><br/>'.$L['Sections'];
$oVIP->exiturl = 'qte_adm_users.php';

// --------
// SUBMITTED
// --------

if ( isset($_POST['del']) )
{
  if ( $_POST['cat']=='SC' )
  {
  $oDB->Query('DELETE FROM '.TABUSER.' WHERE children="2" AND id>1');
  $strInfo = $L['S_delete'];
  }
}

if ( isset($_POST['add']) )
{
  // check
  if ( empty($error) )
  {
    $str = $_POST['title']; if ( get_magic_quotes_gpc() ) $str = stripslashes($str);
    $str = QTconv($str,'U');
    if ( !QTislogin($str) ) $error = ObjTrans('field','username').S.$L['E_invalid'];
    $strTitle = $str;
  }
  if ( empty($error) )
  {
    $oDB->Query('SELECT count(id) as countid FROM '.TABUSER.' WHERE username="'.htmlspecialchars($strTitle,ENT_QUOTES).'"');
    $row = $oDB->Getrow();
    if ($row['countid']!=0) $error = ObjTrans('field','username').S.$L['E_already_used'];
  }
  if ( empty($error) )
  {
    $str = $_POST['pass']; if ( get_magic_quotes_gpc() ) $str = stripslashes($str);
    $str = QTconv($str,'U');
    if ( !QTispassword($str) ) $error = $L['Password'].S.$L['E_invalid'];
    $strNewpwd = $str;
  }
  if ( empty($error) )
  {
    $str = $_POST['mail']; if ( get_magic_quotes_gpc() ) $str = stripslashes($str);
    $str = QTconv($str,'U');
    if ( !QTismail($str) ) $error = $L['Email'].S.$L['E_invalid'];
    $strMail = $str;
  }
  // save
  if ( empty($error) )
  {
    include('bin/qt_lib_smtp.php');
    $id = Nextid(TABUSER);
    $oDB->Query( 'INSERT INTO '.TABUSER.' (id,role,username,lastname,pwd,emails,children,status,firstdate) VALUES ('.$id.',"U","'.htmlspecialchars($strTitle,ENT_QUOTES).'","'.htmlspecialchars($strTitle,ENT_QUOTES).'","'.sha1($strNewpwd).'","'.$strMail.'","0","'.$_POST['status'].'","'.date('Ymd').'")' );
    $oDB->Query( 'INSERT INTO '.TABS2U.' (sid,userid,issuedate) VALUES ('.$s.','.$id.',"'.date('Ymd').'")' );
    cSection::UpdateStats($s);

    $strDefaultStatus=$_POST['status'];
    $strDefaultSection=$s;

    // Unregister global sys (will be recomputed on next page)
    Unset($_SESSION[QT]['sys_members']);
    Unset($_SESSION[QT]['sys_newuserid']);

    // send email
    $strSubject='Welcome';
    $strMessage='Please find here after your login and password to access the board '.$_SESSION[QT]['site_name'].N.'Login: %s\nPassword: %s';
    $strFile = $_SESSION[QT]['language'].'/mail_registred.php';
    if ( file_exists($strFile) ) include($strFile);
    $strMessage = sprintf($strMessage,$strTitle,$strNewpwd);
    QTmail($strMail,QTconv($strSubject,'-4'),QTconv($strMessage,'-4'),QTE_HTML_CHAR);

    // index
    $oUser = new cUser($id);
    $oUser->SaveKeywords($oUser->GetKeywords(GetFields('index_p')));
    
    // exit
    unset($_POST['title']);
    unset($_POST['pass']);
    $strInfo = $L['Register_completed'];
  }
}

// INITIALISE

$strGroup = 'all';
$intLimit = 0;
$intPage  = 1;
$strOrder = 'id';
$strDirec = 'ASC';
$strInver = 'DESC';
$strCateg = 'all';

// security check 1
if ( isset($_GET['group']) ) $strGroup = strip_tags($_GET['group']);
if ( isset($_GET['page']) ) $intPage = intval(strip_tags($_GET['page']));
if ( isset($_GET['order']) ) $strOrder = strip_tags($_GET['order']);
if ( isset($_GET['dir']) ) $strDirec = strip_tags($_GET['dir']);
if ( isset($_GET['cat']) ) $strCateg = strip_tags($_GET['cat']);

// security check 2 (no long argument)
if ( strlen($strGroup)>4 ) die('Invalid argument #group');
if ( strlen($strOrder)>12 ) die('Invalid argument #order');
if ( strlen($strDirec)>4 ) die('Invalid argument #dir');

$intLimit = ($intPage-1)*$_SESSION[QT]['items_per_page'];
if ( $strDirec=='DESC' ) $strInver='ASC';

// --------
// HTML START
// --------

$strHeadScript = '
<script type="text/javascript" src="bin/qt_jquery.js"></script>
<script type="text/javascript">
<!--
$(function() {
  $("#title").blur(function() {
    $.post("qte_j_exists.php",
           {f:"username",v:$("#title").val(),e1:"'.$L['E_min_4_char'].'",e2:"'.$L['E_already_used'].'"},
           function(data)
           { 
             if ( data.length>0 ) document.getElementById("title_err").innerHTML=data;
           }
          );
  });
});
-->
</script>
';

include('qte_adm_p_header.php');
include('qte_adm_p_title.php');

// --------
// Global statistics  (children and children without agreement)
// --------

$oDB->Query('SELECT count(id) as countid FROM '.TABUSER.' WHERE id>0');
$row = $oDB->Getrow();
$intUsers = $row['countid'];

if ( $_SESSION[QT]['register_coppa']=='1' )
{
  // children (all)
  $oDB->Query('SELECT count(id) as numuser FROM '.TABUSER.' WHERE id>1 AND children<>"0"');
  $row = $oDB->Getrow();
  $intChild = $row['numuser'];

  if ( $intChild>0 )
  {
  $strChild = '<a href="qte_adm_users.php?cat=CH">[&raquo;]</a>';
  }
  else
  {
  $strChild = S;
  }

  // children (without agreement only)
  $oDB->Query('SELECT count(id) as numuser FROM '.TABUSER.' WHERE id>1 AND children="2"');
  $row = $oDB->Getrow();
  $intSleepchild = $row['numuser'];

  if ( $intSleepchild>0 )
  {
  $strSleepChild = '<a href="qte_adm_users.php?cat=SC">[&raquo;]</a>';
  }
  else
  {
  $strSleepChild = S;
  }

  echo '<table class="data_o" style="width:500px" cellspacing="0">',N;
  echo '<tr class="tr">',N;
  echo '<td class="td_o_all">',$L['Users'],'</td>',N;
  echo '<td class="td_o_all">&nbsp;</td>',N;
  echo '<td class="td_o_all"><b>',$intUsers,'</b></td>',N;
  echo '<td class="td_o_all"><a href="qte_adm_users.php">[&raquo;]</a></td>',N;
  echo '</tr>',N;
  echo '<tr class="tr">',N;
  echo '<td class="td_o">',$L['Members_CH'],'</td>',N;
  echo '<td class="td_o"><span class="small">',$L['H_Members_CH'],'</span></td>',N;
  echo '<td class="td_o"><b>',$intChild,'</b></td>',N;
  echo '<td class="td_o">',$strChild,'</td>',N;
  echo '</tr>',N;
  echo '<tr class="tr">',N;
  echo '<td class="td_o">',$L['Members_SC'],'</td>',N;
  echo '<td class="td_o"><span class="small">',$L['H_Members_SC'],'</span></td>',N;
  echo '<td class="td_o"><b>',$intSleepchild,'</b></td>',N;
  echo '<td class="td_o">',$strSleepChild,'</td>',N;
  echo '</tr>',N;
  echo '</table><br/>',N;

}
else
{
 echo '<p>'.$intUsers.' '.$L['Users'].'</p>';
}

// --------
// Category subform
// --------

if ( $strCateg!='all' )
{
  echo '<h1>',$L['Members_'.$strCateg],' (',$L['H_Members_'.$strCateg],')</h1>',N;
  if ( $strCateg!='CH' )
  {
  echo '<form method="post" action="qte_adm_users.php">';
  $intCount = $intFalse;
  if ( $strCateg=='SC' ) $intCount = $intSleepchild;
  echo $L['Delete'],' ',$intCount,' ',$L['Members_'.$strCateg],'&nbsp;&nbsp;<input type="hidden" name="cat" value="',$strCateg,'"/><input type="submit" name="del" value="',$L['Delete'],' !"/></form>',N;
  }
}

// --------
// Button line and pager
// --------

if ( $strCateg=='all' )
{
  $strGroups = '<td class="lettres" style="width:35px;">'.($strGroup=='all' ? '<b>'.$L['All'].'</b>' : '<a class="lettres" href="'.$oVIP->selfurl.'?group=all">'.$L['All'].'</a>' ).'</td>';
  for ($g='A';$g!='AA';$g++)
  {
  $strGroups .= '<td class="lettres" style="width:18px;">'.($strGroup==$g ? '<b>'.$g.'</b>' : '<a class="lettres" href="'.$oVIP->selfurl.'?group='.$g.'">'.$g.'</a>' ).'</td>';
  }
  $strGroups .= '<td class="lettres" style="width:18px;">'.($strGroup=='0' ? '<b>#</b>' : '<a class="lettres" href="'.$oVIP->selfurl.'?group=0">#</a>' ).'</td>';
  $strGroups .= '<td class="hidden">&nbsp;</td>'.N;
}

Switch ($strGroup)
{
  Case 'all': $strWhere = ' WHERE id>0'; Break;
  Case '0':   $strWhere = ' WHERE '.FirstCharCase('username','a-z'); Break;
  Default:    $strWhere = ' WHERE '.FirstCharCase('username','u').'="'.$strGroup.'"'; Break;
}

if ( $strCateg=='CH' ) $strWhere .= ' AND id>1 AND children<>"0"'; //children
if ( $strCateg=='SC' ) $strWhere .= ' AND id>1 AND children="2"';  //sleeping children

$oDB->Query('SELECT count(id) as countid FROM '.TABUSER.$strWhere);
$row = $oDB->Getrow();
$intCount = $row['countid'];

// -- build pager --

$strPager = MakePager("qte_adm_users.php?cat=$strCateg&group=$strGroup&order=$strOrder&dir=$strDirec",$intCount,$_SESSION[QT]['items_per_page'],$intPage);
if ( !empty($strPager) ) { $strPager = $L['Page'].$strPager; } else { $strPager=S; }
if ( $intCount<$intUsers ) $strPager = '<span class="small">'.$intCount.' '.$L['Selected_from'].' '.$intUsers.' '.strtolower($L['Users']).'</span>'.($strPager==S ? '' : ' | '.$strPager);

// -- Display button line and pager --

if ( $intCount>$_SESSION[QT]['items_per_page'] || $strGroup!='all' ) echo '<br/><table class="lettres" cellspacing="0"><tr class="lettres">',N,$strGroups,N,'</tr></table>',N;
echo '<table class="hidden" cellspacing="0" ><tr><td id="pager_zt">',$strPager,'</td></tr></table>',N;

// --------
// Memberlist
// --------

if ( $intCount!=0 )
{

  $img['NO']='';
  $img['ASC']= ' <img class="ico i_sort" src="admin/sort_asc.gif" alt="+"/>';
  $img['DESC']= ' <img class="ico i_sort" src="admin/sort_desc.gif" alt="-"/>';
  $sort['ASC']= 'DESC';
  $sort['DESC']= 'ASC';

  echo '<table class="data_o" cellspacing="0">',N;
  echo '<tr class="tr">',N;
  if ( $intCount>2 )
  {
    echo '<td class="th_o" style="width:40px;"><a class="th_o" href="qte_adm_users.php?cat=',$strCateg,'&amp;group=',$strGroup,'&amp;page=1&amp;order=id&amp;dir=' , $sort[$strDirec] , '">Id</a>' , ($strOrder=='id' ? $img[$strDirec] : $img['NO']) , '</td>',N;
    echo '<td class="th_o" style="width:30px;"><a class="th_o" href="qte_adm_users.php?cat=',$strCateg,'&amp;group=',$strGroup,'&amp;page=1&amp;order=status&amp;dir=' , $sort[$strDirec] , '">&bull;</a>' , ($strOrder=='status' ? $img[$strDirec] : $img['NO']) , '</td>',N;
    echo '<td class="th_o" style="text-align:left"><a class="th_o" href="qte_adm_users.php?cat=',$strCateg,'&amp;group=',$strGroup,'&amp;page=1&amp;order=username&amp;dir=' , $sort[$strDirec] , '">', ObjTrans('field','username'), '</a>' , ($strOrder=='username' ? $img[$strDirec] : $img['NO']) , '</td>',N;
    echo '<td class="th_o" style="text-align:left"><a class="th_o" href="qte_adm_users.php?cat=',$strCateg,'&amp;group=',$strGroup,'&amp;page=1&amp;order=fullname&amp;dir=' , $sort[$strDirec] , '">',ObjTrans('field','fullname'),'</a>' , ($strOrder=='fullname' ? $img[$strDirec] : $img['NO']) , '</td>',N;
    echo '<td class="th_o"><a class="th_o" href="qte_adm_users.php?cat=',$strCateg,'&amp;group=',$strGroup,'&amp;page=1&amp;order=role&amp;dir=' , $sort[$strDirec] , '">' , $L['Role'] , '</a>' , ($strOrder=='role' ? $img[$strDirec] : $img['NO']) , '</td>',N;
    echo '<td class="th_o"><a class="th_o" href="qte_adm_users.php?cat=',$strCateg,'&amp;group=',$strGroup,'&amp;page=1&amp;order=firstdate&amp;dir=' , $sort[$strDirec] , '">' , $L['Registration'] , '</a>' , ($strOrder=='firstdate' ? $img[$strDirec] : $img['NO']) , '</td>',N;
    echo '<td class="th_o">',$L['Action'],'</td>',N;
  }
  else
  {
    echo '<td class="th_o" style="width:40px;">Id</td>',N;
    echo '<td class="th_o">&bull;</td>',N;
    echo '<td class="th_o" style="text-align:left">',ObjTrans('field','username'),'</td>',N;
    echo '<td class="th_o" style="text-align:left">',ObjTrans('field','fullname'),'</td>',N;
    echo '<td class="th_o">',$L['Role'],'</td>',N;
    echo '<td class="th_o">',$L['Registration'],'</td>',N;
    echo '<td class="th_o">',$L['Action'],'</td>',N;
  }
  echo '</tr>',N;

  //-- LIMIT QUERY --
  $strState = 'id,username,status,role,title,firstname,midname,lastname,alias,ip,firstdate FROM '.TABUSER.$strWhere;
  if ( $strOrder=='fullname' ) $strOrder = 'lastname';
  $oDB->Query( LimitSQL($strState,$strOrder.' '.$strDirec,$intLimit,$_SESSION[QT]['items_per_page'],$intCount) );
  // --------

  For ($i=0;$i<$_SESSION[QT]['items_per_page'];$i++)
  {
    $row = $oDB->Getrow();
    if ( !$row ) break;

    $oUser = new cUser($row);

    echo '<tr class="rowlight">',N;
    echo '<td class="td_o" style="text-align: center"><span class="small">',$oUser->id.'</span></td>',N;
    echo '<td class="td_o" style="text-align: center">',AsImg($_SESSION[QT]['skin_dir'].'/'.$oSYS->statuses[$oUser->status]['icon'],$oUser->status,$oSYS->statuses[$oUser->status]['statusname'],'ico i_status'),'</td>',N;
    echo '<td class="td_o"><a href="qte_usr.php?id=',$oUser->id,'">',$oUser->username,'</a></td>',N;
    echo '<td class="td_o"><span class="small">',$oUser->fullname,'</span></td>',N;
    echo '<td class="td_o" style="text-align: center"><span class="small">',$L['Userrole'][$oUser->role],'</span></td>',N;
    echo '<td class="td_o" style="text-align: center"><span class="small">',(!empty($oUser->firstdate) ? QTdatestr($oUser->firstdate,'$','') : S),'</span></td>',N;
    echo '<td class="td_o" style="text-align: center">',($row['id']>1 ? '<a class="small" href="qte_cmd.php?a=deleteuser&amp;u='.$oUser->id.'&amp;v=qte_adm_users">'.$L['Delete'].'</a>' : '&nbsp;'),'</td>',N;
    echo '</span></td>',N,'</tr>',N;
  }
  echo '</table>',N;

}
else
{
  echo $L['E_no_member'];
}

// -- Display pager --

echo '<table class="hidden" cellspacing="0"><tr class="hidden"><td id="pager_zb">',$strPager,'</td></tr></table>',N,N;

// --------
// Form
// --------

if ( !isset($strDefaultStatus) ) $strDefaultStatus='Z';

echo '
<script type="text/javascript">
<!--
function ValidateForm(theForm)
{
  if (theForm.title.value.length==0) { alert(html_entity_decode("',$L['E_mandatory'],': ',ObjTrans('field','username'),'")); return false; }
  if (theForm.pass.value.length==0) { alert(html_entity_decode("',$L['E_mandatory'],': ',$L['Password'],'")); return false; }
  if (theForm.mail.value.length==0) { alert(html_entity_decode("',$L['E_mandatory'],': ',$L['Email'],'")); return false; }
  return null;
}
-->
</script>
';

echo '<h2>',$L['Sysuser_add'],'</h2>',N;
echo '<form method="post" action="',$oVIP->selfurl,'" onsubmit="return ValidateForm(this);">',N;
echo '<table class="data_o" cellspacing="0">',N;
echo '<tr class="tr0">',N;
echo '<td class="th_o" style="text-align:left">',$L['Status'],'</td>',N;
echo '<td class="th_o" style="text-align:left">',ObjTrans('field','username'),'</td>',N;
echo '<td class="th_o" style="text-align:left">',$L['Password'],'</td>',N;
echo '<td class="th_o" style="text-align:left">',$L['Email'],'</td>',N;
echo '</tr>',N;
echo '<tr class="tr1">',N;
echo '<td class="td_o td_o_inf"><select name="status" size="1">',QTastags($oSYS->statuses,null,$strDefaultStatus),'</select></td>',N;
echo '<td class="td_o td_o_inf"><input id="title" name="title" type="text" size="20" maxlength="24" value="',(isset($_POST['title']) ? $_POST['title'] : ''),'" onfocus="document.getElementById(\'title_err\').innerHTML=\'\';"/></td>',N;
echo '<td class="td_o td_o_inf"><input id="pass" name="pass" type="text" size="24" maxlength="32"  value="',(isset($_POST['pass']) ? $_POST['pass'] : ''),'"/></td>',N;
echo '<td class="td_o td_o_inf"><input id="mail" name="mail" type="text" size="24" maxlength="255"  value="',(isset($_POST['mail']) ? $_POST['mail'] : ''),'" onkeyup="handle_keypress(event,\'add\')"/></td>',N;
echo '</tr>',N;
echo '<tr class="tr0">',N;
echo '<td class="td_o td_o_inf" colspan="4">
',$L['Destination'],': ',$L['Section'],' <select name="s" size="1">',QTastags($oSYS->sections,null,$s),'</select>
&nbsp;<input type="submit" id="add" name="add" value="',$L['Add'],'"/>
</td>',N;
echo '</tr>',N;
echo '</table>
<span id="title_err" class="error"></span>
</form>
';
if ( !empty($error) ) echo '<span class="error">',$error,'</span><br/>',N,N;
echo '<p><a href="qte_adm_users_imp.php">',$L['Users_import_csv'],'</a></p>';

// --------
// HTML END
// --------

include('qte_adm_p_footer.php');

?>