<?php

/*
 * PHP versions 4 and 5
 *
 * LICENSE: This source file is subject to version 3.0 of the PHP license
 * that is available through the world-wide-web at the following URI:
 * http://www.php.net/license.  If you did not receive a copy of
 * the PHP License and are unable to obtain it through the web, please
 * send a note to license@php.net so we can mail you a copy immediately.
 *
 * @category   Team
 * @package    QuickTeam
 * @author     Philippe Vandenberghe <info@qt-cute.org>
 * @copyright  2008-2012 The PHP Group
 * @license    http://www.php.net/license  PHP License 3.0
 * @version    2.0 build:20090311
 * @link       http://www.qt-cute.org/doc/package/qte
 * @since      File available since Release 1.0.0
 * @deprecated File deprecated in Release 3.0.0
 *
 */

session_start();
require_once('bin/qte_init.php');
require_once('bin/qte_fn_admin.php');
if ( $oVIP->role!='A' ) die($L['R_admin']);

// ---------
// INITIALISE
// ---------

include(Translate('qte_adm.php'));

$oVIP->selfurl = 'qte_adm_statuses.php';
$oVIP->exiturl = 'qte_adm_statuses.php';
$oVIP->selfname = '<span class="upper">'.$L['Adm_content'].'</span><br/>'.$L['Statuses'];
$oVIP->exitname = $L['Statuses'];

// --------
// SUBMITTED
// --------

if ( isset($_POST['ok_add']) )
{
  // check id, name and duplicate id

  $id = strtoupper($_POST['id']);
  if ( !ereg('[A-Y]',$id) ) $error="Id $id ".$L['E_invalid']." (A-Y)";
  $name = trim($_POST['name']); if ( get_magic_quotes_gpc() ) $name = stripslashes($name);
  if ( $name=='' ) $error = $L['Status'].S.$L['E_invalid'];
  if ( array_key_exists($id,$oSYS->statuses) ) $error = $L['Status'].' ['.$id.'] '.strtolower($L['E_already_used']);

  // add and exit

  if ( empty($error) )
  {
    $error = $oSYS->StatusAdd($id,$name,'status_0.gif');
  }
  if ( empty($error) )
  {
    $oVIP->exiturl = 'qte_adm_status.php?id='.$id;
    $oVIP->exitname = $L['Status_upd'];
    $oVIP->EndMessage('0');
    exit;
  }
}

// --------
// SUBMITTED for show
// --------

if ( isset($_POST['ok_show']) )
{
  if ( $_POST['show_Z']=='0' ) { $_SESSION[QT]['show_Z']='0'; }  else { $_SESSION[QT]['show_Z']='1'; }
  $oDB->Query('UPDATE '.TABSETTING.' SET setting="'.$_SESSION[QT]['show_Z'].'" WHERE param="show_Z"');
  $strInfo = $L['S_save'];
}

// --------
// HTML START
// --------

include('qte_adm_p_header.php');
include('qte_adm_p_title.php');

echo '<form method="post" action="',$oVIP->selfurl,'" onsubmit="return ValidateForm(this);">
<table cellspacing="0" class="data_o">
<colgroup span="5"><col width="30"></col><col width="30"></col><col></col><col width="75"></col><col></col></colgroup>
';
echo '<tr class="tr">
<td class="th_o">Id</td>
<td class="th_o">&nbsp;</td>
<td class="th_o" style="text-align:left">',$L['Status'],'</td>
<td class="th_o">',$L['Status_background'],'</td>
<td class="th_o">',$L['Action'],'</td>
</tr>
';

foreach( $oSYS->statuses as $id=>$arrStatus  )
{
  echo '<tr class="rowlight">',N;
  echo '<td class="td_o td_o_sta">',$id,'</td>',N;
  echo '<td class="td_o td_o_sta">',AsImg($_SESSION[QT]['skin_dir'].'/'.$arrStatus['icon'],'-',$arrStatus['statusname'],'ico i_status'),'</td>',N;
  echo '<td class="td_o td_o_inf"><a class="bold" href="qte_adm_status.php?id=',$id,'">',$arrStatus['statusname'],'</a>',(empty($arrStatus['statusdesc']) ? '' : '<span class="disabled"> &middot; '.$arrStatus['statusdesc'].'</span>'),'</td>',N;
  echo '<td class="td_o td_o_inf" style="background-color:',$arrStatus['color'],'">&nbsp;</td>',N;
  echo '<td class="td_o td_o_sta"><a class="small" href="qte_adm_status.php?id=',$id,'">',$L['Edit'],'</a>&nbsp;&middot;&nbsp;';
  if ( $id=='Z' ) { echo '<span class="disabled">',$L['Delete']; } else { echo '<a class="small" href="qte_cmd.php?a=status_del&amp;v=',$id,'">',$L['Delete'],'</a>'; }
  echo '</td>',N,'</tr>',N;
}

echo '
<tr class="tr">
<td class="td_o_all"><input type="text" name="id" value="" size="1" maxlength="1" class="small" onchange="bEdited=true;"/></td>
<td class="td_o_all">&nbsp;</td>
<td class="td_o_all" colspan="3"><input type="text" name="name" value="" size="20" maxlength="24" class="small" onchange="bEdited=true;"/> <input type="submit" name="ok_add" value="',$L['Add'],'"/></td>
</tr>
</table>
</form>
';

echo '<h2>',$L['Display_options'],'</h2>';

echo '
<form method="post" action="',$oVIP->selfurl,'" onsubmit="return ValidateForm(this);">
<table cellspacing="0" class="data_o">
<tr class="tr">
<td class="th_o th_o_first" style="width:150px"><label for="show_closed">',$L['Show_z'],'</label></td>
<td class="td_o"><select id="show_Z" name="show_Z" onchange="bEdited=true;">
<option value="0"',($_SESSION[QT]['show_Z']=='0' ? QSEL : ''),'>',$L['N'],'</option>
<option value="1"',($_SESSION[QT]['show_Z']=='1' ? QSEL : ''),'>',$L['Y'],'</option>
</select> <span class="small">',sprintf($L['H_Show_z'],$oSYS->statuses['Z']['statusname']),'</span></td>
<td class="td_o"><input type="submit" name="ok_show" value="',$L['Ok'],'"/></td>
</tr>
</table>
</form>

<script type="text/javascript">
<!--
function ValidateForm(theForm)
{
  if (theForm.id.value.length==0) { alert(html_entity_decode("',$L['E_mandatory'],': Id")); return false; }
  if (theForm.name.value.length==0) { alert(html_entity_decode("',$L['E_mandatory'],': ',$L['Status'],'")); return false; }
  return null;
}
-->
</script>
';

// --------
// HTML END
// --------

include('qte_adm_p_footer.php');

?>