<?php

/*
 * PHP versions 4 and 5
 *
 * LICENSE: This source file is subject to version 3.0 of the PHP license
 * that is available through the world-wide-web at the following URI:
 * http://www.php.net/license.  If you did not receive a copy of
 * the PHP License and are unable to obtain it through the web, please
 * send a note to license@php.net so we can mail you a copy immediately.
 *
 * @category   Team
 * @package    QuickTeam
 * @author     Philippe Vandenberghe <info@qt-cute.org>
 * @copyright  2008-2012 The PHP Group
 * @license    http://www.php.net/license  PHP License 3.0
 * @version    2.0 build:20090311
 * @link       http://www.qt-cute.org/doc/package/qte
 * @since      File available since Release 1.0.0
 * @deprecated File deprecated in Release 3.0.0
 *
 */

session_start();
require_once('bin/qte_init.php');
require_once('bin/qte_fn_admin.php');
if ( $oVIP->role!='A' ) die($L['R_admin']);

// ---------
// INITIALISE
// ---------

$id = '-1';
if ( isset($_GET['id']) ) $id = strip_tags($_GET['id']);
if ( isset($_POST['id']) ) $id = strip_tags($_POST['id']);
if ( $id=='-1' ) die('Missing parameter: id');

include(Translate('qte_adm.php'));

$oVIP->selfurl = 'qte_adm_status.php';
$oVIP->exiturl = 'qte_adm_statuses.php';
$oVIP->selfname = '<span class="upper">'.$L['Adm_content'].'</span><br/>'.$L['Status_upd'];
$oVIP->exitname = '&laquo; '.$L['Statuses'];

// --------
// SUBMITTED
// --------

if (isset($_POST['ok']))
{
  // check id
  if (!ereg('[A-Z]',$id)) $error="Id $id ".$L['E_invalid'].' (A-Z)';

  // change id
  if ( empty($error) )
  {
    if ( $_POST['oldid']!=$id )
    {
    $error = $oSYS->StatusChangeId($_POST['oldid'],$id);
    }
  }

  // check name
  if ( empty($error) )
  {
    $name = strip_tags(trim($_POST['name'])); if ( get_magic_quotes_gpc() ) $name = stripslashes($name);
    if ( $name=='' ) $error = 'Status name '.S.$L['E_invalid'];
    $name = QTconv($name,'3',QTE_CONVERT_AMP);
  }

  // check unic name
  if ( empty($error) )
  {
    if ( $_POST['oldname']!=$_POST['name'] )
    {
    $oDB->Query('SELECT count(id) as countid FROM '.TABSTATUS.' WHERE name="'.addslashes($name).'"');
    $row = $oDB->Getrow();
    if ($row['countid']>0) $warning = 'Name ['.$name.'] '.$L['E_already_used'];
    }
  }

  // check color
  if ( empty($error) )
  {
    $color = strip_tags(trim($_POST['color']));
  }

  // check icon
  if ( empty($error) )
  {
    $icon = strip_tags(trim($_POST['icon']));
    $icon = htmlspecialchars($icon,ENT_QUOTES);
    if ( $icon!=trim($_POST['icon']) ) $error = $L['Icon'].S.$L['E_invalid'];
  }

  // save

  if ( empty($error) )
  {
    $oDB->Query('UPDATE '.TABSTATUS.' SET name="'.addslashes($name).'",color="'.$color.'",icon="'.$icon.'" WHERE id="'.$id.'"');

    //  save translation

    $oDB->Query('DELETE FROM '.TABLANG.' WHERE (objtype="status" OR objtype="statusdesc") AND objid="'.$id.'"');

    foreach ($_POST as $strKey => $strTranslation)
    {
      if ( substr($strKey,0,1)=='T' )
      {
        if ( !empty($strTranslation) )
        {
        if ( get_magic_quotes_gpc() ) $strTranslation = stripslashes($strTranslation);
        cLang::Add('status',substr($strKey,1),$id,$strTranslation);
        }
      }
      if ( substr($strKey,0,1)=='D' )
      {
        if ( !empty($strTranslation) )
        {
        if ( get_magic_quotes_gpc() ) $strTranslation = stripslashes($strTranslation);
        cLang::Add('statusdesc',substr($strKey,1),$id,$strTranslation);
        }
      }
    }

    // Exit
    
    Unset($_SESSION[QT]['sys_statuses']);
    $oVIP->selfname = $L['Status_upd'];
    $oVIP->EndMessage(NULL,$L['S_update'].'<br/><br/><span class="warning">'.$warning.'</span>','admin',(!empty($warning) ? 0: 2));
  }
  else
  {
    $id = $_POST['oldid'];
  }
}

// --------
// HTML START
// --------

$arrCss = array('qt_jquery_color.css');
$strHeadScript = '
<script type="text/javascript" src="bin/qt_jquery.js"></script>
<script type="text/javascript" src="bin/qt_jquery_color.js"></script>
<script type="text/javascript">
  $(document).ready(function() {
    $.farbtastic("#picker");
    $("#picker").css("height","5px");
    $("#picker").css("visibility","hidden");
    $("#color").focus(function() { $.farbtastic("#picker").linkTo(this); $("#picker").css("height","195px"); $("#picker").css("visibility","visible"); });
    $("input:not(#color)").click(function() { $("#picker").css("visibility","hidden"); $("#picker").css("height","5px"); });  
  });
</script>
';

include('qte_adm_p_header.php');
include('qte_adm_p_title.php');

echo '<table cellspacing="0" class="hidden">
<tr>
<td style="width:20px">',$id,'</td>
<td style="width:30px">',AsImg($_SESSION[QT]['skin_dir'].'/'.$oSYS->statuses[$id]['icon'],'-',$oSYS->statuses[$id]['statusdesc'],'ico i_sectatus'),'</td>
<td style="width:100px;padding:3px 10px 3px 10px;text-align:center;background-color:',$oSYS->statuses[$id]['color'],'; border-style:solid; border-color:#dddddd; border-width:1px">',$oSYS->statuses[$id]['statusname'],'</td>
<td>&nbsp;</td>
</tr>
</table>
<br/>';
echo '<form method="POST" action="',$oVIP->selfurl,'">
<table width="500" cellspacing="0" class="data_o">
';
echo '<tr class="tr_o">
<td class="th_o th_o_all" colspan="2">',$L['Definition'],'</td>
</tr>
';
echo '<tr>
<td class="th_o th_o_first" style="width:150px;"><label for="id">Id</label></td>
<td class="td_o">
';
if ( ($id=='A') || ($id=='Z') )
{
  echo $id.'&nbsp;<input type="hidden" name="id" value="',$id,'"/>';
}
else
{
  echo '<input type="text" id="id" name="id" size="1" maxlength="1" value="',$id,'" onchange="bEdited=true;"/>';
}
echo '</td>
</tr>
';
$str = QTconv($oSYS->statuses[$id]['name'],'I');
echo '<tr>
<td class="th_o th_o_first"><label for="name">Name</label></td>
<td class="td_o"><input type="text" id="name" name="name" size="24" maxlength="24" value="',$str,'" style="background-color:#FFFF99" onchange="bEdited=true;"/>',(strstr($str,'&amp;') ?  ' <span class="disabled">'.$oSYS->statuses[$id]['name'].'</span>' : ''),'</td>
</tr>
';
echo '<tr>
<td class="th_o th_o_first"><label for="icon">Icon</label></td>
<td class="td_o"><input type="text" id="icon" name="icon" size="24" maxlength="64" value="',$oSYS->statuses[$id]['icon'],'" onchange="bEdited=true;"/>&nbsp;',AsImg($_SESSION[QT]['skin_dir'].'/'.$oSYS->statuses[$id]['icon'],'-',$oSYS->statuses[$id]['statusdesc'],'ico i_sectatus'),'&nbsp;&nbsp;<a href="qte_adm_status_ico.php" target="_blank">show icons</a></td>
</tr>
';
echo '<tr>
<td class="th_o th_o_first"><label for="color">',$L['Status_background'],'</label></td>
<td class="td_o">
<div id="picker" style="float:right;width:195px"></div>
<input type="text" class="colortext" id="color" name="color" size="10" maxlength="24" value="',(empty($oSYS->statuses[$id]['color']) ? '#' : $oSYS->statuses[$id]['color']),'" onchange="bEdited=true;"/>&nbsp;<span class="small">',$L['H_Status_background'],'</span>
</td>';

echo '<tr>
<td class="th_o th_o_all" colspan="2">',$L['Translations'],'</td>
<tr class="tr tr_o">
<td class="th_o th_o_first">',$L['Status_name_and_desc'],'</td>
<td class="td_o" colspan="2">
<p class="help">',sprintf($L['E_no_translation'],ucfirst(str_replace('_',' ',$oSYS->statuses[$id]['name']))),'</p>
<table cellspacing="0" class="hidden">';

$arrTrans = cLang::GetTrans('status',$id);
$arrDescTrans = cLang::GetTrans('statusdesc',$id);
include('bin/qte_lang.php'); // this creates $arrLang
foreach ($arrLang as $strIso => $arr)
{
  echo '
  <tr>
  <td class="hidden" style="width:25px"><span title="',$arr[1],'">',$arr[0],'</span></td>
  <td class="hidden">
  <input class="small" title="',$L['Status'],' (',$strIso,')" type="text" id="T',$strIso,'" name="T',$strIso,'" size="20" maxlength="64" value="',(isset($arrTrans[$strIso]) ? $arrTrans[$strIso] : ''),'" onchange="bEdited=true;"/>
  <input class="small" title="',$L['Description'],' (',$strIso,')" type="text" id="D',$strIso,'" name="D',$strIso,'" size="55" maxlength="255" value="',(isset($arrDescTrans[$strIso]) ? $arrDescTrans[$strIso] : ''),'" onchange="bEdited=true;"/>
  </td>
  </tr>
  ';
}

echo '</table>
</td>
</tr>
';
echo '<tr>
<td class="th_o th_o_all" colspan="2" style="padding:6px; text-align:center">
<input type="hidden" name="oldid" value="',$id,'"/>
<input type="hidden" name="oldname" value="',QTconv($oSYS->statuses[$id]['name'],'1'),'"/>
<input type="submit" name="ok" value="',$L['Save'],'"/></td>
</tr>
</table>
</form>
<p><a href="',$oVIP->exiturl,'" onclick="return warningedited(bEdited,\''.$L['E_editing'].'\');">',$oVIP->exitname,'</a></p>
';

// --------
// HTML END
// --------

include('qte_adm_p_footer.php');

?>