<?php

/*
 * PHP versions 4 and 5
 *
 * LICENSE: This source file is subject to version 3.0 of the PHP license
 * that is available through the world-wide-web at the following URI:
 * http://www.php.net/license.  If you did not receive a copy of
 * the PHP License and are unable to obtain it through the web, please
 * send a note to license@php.net so we can mail you a copy immediately.
 *
 * @category   Team
 * @package    QuickTeam team
 * @author     Philippe Vandenberghe <info@qt-cute.org>
 * @copyright  2008-2012 The PHP Group
 * @license    http://www.php.net/license  PHP License 3.0
 * @version    2.0 build:20090311
 * @link       http://www.qt-cute/doc/package/qte
 * @since      File available since Release 1.0.0
 * @deprecated File deprecated in Release 3.0.0
 *
 */

session_start();
require_once('bin/qte_init.php');
if ( $oVIP->role!='A' ) die($L['R_admin']);

// INITIALISE

include(Translate('qte_adm.php'));

$oVIP->selfurl = 'qte_adm_site.php';
$oVIP->selfname = '<span class="upper">'.$L['Adm_info'].'</span><br/>'.$L['Adm_general'];

// --------
// SUBMITTED
// --------

if ( isset($_POST['ok']) )
{
  // check sitename
  $str = $_POST['sitename']; if ( get_magic_quotes_gpc() ) $str = stripslashes($str);
  $str = substr(QTconv($str,'3',false),0,64);
  if ( !empty($str) ) { $_SESSION[QT]['site_name'] = $str; } else { $error = $L['Site_name'].S.$L['E_invalid']; }

  // check siteurl
  if ( empty($error) )
  {
    $str = QTconv($_POST['siteurl'],'2');
    if ( substr($str,-1,1)=='/' ) $str = substr($str,0,-1);
    if ( !empty($str) ) { $_SESSION[QT]['site_url'] = $str; } else { $error = $L['Site_url'].': '.$L['E_invalid']; }
    if ( !ereg("^(http://|https://)",$str) ) $warning = $L['Site_url'].': '.$L['E_missing_http'];
  }

  // check indexname
  if ( empty($error) )
  {
    $str = $_POST['title']; if ( get_magic_quotes_gpc() ) $str = stripslashes($str);
    $str = substr(QTconv($str,'3',false),0,64);
    if ( !empty($str) ) { $_SESSION[QT]['index_name'] = $str; } else { $error = $L['Name_of_index'].S.$L['E_invalid']; }
  }

  // check adminemail
  if ( empty($error) )
  {
    $str = trim($_POST['adminmail']);
    if ( QTismail($str) ) { $_SESSION[QT]['admin_email'] = $str; } else { $error = $L['Adm_e_mail'].' ['.$str.'] '.$L['E_invalid']; }
  }

  // check others
  if ( empty($error) )
  {
    $_SESSION[QT]['use_smtp'] = $_POST['smtp'];
    if ( $_SESSION[QT]['use_smtp']=='1' )
    {
    $_SESSION[QT]['smtp_host'] = $_POST['smtphost'];
    $_SESSION[QT]['smtp_username'] = $_POST['smtpusr'];
    $_SESSION[QT]['smtp_password'] = $_POST['smtppwd'];
    if ( empty($_SESSION[QT]['smtp_host']) ) $error = 'Smtp host '.$L['E_invalid'];
    }
  }

  // save value
  if ( empty($error) )
  {
    $oDB->Query('UPDATE '.TABSETTING.' SET setting="'.addslashes($_SESSION[QT]['site_name']).'" WHERE param="site_name"');
    $oDB->Query('UPDATE '.TABSETTING.' SET setting="'.$_SESSION[QT]['site_url'].'"WHERE param="site_url"');
    $oDB->Query('UPDATE '.TABSETTING.' SET setting="'.addslashes($_SESSION[QT]['index_name']).'" WHERE param="index_name"');
    $oDB->Query('UPDATE '.TABSETTING.' SET setting="'.$_SESSION[QT]['admin_email'].'" WHERE param="admin_email"');
    $oDB->Query('UPDATE '.TABSETTING.' SET setting="'.$_SESSION[QT]['use_smtp'].'" WHERE param="use_smtp"');
    if ( $_SESSION[QT]['smtp_host']=='1' )
    {
    $oDB->Query('UPDATE '.TABSETTING.' SET setting="'.$_SESSION[QT]['smtp_host'].'" WHERE param="smtp_host"');
    $oDB->Query('UPDATE '.TABSETTING.' SET setting="'.$_SESSION[QT]['smtp_username'].'" WHERE param="smtp_username"');
    $oDB->Query('UPDATE '.TABSETTING.' SET setting="'.$_SESSION[QT]['smtp_password'].'" WHERE param="smtp_password"');
    }
    $str = trim($_POST['adminfax']); if ( get_magic_quotes_gpc() ) $str = stripslashes($str);
      $str = QTconv($str,'3',false);
      if ( strlen($str)>255 ) $str = substr($str,0,255);
      $oDB->Query('UPDATE '.TABSETTING.' SET setting="'.addslashes($str).'" WHERE param="admin_fax"');
      $_SESSION[QT]['admin_fax'] = $str;
    $str = trim($_POST['adminname']); if ( get_magic_quotes_gpc() ) $str = stripslashes($str);
      $str = QTconv($str,'3',false);
      if ( strlen($str)>255 ) $str = substr($str,0,255);
      $oDB->Query('UPDATE '.TABSETTING.' SET setting="'.addslashes($str).'" WHERE param="admin_name"');
      $_SESSION[QT]['admin_name'] = $str;
    $str = trim($_POST['adminaddr']); if ( get_magic_quotes_gpc() ) $str = stripslashes($str);
      $str = QTconv($str,'3',false);
      if ( strlen($str)>255 ) $str = substr($str,0,255);
      $oDB->Query('UPDATE '.TABSETTING.' SET setting="'.addslashes($str).'" WHERE param="admin_addr"');
      $_SESSION[QT]['admin_addr'] = $str;

    // save lang

    cLang::Delete('index','i');
    foreach ($_POST as $strKey => $strTranslation)
    {
      if ( substr($strKey,0,1)=='T' )
      {
        if ( !empty($strTranslation) )
        {
        if ( get_magic_quotes_gpc() ) $strTranslation = stripslashes($strTranslation);
        cLang::Add('index',substr($strKey,1),'i',$strTranslation);
        }
      }
    }

    // register lang

    $_SESSION['L']['index'] = cLang::GetName('index',$_SESSION[QT]['lang_iso'],'*');

    // exit
    if ( empty($error) ) $strInfo = $L['S_save'];
  }
}

// --------
// HTML START
// --------

// WARNINGS

if ( !ereg("^(http://|https://)",$_SESSION[QT]['site_url']) ) $warning = $L['Site_url'].': '.$L['E_missing_http'];

include('qte_adm_p_header.php');
include('qte_adm_p_title.php');

// INITIALISE

if ( empty($_SESSION[QT]['site_name']) )   $_SESSION[QT]['site_name']='';
if ( empty($_SESSION[QT]['index_name']) )  $_SESSION[QT]['index_name']='';
if ( empty($_SESSION[QT]['admin_email']) ) $_SESSION[QT]['admin_email']='';
if ( empty($_SESSION[QT]['admin_fax']) )   $_SESSION[QT]['admin_fax']='';
if ( empty($_SESSION[QT]['admin_name']) )  $_SESSION[QT]['admin_name']='';
if ( empty($_SESSION[QT]['admin_addr']) )  $_SESSION[QT]['admin_addr']='';

echo '
<script type="text/javascript">
<!--
function smtpdisabled(str)
{
  if (str=="0")
  {
  document.getElementById("smtphost").disabled=true;
  document.getElementById("smtpusr").disabled=true;
  document.getElementById("smtppwd").disabled=true;
  }
  else
  {
  document.getElementById("smtphost").disabled=false;
  document.getElementById("smtpusr").disabled=false;
  document.getElementById("smtppwd").disabled=false;
  }
  return null;
}
function PassInLink()
{
  strHost = document.getElementById("smtphost").value;
  strUser = document.getElementById("smtpusr").value;
  strPass = document.getElementById("smtppwd").value;
  document.getElementById("smtplink").href="qte_adm_smtp.php?h=" + strHost + "&u=" + strUser + "&p=" + strPass;
  document.getElementById("smtplink").target="_blank";
  return null;
}
function ValidateForm(theForm)
{
  if (theForm.sitename.value.length < 1) { alert(html_entity_decode("',$L['E_mandatory'],': ',$L['Site_name'],'")); return false; }
  if (theForm.siteurl.value.length < 1) { alert(html_entity_decode("',$L['E_mandatory'],': ',$L['Site_url'],'")); return false; }
  if (theForm.siteurl.value.substr(0,4) != "http") { alert(html_entity_decode("http:// or https:// required in ',$L['Site_url'],'")); return false; }
  if (theForm.title.value.length < 1) { alert(html_entity_decode("',$L['E_mandatory'],' ',$L['Name_of_index'],'")); return false; }
  if (theForm.adminmail.value.length < 1) { alert(html_entity_decode("',$L['E_mandatory'],': ',$L['Adm_e_mail'],'")); return false; }
  return null;
}
-->
</script>
';

echo '<form method="post" action="',$oVIP->selfurl,'" onsubmit="return ValidateForm(this);">
<table class="data_o" cellspacing="0">
<tr class="tr">
<td class="th_o th_o_all" colspan="2">',$L['General_site'],'</td>
</tr>
';
$str = QTconv($_SESSION[QT]['site_name'],'I');
echo '<tr class="tr" title="',$L['H_Site_name'],'">
<td class="th_o th_o_first" style="width:200px;"><label for="sitename">',$L['Site_name'],'</label></td>
<td class="td_o"><input type="text" id="sitename" name="sitename" size="50" maxlength="64" value="',$str,'" onchange="bEdited=true;"/>',(strstr($str,'&amp;') ?  ' <span class="disabled">'.$_SESSION[QT]['site_name'].'</span>' : ''),'</td>
</tr>
';
echo '<tr class="tr" title="',$L['H_Site_url'],'">
<td class="th_o th_o_first"><label for="siteurl">',$L['Site_url'],'</label></td>
<td class="td_o"><input type="text" id="siteurl" name="siteurl" size="50" maxlength="255" value="',$_SESSION[QT]['site_url'],'" onchange="bEdited=true;"/></td>
</tr>
';
$str = QTconv($_SESSION[QT]['index_name'],'I');
echo '<tr class="tr" title="',$L['H_Name_of_index'],'">
<td class="th_o th_o_first"><label for="title">',$L['Name_of_index'],'</label></td>
<td class="td_o">
<input type="text" id="title" name="title" size="50" maxlength="64" value="',$str,'" style="background-color:#FFFF99" onchange="bEdited=true;"/>',(strstr($str,'&amp;') ?  ' <span class="disabled">'.$_SESSION[QT]['index_name'].'</span>' : ''),'</td>
</tr>
';
echo '<tr class="tr">
<td class="th_o th_o_all" colspan="2">',$L['Contact'],'</td>
</tr>
';
echo '<tr class="tr" title="',$L['H_Admin_e_mail'],'">
<td class="th_o th_o_first"><label for="adminmail">',$L['Adm_e_mail'],'</label></td>
<td class="td_o"><input type="text" id="adminmail" name="adminmail" size="50" maxlength="255" value="',$_SESSION[QT]['admin_email'],'" onchange="bEdited=true;"/></td>
</tr>
';
$str = QTconv($_SESSION[QT]['admin_fax'],'I');
echo '<tr class="tr" title="',$L['H_Admin_fax'],'">
<td class="th_o th_o_first"><label for="adminfax">',$L['Adm_fax'],'</label></td>
<td class="td_o"><input type="text" id="adminfax" name="adminfax" size="50" maxlength="255" value="',$str,'" onchange="bEdited=true;"/>',(strstr($str,'&amp;') ?  ' <span class="disabled">'.$_SESSION[QT]['admin_fax'].'</span>' : ''),'</td>
</tr>
';
$str = QTconv($_SESSION[QT]['admin_name'],'I');
echo '<tr class="tr" title="',$L['Adm_name'],'">
<td class="th_o th_o_first"><label for="adminname">',$L['Adm_name'],'</label></td>
<td class="td_o"><input type="text" id="adminname" name="adminname" size="50" maxlength="255" value="',$str,'" onchange="bEdited=true;"/>',(strstr($str,'&amp;') ?  ' <span class="disabled">'.$_SESSION[QT]['admin_name'].'</span>' : ''),'</td>
</tr>
';
$str = QTconv($_SESSION[QT]['admin_addr'],'I');
echo '<tr class="tr" title="',$L['Adm_addr'],'">
<td class="th_o th_o_first"><label for="adminaddr">',$L['Adm_addr'],'</label></td>
<td class="td_o"><input type="text" id="adminaddr" name="adminaddr" size="50" maxlength="255" value="',$str,'" onchange="bEdited=true;"/>',(strstr($str,'&amp;') ?  ' <span class="disabled">'.$_SESSION[QT]['admin_addr'].'</span>' : ''),'</td>
</tr>
';
echo '<tr class="tr">
<td class="th_o th_o_all" colspan="2">',$L['Email_settings'],'</td>
</tr>
';
echo '<tr class="tr" title="',$L['H_Use_smtp'],'">
<td class="th_o th_o_first"><label for="smtp">',$L['Use_smtp'],'</label></td>
<td class="td_o">
<select id="smtp" name="smtp" onchange="smtpdisabled(this.value); bEdited=true;">
<option value="0"',($_SESSION[QT]['use_smtp']=='0' ? QSEL : ''),'>',$L['N'],'</option>
<option value="1"',($_SESSION[QT]['use_smtp']=='1' ? QSEL : ''),'>',$L['Y'],'</option>
</select></td>
</tr>
';
echo '<tr class="tr" title="',$L['H_Use_smtp'],'">
<td class="th_o th_o_first"><label for="smtphost">Smtp host</label></td>
<td class="td_o"><input type="text" id="smtphost" name="smtphost" size="28" maxlength="64" value="',$_SESSION[QT]['smtp_host'],'"'.($_SESSION[QT]['use_smtp']=='0' ? QDIS : '').' onchange="bEdited=true;"/></td>
</tr>
';
echo '<tr class="tr" title="',$L['H_Use_smtp'],'">
<td class="th_o th_o_first"><label for="smtpusr">Smtp username</label></td>
<td class="td_o"><input type="text" id="smtpusr" name="smtpusr" size="28" maxlength="64" value="',$_SESSION[QT]['smtp_username'],'"'.($_SESSION[QT]['use_smtp']=='0' ? QDIS : '').' onchange="bEdited=true;"/></td>
</tr>
';
echo '<tr class="tr" title="',$L['H_Use_smtp'],'">
<td class="th_o th_o_first"><label for="smtppwd">Smtp password</label></td>
<td class="td_o"><input type="text" id="smtppwd" name="smtppwd" size="28" maxlength="64" value="',$_SESSION[QT]['smtp_password'],'"'.($_SESSION[QT]['use_smtp']=='0' ? QDIS : '').' onchange="bEdited=true;"/> <a id="smtplink" href="qte_adm_smtp.php" onclick="PassInLink()">test smtp</a></td>
</tr>
';
echo '<td class="th_o th_o_all" colspan="3">',$L['Translations'],'</td>
<tr class="tr tr_o">
<td class="th_o th_o_first">',$L['Name_of_index'],'</td>
<td class="td_o" colspan="2">
<p class="help">',sprintf($L['E_no_translation'],$_SESSION[QT]['index_name']),'</p>
<table cellspacing="0" class="hidden">';
$arrTrans = cLang::GetTrans('index','i');
include('bin/qte_lang.php'); // this creates $arrLang
foreach ($arrLang as $strIso => $arr)
{
  $str = '';
  if ( isset($arrTrans[$strIso]) ) {
  if ( !empty($arrTrans[$strIso]) ) {
    $str = QTconv($arrTrans[$strIso],'I');
  }}
  echo '
  <tr>
  <td class="hidden" style="width:25px"><span title="',$arr[1],'">',$arr[0],'</span></td>
  <td class="hidden"><input class="small" title="',$L['Name_of_index'],' (',$strIso,')" type="text" id="T',$strIso,'" name="T',$strIso,'" size="45" maxlength="64" value="',$str,'"/>',(strstr($str,'&amp;') ?  ' <span class="disabled">'.$arrTrans[$strIso].'</span>' : ''),'</td>
  </tr>
  ';
}
echo '</table>
</td>
</tr>
';
echo '<tr class="tr">
<td class="th_o" colspan="2" style="padding:6px; text-align:center"><input type="submit" name="ok" value="',$L['Save'],'"/></td>
</tr>
';
echo '</table>
</form>
';

// --------
// HTML END
// --------

include('qte_adm_p_footer.php');

?>