<?php

/*
 * PHP versions 4 and 5
 *
 * LICENSE: This source file is subject to version 3.0 of the PHP license
 * that is available through the world-wide-web at the following URI:
 * http://www.php.net/license.  If you did not receive a copy of
 * the PHP License and are unable to obtain it through the web, please
 * send a note to license@php.net so we can mail you a copy immediately.
 *
 * @category   Team
 * @package    QuickTeam
 * @author     Philippe Vandenberghe <info@qt-cute.org>
 * @copyright  2008-2012 The PHP Group
 * @license    http://www.php.net/license  PHP License 3.0
 * @version    2.0 build:20090311
 * @link       http://www.qt-cute/doc/package/qte
 * @since      File available since Release 1.0.0
 * @deprecated File deprecated in Release 3.0.0
 *
 */

session_start();
require_once('bin/qte_init.php');
if ( $oVIP->role!='A' ) die($L['R_admin']);

// ---------
// INITIALISE
// ---------

include(Translate('qte_adm.php'));

function arrShift($arrSrc,$intObject,$strDir)
{
  $arrTemp = $arrSrc;

  // search for the value
  foreach ($arrSrc as $intKey => $intValue)
  {
  if ( $intValue==$intObject ) $intNewkey = $intKey;
  }
  if ( !isset($intNewkey) ) return false;
  if ( $intNewkey==0 && $strDir=='up' ) return $arrSrc;
  if ( $intNewkey==(count($arrSrc)-1) && $strDir=='down' ) return $arrSrc;

  // reorder the elements
  if ( $strDir=='up' ) { $intDir = -1; } else { $intDir = 1; }
  $arrTemp[$intNewkey+$intDir] = $arrSrc[$intNewkey];
  $arrTemp[$intNewkey] = $arrSrc[$intNewkey+$intDir];

  // return the ordered array
  return $arrTemp;
}

if ( isset($_SESSION['fields']) ) unset($_SESSION['fields']);

$oVIP->selfurl = 'qte_adm_sections.php';
$oVIP->selfname = '<span class="upper">'.$L['Adm_content'].'</span><br/>'.$L['Sections'];

// --------
// SUBMITTED
// --------

// ADD DOMAIN

if ( isset($_POST['adddomain']) )
{
  // CHECK TITLE
  $str = $_POST['title']; if ( get_magic_quotes_gpc() ) $str = stripslashes($str);
  $str = QTconv($str,'3',QTE_CONVERT_AMP,false);
  if ( empty($str) ) $error = $L['Title'].S.$L['E_invalid'];

  // SAVE
  if ( empty($error) )
  {
  $intNewid = Nextid(TABDOMAIN);
  $oDB->Query( 'INSERT INTO '.TABDOMAIN.' (id,title,vorder) VALUES ('.$intNewid.',"'.addslashes($str).'",255)' );
  }
}

// ADD SECTION

if ( isset($_POST['addteam']) )
{
  // CHECK TITLE
  $str = $_POST['title']; if ( get_magic_quotes_gpc() ) $str = stripslashes($str);
  $str = QTconv($str,'3',QTE_CONVERT_AMP);
  if ( empty($str) ) $error = $L['Title'].S.$L['E_invalid'];

  // SAVE
  if ( empty($error) )
  {
  $intId = Nextid(TABSECTION);
  $oDB->Query( 'INSERT INTO '.TABSECTION.' (domainid,id,title,type,status,vorder,forder,modid,modname,allowpic,template,ontop,members) VALUES ('.intval($_POST['indomain']).','.$intId.',"'.addslashes($str).'","0","0",0,NULL,0,"Admin","Y","T","0",0)' );
  if ( isset($_SESSION[QT]['sys_sections']) ) unset($_SESSION[QT]['sys_sections']);
  }
}

// Move domain/team

if ( isset($_GET['a']) )
{
  if ( $_GET['a']=='d_up' )
  {
    $oDB->Query('SELECT id FROM '.TABDOMAIN.' ORDER BY vorder');
    $arrList = array();
    while ($row = $oDB->Getrow())
    {
    $arrList[]=$row['id'];
    }
    $arrOrdered = arrShift($arrList,$_GET['d'],'up');
    $i = 0;
    foreach ($arrOrdered as $intId)
    {
    $oDB->Query('UPDATE '.TABDOMAIN." SET vorder=$i WHERE id=$intId");
    $i++;
    }
  }
  if ( $_GET['a']=='d_down' )
  {
    $oDB->Query('SELECT id FROM '.TABDOMAIN.' ORDER BY vorder');
    $arrList = array();
    while ($row = $oDB->Getrow())
    {
    $arrList[]=$row['id'];
    }
    $arrOrdered = arrShift($arrList,$_GET['d'],'down');
    $i = 0;
    foreach ($arrOrdered as $intId)
    {
    $oDB->Query('UPDATE '.TABDOMAIN." SET vorder=$i WHERE id=$intId");
    $i++;
    }
  }
  if ( $_GET['a']=='f_up' )
  {
    $oDB->Query('SELECT id FROM '.TABSECTION.' ORDER BY vorder');
    $arrList = array();
    while ($row = $oDB->Getrow())
    {
    $arrList[]=$row['id'];
    }
    $arrOrdered = arrShift($arrList,$_GET['s'],'up');
    $i = 0;
    foreach ($arrOrdered as $intId)
    {
    $oDB->Query('UPDATE '.TABSECTION." SET vorder=$i WHERE id=$intId");
    $i++;
    }
  }
  if ( $_GET['a']=='f_down' )
  {
    $oDB->Query('SELECT id FROM '.TABSECTION." ORDER BY vorder");
    $arrList = array();
    while ($row = $oDB->Getrow())
    {
    $arrList[]=$row['id'];
    }
    $arrOrdered = arrShift($arrList,$_GET['s'],'down');
    $i = 0;
    foreach ($arrOrdered as $intId)
    {
    $oDB->Query('UPDATE '.TABSECTION." SET vorder=$i WHERE id=$intId");
    $i++;
    }
  }
}

// --------
// HTML START
// --------

$bJava=true;
include('qte_adm_p_header.php');
include('qte_adm_p_title.php');

$arrDomains = GetDomains();

$strYes = '<b>'.$L['Y'].'</b>';
$strNo  = '<span class="disabled">'.$L['N'].'</span>';

echo '<table class="data_o" cellspacing="0">
<colgroup span="7"><col width="30"></col><col width="50"></col><col></col><col></col><col></col><col></col><col></col></colgroup>
<tr class="tr">
<td class="th_o">Id</td>
<td class="th_o" colspan="2" style="text-align:left">',$L['Domain'],'/',$L['Section'],'</td>
<td class="th_o">',$L['Section_moderator'],'</td>
<td class="th_o">',$L['Action'],'</td>
<td class="th_o">',$L['Move'],'</td>
<td class="th_o">',$L['Users'],'</td>
</tr>
';

$i=0;
foreach($arrDomains as $intDomid=>$strDomtitle)
{
  // GET SECTIONS (with hidden)

  $arrSections = GetSectionTitles('A',$intDomid);

  // DISPLAY

  echo '<tr class="tr">',N;
  echo '<td class="td_o_all">&nbsp;</td>',N;
  echo '<td class="td_o_all" colspan="2">',$strDomtitle,'</td>',N;
  echo '<td class="td_o_all">&nbsp;</td>',N;
  echo '<td class="td_o_all" style="text-align:center"><a class="small" href="qte_adm_domain.php?d=',$intDomid,'">',$L['Edit'],'</a>';
  echo ' &middot; ',($intDomid==0 ? '<span class="disabled">'.$L['Delete'].'</span>' : '<a class="small" href="qte_cmd.php?a=deletedomain&amp;s='.$intDomid.'">'.$L['Delete'].'</a>'),'</td>',N;
  echo '<td class="td_o_all" style="text-align:center">';
  if ( $i==0 )
  {
  echo '<span class="disabled">',$L['Up'],'</span>';
  }
  else
  {
  echo '<a class="small" href="qte_adm_sections.php?d=',$intDomid,'&amp;a=d_up">',$L['Up'],'</a>';
  }
  echo ' &middot; ';
  if ( $i+1==count($arrDomains) )
  {
  echo '<span class="disabled">',$L['Down'],'</span>';
  }
  else
  {
  echo '<a class="small" href="qte_adm_sections.php?d=',$intDomid,'&amp;a=d_down">',$L['Down'],'</a>';
  }
  echo '</td>',N;
  echo '<td class="td_o_all" style="text-align:center">&nbsp;</td>',N;

  $i += 1;

  $j = 0;
  foreach($arrSections as $intSecid=>$strSectitle)
  {
    // GET SECTION
    $oSEC = new cSection($intSecid);
    echo '<tr class="tr">',N;
    echo '<td class="td_o" style="text-align:center">',$oSEC->id,'</td>',N;
    echo '<td class="td_o" style="text-align:center">',AsImg($_SESSION[QT]['skin_dir'].'/ico_section_'.$oSEC->type.'_'.$oSEC->status.'.gif','[+]',$L['Ico_section_'.$oSEC->type.'_'.$oSEC->status],'ico i_sec','','qte_adm_section.php?d='.$intDomid.'&amp;s='.$oSEC->id),'</td>';
    echo '<td class="td_o"><a class="bold" href="qte_adm_section.php?d=',$intSecid,'&amp;s=',$oSEC->id,'">',$oSEC->name,'</a><br/><span class="small">',$L['Section_type'][$oSEC->type],($oSEC->status=='1' ? '<br><span class="small">('.$L['Section_status'][1].')</span>' : ''),'</span></td>';
    echo '<td class="td_o" style="text-align:center">',$oSEC->modname,'</td>',N;
    echo '<td class="td_o" style="text-align:center">
    <a class="small" href="qte_adm_section.php?d=',$intDomid,'&amp;s=',$oSEC->id,'">',$L['Edit'],'</a> &middot; 
    '.($intSecid==0 ? '<span class="disabled">'.$L['Delete'].'</span>' : '<a class="small" href="qte_cmd.php?a=deletesection&amp;s='.$intSecid.'">'.$L['Delete'].'</a>'),'</td>',N;
    echo '<td class="td_o" style="text-align:center">';
    if ( $j==0 )
    {
    echo '<span class="disabled">',$L['Up'],'</span>';
    }
    else
    {
    echo '<a class="small" href="qte_adm_sections.php?d=',$intDomid,'&amp;s=',$intSecid,'&amp;a=f_up">',$L['Up'],'</a>';
    }
    echo ' &middot; ';
    if ( $j+1==count($arrSections) )
    {
    echo '<span class="disabled">',$L['Down'],'</span>';
    }
    else 
    {
    echo '<a class="small" href="qte_adm_sections.php?d=',$intDomid,'&amp;s=',$intSecid,'&amp;a=f_down">',$L['Down'],'</a>';
    }
    $j += 1;
    echo '</td>',N;
    echo '<td class="td_o" style="text-align:center">',$oSEC->members,' &middot; <a class="small" href="qte_adm_users_move.php?s=',$oSEC->id,'">',$L['User_man'],'</a></td>',N;
    echo '</tr>',N;
  }
}
echo '</table>
';

echo '<h2>',$L['Section_add'],'</h2>
';

echo '
<script type="text/javascript">
<!--
function ValidateForm(theForm)
{
  if (theForm.title.value.length==0) { alert(html_entity_decode("',$L['E_mandatory'],': ',$L['Domain'],'/',$L['Section'],'")); return false; }
  return null;
}
-->
</script>
';

echo '<form method="post" action="qte_adm_sections.php" onsubmit="return ValidateForm(this);">
<table class="data_o" cellspacing="0">
<tr class="tr">
<td class="td_o_all" style="width:130px;">',$L['Domain_add'],'</td>
<td class="td_o_all"><input name="title" type="text" size="30" maxlength="64" onkeyup="handle_keypress(event,\'adddomain\')"/></td>
<td class="td_o_all" style="width:75px;"><input id="adddomain" name="adddomain" type="submit" value="',$L['Add'],'"/></td>
</tr>
</table>
</form>
';
echo '<form method="post" action="qte_adm_sections.php" onsubmit="return ValidateForm(this);">
<table class="data_o" cellspacing="0">
<tr class="tr">
<td class="td_o" style="width:130px;">',$L['Section_add'],'</td>
<td class="td_o">
<input name="title" type="text" size="30" maxlength="64"/> <span class="small">',strtolower($L['In_domain']),'</span> <select name="indomain" size="1" class="small">',QTastags($arrDomains),'</select>
</td>
<td class="td_o" style="width:75px;"><input name="addteam" type="submit" value="',$L['Add'],'"/></td>
</tr>
</table>
</form>
';

// --------
// HTML END
// --------

include('qte_adm_p_footer.php');

?>