<?php

/*
 * PHP versions 4 and 5
 *
 * LICENSE: This source file is subject to version 3.0 of the PHP license
 * that is available through the world-wide-web at the following URI:
 * http://www.php.net/license.  If you did not receive a copy of
 * the PHP License and are unable to obtain it through the web, please
 * send a note to license@php.net so we can mail you a copy immediately.
 *
 * @category   Team
 * @package    QuickTeam
 * @author     Philippe Vandenberghe <info@qt-cute.org>
 * @copyright  2008-2012 The PHP Group
 * @license    http://www.php.net/license  PHP License 3.0
 * @version    2.0 build:20090311
 * @link       http://www.qt-cute/doc/package/qte
 * @since      File available since Release 1.0.0
 * @deprecated File deprecated in Release 3.0.0
 *
 */

session_start();
require_once('bin/qte_init.php');
require_once('bin/qte_fn_edit.php');
include(Translate('qte_adm.php'));
include(Translate('qte_reg.php'));

if ( $_SESSION[QT]['picture']=='0' ) die($L['E_access']);
if ( $oVIP->role!='A' ) die($L['E_admin']);

// ---------
// INITIALISE
// ---------

include('bin/qt_lib_smtp.php');

$s = -1;
if (isset($_GET['s'])) $s = intval($_GET['s']);
if (isset($_POST['s'])) $s = intval($_POST['s']);
if ( $s<0 ) die('Missing parameters');

$strImg = 'document/section/none.gif';

$oVIP->selfurl = 'qte_adm_section_img.php';
$oVIP->selfname = $L['Change_picture'];
$oVIP->exiturl = 'qte_adm_section.php?s='.$s;
$oVIP->exitname = $L['Section_upd'];

// --------
// SUBMITTED FOR DELETE
// --------

if ( isset($_POST['del']) )
{
  $oDB->Query('UPDATE '.TABSECTION.' SET picture="" WHERE id='.$s);
  if (file_exists($_POST['file'])) unlink($_POST['file']);
  $oVIP->EndMessage(NULL,$L['S_delete'],$_SESSION[QT]['skin_dir'],2);
}

// --------
// SUBMITTED FOR UPLOAD
// --------

if ( isset($_POST['ok']) )
{
  // Check uploaded document

  $error = InvalidUpload($_FILES['title'],'gif,jpg,jpeg,png','',0,200,200);

  // Save

  if ( empty($error) )
  {
    $strExt = strtolower(substr(strrchr($_FILES['title']['name'],'.'),1));
    copy($_FILES['title']['tmp_name'],'document/section/'.$s.$strExt);
    $oDB->Query('UPDATE '.TABSECTION.' SET picture="document/section/'.$s.$strExt.'" WHERE id='.$s);
    unlink($_FILES['title']['tmp_name']);
    $oVIP->EndMessage(NULL,$L['S_update'],$_SESSION[QT]['skin_dir'],2);
  }  
}

// --------
// HTML START
// --------

if ( $oVIP->role!='A' ) { if ($oVIP->id!=$s) die($L['R_user']); }

include('qte_adm_p_header.php');

$oDB->Query('SELECT picture,title FROM '.TABSECTION.' WHERE id='.$s);
$row = $oDB->Getrow();
if ( !empty($row['picture']) ) $strImg = $row['picture'];

echo '<table class="hidden" cellspacing="0">
<tr class="hidden">
<td class="hidden" style="width:200px;"><br/>',AsImgBox(AsImg($strImg),'picbox'),'</td>
<td class="hidden">
';

HtmlMsg(0,'400px','',$oVIP->selfname);

echo '
<script type="text/javascript">
<!--
function ValidateForm(theForm)
{
  if (theForm.title.value.length==0) { alert(html_entity_decode("',$L['E_mandatory'],': File")); return false; }
  return null;
}
-->
</script>
';

echo '<form method="post" action="',$oVIP->selfurl,'" enctype="multipart/form-data" onsubmit="return ValidateForm(this);">',N;
if ( !empty($error) ) echo '<span class="error">',$error,'</span>',N;
echo '<p class="small" style="text-align:right">',$L['H_Change_logo'],'</p>
<p style="text-align:right">
<input type="file" id="title" name="title" size="32"/>
<input type="hidden" name="max_file_size" value="10000"/>
<input type="hidden" name="s" value="',$s,'"/>
<input type="submit" name="ok" value="',$L['Save'],'"/></p>
</form><br/>
<form method="post" action="',$oVIP->selfurl,'">
<p style="text-align:right">',$L['Delete_picture'],' <input type="hidden" name="s" value="',$s,'"/>
<input type="hidden" name="file" value="',$row['picture'],'"/>
<input type="submit" name="del" value="',$L['Delete'],'"/></p>
</form>
';
HtmlMsg(1);

echo '
</td>
<td class="hidden">&nbsp;</td>
</tr>
</table>
<p><a href="',$oVIP->exiturl,'">&laquo; ',$oVIP->exitname,'</a></p>';

// --------
// HTML END
// --------

include('qte_adm_p_footer.php');

?>