<?php

/*
 * PHP versions 4 and 5
 *
 * LICENSE: This source file is subject to version 3.0 of the PHP license
 * that is available through the world-wide-web at the following URI:
 * http://www.php.net/license.  If you did not receive a copy of
 * the PHP License and are unable to obtain it through the web, please
 * send a note to license@php.net so we can mail you a copy immediately.
 *
 * @category   Team
 * @package    QuickTeam
 * @author     Philippe Vandenberghe <info@qt-cute.org>
 * @copyright  2008-2012 The PHP Group
 * @license    http://www.php.net/license  PHP License 3.0
 * @version    2.0 build:20090311
 * @link       http://www.qt-cute.org/doc/package/qte
 * @since      File available since Release 1.0.0
 * @deprecated File deprecated in Release 3.0.0
 *
 */

session_start();
require_once('bin/qte_init.php');
include('bin/qte_fn_admin.php');
if ( $oVIP->role!='A' ) die($L['R_admin']);

// ---------
// INITIALISE
// ---------

$s = -1;
if ( isset($_GET['s']) ) $s = intval($_GET['s']);
if ( $s<0 ) die('missing section id...');

include(Translate('qte_adm.php'));

$oSEC = new cSection($s);
$oUser = new cUser(1);

$oVIP->selfurl = 'qte_adm_section_col.php';
$oVIP->selfname = $L['Section_upd'];
$oVIP->exiturl = 'qte_adm_section.php?s='.$s;
$oVIP->exitname = '&laquo; '.$L['Sections'];

// --------
// SUBMITTED
// --------

if ( isset($_GET['a']) )
{  
  switch($_GET['a'])
  {
  case $L['Add']:
    if ( substr($_GET['v'],0,1)!='-' )
    {
    if ( in_array($_GET['v'],$_SESSION['fields']) ) $error = $L['E_already_used'];
    if ( count($_SESSION['fields'])>=10 ) $error = $L['E_max_10'];
    if ( empty($error) )
    {
      $_SESSION['fields'] = Changelist($_SESSION['fields'],'add',$_GET['v']);
      if ( count($_SESSION['fields'])>6 ) $error = $L['E_more_than_5'];
    }
    }
    break;
  case 'del': $_SESSION['fields'] = Changelist($_SESSION['fields'],'del',$_GET['v']); unset($_SESSION['values']); break;
  case 'left': $_SESSION['fields'] = Changelist($_SESSION['fields'],'left',$_GET['v']); break;
  case 'right': $_SESSION['fields'] = Changelist($_SESSION['fields'],'right',$_GET['v']); break;
  case 'default': $_SESSION['fields'] = array('status_i','fullname','phones','emails_i','picture'); break;
  }
}

if ( isset($_GET['ok']) )
{
  $oSEC->forder = implode(';',$_SESSION['fields']);
  $oDB->Query('UPDATE '.TABSECTION.' SET forder="'.$oSEC->forder.'" WHERE id='.$s);
  unset($_SESSION['fields']);
  // exit
  $oVIP->EndMessage(NULL,$L['S_update'],'admin',2);
}

// --------
// HTML START
// --------

if ( !isset($_SESSION['fields']) || !isset($_GET['a']) )
{
  $_SESSION['fields'] = GetFieldsUsable($oSEC->forder,'nid');
}

include('qte_adm_p_header.php');
include('qte_adm_p_title.php');

$strChoicelist = QTastags(ChoiceList($_SESSION['fields']));
$strChoicelist = str_replace('>[X] ','disabled="disabled">',$strChoicelist);
$strChoicelist = str_replace('-">','-" disabled="disabled">',$strChoicelist);

echo '<h2>',$L['Columns'],': ',$oSEC->name,'</h2><br/><br/>';

echo '<form method="get" action="',$oVIP->selfurl,'">';
echo '<select id="v" name="v">',$strChoicelist,'</select>';
echo '<input type="hidden" name="s" value="',$s,'"/>';
echo '&nbsp;<input type="submit" name="a" value="',$L['Add'],'"/>';
echo ' <a href="',$oVIP->selfurl,'?s=',$s,'&amp;a=default">',$L['Default_fields'],'</a>';
echo '<br/ ><br/>';

echo '<table cellspacing="0" class="data_o">';

// editor
echo '<tr class="tr">';
foreach ($_SESSION['fields'] as $strField) 
{
echo '<td class="th_o th_o_first" style="text-align:center; min-width:40px">
<a href="',$oVIP->selfurl,'?s=',$s,'&amp;a=left&amp;v=',$strField,'"><img src="admin/sort_left.gif" style="border-width:0" alt="&lt;" title="move left"/></a>
<a href="',$oVIP->selfurl,'?s=',$s,'&amp;a=del&amp;v=',$strField,'"><img src="admin/sort_del.gif" style="border-width:0" alt="x" title="delete"/></a>
<a href="',$oVIP->selfurl,'?s=',$s,'&amp;a=right&amp;v=',$strField,'"><img src="admin/sort_right.gif" style="border-width:0" alt="&gt;" title="move right"/></a>
</td>';
}
echo '</tr>',N;

// head
echo '<tr class="tr">';
foreach ($_SESSION['fields'] as $strField) 
{
  $strLabel = ObjTrans('field',$strField);
  // exception
  if ( $strField=='emails_i' ) $strLabel=ObjTrans('field','emails');
  if ( $strField=='status_i' ) $strLabel=ObjTrans('field','status');
  
  echo '<td class="th_o th_o_first" style="text-align:center">',$strLabel,'</td>';
}
echo '</tr>',N;

// value sample
echo '<tr class="tr">';

foreach ($_SESSION['fields'] as $strField) 
{
  switch ($strField)
  {
  case 'status_i':
    echo '<td class="td_s" style="text-align:center">',AsImg($_SESSION[QT]['skin_dir'].'/'.$oSYS->statuses[$oUser->status]['icon']),'</td>',N;
    break; 
  case 'status':
    echo '<td class="td_s" style="text-align:center">',$oSYS->statuses[$oUser->status]['statusname'],'</td>',N;
    break; 
  case 'picture':
    if ( count($_SESSION['fields'])>6 )
    {
    echo '<td class="td_s" style="text-align:center; width:60px">',AsImg((empty($oUser->picture) ? '' : $oUser->picture),'',$oUser->fullname,'memberlistC'),'</td>',N;
    }
    else
    {
    echo '<td class="td_s" style="text-align:center; width:120px">',AsImg((empty($oUser->picture) ? '' : $oUser->picture),'',$oUser->fullname,'memberlistN'),'</td>',N;
    }
    break; 
  case 'birthdate':
    echo '<td class="td_s" style="text-align:center">',( empty($oUser->birthdate) ? S : QTdatestr($oUser->birthdate,'$','',false) ),'</td>',N;
    break; 
  case 'teamdate1':
    echo '<td class="td_s" style="text-align:center">',QTdatestr('now','$','',false),'</td>',N;
    break; 
  case 'teamdate2':
    echo '<td class="td_s" style="text-align:center">',QTdatestr('now','$','',false),'</td>',N;
    break; 
  case 'age':
    echo '<td class="td_s" style="text-align:center">',$oUser->age,'</td>',N;
    break; 
  case 'role':
    echo '<td class="td_s" style="text-align:center">',$L['Userrole'][$oUser->role],'</td>',N;
    break; 
  case 'username': 
    echo '<td class="td_s" style="text-align:center"><a href="" onclick="return false">',$oUser->username,'</a></td>',N;
    break; 
  case 'emails_i':
    echo '<td class="td_s" style="text-align:center">',AsImg($_SESSION[QT]['skin_dir'].'/ico_user_e_1.gif','mail',(empty($oUser->emails) ? '' : $oUser->emails)),'</td>',N;
    break;
  default:
    echo '<td class="td_s" style="text-align:center">',(!empty($oUser->$strField) ? AsTextList($oUser->$strField) : S),'</td>',N;
    break;
  }
}

echo '</tr>',N;

echo '</table>',N,N;

echo '<br/><input type="submit" name="ok" value="',$L['Save'],'"/>';
echo '</form>';

// --------
// HTML END
// --------

echo '<p><a href="',$oVIP->exiturl,'">',$oVIP->exitname,'</a></p>';

include('qte_adm_p_footer.php');

?>