<?php

/* PHP versions 4 and 5
 *
 * LICENSE: This source file is subject to version 3.0 of the PHP license
 * that is available through the world-wide-web at the following URI:
 * http://www.php.net/license.  If you did not receive a copy of
 * the PHP License and are unable to obtain it through the web, please
 * send a note to license@php.net so we can mail you a copy immediately.
 *
 * @category   Team
 * @package    QuickTeam
 * @author     Philippe Vandenberghe <info@qt-cute.org>
 * @copyright  2008-2012 The PHP Group
 * @license    http://www.php.net/license  PHP License 3.0
 * @version    2.0 build:20090311
 * @link       http://www.qt-cute/doc/package/qte
 * @since      File available since Release 1.0.0
 * @deprecated File deprecated in Release 3.0.0 */

session_start();
require_once('bin/qte_init.php');
if ( $oVIP->role!='A' ) die($L['R_admin']);

// ---------
// INITIALISE
// ---------

$s = -1;
if ( isset($_GET['s']) ) $s = intval($_GET['s']);
if ( isset($_POST['s']) ) $s = intval($_POST['s']);
if ( $s<0 ) die('Missing parameters');

include(Translate('qte_adm.php'));
include(Translate('qte_reg.php'));

$oVIP->selfurl  = 'qte_adm_section.php';
$oVIP->selfname = $L['Section_upd'];
$oVIP->exiturl  = 'qte_adm_sections.php';
$oVIP->exitname = '&laquo; '.$L['Sections'];

$arrDomains = GetDomains();
$arrStaff = GetUsers('M');
if ( count($arrStaff)>10 ) { $bAjax=true; } else { $bAjax=false; }

$oSEC = new cSection($s);

// --------
// SUBMITTED
// --------

if ( isset($_POST['ok']) )
{
  // CHECK MANDATORY VALUE

  $str = trim(strip_tags($_POST['title'])); if ( get_magic_quotes_gpc() ) $str = stripslashes($str);
  $str = QTconv($str,'3',QTE_CONVERT_AMP,false);
  if ( empty($str) ) $error = $L['Title'].S.$L['E_invalid'];

  if ( empty($error) )
  {
    $oSEC->id = $s;
    $oSEC->domid = $_POST['domid'];
    $oSEC->name = $str;
    $oSEC->type = intval($_POST['type']);
    $oSEC->status = intval($_POST['status']);
    if ( isset($_POST['modname']) )
    {
      if ( $_POST['modname']!=$_POST['modnameold'] )
      {
      $oSEC->modname = $_POST['modname'];
      $oSEC->modid = array_search($_POST['modname'],$arrStaff);
      if ( $oSEC->modid==FALSE || empty($oSEC->modid) ) { $oSEC->modid=1; $oSEC->modname=$arrStaff[1]; $warning=$L['Userrole_MF'].S.$L['E_invalid']; }
      }
    }
    if ( isset($_POST['modid']) )
    {
      if ( $_POST['modid']!=$_POST['modidold'] )
      {
        $oSEC->modname = $arrStaff[$_POST['modid']];
        $oSEC->modid = $_POST['modid'];
      }
    }
  }

  // SAVE

  if ( empty($error) )
  {
    // update
    $oDB->Query('UPDATE '.TABSECTION.' SET domainid='.$oSEC->domid.', title="'.$oSEC->name.'", type="'.$oSEC->type.'", status="'.$oSEC->status.'", modid='.$oSEC->modid.', modname="'.$oSEC->modname.'" WHERE id='.$oSEC->id);
    
    // translation
    $oDB->Query('DELETE FROM '.TABLANG.' WHERE (objtype="sec" OR objtype="secdesc") AND objid="s'.$oSEC->id.'"');
    foreach ($_POST as $strKey => $strTranslation)
    {
      if ( substr($strKey,0,1)=='T' )
      {
        if ( !empty($strTranslation) )
        {
        if ( get_magic_quotes_gpc() ) $strTranslation = stripslashes($strTranslation);
        cLang::Add('sec',substr($strKey,1),'s'.$oSEC->id,$strTranslation);
        }
      }
      if ( substr($strKey,0,1)=='D' )
      {
        if ( !empty($strTranslation) )
        {
        if ( get_magic_quotes_gpc() ) $strTranslation = stripslashes($strTranslation);
        cLang::Add('secdesc',substr($strKey,1),'s'.$oSEC->id,$strTranslation);
        }
      }
    }

    // register section lang and description

    $_SESSION['L']['sec'] = cLang::GetName('sec',$_SESSION[QT]['lang_iso'],'*');
    $_SESSION['L']['secdesc'] = cLang::GetName('secdesc',$_SESSION[QT]['lang_iso'],'*');
    Unset($oSYS->sections);
    Unset($_SESSION[QT]['sys_notifysections']);
    
    // exit
    $strInfo = $L['S_save'];
  }
}

// --------
// HTML START
// --------

if ( $bAjax )
{
$arrCss = array('qt_jquery.css'); 
$strHeadScript = '
<script type="text/javascript" src="bin/qt_jquery.js"></script>
<script type="text/javascript" src="bin/qt_jquery_auto.js"></script>
<script type="text/javascript">
<!--
$(document).ready(function() {
  $("#modname").autocomplete("qte_j_name.php", {
    selectFirst: false,
    extraParams: { r:"M" }
  });
});
-->
</script>';
}

include('qte_adm_p_header.php');
include('qte_adm_p_title.php');

$arrDest = $arrDomains;
Unset($arrDest[$oSEC->domid]);

// FORM

echo '
<script type="text/javascript">
<!--
function ValidateForm(theForm)
{
  if (theForm.title.value.length==0) { alert(html_entity_decode("',$L['E_mandatory'],': ',$L['Title'],'")); return false; }
  return null;
}
-->
</script>
';

echo '<form method="post" action="',$oVIP->selfurl,'" onsubmit="return ValidateForm(this);">
<table class="data_o" cellspacing="0">
<tr class="tr">
<td class="th_o th_o_all" colspan="2"><b>',$L['Definition'],'</b></td>
</tr>
<tr class="tr">
<td class="th_o th_o_first" style="width:150px"><span class="texthead">Id</span></td>
<td class="td_o">',$oSEC->id,'</td>
</tr>
';
$str = QTconv($oSEC->idtitle,'I');
echo '<tr class="tr tr_o">
<td class="th_o" style="width:150px; text-align:right"><span class="texthead"><label for="title">',$L['Title'],'</label></span></td>
<td class="td_o"><input type="text" id="title" name="title" size="55" maxlength="64" value="',$str,'" style="background-color:#FFFF99;" onchange="bEdited=true;"/>',(strstr($str,'&amp;') ?  ' <span class="disabled">'.$oSEC->idtitle.'</span>' : ''),'</td>
</tr>
';
echo '<tr class="tr tr_o">
<td class="th_o" style="width:150px; text-align:right"><span class="texthead">',$L['Domain'],'</span></td>
<td class="td_o"><select name="domid" onchange="bEdited=true;">
<option value="',$oSEC->domid,'"',QSEL,'>',$arrDomains[$oSEC->domid],'</option>',QTastags($arrDest,$L['Move_to'].': %s'),'</select></td>
</tr>
';
echo '<tr class="tr">
<td class="th_o th_o_all" colspan="2"><b>',$L['Options'],'</b></td>
</tr>
';
echo '<tr class="tr">
<td class="th_o th_o_first" style="width:150px"><span class="texthead"><label for="type">',$L['Type'],'</label></span></td>
<td class="td_o">
<select id="type" name="type" onchange="bEdited=true;">
<option value="0"',($oSEC->type=='0' ? QSEL : ''),'>',$L['Section_type'][0],'</option>
<option value="1"',($oSEC->type=='1' ? QSEL : ''),'>',$L['Section_type'][1],'</option>
</select> ',$L['Status'],' <select id="status" name="status" onchange="bEdited=true;">
<option value="0"',($oSEC->status=='0' ? QSEL : ''),'>',$L['Section_status'][0],'</option>
<option value="1"',($oSEC->status=='1' ? QSEL : ''),'>',$L['Section_status'][1],'</option>
</select>
</tr>
';
if ( count($arrStaff)>10 )
{
echo '<tr class="tr">
<td class="th_o th_o_first" style="width:150px"><span class="texthead">',$L['Section_moderator'],'</span></td>
<td class="td_o"><input type="hidden" name="modnameold" value="',$oSEC->modname,'"/>
<input type="text" name="modname" id="modname" value="',$oSEC->modname,'" size="24" maxlength="32" onchange="bEdited=true;"/>
</td>
</tr>
';
}
else
{
echo '<tr class="tr">
<td class="th_o th_o_first" style="width:150px"><span class="texthead">',$L['Section_moderator'],'</span></td>
<td class="td_o"><input type="hidden" name="modidold" value="',$oSEC->modname,'"/>
<select name="modid" id="modid" onchange="bEdited=true;"/>',QTastags($arrStaff,null,$oSEC->modid,null,$oSEC->modid,'bold'),'</select>
</td>
</tr>
';
}
echo '<tr class="tr">
<td class="th_o th_o_first" style="width:150px"><span class="texthead">',$L['Picture'],'</span></td>
<td class="td_o">',( !empty($oSEC->picture) ? AsImg($oSEC->picture) : '' ),' <a href="qte_adm_section_img.php?s=',$oSEC->id,'" onclick="return warningedited(bEdited,\''.$L['E_editing'].'\');">',$L['Change_picture'],'</a></td>
</tr>
';
echo '<tr class="tr">
<td class="th_o th_o_first" style="width:150px"><span class="texthead">',$L['Columns'],'</span></td>
<td class="td_o">',GetFieldsUsable($oSEC->forder,'name',', '),' &middot; <a href="qte_adm_section_col.php?s=',$oSEC->id,'" onclick="return warningedited(bEdited,\''.$L['E_editing'].'\');">',$L['Edit'],'</a></td>
</tr>
';
echo '<td class="th_o th_o_all" colspan="3">',$L['Translations'],'</td>
<tr class="tr tr_o">
<td class="th_o th_o_first">',$L['Section_name_and_desc'],'</td>
<td class="td_o" colspan="2">
<p class="help">',sprintf($L['E_no_translation'],$oSEC->idtitle),'</p>
<table cellspacing="0" class="hidden">';
$arrTrans = cLang::GetTrans('sec','s'.$oSEC->id);
$arrDescTrans = cLang::GetTrans('secdesc','s'.$oSEC->id);
include('bin/qte_lang.php'); // this creates $arrLang
foreach ($arrLang as $strIso => $arr)
{
  $str = '';
  if ( isset($arrTrans[$strIso]) ) {
  if ( !empty($arrTrans[$strIso]) ) {
    $str = QTconv($arrTrans[$strIso],'I');
  }}
  echo '
  <tr class="hidden">
  <td class="hidden" style="width:25px"><span title="',$arr[1],'">',$arr[0],'</span></td>
  <td class="hidden" style="width:220px"><input class="small" title="',$L['Section'],' (',$strIso,')" type="text" id="T',$strIso,'" name="T',$strIso,'" size="32" maxlength="64" value="',$str,'" onchange="bEdited=true;"/>&nbsp;',(strstr($str,'&amp;') ?  '<br/><span class="disabled">'.$arrTrans[$strIso].'</span>' : ''),'</td>';
  $str = '';
  if ( isset($arrDescTrans[$strIso]) ) {
  if ( !empty($arrDescTrans[$strIso]) ) {
    $str = QTconv($arrDescTrans[$strIso],'I');
  }}
  echo '<td class="hidden"><textarea class="small" title="',$L['Description'],' (',$strIso,')" type="text" id="D',$strIso,'" name="D',$strIso,'" cols="45" rows="2">',$str,'</textarea></td>
  </tr>
  ';
}
echo '</table>
</td>
</tr>
';
echo '<tr class="tr">
<td class="th_o" colspan="2" style="padding:6px; text-align:center"><input type="hidden" name="s" value="',$oSEC->id,'"/><input type="submit" name="ok" value="',$L['Save'],'"/></td>
</tr>
';
echo '</table>
</form>
<p><a href="',$oVIP->exiturl,'" onclick="return warningedited(bEdited,\''.$L['E_editing'].'\');">',$oVIP->exitname,'</a></p>
';

// --------
// HTML END
// --------

include('qte_adm_p_footer.php');

?>