<?php

/*
 * PHP versions 4 and 5
 *
 * LICENSE: This source file is subject to version 3.0 of the PHP license
 * that is available through the world-wide-web at the following URI:
 * http://www.php.net/license.  If you did not receive a copy of
 * the PHP License and are unable to obtain it through the web, please
 * send a note to license@php.net so we can mail you a copy immediately.
 *
 * @category   Team
 * @package    QuickTeam
 * @author     Philippe Vandenberghe <info@qt-cute.org>
 * @copyright  2008-2012 The PHP Group
 * @license    http://www.php.net/license  PHP License 3.0
 * @version    2.0 build:20090311
 * @link       http://www.qt-cute.org/doc/package/qte
 * @since      File available since Release 1.0.0
 * @deprecated File deprecated in Release 3.0.0
 *
 */

session_start();
require_once('bin/qte_init.php');
include(Translate('qte_adm.php'));
include(Translate('qte_zone.php'));

if ( $oVIP->role!='A' ) die($L['E_admin']);

// ---------
// INITIALISE
// ---------

$oVIP->selfurl = 'qte_adm_region.php';
$oVIP->selfname = '<span class="upper">'.$L['Adm_settings'].'</span><br/>'.$L['Adm_region'];
$oVIP->exiturl = $oVIP->selfurl;
$oVIP->exitname = $oVIP->selfname;

// --------
// SUBMITTED
// --------

if ( isset($_POST['ok']) )
{
  $bNewLang = False;
  if ( $_POST['dfltlang']<>$_SESSION[QT]['language'] ) $bNewLang = true;

  $_SESSION[QT]['time_zone'] = $_POST['timezone'];
  $_SESSION[QT]['daylight'] = $_POST['daylight'];
  $_SESSION[QT]['show_time_zone'] = $_POST['showtimezone'];
  $_SESSION[QT]['userlang'] = $_POST['userlang'];
  $_SESSION[QT]['language'] = 'language/'.$_POST['dfltlang'];

  // change language
  include(Translate('qte_main.php'));
  include(Translate('qte_adm.php'));
  include(Translate('qte_zone.php'));
  $oVIP->exitname = $oVIP->selfname;
  $oVIP->selfname = '<span style="text-transform:uppercase">'.$L['Adm_settings'].'</span><br/>'.$L['Adm_region'];

  // save
  $oDB->Query('UPDATE '.TABSETTING.' SET setting="'.$_SESSION[QT]['time_zone'].'" WHERE param="time_zone"');
  $oDB->Query('UPDATE '.TABSETTING.' SET setting="'.$_SESSION[QT]['daylight'].'" WHERE param="daylight"');
  $oDB->Query('UPDATE '.TABSETTING.' SET setting="'.$_SESSION[QT]['show_time_zone'].'" WHERE param="show_time_zone"');
  $oDB->Query('UPDATE '.TABSETTING.' SET setting="'.$_SESSION[QT]['userlang'].'" WHERE param="userlang"');
  $oDB->Query('UPDATE '.TABSETTING.' SET setting="'.$_POST['dfltlang'].'" WHERE param="language"');
  
  // formatdate
  $str = trim($_POST['formatdate']); if ( get_magic_quotes_gpc() ) $str = stripslashes($_POST['formatdate']);
  if ( $str=='' ) $error = $L['E_invalid'].S.$L['Date_format'];
  if ( empty($error) )
  {
  $_SESSION[QT]['formatdate'] = $str;
  $oDB->Query('UPDATE '.TABSETTING.' SET setting="'.$_SESSION[QT]['formatdate'].'" WHERE param="formatdate"');
  }

  // formattime (empty allowed)
  $str = trim($_POST['formattime']); if ( get_magic_quotes_gpc() ) $str = stripslashes($_POST['formattime']);
  if ( empty($error) )
  {
  $_SESSION[QT]['formattime'] = $str;
  $oDB->Query('UPDATE '.TABSETTING.' SET setting="'.$_SESSION[QT]['formattime'].'" WHERE param="formattime"');
  }

  // exit  
  if ( empty($error) )
  {
    if ( $bNewLang )
    {
    if ( isset($_SESSION[QT]['lx']) ) unset($_SESSION[QT]['lx']);
    }
    $strInfo = $L['S_save'];
  }
}

// --------
// HTML START
// --------

include('qte_adm_p_header.php');
include('qte_adm_p_title.php');

// Read directory in language

$intHandle = opendir('language');
$arrFiles = array();
while ( false!==($strFile = readdir($intHandle)) )
{
if ( $strFile!='.' && $strFile!='..' ) $arrFiles[$strFile] = ucfirst($strFile);
}
closedir($intHandle);
asort($arrFiles);

// Get default language

$strDfltlang = 'english';
$oDB->Query('SELECT setting FROM '.TABSETTING.' WHERE param="language"');
$row=$oDB->Getrow();
if ( isset($row['setting']) ) {
if ( !empty($row['setting']) ) {
  $strDfltlang = $row['setting'];
}}

// FORM

echo '<form method="post" action="',$oVIP->selfurl,'">
<table class="data_o" cellspacing="0">
';
echo '<tr class="tr">
<td class="th_o th_o_all" colspan="3">',$L['Language'],'</td>
</tr>
';
echo '<tr class="tr">
<td class="th_o th_o_first" style="width:150px;"><label for="dfltlang">',$L['Dflt_language'],'</label></td>
<td class="td_o" style="width:200px;"><select id="dfltlang" name="dfltlang" onchange="bEdited=true;">',QTastags($arrFiles,null,$strDfltlang),'</select></td>
<td class="td_o"><span class="help">&nbsp;</span></td>
</tr>
';
echo '<tr class="tr">
<td class="th_o th_o_first" style="width:150px;"><label for="userlang">',$L['User_language'],'</label></td>
<td class="td_o" style="width:200px;"><select id="userlang" name="userlang" onchange="bEdited=true;">
<option value="0"',($_SESSION[QT]['userlang']=='0' ? QSEL : ''),'>',$L['N'],'</option>
<option value="1"',($_SESSION[QT]['userlang']=='1' ? QSEL : ''),'>',$L['Y'],'</option>
</select></td>
<td class="td_o"><span class="help">',$L['H_User_language'],'</span></td>
</tr>
';
echo '<tr class="tr">
<td class="th_o th_o_all" colspan="3">',$L['Date_time'],'</td>
</tr>
';
echo '<tr class="tr">
<td class="th_o th_o_first"><label for="timezone">',$L['Time_zone'],'</label></td>
<td class="td_o"><select id="timezone" name="timezone" onchange="bEdited=true;">',QTastags($L['tz'],null,$_SESSION[QT]['time_zone']),'</select></td>
<td class="td_o"><select name="daylight" onchange="bEdited=true;">
<option value="0"',($_SESSION[QT]['daylight']=='0' ? QSEL : ''),'>',$L['Normal_time'],'</option>
<option value="1"',($_SESSION[QT]['daylight']=='1' ? QSEL : ''),'>',$L['Daylight_time'],'</option>
</select>
</td>
</tr>
';
echo '<tr class="tr">
<td class="th_o th_o_first" style="width:150px;"><label for="showtimezone">',$L['Show_time_zone'],'</label></td>
<td class="td_o" style="width:200px;"><select id="showtimezone" name="showtimezone" onchange="bEdited=true;">
<option value="0"',($_SESSION[QT]['show_time_zone']=='0' ? QSEL : ''),'>',$L['N'],'</option>
<option value="1"',($_SESSION[QT]['show_time_zone']=='1' ? QSEL : ''),'>',$L['Y'],'</option>
</select></td>
<td class="td_o"><span class="help">',$L['H_Show_time_zone'],'</span></td>
</tr>
';
echo '<tr class="tr">
<td class="th_o th_o_first"><label for="formatdate">',$L['Date_format'],'</label></td>
<td class="td_o"><input id="formatdate" name="formatdate" size="10" maxlength="24" value="',$_SESSION[QT]['formatdate'],'" onchange="bEdited=true;"/></td>
<td class="td_o"><span class="help">',$L['H_Date_format'],'</span></td>
</tr>
';
echo '<tr class="tr">
<td class="th_o th_o_first"><label for="formattime">',$L['Time_format'],'</label></td>
<td class="td_o"><input id="formattime" name="formattime" size="10" maxlength="24" value="',$_SESSION[QT]['formattime'],'" onchange="bEdited=true;"/></td>
<td class="td_o"><span class="help">',$L['H_Time_format'],'</span></td>
</tr>
';
echo '<tr class="tr">
<td class="th_o" colspan="3" style="padding:6px; text-align:center"><input type="submit" name="ok" value="',$L['Save'],'"/></td>
</tr>
';
echo '</table>
</form>
';

echo '
<h2>',$L['Format_preview'],'</h2>
<table class="data_o" style="width:350px;" cellspacing="0">
<tr class="tr">
<td class="th_o th_o_first" style="width:150px;">',$L['GMT_time'],'</td>
<td class="td_o">',gmdate($_SESSION[QT]['formattime'],time() + 3600*($_SESSION[QT]['daylight'])),'</td>
</tr>
<tr class="tr">
<td class="th_o th_o_first">',$L['Local_time'],'</td>
<td class="td_o">';
echo gmdate($_SESSION[QT]['formattime'], time() + 3600*($_SESSION[QT]['time_zone']+$_SESSION[QT]['daylight']));
if ( $_SESSION[QT]['show_time_zone']=='1' )
{
  echo ' (gmt';
  if ( $_SESSION[QT]['time_zone']>0 ) echo '+',$_SESSION[QT]['time_zone'];
  if ( $_SESSION[QT]['time_zone']<0 ) echo $_SESSION[QT]['time_zone'];
  echo ')';
}
echo '</td>
</tr>
';
echo '<tr class="tr">
<td class="th_o th_o_first">',$L['Date'],'</td>
<td class="td_o">',QTdatestr('now','$','$',false),'</td>
</tr>
</table>
';

// --------
// HTML END
// --------

include('qte_adm_p_footer.php');

?>
