<?php

/*
 * PHP versions 4 and 5
 *
 * LICENSE: This source file is subject to version 3.0 of the PHP license
 * that is available through the world-wide-web at the following URI:
 * http://www.php.net/license.  If you did not receive a copy of
 * the PHP License and are unable to obtain it through the web, please
 * send a note to license@php.net so we can mail you a copy immediately.
 *
 * @category   Team
 * @package    QuickTeam
 * @author     Philippe Vandenberghe <info@qt-cute.org>
 * @copyright  2008-2012 The PHP Group
 * @license    http://www.php.net/license  PHP License 3.0
 * @version    2.0 build:20090311
 * @link       http://www.qt-cute/doc/package/qte
 * @since      File available since Release 1.0.0
 * @deprecated File deprecated in Release 3.0.0
 *
 */

session_start();
require_once('bin/qte_init.php');
include(Translate('qte_adm.php'));

if ( $oVIP->role!='A' ) die($L['E_admin']);

// ---------
// INITIALISE
// ---------

$oVIP->selfurl = 'qte_adm_index.php';
$oVIP->selfname = '<span class="upper">'.$L['Adm_info'].'</span><br/>'.$L['Adm_status'];

// --------
// SUBMITTED
// --------

if ( isset($_POST['ok']) )
{
  // check admin email and team url
  if ( !QTismail($_SESSION[QT]['admin_email']) ) $error='Error';
  if ( strlen($_SESSION[QT]['site_url'])<8 ) $error='Error';
  if ( !empty($error) )
  {
    $strFile = $_SESSION[QT]['language'].'/sys_online_error.php';
    if ( file_exists($strFile) ) { $strMsg = include($strFile); } else { $strMsg = '<p>Missing admin e-mail or team url...</p>'; }
    $oVIP->exiturl = 'qte_adm_site.php';
    $oVIP->exitname = $L['Adm_general'];
    $oVIP->EndMessage(NULL,$strMsg,'admin',0);
  }

  $str = '-1';
  if ( isset($_POST['offline']) ) $str = strip_tags($_POST['offline']);
  if ( $str=='1' || $str=='0' )
  {
  $oDB->Query('UPDATE '.TABSETTING.' SET setting="'.$_POST['offline'].'" WHERE param="board_offline"');
  $_SESSION[QT]['board_offline'] = $_POST['offline'];
  }

  $strInfo = $L['S_save'];
}

// --------
// HTML START
// --------

include('qte_adm_p_header.php');
include('qte_adm_p_title.php');

// BOARD OFFLINE

echo '<h2>',$L['Adm_status'],'</h2>',N;

echo '<table class="data_o" cellspacing="0">',N;
echo '<tr class="tr">',N;
echo '<td class="th_o th_o_first" style="width:200px;"><span class="txt_head">',$L['Adm_status'],'</span></td>';
if ( $_SESSION[QT]['board_offline']=='0' )
{
  echo '<td class="td_o">&nbsp;</td>';
  echo '<td class="td_o" style="text-align:center; background-color:#AAFFAA"><b>',$L['On_line'],'</b></td>';
}
else
{
  echo '<td class="td_o">&nbsp;</td>';
  echo '<td class="td_o" style="text-align:center; background-color:#FFAAAA"><b>',$L['Off_line'],'</b></td>';
}
echo '<td class="td_o" style="text-align:right">';
echo '<form method="post" action="',$oVIP->selfurl,'">',$L['Action'],S;
echo '<select id="offline" name="offline">';
echo '<option value="0"',($_SESSION[QT]['board_offline']=='0' ? QSEL : ''),'>',$L['On_line'],'</option>';
echo '<option value="1"',($_SESSION[QT]['board_offline']=='1' ? QSEL : ''),'>',$L['Off_line'],'</option>';
echo '</select>&nbsp;<input type="submit" name="ok" value="',$L['Ok'],'"/>';
echo '</form></td>';
echo '</tr>',N,'</table>',N,N;

// STATS

echo '<h2>',$L['Info'],'</h2>',N;

$oDB->Query('SELECT count(*) as countid FROM '.TABDOMAIN);
$row = $oDB->Getrow();
$intDomain = $row['countid'];

$oDB->Query('SELECT count(*) as countid FROM '.TABSECTION);
$row = $oDB->Getrow();
$intTeam = $row['countid'];

$oDB->Query('SELECT count(*) as countid FROM '.TABSECTION.' WHERE type="1"');
$row = $oDB->Getrow();
$intHidden = $row['countid'];

$oDB->Query('SELECT count(*) as countid FROM '.TABUSER.' WHERE id>0');
$row = $oDB->Getrow();
$intUser = $row['countid'];

echo '<table class="data_o" cellspacing="0">',N;
echo '<tr class="tr">';
echo '<td class="th_o th_o_first" style="width:200px;"><span class="txt_head">',$L['Domains'],'/',$L['Sections'],'</span></td>';
echo '<td class="td_o">',LangS('Domain',$intDomain),', ',LangS('Section',$intTeam),' <span class="small">(',$intHidden,S,$L['Hidden'],')</span>, <a href="qte_stats.php">',$L['Statistics'],'</a></td>';
echo '</tr>',N;
echo '<tr class="tr">';
echo '<td class="th_o th_o_first"><span class="txt_head">',$L['Users'],'</span></td>';

$oDB->Query('SELECT count(*) as countid FROM '.TABUSER.' WHERE id>0');
$row = $oDB->Getrow();
$intUser = $row['countid'];
$oDB->Query('SELECT count(*) as countid FROM '.TABUSER.' WHERE role="A"');
$row = $oDB->Getrow();
$intAdmin = $row['countid'];
$oDB->Query('SELECT count(*) as countid FROM '.TABUSER.' WHERE role="M"');
$row = $oDB->Getrow();
$intMod = $row['countid'];

echo '<td class="td_o">',LangS('User',$intUser),' <span class="small">(',LangS('Userrole,A',$intAdmin),', ',LangS('Userrole,M',$intMod),')</span></td>';
echo '</tr>',N;

// db version

echo '<tr class="tr">
<td class="th_o th_o_first"><span class="txt_head">',$L['Version'],'</span></td>
<td class="td_o">',QTEVERSION,'<span class="small">, database ',$_SESSION[QT]['version'],', sid ',QT,'</span></td>
</tr>',N;

echo '</table>',N;

// PUBLIC ACCESS LEVEL

echo '
<h2>',$L['Public_access_level'],'</h2>
<table class="data_o" cellspacing="0">
<tr class="tr">
<td class="th_o th_o_first" style="width:200px;"><span class="texthead">',$L['Visitors_can'],'</span></td>
<td class="td_o">',$L['Pal'][$_SESSION[QT]['visitor_right']],'</td>
<td class="td_o">&nbsp;</td>
</tr>
<tr class="tr">
<td class="th_o th_o_first" style="width:200px;"><span class="texthead">',$L['Members_can'],'</span></td>
<td class="td_o">',$L['Mal'][$_SESSION[QT]['member_right']],'</td>
<td class="td_o" style="text-align:right"><a href="qte_adm_secu.php">',$L['Edit'],'</a></span></td>
</tr>
</table>
';

// --------
// HTML END
// --------

include('qte_adm_p_footer.php');

?>