<?php

/**
 * PHP versions 4 and 5
 *
 * LICENSE: This source file is subject to version 3.0 of the PHP license
 * that is available through the world-wide-web at the following URI:
 * http://www.php.net/license.  If you did not receive a copy of
 * the PHP License and are unable to obtain it through the web, please
 * send a note to license@php.net so we can mail you a copy immediately.
 *
 * @category   Team
 * @package    QuickTeam
 * @author     Philippe Vandenberghe <info@qt-cute.org>
 * @copyright  2008-2012 The PHP Group
 * @version    2.0.2 build:20090526
 * @link       http://www.qt-cute.org/doc/package/qte
 * @since      File available since Release 1.0.0
 * @deprecated File deprecated in Release 3.0.0
 */

session_start();
require_once('bin/qte_init.php');
require_once('bin/qte_fn_admin.php');
include(Translate('qte_adm.php'));

if ( $oVIP->role!='A' ) die($L['E_admin']);

// ---------
// INITIALISE
// ---------

include('bin/qte_lang.php'); // this creates $arrLang

$strEditLang = $_SESSION[QT]['lang_iso'];
if ( isset($_GET['editlang']) ) $strEditLang = $_GET['editlang'];
if ( isset($_POST['editlang']) ) $strEditLang = $_POST['editlang'];

$oVIP->selfurl = 'qte_adm_fields.php';
$oVIP->exiturl = 'qte_adm_fields.php';
$oVIP->selfname = '<span class="upper">'.$L['Adm_settings'].'</span><br/>'.$L['Fields'];

// --------
// SUBMITTED
// --------

if ( isset($_POST['ok']) )
{  
  // about allowed dates (default is '2')
  // '0' = dates in the future area allowed,
  // '1' = reject dates in the future
  // '2' = reject dates in the future (except this year)

  // default settings (translation, format, is checked
  $arrFnewnames = array(
  'id'        => array('id','%s',true),
  'status'    => array('Status','%s',true),
  'status_i'  => array('Status icon','%s',true),
  'username'  => array('Username','%s',true),
  'pwd'       => array('Password','%s',true),
  'role'      => array('Role','%s',true),
  'picture'   => array('Picture','%s',false),
  'address'   => array('Address','%s',false),
  'phones'    => array('Phone','%s',false),
  'emails'    => array('E-mail','%s',false),
  'emails_i'  => array('E-mail icon','%s',false),
  'www'       => array('Web site','%s',false),
  'children'  => array('Child','%s',false),
  'title'     => array('Title','%s',false),
  'firstname' => array('Firstname','%s',false),
  'midname'   => array('Middlename','%s',false),
  'lastname'  => array('Lastname','%s',false),
  'alias'     => array('Nickname','%s',false),
  'birthdate' => array('Birthdate','2',false),
  'nationality'=>array('Nationality','%s',false),
  'sexe'      => array('Sexe','M ; V',false),
  'firstdate' => array('Registration','%s',false),
  'age'       => array('Age','%s',false),
  'fullname'  => array('Full name','%s',false),
  'teamid1'   => array('Club id','%s',false),
  'teamid2'   => array('National id','%s',false),
  'teamrole1' => array('Function','%s',false),
  'teamrole2' => array('Level','%s',false),
  'teamdate1' => array('Join date','2',false),
  'teamdate2' => array('Medical date','2',false),
  'teamvalue1'=> array('Percent','%s',false),
  'teamvalue2'=> array('Hits','%s',false),
  'teamflag1' => array('Restriction','Yes ; No',false),
  'teamflag2' => array('Rescue','Yes ; No',false),
  'descr'     => array('Comment','%s',false));
  $arrFrenames = array(); // used to check duplicate names

  // read submitted values
  foreach ($arrFnewnames as $strKey => $arrValues)
  {
    if ( isset($_POST["R_$strKey"]) )
    {
      $str = trim($_POST["R_$strKey"]); if ( get_magic_quotes_gpc() ) $str = stripslashes($str);
      if ( empty($str) ) $str = $strKey;
      $arrFnewnames[$strKey][0]=$str;
      $arrFrenames[]=$str;
    }
    if ( isset($_POST["F_$strKey"]) )
    {
      $str = trim($_POST["F_$strKey"]); if ( get_magic_quotes_gpc() ) $str = stripslashes($str);
      if ( empty($str) ) $str='%s';
      $arrFnewnames[$strKey][1]=$str;
    }
    if ( isset($_POST[$strKey]) )
    {
      $arrFnewnames[$strKey][2]=true;
    }
  }

  // Check duplicates (strict)
  $str = FindDuplicates($arrFrenames);
  if ( $str ) $error = $L['Duplicate_fieldname'].': '.$str;
  if ( empty($error) )
  {
    // Check duplicate (case insensitive)
    $str = FindDuplicates($arrFrenames,false);
    if ( $str ) $warning = $L['Duplicate_fieldname_possible'].' '.$str;
  }

  // exception for email_icon
  $arrFnewnames['emails_i'][0]=$arrFnewnames['emails'][0].S.strtolower($L['Icon']);
  $arrFnewnames['emails_i'][2]=$arrFnewnames['emails'][2];

  // Save
  if ( empty($error) )
  {
    $oDB->Query('DELETE FROM '.TABLANG.' WHERE (objtype="field" OR objtype="ffield") AND objlang="'.$strEditLang.'"');
    $arrFields = array();
    foreach ($arrFnewnames as $strKey=>$arrFnewname)
    {
      cLang::Add('field',$strEditLang,$strKey,$arrFnewname[0]);
      cLang::Add('ffield',$strEditLang,$strKey,$arrFnewname[1]);
      if ( $arrFnewname[2] ) $arrFields[] = $strKey;
    }
    SetFields($arrFields);
  }

  if ( empty($error) ) $strInfo = $L['S_save'];

}

// --------
// HTML START
// --------

$_SESSION['L']['field'] = cLang::GetName('field',$strEditLang,'*');
$_SESSION['L']['ffield'] = cLang::GetName('ffield',$strEditLang,'*');

include('qte_adm_p_header.php');
include('qte_adm_p_title.php');

echo '
<script type="text/javascript">
var bEdited=false;
function SetField(str)
{
  if ( document.getElementById(str).checked==true )
  {
  document.getElementById("I_"+str).className="small";
  document.getElementById("C_"+str).className="";
  document.getElementById("R_"+str).style.visibility="visible";
  document.getElementById("F_"+str).style.visibility="visible";
  }
  else
  {
  document.getElementById("I_"+str).className="disabled small";
  document.getElementById("C_"+str).className="disabled";
  document.getElementById("R_"+str).style.visibility="hidden";
  document.getElementById("F_"+str).style.visibility="hidden";
  }
}
function warningedited(bEdited,str)
{
  if ( bEdited )
  {
    if ( !confirm(str) ) return false;
  }
  return true;
}
</script>
';


$arrStr = array();
foreach ($arrLang as $strIso => $arr)
{
  if ( $strIso==$strEditLang ) { $arrStr[] = '<span class="bold">'.$arr[1].'</span>'; } else { $arrStr[] = '<a class="small" href="'.$oVIP->selfurl.'?editlang='.$strIso.'" onclick="return warningedited(bEdited,\''.$L['E_data_not_saved'].'\');">'.$arr[1].'</a> '; }
}

echo '
<form method="post" action="',$oVIP->selfurl,'">
';

echo '<table cellspacing="0" class="data_o">
<colgroup span="5"><col width="30"></col><col width="90"></col><col width="140"></col><col width="130"></col><col></col></colgroup>
<tr class="tr">
<td class="th_o" colspan="2">&nbsp;</td>
<td class="th_o" style="text-align:left" colspan="3">',implode(' &middot; ',$arrStr),'</td>
</tr>
';
echo '<tr class="tr">
<td class="th_o" style="text-align:left">&nbsp;</td>
<td class="th_o" style="text-align:left">',$L['Fields'],'</td>
<td class="th_o" style="text-align:left">',$L['Name'],'</td>
<td class="th_o" style="text-align:left">',$L['Rename'],'</td>
<td class="th_o" style="text-align:left">',$L['Format'],'</td>
</tr>
';

// Personnal content

echo '<tr class="tr">',N;
echo '<td class="td_o td_o_all" colspan="5">',$L['Fields_personal'],'</td>',N;
echo '</tr>',N;

foreach (array('username','status') as $strKey)
{
  $strField = ObjTrans('field',$strKey);
  $strFormat = ObjTrans('ffield',$strKey,false); if ( $strFormat=='%s' ) $strFormat=' ';
  echo '<tr class="rowlight">',N;
  echo '<td class="td_o"><input type="checkbox" ',QCHE,' disabled="disabled" onchange="bEdited=true;"/><input type="hidden" id="',$strKey,'" name="',$strKey,'" value="1"/></td>',N;
  echo '<td class="td_o" style="background-color:#EEEEEE"><span id="I_',$strKey,'" class="small">'.$strKey,'</span></td>',N;
  echo '<td class="td_o"><span id="C_',$strKey,'">'.$strField,'</span></td>',N;
  echo '<td class="td_o"><input type="input" id="R_',$strKey,'" name="R_',$strKey,'" value="',QTconv($strField,'I'),'" size="20" maxlength="32" class="small" onchange="bEdited=true;"/></td>',N;
  echo '<td class="td_o"><input type="input" id="F_',$strKey,'" name="F_',$strKey,'" value="',$strFormat,'" size="30" maxlength="32" class="small" onchange="bEdited=true;"/></td>',N;
  echo '</tr>',N;
}

foreach (array('title','firstname','midname','lastname','alias','address','phones','emails','www','birthdate','nationality','sexe','picture') as $strKey)
{
  if ( strpos($_SESSION[QT]['fields_u'],$strKey)===FALSE ) { $bField=false; } else { $bField=true; }
  $strField = ObjTrans('field',$strKey);
  $strFormat = ObjTrans('ffield',$strKey,false); if ( $strFormat=='%s' ) $strFormat=' ';
  echo '<tr class="rowlight">',N;
  echo '<td class="td_o"><input type="checkbox" id="',$strKey,'" name="',$strKey,'"',(!$bField ? '' : QCHE),' onclick="SetField(this.id)" onchange="bEdited=true;"/></td>',N;
  echo '<td class="td_o" style="background-color:#EEEEEE"><label for="',$strKey,'"><span id="I_',$strKey,'" class="',( !$bField ? 'disabled' : 'small'),'">'.$strKey,'</span></label></td>',N;
  echo '<td class="td_o"><span id="C_',$strKey,'" class="',( !$bField ? 'disabled' : ''),'">'.$strField,'</span></td>',N;
  echo '<td class="td_o"><input type="input" id="R_',$strKey,'" name="R_',$strKey,'" value="',QTconv($strField,'I'),'" size="20" maxlength="32" class="small"',( !$bField ? ' style="visibility:hidden"' : ''),' onchange="bEdited=true;"/></td>',N;
  if ( $strKey=='birthdate' )
  {
  echo '<td class="td_o"><select id="F_',$strKey,'" name="F_',$strKey,'" class="small"',( !$bField ? ' style="visibility:hidden"' : ''),'>',QTastags($L['No_future'],null,$strFormat,null,null,null,'small'),'</select> ';
  }
  else
  {
  echo '<td class="td_o"><input type="input" id="F_',$strKey,'" name="F_',$strKey,'" value="',$strFormat,'" size="30" maxlength="32" class="small"',( !$bField ? ' style="visibility:hidden"' : ''),' onchange="bEdited=true;"/> ';
  }
  if ( in_array($strKey,array('title','nationality','sexe')) ) echo '*';
  if ( $strKey=='picture' && $bField && $_SESSION[QT]['picture']=='0' ) echo '<span class="warning">',$L['Field_no_photo'],'</span>';
  echo '</td>',N;
  echo '</tr>',N;
}

// Computed field

echo '<tr class="tr">',N;
echo '<td class="td_o td_o_all" colspan="5">',$L['Fields_computed'],'</td>',N;
echo '</tr>',N;

foreach (array('fullname','age','children','firstdate') as $strKey)
{
  if ( strpos($_SESSION[QT]['fields_c'],$strKey)===FALSE ) { $bField=false; } else { $bField=true; }
  $strField = ObjTrans('field',$strKey);
  $strFormat = ObjTrans('ffield',$strKey,false); if ( $strFormat=='%s' ) $strFormat=' ';
  echo '<tr class="rowlight">',N;
  echo '<td class="td_o"><input type="checkbox" id="',$strKey,'" name="',$strKey,'"',(!$bField ? '' : QCHE),' onclick="SetField(this.id)" onchange="bEdited=true;"/></td>',N;
  echo '<td class="td_o" style="background-color:#EEEEEE"><label for="',$strKey,'"><span id="I_',$strKey,'" class="',( !$bField ? 'disabled' : 'small'),'">'.$strKey,'</span></label></td>',N;
  echo '<td class="td_o"><span id="C_',$strKey,'" class="',( !$bField ? 'disabled' : ''),'">'.$strField,'</span></td>',N;
  echo '<td class="td_o"><input type="input" id="R_',$strKey,'" name="R_',$strKey,'" value="',QTconv($strField,'I'),'" size="20" maxlength="32" class="small"',( !$bField ? ' style="visibility:hidden"' : ''),' onchange="bEdited=true;"/></td>',N;
  if ( $strKey=='firstdate' )
  {
  echo '<td class="td_o"><select id="F_',$strKey,'" name="F_',$strKey,'" class="small"',( !$bField ? ' style="visibility:hidden"' : ''),'>',QTastags($L['No_future'],null,$strFormat,null,null,null,'small'),'</select> ';
  }
  else
  {
  echo '<td class="td_o"><input type="input" id="F_',$strKey,'" name="F_',$strKey,'" value="',$strFormat,'" size="30" maxlength="32" class="small"',( !$bField ? ' style="visibility:hidden"' : ''),' onchange="bEdited=true;"/> ';
  }
  echo '</tr>',N;
}

// Team content

echo '<tr class="tr">',N;
echo '<td class="td_o td_o_all" colspan="5">',$L['Fields_team'],'</td>',N;
echo '</tr>',N;

foreach (array('teamid1','teamid2','teamrole1','teamrole2','teamdate1','teamdate2','teamvalue1','teamvalue2','teamflag1','teamflag2','descr') as $strKey)
{
  if ( strpos($_SESSION[QT]['fields_t'],$strKey)===FALSE ) { $bField=false; } else { $bField=true; }
  $strField = ObjTrans('field',$strKey);
  $strFormat = ObjTrans('ffield',$strKey,false);
  if ( $strFormat=='%s' ) $strFormat=' ';
  echo '<tr class="rowlight">',N;
  echo '<td class="td_o"><input type="checkbox" id="',$strKey,'" name="',$strKey,'"',(!$bField ? '' : QCHE),' onclick="SetField(this.id)" onchange="bEdited=true;"/></td>',N;
  echo '<td class="td_o" style="background-color:#EEEEEE"><label for="',$strKey,'"><span id="I_',$strKey,'" class="',( !$bField ? 'disabled' : 'small'),'">'.$strKey,'</span></label></td>',N;
  echo '<td class="td_o"><span id="C_',$strKey,'" class="',( !$bField ? 'disabled' : ''),'">'.$strField,'</span></td>',N;
  echo '<td class="td_o"><input type="input" id="R_',$strKey,'" name="R_',$strKey,'" value="',QTconv($strField,'I'),'" size="20" maxlength="32" class="small"',( !$bField ? ' style="visibility:hidden"' : ''),' onchange="bEdited=true;"/></td>',N;
  if ( $strKey=='teamdate1' || $strKey=='teamdate2' )
  {
  echo '<td class="td_o"><select id="F_',$strKey,'" name="F_',$strKey,'" class="small"',( !$bField ? ' style="visibility:hidden"' : ''),'>',QTastags($L['No_future'],null,$strFormat,null,null,null,'small'),'</select> ';
  }
  else
  {
  echo '<td class="td_o"><input type="input" id="F_',$strKey,'" name="F_',$strKey,'" value="',$strFormat,'" size="30" maxlength="32" class="small"',( !$bField ? ' style="visibility:hidden"' : ''),' onchange="bEdited=true;"/> ';
  }
  echo (in_array($strKey,array('teamrole1','teamrole2','teamvalue1','teamvalue2','teamflag1','teamflag2')) ? '*' : ''),'</td>',N;
  echo '</tr>',N;
}

echo '<tr class="tr">
<td class="th_o" colspan="5" style="padding:6px; text-align:center">
<input type="hidden" name="editlang" value="',$strEditLang,'">
<input type="submit" name="ok" value="',$L['Save'],'"/>
</td>
</tr>
</table>
</form>
';

echo '<p class="small">* ',$L['List_allowed'],'</p>';
echo '<p class="small">',$L['H_semicolon_format'],'</p>';

// --------
// HTML END
// --------

include('qte_adm_p_footer.php');

?>