<?php

/*
 * PHP versions 4 and 5
 *
 * LICENSE: This source file is subject to version 3.0 of the PHP license
 * that is available through the world-wide-web at the following URI:
 * http://www.php.net/license.  If you did not receive a copy of
 * the PHP License and are unable to obtain it through the web, please
 * send a note to license@php.net so we can mail you a copy immediately.
 *
 * @category   Team
 * @package    QuickTeam
 * @author     Philippe Vandenberghe <info@qt-cute.org>
 * @copyright  2008-2012 The PHP Group
 * @license    http://www.php.net/license  PHP License 3.0
 * @version    2.0 build:20090311
 * @link       http://www.qt-cute.org/doc/package/qte
 * @since      File available since Release 1.0.0
 * @deprecated File deprecated in Release 3.0.0
 *
 */

session_start();
require_once('bin/qte_init.php');
include(Translate('qte_adm.php'));

if ( $oVIP->role!='A' ) die($L['E_admin']);

// INITIALISE

$id = -1;
if ( isset($_GET['d']) ) $id = intval($_GET['d']);
if ( isset($_POST['d']) ) $id = intval($_POST['d']);
if ( $id<0 ) die('Missing argument d');

$oVIP->selfurl = 'qte_adm_domain.php';
$oVIP->selfname = '<span class="upper">'.$L['Adm_content'].'</span><br/>'.$L['Domain_upd'];
$oVIP->exiturl = 'qte_adm_sections.php';
$oVIP->exitname = '&laquo; '.$L['Sections'];

// --------
// SUBMITTED
// --------

if ( isset($_POST['ok']) )
{
  $str = trim($_POST['title']); if ( get_magic_quotes_gpc() ) $str = stripslashes($str);
  $str = QTconv($str,'3',QTE_CONVERT_AMP,false);
  if ( $str=='' ) $error = $L['Title'].S.$L['E_invalid'];

  // save

  if ( empty($error) )
  {
    $oDB->Query('UPDATE '.TABDOMAIN.' SET title="'.addslashes($str).'" WHERE id='.$id);

    $oDB->Query('DELETE FROM '.TABLANG.' WHERE objtype="domain" AND objid="d'.$id.'"');
    foreach ($_POST as $strKey => $strTranslation)
    {
      if ( substr($strKey,0,1)=='T' )
      {
        $strTranslation = trim($strTranslation);
        if ( !empty($strTranslation) )
        {
        if ( get_magic_quotes_gpc() ) $strTranslation = stripslashes($strTranslation);
        $oDB->Query('INSERT INTO '.TABLANG.' (objtype,objlang,objid,objname) VALUES ("domain","'.substr($strKey,1).'","d'.$id.'","'.addslashes(QTconv($strTranslation,'5')).'")');
        }
      }
    }

    // Exit

    Unset($_SESSION[QT]['sys_sections']);
    Unset($_SESSION['L']['domain']);
    $oVIP->EndMessage('0');
  }
}

// --------
// HTML START
// --------

include('qte_adm_p_header.php');
include('qte_adm_p_title.php');

if ( $id<0 ) die('Missing argument d');

$oDB->Query('SELECT title FROM '.TABDOMAIN.' WHERE id='.$id);
$row = $oDB->Getrow();

// FORM

echo '
<script type="text/javascript">
<!--
function ValidateForm(theForm)
{
  if (theForm.title.value.length < 1) { alert(html_entity_decode("',$L['E_mandatory'],': ',$L['Title'],'")); return false; }
  return null;
}
-->
</script>
';

echo '
<form method="post" action="',$oVIP->selfurl,'" onsubmit="return ValidateForm(this);">
<table class="data_o" width="500" cellspacing="0">
';
$str = QTconv($row['title'],'I');
echo '<tr class="tr tr_o">
<td class="th_o th_o_first" style="width:100px;"><label for="title">',$L['Title'],'</label></td>
<td class="td_o"><input type="text" id="title" name="title" size="32" maxlength="64" value="',$str,'" onkeyup="handle_keypress(event,\'ok\')"/>',(strstr($str,'&amp;') ?  ' <span class="disabled">'.$row['title'].'</span>' : ''),'</td>
</tr>
';
echo '<tr class="tr tr_o">
<td class="th_o th_o_first">',$L['Translations'],'</td>
<td class="td_o" colspan="2">
<p class="help">',sprintf($L['E_no_translation'],$row['title']),'</p>
<table cellspacing="0" class="hidden">';
$arrTrans = cLang::GetTrans('domain','d'.$id);
include('bin/qte_lang.php'); // this creates $arrLang
foreach ($arrLang as $strIso => $arr)
{
  $str = '';
  if ( isset($arrTrans[$strIso]) ) {
  if ( !empty($arrTrans[$strIso]) ) {
    $str = QTconv($arrTrans[$strIso],'I');
  }}
  echo '
  <tr>
  <td class="hidden" style="width:25px"><span title="',$arr[1],'">',$arr[0],'</span></td>
  <td class="hidden"><input class="small" title="',$L['Domain'],' (',$strIso,')" type="text" id="T',$strIso,'" name="T',$strIso,'" size="32" maxlength="64" value="',$str,'"/>',(strstr($str,'&amp;') ?  ' <span class="disabled">'.$arrTrans[$strIso].'</span>' : ''),'</td>
  </tr>
  ';
}
echo '</table>
</td>
</tr>
';
echo '<tr class="tr tr_o">
<td class="th_o th_o_first">&nbsp;</td>
<td class="td_o"><input type="submit" name="ok" value="',$L['Save'],'"/><input type="hidden" name="d" value="',$id,'"/></td>
</tr>
';
echo '</table>
</form>
<p><a href="',$oVIP->exiturl,'">',$oVIP->exitname,'</a></p>
';

// HTML END

include('qte_adm_p_footer.php');

?>