<?php

// QuickTeam 2.0 build:20090311

// --------
// HTML start
// --------
echo '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" dir="ltr" xml:lang="en" lang="en">

<head>
<title>QuickTeam installation checker</title>
<meta http-equiv="content-type" content="text/html; charset=iso-8859-1"/>
<link rel="stylesheet" href="admin/qte_main.css"/>
<style type="text/css">
<!--
p.check {margin:5px 0 0 0; padding:0}
p.endcheck {margin:5px 0 0 0; padding:5px; border:solid 1px #aaaaaa}
span.ok {color:#00aa00; background-color:inherit}
span.nok {color:#ff0000; background-color:inherit}
div.footer_copy {width:100%; text-align:right}
a.footer_copy {color:blue; background-color:inherit; font-size:8pt}
-->
</style>
</head>

<body>

<!-- PAGE CONTROL -->
<div class="qte_page">
<table class="qte_page" width="700" cellspacing="0" style="margin:5px">
<tr class="qte_page">
<td class="qte_page">
<!-- PAGE CONTROL -->

<!-- HEADER BANNER -->
<div class="banner">
<div class="banner_in">
<img src="admin/qte_logo.gif" width="175" height="50" style="border-width:0" alt="QuickTeam" title="QuickTeam"/>
</div>
</div>
<!-- END HEADER BANNER -->

<!-- BODY MAIN -->
<table width="100%" cellspacing="0" style="border:1px solid #AAAAAA;">
<tr>
<td style="padding:5px 10px 5px 10px;">
<!-- BODY MAIN -->
';

// --------
// 1 CONFIG
// --------

echo '<p style="margin:0;text-align:right">QuickTeam 2.0 build:20090311</p>';

echo '<h1>Checking your configuration</h1>';

$error = '';

// 1 file exist

  echo '<p class="check">Checking installed files... ';

  if ( !file_exists('bin/config.php') )          $error .= '<br/>File <b>config.php</b> is not in the <b>bin</b> directory. Communication with database is impossible.';
  if ( !file_exists('bin/qte_init.php') )        $error .= '<br/>File <b>qte_init.php</b> is not in the <b>bin</b> directory. Application cannot start.';
  if ( !file_exists('bin/qt_lib_db.php') )       $error .= '<br/>File <b>qt_lib_db.php</b> is not in the <b>bin</b> directory. Application cannot start.';
  if ( !file_exists('bin/qt_lib_txt.php') )      $error .= '<br/>File <b>qt_lib_txt.php</b> is not in the <b>bin</b> directory. Application cannot start.';
  if ( !file_exists('bin/qt_lib_url.php') )      $error .= '<br/>File <b>qt_lib_url.php</b> is not in the <b>bin</b> directory. Application cannot start.';
  if ( !file_exists('bin/qte_fn_common.php') )   $error .= '<br/>File <b>qte_fn_common.php</b> is not in the <b>bin</b> directory. Application cannot start.';
  if ( !file_exists('bin/qte_fn_limitsql.php') ) $error .= '<br/>File <b>qte_fn_limitsql.php</b> is not in the <b>bin</b> directory. Application cannot start.';
  if ( !file_exists('bin/qte_fn_admin.php') )    $error .= '<br/>File <b>qte_fn_admin.php</b> is not in the <b>bin</b> directory. Application cannot start.';
  if ( !file_exists('bin/qte_class_sys.php') )   $error .= '<br/>File <b>qte_class_sys.php</b> is not in the <b>bin</b> directory. Application cannot start.';
  if ( !file_exists('bin/qte_class_sec.php') )   $error .= '<br/>File <b>qte_class_sec.php</b> is not in the <b>bin</b> directory. Application cannot start.';
  if ( !file_exists('bin/qte_class_user.php') )  $error .= '<br/>File <b>qte_class_user.php</b> is not in the <b>bin</b> directory. Application cannot start.';
  if ( !file_exists('bin/qte_class_vip.php') )   $error .= '<br/>File <b>qte_class_vip.php</b> is not in the <b>bin</b> directory. Application cannot start.';
  if ( !file_exists('bin/qte_class_lang.php') )  $error .= '<br/>File <b>qte_class_lang.php</b> is not in the <b>bin</b> directory. Application cannot start.';

  if ( empty($error) )
  {
  echo '<span class="ok">Main files found.</span></p>';
  }
  else
  {
  die('<span class="nok">'.$error.'</span></p>');
  }

// 2 config is correct

  echo '<p class="check">Checking config.php... ';

  include('bin/config.php');
  include('bin/qte_fn_common.php');

  if ( !isset($qte_dbsystem) ) $error .= '<br/>Variable <b>$qte_dbsystem</b> is not defined in the file <b>bin/config.php</b>. Communication with database is impossible.';
  if ( !isset($qte_host) )     $error .= '<br/>Variable <b>$qte_host</b> is not defined in the file <b>bin/config.php</b>. Communication with database is impossible.';
  if ( !isset($qte_database) ) $error .= '<br/>Variable <b>$qte_database</b> is not defined in the file <b>bin/config.php</b>. Communication with database is impossible.';
  if ( !isset($qte_prefix) )   $error .= '<br/>Variable <b>$qte_prefix</b> is not defined in the file <b>bin/config.php</b>. Communication with database is impossible.';
  if ( !isset($qte_user) )     $error .= '<br/>Variable <b>$qte_user</b> is not defined in the file <b>bin/config.php</b>. Communication with database is impossible.';
  if ( !isset($qte_pwd) )      $error .= '<br/>Variable <b>$qte_pwd</b> is not defined in the file <b>bin/config.php</b>. Communication with database is impossible.';
  if ( !isset($qte_port) )     $error .= '<br/>Variable <b>$qte_port</b> is not defined in the file <b>bin/config.php</b>. Communication with database is impossible.';
  if ( !isset($qte_dsn) )      $error .= '<br/>Variable <b>$qte_dsn</b> is not defined in the file <b>bin/config.php</b>. Communication with database is impossible.';

  if ( !empty($error) )  die('<span class="nok">'.$error.'</span>');

  // check db type
  if ( !in_array($qte_dbsystem,array('mysql4','mysql','mssql','pg','ibase','sqlite','db2','access','ifx','oci')) ) die('Unknown db type '.$qte_dbsystem);
  // check other values
  if ( empty($qte_host) )      $error .= '<br/>Variable <b>$qte_host</b> is not defined in the file <b>bin/config.php</b>. Communication with database is impossible.';
  if ( empty($qte_database) )  $error .= '<br/>Variable <b>$qte_database</b> is not defined in the file <b>bin/config.php</b>. Communication with database is impossible.';

  if ( empty($error) )
  {
  echo '<span class="ok">Done.</span></p>';
  }
  else
  {
  die('<span class="nok">'.$error.'</span></p>');
  }

// 3 test db connection

  echo '<p class="check">Connecting to database... ';

  include('bin/qt_lib_db.php');

  $oDB = new cDB($qte_dbsystem,$qte_host,$qte_database,$qte_user,$qte_pwd,$qte_port,$qte_dsn);

  if ( empty($oDB->error) )
  {
  echo '<span class="ok">Done.</span></p>';
  }
  else
  {
  die('<span class="nok">Connection with database failed.<br/>Check that server is up and running.<br/>Check that the settings in the file <b>bin/config.php</b> are correct for your database.</span></p>');
  }

// end CONFIG tests

  echo '<p class="endcheck">Configuration tests completed successfully.</p>';

// --------
// 2 DATABASE
// --------

$error = '';

echo '
<h1>Checking your database design</h1>
';

// 1 setting table

  echo '<p class="check">Checking setting table... ';
   
  $oDB->Query('SELECT setting FROM '.$qte_prefix.'qtesetting WHERE param="version"');
  if ( !empty($oDB->error) ) die('<span class="nok">Problem with table '.$qte_prefix.'qtesetting</span>');
  $row = $oDB->Getrow();
  $strVersion = $row['setting'];

  echo '<span class="ok">Table [',$qte_prefix,'qtesetting] exists. Version is ',$strVersion,'.</span>';
  if ( !in_array(substr($strVersion,0,3),array('1.9','2.0')) ) die('<span class="nok">But data in this table refers to an incompatible version (must be version 2.0).</span></p>');
  echo '</p>';

// 2 domain table

  echo '<p class="check">Checking domain table... ';
  
  $oDB->Query('SELECT count(*) as countid FROM '.$qte_prefix.'qtedomain');
  if ( !empty($oDB->error) ) die('<span class="nok">Problem with table '.$qte_prefix.'qtedomain</span>');
  $row = $oDB->Getrow();
  $intCount = $row['countid'];
  echo '<span class="ok">Table [',$qte_prefix,'qtedomain] exists. ',$intCount,' domain(s) found.</span></p>';

// 3 team table

  echo '<p class="check">Checking team table... ';
  
  $oDB->Query('SELECT count(*) as countid FROM '.$qte_prefix.'qtesection');
  if ( !empty($oDB->error) ) die('<span class="nok">Problem with table '.$qte_prefix.'qtesection</span>');
  $row = $oDB->Getrow();
  $intCount = $row['countid'];
  echo '<span class="ok">Table [',$qte_prefix,'qtesection] exists. ',$intCount,' team(s) found.</span></p>';

// 4 user table

  echo '<p class="check">Checking user table... ';
  
  $oDB->Query('SELECT count(*) as countid FROM '.$qte_prefix.'qteuser');
  if ( !empty($oDB->error) ) die('<span class="nok">Problem with table '.$qte_prefix.'qteuser</span>');
  $row = $oDB->Getrow();
  $intCount = $row['countid'];
  echo '<span class="ok">Table [',$qte_prefix,'qteuser] exists. ',$intCount,' user(s) found.</span></p>';

// end DATABASE tests

  echo '<p class="endcheck">Database tests completed successfully.</p>';

// --------
// 3 LANGUAGE AND SKIN
// --------

$error = '';

echo '
<h1>Checking language and skin options</h1>
';

  echo '<p class="check">Files... ';

  $oDB->Query('SELECT setting FROM '.$qte_prefix.'qtesetting WHERE param="language"');
  $row = $oDB->Getrow();
  $str = $row['setting'];
  if ( empty($str) ) $error .= 'Setting <b>language</b> is not defined in the setting table. Application can only work with english.<br/>';  
  if ( !file_exists("language/$str/qte_main.php") ) $error .= 'File <b>qte_main.php</b> is not in the <b>language/xxxx</b> directory.<br/>';
  if ( !file_exists("language/$str/qte_adm.php") )  $error .= 'File <b>qte_adm.php</b> is not in the <b>language/xxxx</b> directory.<br/>';
  if ( !file_exists("language/$str/qte_reg.php") )  $error .= 'File <b>qte_reg.php</b> is not in the <b>language/xxxx</b> directory.<br/>';
  if ( !file_exists("language/$str/qte_zone.php") ) $error .= 'File <b>qte_zone.php</b> is not in the <b>language/xxxx</b> directory.<br/>';
  if ( $str!='english' )
  {
  if ( !file_exists("language/english/qte_main.php") ) $error .= 'File <b>qte_main.php</b> is not in the <b>language/english</b> directory. English language is mandatory.<br/>';
  if ( !file_exists("language/english/qte_adm.php") )  $error .= 'File <b>qte_adm.php</b> is not in the <b>language/english</b> directory. English language is mandatory.<br/>';
  if ( !file_exists("language/english/qte_reg.php") )  $error .= 'File <b>qte_reg.php</b> is not in the <b>language/english</b> directory. English language is mandatory.<br/>';
  if ( !file_exists("language/english/qte_zone.php") ) $error .= 'File <b>qte_zone.php</b> is not in the <b>language/english</b> directory. English language is mandatory.<br/>';
  }
  
  $oDB->Query('SELECT setting FROM '.$qte_prefix.'qtesetting WHERE param="skin_dir"');
  $row = $oDB->Getrow();
  $str = $row['setting'];
  if ( empty($str) ) $error .= 'Setting <b>skin</b> is not defined in the setting table. Application will not display correctly.<br/>';  
  if ( !file_exists("skin/$str/qte_main.css") ) $error .= 'File <b>qte_main.css</b> is not in the <b>skin/xxxx</b> directory.<br/>';
  if ( !file_exists("skin/default/qte_main.css") ) $error .= 'File <b>qte_main.css</b> is not in the <b>skin/default</b> directory. Default skin is mandatory.<br/>';
  
  if ( empty($error) ) 
  {
  echo '<span class="ok">Ok.</span>';
  }
  else
  {
  echo '<span class="nok">',$error,'</span>';
  }

  echo '</p>';

// end LANGUAGE AND SKIN tests

  echo '<p class="endcheck">Language and skin files tested.</p>';

// --------
// 4 ADMINISTRATION TIPS
// --------

$error = '';

echo '
<h1>Administration tips</h1>
';

// 1 admin email

  echo '<p class="check">Email setting... ';

  $oDB->Query('SELECT setting FROM '.$qte_prefix.'qtesetting WHERE param="admin_email"');
  $row = $oDB->Getrow();
  $strMail = $row['setting'];
  if ( empty($strMail) )
  {
  $error .= 'Administrator e-mail is not yet defined. It\'s mandatory to define it !';
  }
  else
  {
  if ( !ereg("^.+@.+\..+$",$strMail) )  $error .= 'Administrator e-mail format seams incorrect. Please check it';
  }

  if ( !empty($error) ) echo '<span class="nok">'.$error.'</span></p>';
  echo '<span class="ok">Done.</span></p>';
  $error = '';

// 2 admin password

  echo '<p class="check">Security check... ';

  $oDB->Query('SELECT pwd FROM '.$qte_prefix.'qteuser WHERE id=1');
  $row = $oDB->Getrow();
  $strPwd = $row['pwd'];
  If ( $strPwd==sha1('Admin') ) $error .= 'Administrator password is still the initial password. It\'s recommended to change it !<br/>';

  if ( empty($error) ) 
  {
  echo '<span class="ok">Done.</span></p>';
  }
  else
  {
  echo '<span class="nok">',$error,'</span></p>';
  }
  $error = '';

// 3 site url

  echo '<p class="check">Site url... ';

  $oDB->Query('SELECT setting FROM '.$qte_prefix.'qtesetting WHERE param="site_url"');
  $row = $oDB->Getrow();
  $strText = trim($row['setting']);
  if ( substr($strText,0,7)!='http://' && substr($strText,0,8)!='https://' )
  {
    $error .= 'Site url is not yet defined (or not starting by http://). It\'s mandatory to define it !<br/>';
  }
  else
  {
    $strURL = ( empty($_SERVER['SERVER_HTTPS']) ? 'http://' : 'https://' ).$_SERVER['SERVER_NAME'] . $_SERVER['REQUEST_URI'];
    $strURL = substr($strURL,0,-10);
    if ( $strURL!=$strText ) $error .= 'Site url seams to be different that the current url. Please check it<br/>';
  }   

  if ( empty($error) ) 
  {
  echo '<span class="ok">Done.</span></p>';
  }
  else
  {
  echo '<span class="nok">',$error,'</span></p>';
  }
  $error = '';

// 4 picture folder permission

  echo '<p class="check">Folder permissions... ';
  
  if ( !is_dir('picture') )
  { 
    $error .= 'Directory <b>picture</b> not found.<br/>Please create this directory and make it writeable (chmod 777) if you want to allow pictures.<br/>';
  }
  else
  {
    if ( !is_readable('picture') ) $error .= 'Directory <b>picture</b> is not readable.</font><br/>Change permissions (chmod 777) if you want to allow pictures.<br/>';
    if ( !is_writable('picture') ) $error .= 'Directory <b>picture</b> is not writable.</font><br/>Change permissions (chmod 777) if you want to allow pictures.<br/>';
  }

  if ( !empty($error) ) echo '<span class="nok">',$error,'</span></p>';
  echo '<span class="ok">Done.</span></p>';
  $error = '';

echo '<p class="endcheck">Administration tips completed.</p>';

// --------
// 5 END
// --------

echo '
<h1>Result</h1>
';
echo 'The checker did not found blocking issues in your configuration.<br/>';

  $oDB->Query('SELECT setting FROM '.$qte_prefix.'qtesetting WHERE param="board_offline"');
  $row = $oDB->Getrow();
  $strOff = $row['setting'];
  if ( $strOff=='1' ) echo 'Your board seams well installed, but is currently <font color="red">off-line</font>.<br/>Log as Administrator and go to the Administration panel to turn your board on-line.<br/>';

echo '<br/><br/><a href="qte_index.php">Go to QuickTeam</a>';

// --------
// HTML END
// --------

echo '
<!-- END BODY MAIN -->
</td>
</tr>
</table>
<!-- END BODY MAIN -->

<div class="footer_copy">
<span class="footer_copy">powered by <a href="http://www.qt-cute.org" class="footer_copy">QT-cute</a></span>
</div>

<!-- END PAGE CONTROL -->
</td>
</tr>
</table>
</div>
<!-- END PAGE CONTROL -->

</body>

</html>';

?>
