<?php

// QuickTeam 2.0.1 build:20090517

if ( !isset($qte_root) ) $qte_root='';

// ---------------
// Connection config
// ---------------
require_once($qte_root.'bin/config.php');
if ( isset($qte_install) ) { define('QT','qte'.substr($qte_install,-1)); } else { define('QT','qte'); }

// ---------------
// System constants (CANNOT be changed by webmasters)
// ---------------
define('TABDOMAIN', $qte_prefix.'qtedomain');
define('TABSECTION', $qte_prefix.'qtesection');
define('TABUSER', $qte_prefix.'qteuser');
define('TABS2U', $qte_prefix.'qtes2u');
define('TABSTATUS', $qte_prefix.'qtestatus');
define('TABSETTING', $qte_prefix.'qtesetting');
define('TABCHILD', $qte_prefix.'qtechild');
define('TABINDEX', $qte_prefix.'qteindex');
define('TABDOC', $qte_prefix.'qtedoc');
define('TABLANG', $qte_prefix.'qtelang');
define('QTEVERSION', '2.0.1 build:20090517');
define('QSEL', ' selected="selected"');
define('QCHE', ' checked="checked"');
define('QDIS', ' disabled="disabled"');
define('N', "\n");
define('S', '&nbsp;');

// ---------------
// Interface constants (can be changed by webmasters)
// ---------------
define('QTE_CHANGE_USERNAME', true);         // allow users to change their username (login). False = only administrators can change the username.
define('QTE_SHOW_CONTRAST', true);           // allow user to change contrast/normal mode
define('QTE_SHOW_PRINT',    true);           // allow user to get a print style
define('QTE_SHOW_TIME',     true);           // show time in the bottom bar
define('QTE_SHOW_MODERATOR',true);           // show moderator in the bottom bar
define('QTE_SHOW_GOTOLIST', true);           // show gotolist in the bottom bar
define('QTE_SHOW_DOMAIN',   false);          // show domain+team name in the crumbtrail bar and gotolist
define('QTE_CRUMBTRAIL', ' &middot; ');      // crumbtrail separator (dont forget spaces)
define('QTE_MENUSEPARATOR', ' &middot; ');   // bottom menu separator (dont forget spaces)
define('QTE_CONVERT_AMP',   false);          // save &amp; instead of &. Use TRUE to make &#0000; symbols NOT working.
define('QTE_DIR_DOC',$qte_root.'document/'); // directory of the document (with final /)
define('QTE_DIR_PIC',$qte_root.'picture/');  // directory of user's photo (with final /)
define('QTE_JAVA_MAIL',     false);          // Protect e-mail by a javascript

// ---------------
// Class and function definition
// ---------------
require_once($qte_root.'bin/qt_lib_txt.php');
require_once($qte_root.'bin/qt_lib_db.php');
require_once($qte_root.'bin/qt_lib_url.php');
require_once($qte_root.'bin/qte_class_sys.php');
require_once($qte_root.'bin/qte_class_vip.php');
require_once($qte_root.'bin/qte_class_lang.php');
require_once($qte_root.'bin/qte_class_sec.php');
require_once($qte_root.'bin/qte_class_user.php');

// ---------------
// Fonction definition
// ---------------
require_once($qte_root.'bin/qte_fn_common.php');
require_once($qte_root.'bin/qte_fn_html.php');

// ---------------
//  Installation wizard (if file exists)
// ---------------
if ( !isset($qte_install) )
{
  if ( file_exists('install/index.php') )
  {
  echo 'QuickTeam ',QTEVERSION,' <a href="install/index.php">starting installation</a>...';
  echo '<meta http-equiv="REFRESH" content="1;url=install/index.php">';
  exit;
  }
}
if ( empty($qte_install) )
{
  if ( file_exists('install/index.php') )
  {
  echo 'QuickTeam ',QTEVERSION,' <a href="install/index.php">starting installation</a>...';
  echo '<meta http-equiv="REFRESH" content="1;url=install/index.php">';
  exit;
  }
}

// --------------
// Initialise Classes
// --------------

$oDB  = new cDB($qte_dbsystem,$qte_host,$qte_database,$qte_user,$qte_pwd,$qte_port,$qte_dsn);
if ( !empty($oDB->error) ) die ('<p><font color="red">Connection with database failed.<br/>Please contact the webmaster for further information.</font></p><p>The webmaster must check that server is up and running, and that the settings in the config file are correct for the database.</p>');
$oVIP = new cVIP();

// ----------------
// Load system parameters (attention some parameters can be reserved, thus not loaded)
// ----------------

if ( !isset($_SESSION[QT]) ) GetParam(true);

  // check major parameters
  if ( !isset($_SESSION[QT]['skin_dir']) ) $_SESSION[QT]['skin_dir']='skin/default';
  if ( !isset($_SESSION[QT]['language']) ) $_SESSION[QT]['language']='language/english';
  if ( !isset($_SESSION[QT]['lang_iso']) ) $_SESSION[QT]['lang_iso']='en';
  if ( empty($_SESSION[QT]['skin_dir']) ) $_SESSION[QT]['skin_dir']='skin/default';
  if ( empty($_SESSION[QT]['language']) ) $_SESSION[QT]['language']='language/english';
  if ( empty($_SESSION[QT]['lang_iso']) ) $_SESSION[QT]['lang_iso']='en';
  if ( substr($_SESSION[QT]['skin_dir'],0,5)!='skin/' ) $_SESSION[QT]['skin_dir'] = 'skin/'.$_SESSION[QT]['skin_dir'];
  if ( substr($_SESSION[QT]['language'],0,9)!='language/' ) $_SESSION[QT]['language'] = 'language/'.$_SESSION[QT]['language'];
  if ( empty($_SESSION[QT]['admin_email']) ) $_SESSION[QT]['admin_email']='';

if ( isset($_GET['lx']) )
{
  // check that value is valid (to avoid injection)
  require_once('bin/qte_lang.php');
  if ( array_key_exists($_GET['lx'],$arrLang) )
  {
    $_SESSION[QT]['lx'] = $arrLang[$_GET['lx']][2];
    $_SESSION[QT]['lang_iso'] = $_GET['lx'];
    if ( isset($_SESSION['L']) ) $_SESSION['L'] = array();
    if ( isset($_SESSION[QT]['sys_sections']) ) unset($_SESSION[QT]['sys_sections']);
    if ( isset($_SESSION[QT]['sys_statuses']) ) unset($_SESSION[QT]['sys_statuses']);
  }
  else
  {
    $error = 'Wrong iso code language';
  }
}
if ( isset($_SESSION[QT]['lx']) ) $_SESSION[QT]['language'] = 'language/'.$_SESSION[QT]['lx'];

// ----------------
// Initialise variable
// ----------------

$error = ''; // Required when server uses register_global_on
$warning = ''; // Required when server uses register_global_on

if ( !isset($_SESSION[QT]['viewmode']) ) $_SESSION[QT]['viewmode']='N';
if ( !isset($_SESSION[QT]['userlang']) ) $_SESSION[QT]['userlang']='1';
if ( !isset($_SESSION[QT]['lastcolumn']) ) $_SESSION[QT]['lastcolumn']='';
if ( !isset($_SESSION[QT]['cal_shownews']) ) $_SESSION[QT]['cal_shownews']=FALSE;
if ( !isset($_SESSION[QT]['cal_showall']) ) $_SESSION[QT]['cal_showall']=FALSE;

// ----------------
// Load dictionary
// ----------------

if ( !isset($_SESSION['L']) ) $_SESSION['L'] = array();

CheckDico('index',false);
CheckDico('domain',false);
CheckDico('sec',true);
CheckDico('field',false);
CheckDico('ffield',false);

include_once($qte_root.$_SESSION[QT]['language'].'/qte_main.php');

// ----------------
// Define types,statuses and initialise statistics
// ----------------

$oSYS = new cSYS(); // must be at the end because uses language

?>