<?php

// QuickTeam 2.0 build:20090311

// --------

function AsImg($strSrc='',$strAlt='',$strTitle='',$strClass='',$strStyle='',$strHref='')
{
  if ( ArgTypeError('str',array($strSrc,$strAlt,$strTitle,$strClass,$strStyle,$strHref)) ) die('AsImg: Invalid argument type (expect string)');
  if ( empty($strSrc) ) return '';
  $strSrc = '<img src="'.$strSrc.'" alt="'.(!empty($strAlt) ? QTconv($strAlt) :'').'" title="'.(!empty($strTitle) ? QTconv($strTitle) :'').'"'.(!empty($strClass) ? ' class="'.$strClass.'"' : '').(!empty($strStyle) ? ' style="'.$strStyle.'"' : '').'/>';
  if ( empty($strHref) ) { return $strSrc; } else { return '<a href="'.$strHref.'">'.$strSrc.'</a>' ; }
}

// --------

function AsImgBox($strSrc='',$strClass='',$strStyle='',$strCaption='',$strHref='')
{
  if ( ArgTypeError('str',array($strSrc,$strClass,$strStyle,$strCaption,$strHref)) ) die('AsImgBox: Invalid argument type (expect string)');
  if ( !empty($strHref) ) $strCaption = '<a href="'.$strHref.'" class="small">'.$strCaption.'</a>';
  return '<div'.(empty($strClass) ? '' : ' class="'.$strClass.'"').(empty($strStyle) ? '' : ' style="'.$strStyle.'"').'>'.$strSrc.(empty($strCaption) ? '' : '<p class="imgcaption">'.$strCaption.'</p>').'</div>';
}

// --------

function HtmlHead($strRoot='',$strSkin='',$arrCss='',$strHeadScript='',$bJava=true)
{

if ( empty($strSkin) ) $strSkin = $_SESSION[QT]['skin_dir'];
if ( !is_array($arrCss) ) $arrCss = array();

echo QTE_HTML_DTD,'
<html xmlns="http://www.w3.org/1999/xhtml" dir="',QTE_HTML_DIR,'" xml:lang="',QTE_HTML_LANG,'">
<head>
<title>',$_SESSION[QT]['site_name'],'</title>
<meta http-equiv="content-type" content="text/html; charset=',QTE_HTML_CHAR,'"/>
<link rel="shortcut icon" href="',$strRoot,$strSkin,'/qte_icon.ico"/>
<link rel="stylesheet" type="text/css" href="',$strRoot,$strSkin,'/qte_main.css" title="cssmain"/>
';
foreach($arrCss as $strCss) {
switch($strCss) {
  case 'qte_contrast.css': echo '<link rel="alternate stylesheet" type="text/css" href="',$strRoot,'bin/css/qte_contrast.css" title="cssalternate"/>',"\n"; break;
  case 'qte_main2.css':    echo '<link rel="stylesheet" type="text/css" href="',$strRoot,$strSkin,'/',$strCss,'" title="cssmain"/>',"\n"; break;
  default:                 echo '<link rel="stylesheet" type="text/css" href="',$strRoot,$strSkin,'/',$strCss,'"/>',"\n"; break;
}}

if ( !empty($strHeadScript) ) echo $strHeadScript;
if ( $bJava )
{
echo '<script type="text/javascript">
<!--
';
include($strRoot.'bin/qte_j_common.js');
echo '
-->
</script>';
}

echo '</head>
';

}

// --------

function HtmlPageCtrl($intType=0,$strWidth='90%')
{

switch ($intType)
{
case 0: echo '
<!-- PAGE CONTROL -->
<div class="qte_page">
<table class="qte_page" width="',$strWidth,'" cellspacing="0" cellpadding="0"><tr class="qte_page"><td class="qte_page">
<!-- PAGE CONTROL -->  
';
break;
case 1: echo '
<!-- END PAGE CONTROL -->
</td></tr></table>
</div>
<!-- END PAGE CONTROL -->
';
break;
}

}

// --------

function HtmlBanner($intType=0,$strSkin=null,$strLogo=null,$strLangMenu=null)
{

if ( empty($strSkin) ) $strSkin=$_SESSION[QT]['skin_dir'];
if ( empty($strLogo) ) $strLogo='qte_logo.gif';

//if ( !file_exists($strSkin.'/'.$strLogo) ) { $strSkin='admin'; $strLogo='qte_logo.gif'; }

switch ($intType)
{
case 0: echo '
<!-- HEADER BANNER -->
<div class="banner"><div class="banner_in">
<table class="hidden" cellspacing="0"><tr class="hidden">
<td class="hidden" id="banner_zl"><img id="banner_logo" src="',$strSkin,'/',$strLogo,'" alt="',$_SESSION[QT]['site_name'],'" title="',$_SESSION[QT]['site_name'],'"/></td>
<td class="hidden" id="banner_zr">',$strLangMenu,'</td>
</tr></table></div></div>
<!-- END HEADER BANNER -->
';
break;
case 1: echo '
<!-- HEADER NOBANNER -->
<table class="hidden" cellspacing="0"><tr class="hidden">
<td class="hidden" id="nobanner_zl">&nbsp;</td>
<td class="hidden" id="nobanner_zr">&nbsp;',$strLangMenu,'</td>
</tr></table>
<!-- END HEADER NOBANNER -->
';
break;
case 2: echo '
<!-- HEADER BANNER -->
<div class="banner">
<div class="banner_in">
<img src="',$strSkin,'/',$strLogo,'" width="175" height="50" style="border-width:0" alt="QuickTeam" title="QuickTeam"/>
</div>
</div>
<!-- END HEADER BANNER -->
';
break;
}

}

// --------

function HtmlPage($e=100)
{

/*
  0 BOARD OFF LINE
100 ACCESS DENIED
101 ACCESS RESTRICTED TO USERS
102 ACCESS RESTRICTED TO STAFF
*/

global $oVIP,$L,$oSYS;
include('qte_p_header.php');

switch($e)
{
case 0:
  $strFile = $_SESSION[QT]['language'].'/sys_offline.txt';
  if ( file_exists($strFile) ) { include($strFile); } else { echo '<h1>Board off-line</h1><p>The administrator has turned this board off-line.<br/>Please wait...</p>',"\n"; }
  break;
case 100: HtmlMsg(0); echo $L['E_access']; HtmlMsg(1); break;
case 101: HtmlMsg(0); echo $L['R_user']; HtmlMsg(1); break;
case 102: HtmlMsg(0); echo $L['R_staff'];  HtmlMsg(1); break;
default: echo '<p>Unknown trouble ['.strval($e).']</p>';
}

include('qte_p_footer.php');
exit;

}

// --------

function HtmlMsg($intType=0,$strWidth='',$strTitleId='',$strTitle='',$strBodyId='',$strBody='')
{

if ( empty($strWidth) ) $strWidth='350px';

switch ($intType)
{
case 0: echo '
<div class="msgbox" style="width:',$strWidth,'">
<div class="msgboxtitle"',(empty($strTitleId) ? '' : ' id="'.$strTitleId.'"'),'>',$strTitle,'</div>
<div class="msgboxbody"',(empty($strBodyId) ? '' : ' id="'.$strBodyId.'"'),'>',(empty($strBody) ? '' : $strBody),'
';
break;
case 1: echo '
</div>
</div>
';
break;
}

}

// --------

function HtmlTabs($arrTabs=array(0=>'Empty'),$strUrl='', $strCurrent='',$intMax=6,$bFirst=true,$bLast=true,$strWarning='Data not yet saved. Quit without saving?')
{

// tabx means the last tab (can be special due to popup)
// if defined, the class/style tab_on replaces the class/style tab (but you can cumulate the classes in the definition)
// if defined, the class/style tabx_on replaces the class/style tabx (but you can cumulate the styles in the definition)
// When strCurrent is defined, this tab will not be clickable
// $arrTabs can be an array of: strings, arrays, cTab


$iCurrent=1;
foreach(array_keys($arrTabs) as $strKey)
{
  if ($strKey==$strCurrent) break;
  $iCurrent++;
}

// check

if ( !is_array($arrTabs) ) die('HtmlTabs: Argument #1 must be an array');
if ( !empty($strUrl) ) { if ( !strstr($strUrl,'?') ) $strUrl .= '?'; }

// display

echo'
<!-- tab header begin -->
<table cellspacing="0" class="tab">
';

$strOuts=''; $strOut=''; $intRow=0; $intCol=0;
foreach($arrTabs as $strKey=>$oTab)
{
  if ( $intCol==0 )
  {
    $strOut = '<tr class="tab">'."\n";
    if ( $bFirst ) $strOut .= '<td class="tab '.($intRow==0 ? 'tab_begin' : 'tab_hidden').'">&nbsp;</td>'."\n";
    $intCol++;
  }
  if ( $intCol>0 )
  {
    $strTab = '';
    $strTabDesc = '';
    // extract name and description from the object in arrTabs: can be a string, an array or a cTab
    if ( is_string($oTab) )
    {
      $strTab = $oTab;
    }
    elseif ( is_array($oTab) )
    {
      if ( isset($oTab['tabdesc']) )
      {
        if ( !empty($oTab['tabdesc']) ) $strTabDesc = $oTab['tabdesc'];
      }
      if ( isset($oTab['tabname']) )
      {
        if ( !empty($oTab['tabname']) ) { $strTab=$oTab['tabname']; } else { $strTab=ObjTrans('tab',$strKey); }
      }
      else
      {
        $strTab=ObjTrans('tab',$strKey);
      }
    }
    elseif ( strtolower(get_class($oTab))=='ctab' )
    {
      $strTabDesc = $oTab->tabdesc;
      $strTab = $oTab->tabname; if ( empty($strTab) ) $strTab = $oTab->tabid;
    }
    else
    {
      die('HtmlTabs: Arg #1 must be an array of strings, arrays or cTab');
    }
    $strOut .= '<td class="tab tab_'.($strCurrent==$strKey ? 'on' : 'off').'_l">&nbsp;</td>';
    $strOut .= '<td class="tab tab_'.($strCurrent==$strKey ? 'on' : 'off').'_c">';
    if ( empty($strUrl) || $strCurrent==$strKey )
    {
    $strOut .=  $strTab;
    }
    else
    {
    $strOut .=  '<a class="tab" href="'.$strUrl.'&amp;tt='.$strKey.'"'.(empty($strTabDesc) ? '' : ' title="'.$strTabDesc.'"').' onclick="return warningedited(bEdited,\''.$strWarning.'\');">'.$strTab.'</a>';
    }
    $strOut .= '</td>';
    $strOut .= '<td class="tab tab_'.($strCurrent==$strKey ? 'on' : 'off').'_r">&nbsp;</td>'."\n";
    $intCol++; 
  }
  if ( $intCol>$intMax || $intCol>count($arrTabs) )
  {
    if ( $bLast ) $strOut .= '<td class="'.($intRow==0 ? 'tab tab_end' : 'hidden').'">&nbsp;</td>'."\n";
    $strOut .= '</tr>'."\n";
    $intCol=0;
    $strOuts = $strOut.$strOuts;
    $intRow++;
  }
}
if ( $intCol>0 )
{
  while($intCol<=$intMax) { $strOut .= '<td class="tab tab_a">&nbsp;</td>'; $intCol++; }
  if ( $bLast ) $strOut .= '<td class="tab'.($intRow==0 ? ' tab_end' : ' tab_hidden').'">&nbsp;</td>'."\n";
  $strOut .= '</tr>';
  $strOuts = $strOut.$strOuts;
}
echo $strOuts;

echo '
</table>
<!-- tab header end -->
';
}

?>