<?php

// QuickTeam 2.0 build:20081001

function InvalidUpload($arrFile=array(),$strExtensions='',$strMimes='',$intSize=0,$intWidth=0,$intHeight=0)
{

  /**
   * For the uploaded document ($arrFile), this function returns (as string):
   * '' (empty string) if it matches with all conditions (see parameters)
   * An error message if not, and unlink the uploaded document.
   *
   * @$arrFile: The uploaded document ($_FILES['fieldname']).
   * @$strExtensions: List of valid extensions (as string). Empty to skip.
   * @$strMimes: List of valid mimetypes (as string). Empty to skip
   * @$intSize: Maximum file size (kb). 0 to skip.
   * @$intWidth: Maximum image width (pixels). 0 to skip.
   * @$intHeight: Maximum image width (pixels). 0 to skip.
   */
  
  // check arguments
  
  if ( !is_array($arrFile) ) die('CheckUpload: argument #1 must be an array');
  if ( !is_string($strExtensions) ) die('CheckUpload: argument #2 must be a string');
  if ( !is_string($strMimes) ) die('CheckUpload: argument #3 must be a string');
  if ( !is_integer($intSize) ) die('CheckUpload: argument #4 must be an integer');
  if ( !is_integer($intWidth) ) die('CheckUpload: argument #5 must be an integer');
  if ( !is_integer($intHeight) ) die('CheckUpload: argument #6 must be an integer');
  
  global $L;
  
  // check load
  
  if ( !is_uploaded_file($arrFile['tmp_name']) ) 
  {
    unlink($arrFile['tmp_name']);
    return 'You id not upload a file!';
  }

  // check size (kb)

  if ( $intSize>0 ) {
  if ( $arrFile['size'] > ($intSize*1024+16) ) {
    unlink($arrFile['tmp_name']);
    return $L['E_file_size'].' (&lt;'.$intSize.' Kb)';
  }}

  // check extension
  
  if ( !empty($strExtensions) )
  {
    $ext = substr($_FILES['title']['name'],-4,4); if ( substr($ext,0,1)=='.' ) $ext = substr($ext,1);
    if ( strpos($strExtensions,$ext)===FALSE )
    {
    unlink($arrFile['tmp_name']);
    return 'Format ['.substr($arrFile['name'],-4,4).'] not supported... Use '.$strExtensions;
    }
  }

  // check mimetype
  
  if ( !empty($strMimes) ) {
  if ( strpos($strMimes,$arrFile['type'])===FALSE ) {
    unlink($arrFile['tmp_name']);
    return 'Format ['.$arrFile['type'].'] not supported... Use '.$strExtensions;
  }}

  // check size (pixels)

  if ( $intWidth>0 || $intHeight>0 )
  {
    $size = getimagesize($arrFile['tmp_name']);
    if ( $intWidth>0 ) {    
    if ( $size[0] > $intWidth ) {
      unlink($arrFile['tmp_name']);
      return $intWidth.'x'.$intHeight.' '.$L['E_pixels_max'];
    }}
    if ( $intHeight>0 ) {    
    if ( $size[1] > $intHeight ) {
      unlink($arrFile['tmp_name']);
      return $intWidth.'x'.$intHeight.' '.$L['E_pixels_max'];
    }}
  }
 
  return '';
}

// --------

?>