<?php

// QuickTeam 2.0 build:20090311

// --------
// HIGH LEVEL
// --------

function ArgTypeError($strType,$arrArgs)
{
  // Returns TRUE when argument has wrong type
  // $arrArgs can be one object or an array of objects)
  
  if ( !is_array($arrArgs) ) $arrArgs = array($arrArgs);
  foreach ($arrArgs as $oArg)
  {
    switch($strType)
    {
    case 'str': if ( !is_string($oArg) ) return true; break;
    case 'int': if ( !is_integer($oArg) )  return true; break;
    case 'arr': if ( !is_array($oArg) )  return true; break;
    case 'flo': if ( !is_float($oArg) )  return true; break;
    case 'bol': if ( !is_bool($oArg) )  return true; break;
    case 'empty': if ( empty($oArg) ) return true; break;
    case '<0' : if ( intval($oArg)<0 ) return true; break;
    default: die('ArgTypeError: Argument #1 not in valid range');
    }
  }
  return false;
}

// --------

function CheckDico($strVar,$bDesc=false)
{
  if ( !isset($_SESSION['L'][$strVar]) )
  {
  $_SESSION['L'][$strVar] = cLang::GetName($strVar,$_SESSION[QT]['lang_iso'],'*');
  if ( $bDesc ) $_SESSION['L'][$strVar.'desc'] = cLang::GetName($strVar.'desc',$_SESSION[QT]['lang_iso'],'*');
  }
}

// --------

//  Returns the plural (if $intVal>1 and if the plural word exists)
//  The variable $strVar can be composed of 2 strings (comma separated): LangS['userrole,A',25] returns $L['Userroles']['A']
//  $bInclude=true will returns number + space + the word

function LangS($strVar,$intVar,$bInclude=true)
{  
  global $L;
  if ( !strstr($strVar,',') )
  {
    if ( !isset($L[$strVar]) ) return ($bInclude ? $intVar.' ' : '').$strVar;
    if ( $intVar>1 && isset($L[$strVar.'s']) ) return ($bInclude ? $intVar.' ' : '').$L[$strVar.'s'];
    return ($bInclude ? $intVar.' ' : '').$L[$strVar];
  }
  else
  {
    $arr = explode(',',$strVar);
    if ( !isset($L[$arr[0]][$arr[1]]) ) return ($bInclude ? $intVar.' ' : '').$strVar;
    if ( $intVar>1 && isset($L[$arr[0].'s'][$arr[1]]) ) return ($bInclude ? $intVar.' ' : '').$L[$arr[0].'s'][$arr[1]];
    return ($bInclude ? $intVar.' ' : '').$L[$arr[0]][$arr[1]];    
  }
}

// --------

function ObjTrans($strType,$strId,$bGenerate=true,$intMax=0,$strTrunc='...')
{
  // This function returns the translation of the objid
  // When translation is not defined and generate is true, returns the ucfirst(objid)
  // otherwise, returns ''
  // When $intMax>1, the text is truncated to intMax characters and the $strTrunc is added.

  $str = '';
  if ( isset($_SESSION['L'][$strType][$strId]) ) $str = $_SESSION['L'][$strType][$strId];
  if ( empty($str) && $bGenerate )
  {
    switch($strType)
    {
    case 'field': $str = ucfirst(str_replace('_',' ',$strId)); break;
    case 'ffield': $str = $bGenerate; break;
    case 'tab': $str = ucfirst(str_replace('_',' ',$strId)); break;
    case 'tabdesc': $str = $bGenerate; break;
    case 'index': $str = $_SESSION[QT]['index_name']; break;
    case 'domain': $str = $bGenerate; break;
    case 'sec': $str = $bGenerate; break;
    case 'secdesc': $str = $bGenerate; break;
    }
  }
  if ( $intMax>1 && strlen($str)>$intMax ) return substr($str,0,$intMax).$strTrunc;
  return $str;
}

// --------

function Translate($strFile)
{
  if ( file_exists($_SESSION[QT]['language'].'/'.$strFile) ) Return $_SESSION[QT]['language'].'/'.$strFile;
  Return 'language/english/'.$strFile;
}

// --------
// COMMON FUNCTIONS
// --------

function AsEmails($strEmails,$strId,$strSection='0',$strRender='txt',$bFirst=false,$strSkin='skin/default',$strNojava='Java protected email',$strEmpty='&nbsp;',$strSeparator='; ')
{
  if ( !is_string($strEmails) ) return $strEmpty;
  if ( empty($strEmails) || $strEmails==' ' || $strEmails=='&nbsp;' ) return $strEmpty;
  
  // strip private tags
  $strTag1 = '';
  $strTag2 = '';
  if ( substr($strEmails,0,22)=='<span class="private">' )
  {
    $strEmails = strip_tags($strEmails);
    $strTag1 = '<span class="private">';
    $strTag2 = '</span>';    
  }
  
  // format the list of Emails
  $strEmails = str_replace(array(' ; ',' ;','; ',' , ',' ,',', ',',',' '),';',$strEmails);
  $strEmails = str_replace(';;',';',$strEmails);
  if ( substr($strEmails,-1,1)==';' ) $strEmails=substr($strEmails,0,-1);
  if ( strstr($strEmails,';') )
  {
    $arrEmails = explode(';',$strEmails);
  }
  else
  {
    $arrEmails = array($strEmails);
  }
  
  // if only one email
  if ( $bFirst ) $strEmails = $arrEmails[0];
  
  // initialise values
  $strEmails = implode(';',$arrEmails);
  $strEtexts = implode($strSeparator,$arrEmails);

  // render the emails
  switch ($strRender)
  {
  case 'txt':
    Return $strTag1.'<a id="href'.$strId.'s'.$strSection.'" class="small" href="mailto:'.$strEmails.'">'.$strEtexts.'</a>'.$strTag2;
    break;
  case 'img':
    $strTitle = $arrEmails[0];
    Return $strTag1.'<a id="href'.$strId.'s'.$strSection.'" class="small" href="mailto:'.$strEmails.'"><img id="img'.$strId.'s'.$strSection.'" src="'.$strSkin.'/ico_user_e_1.gif" alt="email" title="'.$strTitle.'"/></a>'.$strTag2;
    break;
  case 'txtjava':
    $str = '<script type="text/javascript">';
    foreach ($arrEmails as $strEmail)
    {
    $arr = explode('@',$strEmail);
    $str .= 'writemailto("'.$arr[0].'","'.$arr[1].'","'.$strSeparator.'");';
    }
    $str .= '</script><noscript class="small">'.$strNojava.'</noscript>';
    Return $strTag1.$str.$strTag2;
    break;
  case 'imgjava':
    $strEmails = str_replace(array('@','.'),array('-at-','-dot-'),$strEmails);
    $strTitle = str_replace(array('@','.'),array('-at-','-dot-'),$arrEmails[0]);    
    Return $strTag1.'<a id="href'.$strId.'s'.$strSection.'" onmouseover="vmail(\''.$strId.'s'.$strSection.'\');" onmouseout="hmail(\''.$strId.'s'.$strSection.'\');" class="small" href="javamail:'.$strEmails.'"><img id="img'.$strId.'s'.$strSection.'" src="'.$strSkin.'/ico_user_e_1.gif" alt="email" title="'.$strTitle.'"/></a>'.$strTag2;
    break;
  }

  return $strEmpty;
}

// AsFormat
// Apply php sprintf

function AsFormat($str='',$strFormat='%s',$strEmpty='&nbsp;')
{
  if ( empty($str) ) return $strEmpty;
  if ( $strFormat=='%s' ) return $str;
  if ( !is_string($strFormat) ) return $str;
  if ( strstr($strFormat,' ; ') ) return $str;
  return sprintf($strFormat,$str);
}

// AsPopupList
// explode a string using a separator and trim
// add a first empty entry
// remove duplicates

function AsPopupList($str='',$strSeparator=' ; ')
{
  $arr = explode($strSeparator,$str);
  $arrResult = array();
  $arrResult[' '] = ' ';
  foreach ($arr as $strValue)
  {
    $str = trim($strValue);
    $arrResult[$str] = $str;
  }
  return array_unique($arrResult);
}

// AsTextList

function AsTextList($strText='',$strSep=' ; ',$bReplace=true)
{
  if ( $strText=='' || $strText==' ' || $strText=='&nbsp;' ) return '&nbsp;';
  if ( $bReplace ) 
  {
  return str_replace($strSep,'<br/>',$strText);
  }
  else
  {
  return str_replace($strSep,' ',$strText);
  }
}

// CanPerform
// the $strParam can be 'upload', 'show_stats' or 'show_calendar' (defined in the settings table)

function CanPerform($strParam='',$strRole='V')
{
  if ( empty($strParam) ) die('Missing argument');
  if ( !isset($_SESSION[QT][$strParam]) ) { echo 'undefined CanPerform()'; return false; }
  if ( $_SESSION[QT][$strParam]=='A' && $strRole=='A' ) return true;
  if ( $_SESSION[QT][$strParam]=='M' && ($strRole=='A' || $strRole=='M') ) return true;
  if ( $_SESSION[QT][$strParam]=='U' && $strRole!='V' ) return true;
  if ( $_SESSION[QT][$strParam]=='V' ) return true;
  return false;
}

// --------
// Returns an array of [key] id, [value] title

function GetDomains()
{
  global $oDB;
  $arr = array();
  $oDB->Query( 'SELECT id,title FROM '.TABDOMAIN.' ORDER BY vorder' );
  while ( $row = $oDB->Getrow() )
  {
    $arr[$row['id']] = $row['title'];
  }
  // search translation
  $arrL = cLang::GetName('domain',$_SESSION[QT]['lang_iso'],'*');
  if ( count($arrL)>0)
  {
    foreach ($arr as $id => $str)
    {
      if ( array_key_exists('d'.$id,$arrL) )
      {
      if ( !empty($arrL['d'.$id]) ) $arr[$id]=$arrL['d'.$id];
      }
    }
  }
  return $arr;
}

// --------

function GetParam($bRegister=false,$strWhere='')
{
  global $oDB;
  $arrParam = array();
  $oDB->Query('SELECT param,setting FROM '.TABSETTING.(empty($strWhere) ? '' : ' WHERE '.$strWhere));  
  while ($row = $oDB->Getrow())
  {
  $arrParam[$row['param']]=$row['setting'];
  if ( $bRegister ) $_SESSION[QT][$row['param']]=$row['setting'];
  }
  Return $arrParam;
}

// --------
// Returns an array of [key] section id, [value] section title

function GetSectionTitles($strRole='V',$intDomain=-1,$intReject=-1,$strExtra='',$bAddDomain=false)
{
  if ( !is_string($strRole) ) die('GetSectionTitles: Argument #1 must be a string');
  if ( !is_int($intDomain) ) die('GetSectionTitles: Argument #2 must be an integer');

  if ( $intDomain>=0 ) { $strWhere = 'domainid='.$intDomain; } else { $strWhere = 'domainid>=0'; }
  if ( $strRole=='V' || $strRole=='U' ) $strWhere .= ' AND type<>"1"';
  if ( !empty($strExtra) ) $strWhere .= ' AND '.$strExtra;

  global $oDB;
  $arr = array();

  // search translation
  $arrL = cLang::GetName('sec',$_SESSION[QT]['lang_iso'],'*');

  $oDB->Query( 'SELECT id,title FROM '.TABSECTION.' WHERE '.$strWhere.' ORDER BY vorder' );
  while ( $row = $oDB->Getrow() )
  {
    $id = intval($row['id']);
    $arr[$id] = stripslashes($row['title']);
    if ( array_key_exists('s'.$id,$arrL) ) {
    if ( !empty($arrL['s'.$id]) ) {
      $arr[$id] = $arrL['s'.$id];
    }}
    if ( $bAddDomain ) $arr[$id] = ObjTrans('domain','d'.$id,'Domain &nbsp;'.$id).': '.$arr[$id];
  }

  if ( count($arr)>0 )
  {
    // reject
    if ( $intReject>=0 ) unset($arr[$intReject]);
  }
  return $arr;
}

// --------
// Returns an array of [key] section id, array of [values] section

function GetSections($strRole='V',$intDomain=-1,$intReject=-1,$strExtra='')
{
  // Check

  if ( ArgTypeError('str',array($strRole,$strExtra)) ) die('GetSections: Invalid argument type (expect string)');
  if ( ArgTypeError('int',array($intDomain,$intReject)) ) die('GetSections: Invalid argument type (expect integer)');

  // Process
  
  global $oDB;

  if ( $intDomain>=0 ) { $strWhere = 'domainid='.$intDomain; } else { $strWhere = 'domainid>=0'; }
  if ( $strRole=='V' || $strRole=='U' ) $strWhere .= ' AND type<>"1"';
  if ( !empty($strExtra) ) $strWhere .= ' AND '.$strExtra;

  $arr = array();
  $oDB->Query( 'SELECT * FROM '.TABSECTION.' WHERE '.$strWhere.' ORDER BY vorder' );
  while($row=$oDB->Getrow()) $arr[intval($row['id'])]=$row;

  if ( count($arr)>0 )
  {
    // search translation
    $arrL = cLang::GetName('sec',$_SESSION[QT]['lang_iso'],'*');
    if ( count($arrL)>0)
    {
      foreach($arr as $id => $str)
      {
        if ( array_key_exists('s'.$id,$arrL) )
        {
        if ( !empty($arr['s'.$id]) ) $arr[$id]['title']=$arrL['s'.$id];
        }
      }
    }
    // reject
    if ( $intReject>=0 ) unset($arr[$intReject]);
  }
  return $arr;
}

/**
 *
 * GetUsers
 *
 * Return an array of (maximum 200) users id/lastname+firstname
 * number = returns 1 user [id][name]
 * 'all' = returns all users (default)
 * 'A'   = returns administrators
 * 'M'   = returns staff members (+Admin)
 * 'M-'  = returns staff members (-Admin)
 * 'U'   = returns users (-Admins -moderators)
 * $bInvert = use true to return firstname+lastname
 **/
function GetUsers($strRole='all',$intSection=-1,$bInvert=false)
{
   global $oDB;
   $intX = 200;
   if ( $intSection<0 )
   {
   $strQ = 'SELECT u.id,u.username,u.firstname,u.lastname FROM '.TABUSER.' u ';
   if ( $strRole=='all' ) $strQ .= 'WHERE u.id>0';
   if ( $strRole=='A' )   $strQ .= 'WHERE u.role="A"';
   if ( $strRole=='U' )   $strQ .= 'WHERE u.role="U"';
   if ( $strRole=='M' )   $strQ .= 'WHERE u.role="A" OR u.role="M"';
   if ( $strRole=='M-' )  $strQ .= 'WHERE u.role="M"';
   if ( $strRole=='lost' ) $strQ .= 'LEFT JOIN '.TABS2U.' l ON l.userid=u.id WHERE u.id>0 AND l.userid IS NULL';
   }
   else
   {
   $strQ = 'SELECT u.id,u.username,u.firstname,u.lastname FROM '.TABUSER.' u INNER JOIN '.TABS2U.' l ON l.userid=u.id ';
   if ( $strRole=='all' ) $strQ .= 'WHERE l.sid='.$intSection;
   if ( $strRole=='A' )   $strQ .= 'WHERE l.sid='.$intSection.' AND u.role="A"';
   if ( $strRole=='U' )   $strQ .= 'WHERE l.sid='.$intSection.' AND u.role="U"';
   if ( $strRole=='M' )   $strQ .= 'WHERE l.sid='.$intSection.' AND (u.role="M" OR u.role="A")';
   if ( $strRole=='M-' )  $strQ .= 'WHERE l.sid='.$intSection.' AND u.role="M"';
   }
   $oDB->Query( $strQ.' ORDER BY u.lastname, u.firstname' );

   $arrUsers = array();
   $i=1;
   while ($row=$oDB->Getrow())
   {
      if ( $bInvert )
      {
      $arrUsers[$row['id']] = substr($row['firstname'].' '.$row['lastname'],0,32);
      }
      else
      {
      $arrUsers[$row['id']] = substr($row['lastname'].' '.$row['firstname'],0,32);
      }
      if ( $arrUsers[$row['id']]==' ' ) $arrUsers[$row['id']]=$row['username'];
      $i++;
      if ( $i>$intX ) break;
   }
   return $arrUsers;
}

// --------
function GetFields($str='all')
{
  switch ($str)
  {
  case 'all':       return array('id','username','status_i','role','status','picture','address','phones','emails','www','title','firstname','midname','lastname','alias','birthdate','nationality','sexe','fullname','age','children','teamid1','teamid2','teamrole1','teamrole2','teamdate1','teamdate2','teamvalue1','teamvalue2','teamflag1','teamflag2','descr'); break;
  case 'usables':   return explode(',',$_SESSION[QT]['fields_c'].','.$_SESSION[QT]['fields_u'].','.$_SESSION[QT]['fields_t']); break;
  case 'personnal': return array('id','username','status_i','role','status','picture','address','phones','emails','www','title','firstname','midname','lastname','alias','birthdate','nationality','sexe','fullname','age','children'); break;
  case 'useredit':  return array('status','address','phones','emails','www','title','firstname','midname','lastname','alias','birthdate','nationality','sexe'); break;
  case 'team':      return array('teamid1','teamid2','teamrole1','teamrole2','teamdate1','teamdate2','teamvalue1','teamvalue2','teamflag1','teamflag2','descr'); break;
  case 'computed':  return array('fullname','age','children'); break;
  case 'index_p':   return array('username','address','phones','emails','www','title','firstname','midname','lastname','alias','birthdate','nationality','sexe','age'); break;
  case 'index_t':   return array('teamid1','teamid2','teamrole1','teamrole2','teamdate1','teamdate2','teamvalue1','teamvalue2','teamflag1','teamflag2','descr'); break;
  default:          die("GetFields: Wrong argument $str");
  }
}

// --------
// From a list of fields returns the 'usable' ones
// @$arrFields a list of fields.
//    If empty array, returns usable fields from the full list
//    It can be a string (with semi-colon as separator)
// @$strInfo the desired information: id, nid, name, format (nid is numerical indexed list)
// @$strSep when a separator string is provided, returns a imploded string instead of an array

function GetFieldsUsable($arrFields=array(),$strInfo='id',$strSep=FALSE)
{  
  if ( is_string($arrFields) ) $arrFields = explode(';',$arrFields);
  if ( !is_array($arrFields) ) die('GetFieldsUsable: Arg #2 must be an array');  
  if ( !is_string($strInfo) ) die('GetFieldsUsable: Arg #3 must be a string');
  if ( count($arrFields)==0 ) $arrFields = GetFields(); 
 
  $arrUsables = GetFields('usables');
 
  $arr = array();
  foreach ($arrFields as $strField)
  {
    if ( in_array($strField,$arrUsables) )
    {
      switch ($strInfo)
      {
      case 'name':  $arr[$strField] = ObjTrans('field',$strField); break;
      case 'format':$arr[$strField] = ObjTrans('ffield',$strField); break;
      case 'id':    $arr[$strField] = $strField; break;
      case 'nid':   $arr[] = $strField; break;
      default:      die('Wrong argument: GetFieldsUsable returns only id,name or format');
      }
    }
  }
  if ( $strSep ) return implode($strSep,$arr);
  return $arr;
}

// MakePager
// Return FALSE if pager not needed

function MakePager($uri, $count, $intPagesize=50, $currentpage=1)
{
   if ( $intPagesize<1 ) die('Invalid pagesize: ['.$intPagesize.']');
   global $L;
   $arrUri = parse_url($uri);
   $uri = $arrUri['path'];
   $arg = $arrUri['query'];
   $arg = str_replace('&amp;','&',$arg);
   $arrArg = explode('&',$arg);
   $arrNew = array();
   foreach ($arrArg as $strValue)
   {
      if ( substr($strValue,0,4)=='page' ) continue;
      $arrNew[]=$strValue;
   }
   $arg = implode('&amp;',$arrNew);
   
   $strPager = false;  
   if ( $count>($intPagesize*5) )
   {
      // firstpage
      if ( $currentpage==1 )
      {
        $firstpage = ' &laquo;';
      }
      else
      {
        $firstpage = ' <a href="'.$uri.'?'.$arg.'&amp;page=1" title="'.$L['First'].'">&laquo;</a>';
      }
      // lastpage
      $il = ceil($count/$intPagesize);
      if ( $currentpage==$il )
      {
        $lastpage = ' &raquo;';
      }
      else
      {
        $lastpage = ' <a href="'.$uri.'?'.$arg.'&amp;page='.$il.'" title="'.$L['Last'].': '.$il.'">&raquo;</a>';
      }
      // 3 pages
      if ( $currentpage==1 )
      {
         $thesepages = ' <b>'.$currentpage.'</b> <a href="'.$uri.'?'.$arg.'&amp;page='.($currentpage+1).'" title="'.$L['Next'].'">'.($currentpage+1).'</a> <a href="'.$uri.'?'.$arg.'&amp;page='.($currentpage+2).'" title="'.$L['Next'].'">'.($currentpage+2).'</a>';
      }
      elseif ( $currentpage==$il )
      {
         $thesepages = ' <a href="'.$uri.'?'.$arg.'&amp;page='.($currentpage-2).'" title="'.$L['Previous'].'">'.($currentpage-2).'</a> <a href="'.$uri.'?'.$arg.'&amp;page='.($currentpage-1).'" title="'.$L['Previous'].'">'.($currentpage-1).'</a> <b>'.$currentpage.'</b> ';
      }
      else
      {
         $thesepages = ' <a href="'.$uri.'?'.$arg.'&amp;page='.($currentpage-1).'" title="'.$L['Previous'].'">'.($currentpage-1).'</a> <b>$currentpage</b> <a href="'.$uri.'?'.$arg.'&amp;page='.($currentpage+1).'" title="'.$L['Next'].'">'.($currentpage+1).'</a>';
      }
      // finish
      $strPager .= $firstpage.$thesepages.$lastpage;
   }
   elseif ($count>$intPagesize)
   {
      for ($i=0; $i<$count; $i+=$intPagesize)
      {
        $page = $i/$intPagesize+1;
        if ( $currentpage==$page )
        {
          $strPager .= ' <b>'.$page.'</b>';
        }
        else
        {
          $strPager .= ' <a href="'.$uri.'?'.$arg.'&amp;page='.$page.'">'.$page.'</a>';
        }
      }
   }
   return $strPager;
}

// --------

function Nextid($strTable,$strField='id',$strWhere='',$onerror=null)
{
  // Check

  if ( !is_string($strTable) ) { if ( isset($onerror) ) return $onerror; die('Nextid: arg #2 must be an string'); }
  if ( !is_string($strField) ) { if ( isset($onerror) ) return $onerror; die('Nextid: arg #3 must be an string'); }
  if ( !is_string($strWhere) ) { if ( isset($onerror) ) return $onerror; die('Nextid: arg #4 must be an string'); }
  if ( empty($strTable) ) { if ( isset($onerror) ) return $onerror; die('Nextid: arg #2 must be an string'); }
  if ( empty($strField) ) { if ( isset($onerror) ) return $onerror; die('Nextid: arg #3 must be an string'); }

  // Process

  global $oDB;
  
  $oDB->Query("SELECT max($strField)+1 as newnum FROM $strTable $strWhere");
  $row = $oDB->Getrow();
  $intId = $row['newnum'];
  if ( empty($intId) ) $intId=1;

  return intval($intId);
}

// --------

function TableHeader($arrFields,$intCount=0,$strUrl='',$strOrder='username',$strDir='')
{
  $img['ASC'] = ' <img class="ico i_sort" src="'.$_SESSION[QT]['skin_dir'].'/sort_asc.gif" alt="+"/>';
  $img['DESC']= ' <img class="ico i_sort" src="'.$_SESSION[QT]['skin_dir'].'/sort_desc.gif" alt="-"/>';
  
  Foreach ($arrFields as $strField => $arrField)
  {
    // change the text to hyperlink+image when necessary
    if ( $arrField['sort'] && $intCount>2 )
    {
      if ( $strField==$strOrder )
      {
      $str = '<a href="'.$strUrl.'&amp;order='.$arrField['sort'].'&amp;dir='.QTinvert($strDir).'"'.(isset($arrField['class']) ? ' class="'.$arrField['class'].'"' : '').'>'.$arrField['text'].'</a>'.$img[$strDir];
      }
      else
      {
      $str = '<a href="'.$strUrl.'&amp;order='.$arrField['sort'].'&amp;dir='.$arrField['dir'].'"'.(isset($arrField['class']) ? ' class="'.$arrField['class'].'"' : '').'>'.$arrField['text'].'</a>';
      }
    }
    else
    {
    $str = $arrField['text'];
    }
    // show the column text
    echo '<td',(empty($arrField['class']) ? '' : ' class="'.$arrField['class'].'"'),(empty($arrField['style']) ? '' : ' style="'.$arrField['style'].'"'),'>',$str,'</td>',N;
  }
}

// --------

function TargetDir($strRoot='',$intId=0)
{
  // This check if a directory/subdirectory is available for an Id
  // Returns dir/subdir (without the root)
  // Returns '' if not available

  $strDir = '';
  $intDir = ($intId>0 ? floor($intId/1000) : 0);
  if ( is_dir($strRoot.strval($intDir).'000') )
  {
    $strDir = strval($intDir).'000/';    
    $intSDir = $intId-($intDir*1000);
    $intSDir = ($intSDir>0 ? floor($intSDir/100) : 0);
    if ( is_dir($strRoot.$strDir.strval($intDir).strval($intSDir).'00') ) $strDir .= strval($intDir).strval($intSDir).'00/';
  }
  return $strDir;
}

// --------

function UseModule($strName=null,$onerror=null)
{
  if ( !is_string($strName) ) { if ( isset($onerror) ) return $onerror; die('UseModule: arg #1 must be an string'); }
  if ( isset($_SESSION[QT]['module_'.$strName]) ) return TRUE;
  return FALSE;  
}

?>
