<?php

// QuickTeam 2.0 build:20090311

function ChoiceList($arrMark=array(),$arrRemove=array())
{
  if ( !is_array($arrRemove) ) die('FieldSort: arg #2 must be an array');
  if ( !is_array($arrMark) ) die('FieldSort: arg #3 must be an array');

  $arrSrc = array();

  $arr = GetFieldsUsable(array('status_i','fullname'));
  foreach ($arr as $strKey) { $arrSrc[$strKey] = ObjTrans('field',$strKey); }
  $arrSrc['-']='--------------';
  $arr = GetFieldsUsable(array('title','firstname','midname','lastname','alias','birthdate','age','nationality','address','phones','emails','emails_i','picture'));
  foreach ($arr as $strKey) { $arrSrc[$strKey] = ObjTrans('field',$strKey); }
  $arrSrc['--']='--------------';
  $arr = GetFieldsUsable(array('teamid1','teamid2','teamrole1','teamrole2','teamdate1','teamdate2','teamvalue1','teamvalue2','teamflag1','teamflag2','descr'));
  foreach ($arr as $strKey) { $arrSrc[$strKey] = ObjTrans('field',$strKey); }
  $arrSrc['---']='--------------';
  $arr = GetFieldsUsable(array('id','username','role','status','children'));
  foreach ($arr as $strKey) { $arrSrc[$strKey] = ObjTrans('field',$strKey); }
  
  foreach($arrRemove as $strRemove)
  {
    if ( isset($arrSrc[$strRemove]) ) unset($arrSrc[$strRemove]);
  }
  foreach($arrMark as $strKey)
  {
    if ( isset($arrSrc[$strKey]) ) $arrSrc[$strKey]='[X] '.$arrSrc[$strKey];
  }
  Return $arrSrc;  
}

// ------------

function Changelist($arr,$action,$value='N')
{
  if ( !is_array($arr) ) die('FieldSort: arg #1 must be an array');
  if ( !is_string($action) ) die('FieldSort: arg #2 must be a string');
  if ( !is_string($value) ) die('FieldSort: arg #3 must be a string');

  switch ($action)
  {
  case 'add':
    if ( $value!='N' )
    {
    $arr[]=$value;    
    $arr = array_unique($arr);
    }
    break;
  case 'del':
    if ( in_array($value,$arr) ) 
    {
      $keysrc = array_search($value,$arr);
      unset($arr[$keysrc]);
    }
    break;
  case 'left':
    if ( in_array($value,$arr) ) 
    {
      $keysrc = array_search($value,$arr);
      $valsrc = $arr[$keysrc];
      if ( $keysrc>0 )
      {
        $keydest = $keysrc-1;
        $valdest = $arr[$keydest];
        $arr[$keydest] = $valsrc;
        $arr[$keysrc] = $valdest;
      }
    }
    break;
  case 'right':
    if ( in_array($value,$arr) ) 
    {
      $keysrc = array_search($value,$arr);
      $valsrc = $arr[$keysrc];
      if ( $keysrc<count($arr)-1 )
      {
        $keydest = $keysrc+1;
        $valdest = $arr[$keydest];
        $arr[$keydest] = $valsrc;
        $arr[$keysrc] = $valdest;
      }
    }
    break;
  case 'first':
    if ( in_array($value,$arr) ) 
    {
      $keysrc = array_search($value,$arr);
      $valsrc = $arr[$keysrc];
      if ( $keysrc>0 )
      {
        $keydest = 0;
        $valdest = $arr[$keydest];
        $arr[$keydest] = $valsrc;
        $arr[$keysrc] = $valdest;
      }
    }
    break;
  case 'last':
    if ( in_array($value,$arr) ) 
    {
      $keysrc = array_search($value,$arr);
      $valsrc = $arr[$keysrc];
      if ( $keysrc<count($arr)-1 )
      {
        $keydest = count($arr)-1;
        $valdest = $arr[$keydest];
        $arr[$keydest] = $valsrc;
        $arr[$keysrc] = $valdest;
      }
    }
    break;
  }
  ksort($arr);
  Return $arr;
}

// ------------
// FindDuplicates
// Returns a string containing duplicates OR return false if no duplicate

function FindDuplicates($arrValues,$bStrict=true)
{
  if ( !is_array($arrValues) ) die('FindDuplicates requiers an array');
  if ( !$bStrict ) $arrValues = array_map('strtoupper',$arrValues);
  $arrUniques = array_unique($arrValues);
  if ( count($arrValues)==count($arrUniques) ) return false;  
  $arr = array();
  $str = '';
  foreach ($arrValues as $strValue)
  {
    if ( !isset($arr[$strValue]) ) { $arr[$strValue]=1; } else { $str .= (empty($str) ? '' : ', ').$strValue; }
  }
  return $str;
}

// --------

function SetFields($arrFields)
{
  if ( !is_array($arrFields) ) die('cUser->SetFields: Argument #1 must be an array.');

  global $oDB;

  $arrFields = array_unique($arrFields);
  
  $arrSetFieldsC = array('id','username','pwd','status','status_i','role');
  $arrSetFieldsU = array();
  $arrSetFieldsT = array();
  
  foreach (array('fullname','age','children','firstdate') as $strField)
  {
    if ( in_array($strField,$arrFields) ) $arrSetFieldsC[] = $strField;
  }
  foreach (array('picture','address','phones','emails','emails_i','www','title','firstname','midname','lastname','alias','birthdate','nationality','sexe') as $strField)
  {
    if ( in_array($strField,$arrFields) ) $arrSetFieldsU[] = $strField;
  }
  foreach (array('teamid1','teamid2','teamrole1','teamrole2','teamdate1','teamdate2','teamvalue1','teamvalue2','teamflag1','teamflag2','descr') as $strField)
  {
    if ( in_array($strField,$arrFields) ) $arrSetFieldsT[] = $strField;
  }
    
  $_SESSION[QT]['fields_c'] = implode(',',$arrSetFieldsC);
  $_SESSION[QT]['fields_u'] = implode(',',$arrSetFieldsU);
  $_SESSION[QT]['fields_t'] = implode(',',$arrSetFieldsT);
  
  $oDB->Query( 'UPDATE '.TABSETTING.' SET setting="'.$_SESSION[QT]['fields_c'].'" WHERE param="fields_c"' );
  $oDB->Query( 'UPDATE '.TABSETTING.' SET setting="'.$_SESSION[QT]['fields_u'].'" WHERE param="fields_u"' );
  $oDB->Query( 'UPDATE '.TABSETTING.' SET setting="'.$_SESSION[QT]['fields_t'].'" WHERE param="fields_t"' );  
  
}

// --------

?>