<?php

// QuickTeam 2.0 build:20090311

class cSYS
{

// -- Properties --

var $sections = array(); // list of sectionstitles (translated) visible for the current user ($oVIP->role)
var $types = array();    // list of types
var $statuses = array(); // list of statuses
var $members = 0;      // count members
var $states = array();   // other info
var $output = 'screen'; // output media (screen,print)

// -- Constructor --

function cSYS()
{
  // Construct if not yet registered

  if ( !isset($_SESSION[QT]['sys_sections']) ) $_SESSION[QT]['sys_sections'] = $this->GetSections();
  if ( !isset($_SESSION[QT]['sys_statuses']) ) $_SESSION[QT]['sys_statuses'] = $this->GetStatuses();  
  if ( !isset($_SESSION[QT]['sys_members']) ) $_SESSION[QT]['sys_members'] = $this->SysCount('members');
  if ( !isset($_SESSION[QT]['sys_states']) ) $_SESSION[QT]['sys_states'] = $this->SysCount('states');

  // Exit

  $this->types = $this->GetTypes();
  $this->sections = $_SESSION[QT]['sys_sections'];
  $this->statuses = $_SESSION[QT]['sys_statuses'];
  $this->members = $_SESSION[QT]['sys_members'];
  $this->states = $_SESSION[QT]['sys_states'];
}

// --------

function SysCount($strObject='members')
{
  // Check
  
  if ( ArgTypeError('str',array($strObject)) ) die('SysCount: Invalid argument type (expect string)');

  // Process
  
  global $oDB;
  switch($strObject)
  {
  case 'members':
    $oDB->Query('SELECT count(id) as countid FROM '.TABUSER);
    $row = $oDB->Getrow();
    return intval($row['countid']);
    break;
  case 'states':
    $arr = array();
      $oDB->Query('SELECT max(id) as countid FROM '.TABUSER);
      $row = $oDB->Getrow();
    $arr['newuserid'] = intval($row['countid']);
      $oDB->Query('SELECT username,firstname,lastname FROM '.TABUSER.' WHERE id='.$row['countid'] );
      $row = $oDB->Getrow();
    $arr['newusername'] =  $row['firstname'].' '.$row['lastname']; if ( strlen($arr['newusername'])<3 ) $arr['newusername'] = $row['username'];
    return $arr;
    break;
  }
}

// --------

function GetSections()
{
  // Process

  $arr = array();
  global $oDB,$oVIP;
  if ( $oVIP->role=='V' || $oVIP->role=='U' ) { $strWhere=' WHERE type<>"1"'; } else { $strWhere=''; }

  // Search translations
  
  $arrL = cLang::GetName('sec',$_SESSION[QT]['lang_iso'],'*');
  
  // Get sections from DB

  $oDB->Query( 'SELECT id,title FROM '.TABSECTION.$strWhere.' ORDER BY vorder' );
  while ( $row = $oDB->Getrow() )
  {
    $id = intval($row['id']);
    $arr[$id] = stripslashes($row['title']);
    if ( array_key_exists('s'.$id,$arrL) ) {
    if ( !empty($arrL['s'.$id]) ) {
      $arr[$id] = $arrL['s'.$id];
    }}
    if ( QTE_SHOW_DOMAIN ) $arr[$id] = ObjTrans('domain','d'.$id,'Domain &nbsp;'.$id).': '.$arr[$id];
  }

  return $arr;
}

// --------

function GetStatuses()
{
  $arr = array();

  global $oDB;  $oDB->Query( 'SELECT * FROM '.TABSTATUS.' ORDER BY id' );
  while($row=$oDB->Getrow())
  {
    $arr[$row['id']]['statusname'] = ucfirst(str_replace('_',' ',$row['name']));
    $arr[$row['id']]['statusdesc'] = '';
    $arr[$row['id']]['name'] = $row['name'];
    $arr[$row['id']]['icon'] = $row['icon'];
    $arr[$row['id']]['color'] = $row['color'];
  }

  // find translations

  $arrL = cLang::GetName('status',$_SESSION[QT]['lang_iso'],'*');
  foreach ($arrL as $id=>$str)
  {
    if ( !empty($str) ) $arr[$id]['statusname'] = $str;
  }
  $arrL = cLang::GetName('statusdesc',$_SESSION[QT]['lang_iso'],'*');
  foreach ($arrL as $id=>$str)
  {
    if ( !empty($str) ) $arr[$id]['statusdesc'] = $str;
  }

  return $arr;
}

// --------

function StatusAdd($id='',$name='',$icon='',$color='')
{
  // Check

  if ( !is_string($id) || empty($id) ) die('cSYS->StatusAdd: Argument #1 must be a string');
  if ( !is_string($name) || empty($name) ) die('cSYS->StatusAdd: Argument #2 must be a string');
  if ( !is_string($icon) ) die('cSYS->AddStatusAdd Argument #3 must be a string');
  if ( !is_string($color) ) die('cSYS->StatusAdd: Argument #4 must be a string');

  // Process

  global $oDB;
  $error = '';

  $id = strtoupper(substr(trim($id),0,1));
  $name = QTconv($name,'3',QTE_CONVERT_AMP);

  // unique id and name

  $oDB->Query('SELECT count(*) AS countid FROM '.TABSTATUS.' WHERE id="'.$id.'"');
  $row=$oDB->Getrow();
  if ( $row['countid']>0 ) $error = "Status id [$id] already used";
  $oDB->Query('SELECT count(*) AS countid FROM '.TABSTATUS.' WHERE name="'.addslashes($name).'"');
  $row=$oDB->Getrow();
  if ( $row['countid']>0 ) $error = "Status name [$name] already used";

  // Save

  if ( empty($error) )
  {
    $oDB->Query('INSERT INTO '.TABSTATUS.' (id,name,color,icon) VALUES ("'.$id.'","'.addslashes($name).'","'.$color.'","'.$icon.'")');
  }
  
  // Exit
  
  if ( isset($_SESSION[QT]['sys_statuses']) ) unset($_SESSION[QT]['sys_statuses']);
  return $error;
}

// --------

function StatusDelete($id='',$to='A')
{
  // Check

  if ( !is_string($id) || empty($id) ) die('cSYS->StatusDelete: Argument #1 must be a string');
  if ( !is_string($to) || empty($to) ) die('cSYS->StatusDelete: Argument #2 must be a string');
  $id = strtoupper(substr(trim($id),0,1));
  $to = strtoupper(substr(trim($to),0,1));
  if ( $id=='A' || $id=='A' ) die('cSYS->StatusDelete: Argument #1 cannot be A nor Z');
  if ( $id==$to ) die('cSYS->StatusDelete: Argument #1 equal #2');

  // Process - status id > to and delete id
  
  global $oDB;

  $oDB->Query( 'UPDATE '.TABUSER.' SET status="'.$to.'" WHERE status="'.$id.'"' );
  $oDB->Query( 'DELETE FROM '.TABSTATUS.' WHERE id="'.$id.'"' );
  $oDB->Query( 'DELETE FROM '.TABLANG.' WHERE (objtype="status" OR objtype="statusdesc") AND objid="'.$id.'"' );

  // Exit

  if ( isset($_SESSION[QT]['sys_statuses']) ) unset($_SESSION[QT]['sys_statuses']);
}

// --------

function StatusChangeId($id='',$to='')
{
  // Check

  if ( !is_string($id) || empty($id) ) die('cSYS->StatusChangeId: Argument #1 must be a string');
  if ( !is_string($to) || empty($to) ) die('cSYS->StatusChangeId: Argument #2 must be a string');
  $id = strtoupper(substr(trim($id),0,1));
  $to = strtoupper(substr(trim($id),0,1));
  if ( $id=='A' || $id=='A' ) die('cSYS->StatusChangeId: Argument #1 cannot be A nor Z');
  if ( $to=='A' || $to=='A' ) die('cSYS->StatusChangeId: Argument #2 cannot be A nor Z');

  // Process
  
  global $oDB;
  $error = '';

  // Unique name

  if ( empty($error) )
  {
  $oDB->Query('SELECT count(*) AS countid FROM '.TABSTATUS.' WHERE status="'.$to.'"');
  $row=$oDB->Getrow();
  if ( $row['countid']>0 ) $error = "Status id [$id] already used";
  }

  // Save changes

  if ( empty($error) )
  {
  $oDB->Query('UPDATE '.TABUSER.' SET status="'.$to.'" WHERE status="'.$id.'"');
  $oDB->Query('UPDATE '.TABSTATUS.' SET id="'.$to.'" WHERE id="'.$id.'"');
  }

  // Exit
  
  if ( isset($_SESSION[QT]['sys_statuses']) ) unset($_SESSION[QT]['sys_statuses']);
  return $error;
}

// --------

function GetTypes()
{
  global $L;
  return array('H'=>array('name'=>'Human','color'=>''),'O'=>array('name'=>'Other','color'=>''));
}

// --------

}

?>