<?php

// QuickTeam 2.0 build:20090311

// CONSTRAINT:
// users can be outside section (i.e. new user not yet in section)
// users without section are stored in the garbage collector (section 0)

/*
 * CLASS cSection
 *
 * constructor cSection: argument can be null, a section id, a section arr, a cSection object
 * function MakeFromArray: used by the constructor
 * function MoveContent (=DeleteContent)
 * function UpdateStats
 *
 */

class cSection
{

// --------

var $domid;     // Domain id
var $domname;   // Domain name
var $id;        // Section id
var $idtitle;   // Section title
var $name;      // Section name (translation)
var $descr;     // Section descr (translation)
var $type = 0;  // '0'=visible, '1'=hidden, '2'=hidden by user
var $status = 0;// '0'=actif, '1'=closed
var $picture;
var $vorder = 255;
var $forder;
var $modid = 1;
var $modname = 'Admin';
var $members = 0;
var $allowpic = 'Y';    // allow image [Y/N] (only N means no; unset means Y)
// not used (version 14)
var $template='T';      // 'T'=table, 'P'=preview, 'C'=compactlist;
var $ontop='0';   // status members to be on top (0=none)

// --------

function cSection($aSection=null)
{
  if ( isset($aSection) )
  {
    if ( is_int($aSection) )
    {
      if ( $aSection<0 ) die('Wrong id in cSection');
      global $oDB;
      $oDB->Query('SELECT * FROM '.TABSECTION.' WHERE id='.$aSection);
      $row = $oDB->Getrow();
      if ( $row===False ) die('No section '.$aSection);
      $this->MakeFromArray($row);
    }
    elseif ( is_array($aSection) )
    {
      $this->MakeFromArray($aSection);
    }
    elseif ( strtolower(get_class($aSection))=='csection' )
    {
      $this->domid    = $aSection->domid;
      $this->domname  = $aSection->domname;
      $this->id       = $aSection->id;
      $this->idtitle  = $aSection->idtitle;
      $this->name     = $aSection->name;
      $this->descr    = $aSection->descr;
      $this->type     = $aSection->type;
      $this->status   = $aSection->status;
      $this->picture  = $aSection->picture;
      $this->vorder   = $aSection->vorder;
      $this->forder   = $aSection->forder;
      $this->modid    = $aSection->modid;
      $this->modname  = $aSection->modname;
      $this->members  = $aSection->members;
      $this->allowpic = $aSection->allowpic;
      $this->template = $aSection->template;
      $this->ontop    = $aSection->ontop;
    }
    else
    {
      die('Invalid constructor parametre #1 for the class cSection');
    }
  }
}

// --------

function MakeFromArray($arr)
{
  if ( !is_array($arr) ) die('Invalid argument for cSection->MakeFromArray');
  foreach ($arr as $strKey => $oValue) {
  switch ($strKey) {
    case 'domainid': $this->domid   = intval($oValue); break;
    case 'id':       $this->id      = intval($oValue); break;
    case 'title':    $this->idtitle = $oValue; break;
    case 'type':     $this->type    = intval($oValue); break;
    case 'status':   $this->status  = intval($oValue); break;
    case 'picture':  $this->picture = $oValue; break;
    case 'vorder':   $this->vorder  = intval($oValue); break;
    case 'forder':   $this->forder  = $oValue; if ( empty($this->forder) ) $this->forder = 'status_i;fullname;phones;emails;picture'; break;
    case 'modid':    $this->modid   = intval($oValue); break;
    case 'modname':  $this->modname = $oValue; break;
    case 'members':  $this->members = intval($oValue); break;
    case 'allowpic':  if ( $oValue=='N' ) $this->allowpic='N'; break;
    // not used (version 14)
    case 'template': $this->template = $oValue; break;
    case 'ontop':    $this->ontop    = $oValue; break;
  }}
  $this->name = ObjTrans('sec','s'.$this->id,$this->idtitle);
  $this->descr = ObjTrans('secdesc','s'.$this->id,false);
  $this->domname= ObjTrans('domain','d'.$this->domid,'(domain '.$this->domid.')');
}

// --------
// instanciate is allowed

function MoveContent($intSrc=null,$intDest=0,$bStats=true)
{
  if ( !isset($intSrc) ) $intSrc = $this->id;
  if ( $intSrc<0 || $intDest<0 ) die('Wrong idSrc in section->MoveContent');
  if ( $intSrc == $intDest )     die('Wrong idDest in section->MoveContent');

  // Move members
  global $oDB;
  $oDB->Query('UPDATE '.TABS2U." SET sid=$intDest WHERE sid=$intSrc");

  // Update stats
  $this->UpdateStats($intSrc);
  $this->UpdateStats($intDest);
}

// --------
// instanciate is allowed
// use id "all" to update all

function UpdateStats($id=null)
{
  global $oDB,$oSYS;
  if ( !isset($id) ) $id = $this->id;
  if ( $id=='all' )
  {
    foreach ($oSYS->sections as $s => $str)
    {
    $oDB->Query('SELECT count(*) as countid FROM '.TABS2U.' WHERE sid='.$s);
    $row = $oDB->Getrow();
    $oDB->Query( 'UPDATE '.TABSECTION.' SET members='.$row['countid'].' WHERE id='.$s );
    }
  }
  else
  {
    if ( $id<0 ) die('Wrong id in section->UpdateStats');
    $oDB->Query('SELECT count(*) as countid FROM '.TABS2U.' WHERE sid='.$id);
    $row = $oDB->Getrow();
    $oDB->Query( 'UPDATE '.TABSECTION.' SET members='.intval($row['countid']).' WHERE id='.$id );  
  }
}

// --------

function ShowInfo($strClassMain='',$strClassName='',$strClassDesc='',$strAlign='right',$strPictureUrl='',$qte_root='')
{
  echo '<!-- section description -->',N;
  echo '<table class="',$strClassMain,'" style="margin-bottom:10px"><tr class="',$strClassMain,'"><td class="',$strClassMain,'">';
  //echo '<div class="',$strClassMain,'">';
  if ( !empty($this->picture) )
  {
    echo AsImg($qte_root.$this->picture,'logo',$this->name,$strClassMain.'_'.$strAlign,'',$strPictureUrl);
  }
  if ( !is_null($strClassName) ) echo '<p class="',$strClassName,'">',$this->name,'</p>';
  if ( !is_null($strClassDesc) ) echo '<p class="',$strClassDesc,'">',$this->descr,'</p>';
  //echo '</div>',N;
  echo '</td></tr></table>';

  echo '<!-- end section description -->',N;
}

// --------

}

?>