<?php

/* ============
 * qt_lib_txt.php
 * ------------
 * version: 3.5 build:20090130
 * This is a library of public functions
 * ------------
 * QTastags()
 * QTcompactline()
 * QTbbc()
 * QTdatestr()
 * QTinvert()
 * QTislogin()
 * QTispassword()
 * QTismail()
 * QTisbetween()
 * QTisvaliddate()
 * ============ */

// AsTags
//
// Returns html blocks (ex: <option></option>) based on an array.
// @$arr, the array
// @$strFormat, a formatting string for the texts
// @$strSelectedValue, the value that must be selected
// @$strSelectedClass
// @$strCurrentValue, defines a current value (to apply a class)
// @$strCurrentClass
// @$strAllClass, a class that must be added to all tag.
// @$strTag, the tag (option by default)
// @$strName, the name attribute (for checkbox only)
// Note: If the array is an array of arrays, the option text will be the first element of the array

function QTastags($arr,$strFormat=null,$strSelectedValue=null,$strSelectedClass=null,$strCurrentValue=null,$strCurrentClass=null,$strAllClass=null,$strTag='option',$strName='',$onerror=null)
{
  // check

  if ( !is_array($arr) ) { if ( isset($onerror) ) return $onerror; die('QTastags: arg #1 must be an array'); }

  // process

  $strReturn = '';

  foreach ($arr as $strKey => $strValue)
  {
    $arrClasses = array();
    // value type and format
    if ( is_array($strValue) ) $strValue = reset($strValue);
    if ( isset($strFormat) ) $strValue = sprintf($strFormat,$strValue);
    // classes
    if ( isset($strAllClass) ) $arrClasses[] = $strAllClass;
    if ( isset($strSelectedValue) && $strSelectedValue==$strKey && isset($strSelecedClass) ) $arrClasses[] = $strSelectedClass;
    if ( isset($strCurrentValue) && $strCurrentValue==$strKey && isset($strCurrentClass) ) $arrClasses[]=$strCurrentClass;
    if ( count($arrClasses)>0 ) { $strClasses=' class="'.implode(' ',$arrClasses).'"'; } else { $strClasses=''; }
    // builder
    switch($strTag)
    {
    case 'option':
      if ( !isset($strSelectedValue) )
      {
      $strReturn .= '<option value="'.$strKey.'"'.$strClasses.'>'.$strValue.'</option>';
      }
      else
      {
      $strReturn .= '<option value="'.$strKey.'"'.$strClasses.($strSelectedValue==$strKey ? ' selected="selected"' : '').'>'.$strValue.'</option>';
      }
      break;
    case 'checkbox':
      if ( !isset($strSelectedValue) )
      {
      $strReturn .= '<input type="checkbox" name="'.$strName.'" value="'.$strKey.'"'.$strClasses.'/>'.$strValue;
      }
      else
      {
      $strReturn .= '<input type="checkbox" name="'.$strName.'" value="'.$strKey.'"'.$strClasses.($strSelectedValue==$strKey ? ' checked="checked"' : '').'/>'.$strValue;
      }
      break;
    case 'hidden':
      $strReturn .= '<input type="hidden" name="'.$strKey.'" value="'.$strValue.'"/>';
      break;
    default: die('QTastags only support option, and checkbox');
    }
  }
  return $strReturn;
}

// QTcompactline

function QTcompactline($str,$max=0,$onerror=null)
{
  // check

  if ( !is_string($str) ) { if ( isset($onerror) ) return $onerror; die('QTcompactline: arg #1 must be a string'); }
  if ( !is_numeric($max) ) { if ( isset($onerror) ) return $onerror; die('QTcompactline: arg #2 must be a number (or a number as string'); }

  // process

  if ($max>0) $str=substr($str,0,$max);
  $str = str_replace("\r\n\r\n\r\n", "\r\n", $str);
  $str = str_replace("\r\n\r\n", "\r\n", $str);
  if ( strpos($str,'[')!==FALSE )
  {
  $str = str_replace("[/quote]\r\n", '[/quote]', $str);
  $str = str_replace("[/code]\r\n", '[/code]', $str);
  }
  return $str;
}

/**
 * QTdatestr
 *
 * Convert a date [string] to a formatted date [string] and translate it.
 *
 * @$strDate    The date string, can be 'YYYYMMDD[HH][MM][SS]' or 'now'. It can include [.][/][-][ ]
 * @$strOutDate The format for the date (or '$' to use the system format)
 * @$strOutTime The format for the time (or '$' to use the system format). If not empty, it is added to the date format (or to the short date)
 * @$bShort     Use short date 'Today','Yesterday' when possible.
 *
 * When $strDate is '0' or empty, this function returns '' (an empty string).
 * Other $strDate patterns will issue a fatal error.
 * The translation uses $L['dateSQL'], if existing, and the default php words if not.
 */

function QTdatestr($strDate='now',$strOutDate='$',$strOutTime='$',$bShort=true)
{
  // Check arguments
  
  if ( !is_string($strDate) )    die('QTdatestr: argument #1 must be a string.');
  if ( !is_string($strOutDate) ) die('QTdatestr: argument #2 must be a string.');
  if ( !is_string($strOutTime) ) die('QTdatestr: argument #3 must be a string.');
  if ( !is_bool($bShort) )       die('QTdatestr: argument #4 must be a boolean.');
  if ( $strOutDate=='$' )
  {
    $strOutDate='Ymd'; // date format cannot be empty
    if ( isset($_SESSION[QT]['formatdate']) ) {
    if ( !empty($_SESSION[QT]['formatdate']) ) {
      $strOutDate=$_SESSION[QT]['formatdate'];
    }}
  }
  if ( $strOutTime=='$' )
  {
    $strOutTime='';  // time format can be empty
    if ( isset($_SESSION[QT]['formattime']) ) {
    if ( !empty($_SESSION[QT]['formattime']) ) {
      $strOutTime=$_SESSION[QT]['formattime'];
    }}
  }
  
  // Clean $strDate
  
  if ( empty($strDate) ) return '';
  if ( $strDate=='now' ) $strDate = date('YmdHi');
  if ( strpos($strDate,' ') ) $strDate = str_replace(' ','',$strDate);
  if ( strpos($strDate,'-') ) $strDate = str_replace('-','',$strDate);
  if ( strpos($strDate,'.') ) $strDate = str_replace('.','',$strDate);
  if ( strpos($strDate,'/') ) $strDate = str_replace('/','',$strDate);

  // Read $strDate
  
  $intDate = FALSE;

  switch(strlen($strDate) )
  {
  case 8:  $intDate = mktime(0,0,0,substr($strDate,4,2),substr($strDate,6,2),substr($strDate,0,4)); break;
  case 10: $intDate = mktime(substr($strDate,-2,2),0,0,substr($strDate,4,2),substr($strDate,6,2),substr($strDate,0,4)); break;
  case 12: $intDate = mktime(substr($strDate,-4,2),substr($strDate,-2,2),0,substr($strDate,4,2),substr($strDate,6,2),substr($strDate,0,4)); break;
  case 14: $intDate = mktime(substr($strDate,-6,2),substr($strDate,-4,2),substr($strDate,-2,2),substr($strDate,4,2),substr($strDate,6,2),substr($strDate,0,4)); break;
  }
  
  if ( $intDate===FALSE ) return "Cannot make date from [$strDate]";
  
  // Output format
  
  $strDate = date($strOutDate.(empty($strOutTime) ? '' : ' '.$strOutTime),$intDate);

  // Short date
  
  if ( $bShort )
  {
  $strT = date('Y-m-d',$intDate);
  $strY = date('Y-m-d',$intDate+86400);
  if ( date('Y-m-d')==$strT ) $strDate = 'Today'.(empty($strOutTime) ? '' : ' '.date($strOutTime,$intDate));
  if ( date('Y-m-d')==$strY ) $strDate = 'Yesterday'.(empty($strOutTime) ? '' : ' '.date($strOutTime,$intDate));
  }

  // Translating
  
  global $L;
  if ( isset($L['dateSQL']) ) {
  if ( is_array($L['dateSQL']) ) {
    $strDate = str_replace(array_keys($L['dateSQL']),array_values($L['dateSQL']),$strDate);
  }}

  // Exit
  
  return $strDate;
}

/* ============
 * QTbbc
 * ------------
 * Convert bbc to html (or drop bbc).
 * Attention: It also converts < and >, and does NOT perform a striptags (html code will remains "readable")
 * ------------
 * $str       : [mandatory] a string than can contains bbc tags
 * $output    : 'html' to convert the bbc tags to html tags
 *            : 'drop' to remove the bbc tags (and smiles)
 *            : 'deepdrop' to remove the bbc tags and the Cite/Code tags arround the Quote/Code blocs
 * $nl        : convert \r\n, \r or \n to $nl. Use FALSE to not convert.
 * $length    : truncate at length $length. Use 0 to not truncate.
 * $beforediv : (optional) tag to use before a bloc ([quote] or [code])
 * $afterdiv  : (optional) tag to use after a bloc ([quote] or [code])
 * ------------
 * Examples
 * QTbbc( '[b]Text[/b]',       'html' )  -->   <b>Text</b>
 * QTbbc( '[i]<b>Text<b>[/i]', 'html' )  -->   <i>&lt;b&gt;Text&lt;/b&gt;</i>
 * QTbbc( '[u]Text[/u]',       'drop' )  -->   Text
 * QTbbc( '[u]<b>Text<b>[/u]', 'drop' )  -->   &lt;b&gt;Text&lt;/b&gt;
 * ------------
 * Remarks
 * 'drop'     will convert '[quote]hello[/quote]' into 'Quotation: <cite>hello</cite>'
 * 'deepdrop' will convert '[quote]hello[/quote]' into 'hello'
 * Same principle for for the bbc [code]
 * For css users, output 'html' will convert the bbc quote,code,smile into a object having classes named quote, code, imgmsg,...
 * ============ */

function QTbbc($str,$output='html',$nl='<br/>',$length=0, $beforediv='', $afterdiv='', $onerror=null)
{
  // check

  if ( !is_string($str) ) { if ( isset($onerror) ) return $onerror; die('QTbbc: arg #1 must be a string'); }
  if ( !in_array($output,array('html','drop','deepdrop')) ) { if ( isset($onerror) ) return $onerror; die('QTbbc: arg #2 must be "html", "drop" or "deepdrop"'); }
  if ( !is_string($nl) ) { if ( isset($onerror) ) return $onerror; die('QTbbc: arg #3 must be a string'); }

  // process

  $arrSearch = array (
  '/</',
  '/>/',
  '/\[b\](.*?)\[\/b\]/',
  '/\[i\](.*?)\[\/i\]/',
  '/\[u\](.*?)\[\/u\]/',
  '/\[\*\]/',
  '/\[img\](.*?)\[\/img\]/',
  '/\[url\](.*?)\[\/url\]/',
  '/\[url\=(.*?)\](.*?)\[\/url\]/',
  '/\[mail\](.*?)\[\/mail\]/',
  '/\[mail\=(.*?)\](.*?)\[\/mail\]/',
  '/\[color\=(.*?)\](.*?)\[\/color\]/',
  '/\[size=(.*?)\](.*?)\[\/size\]/',
  '/\[quote\]/',
  '/\[quote\=(.*?)\]/',
  '/\[\/quote\]/',
  '/\[code\]/',
  '/\[\/code\]/');

  switch ($output)
  {

  case 'html' :
    $arrReplace = array (
    '&lt;',
    '&gt;',
    '<b>$1</b>',
    '<i>$1</i>',
    '<span class="u">$1</span>',
    '&bull;',
    '<div class="imgmsg"><img class="imgmsg" src="$1" alt="[image]" title=""/></div>',
    '<a class="msgbody" href="http://$1" target="_blank">$1</a>',
    '<a class="msgbody" href="http://$2" target="_blank">$1</a>',
    '<a class="msgbody" href="mailto:$1">$1</a>',
    '<a class="msgbody" href="mailto:$2">$1</a>',
    '<font color="$1">$2</font>',
    '<span style="font-size:$1pt">$2</span>',
    $beforediv.'<div class="quotetitle">Quotation:</div><div class="quote">',
    '<div class="quotetitle">Quotation by $1:</div><div class="quote">',
    '</div>'.$afterdiv,
    $beforediv.'<div class="codetitle">Code:</div><div class="code">',
    '</div>'.$afterdiv);
    break;

  case 'drop' :
    $arrReplace = array(
    '&lt;','&gt;',
    '$1','$1','$1','$1','$1','$1','$1','$1','$1','$1','$1',
    'Quotation: ','Quotation by $1:','',
    'Code: ','');

  case 'deepdrop' :
    $arrReplace = array(
    '&lt;','&gt;',
    '$1','$1','$1','$1','$1','$1','$1','$1','$1','$1','$1',
    '','','','','');
  }

  $str = preg_replace( $arrSearch, $arrReplace, $str );
  $str = str_replace( array('http://http','http://ftp:','http://mailto:','mailto:mailto:'), array('http','ftp:','mailto:','mailto'), $str ); // special check for the href error
  if ( is_string($nl) ) $str = str_replace( array("\r\n","\r","\n"), $nl, $str );

  if ( is_numeric($length) ) {
  if ( $length>0 ) {
  if ( strlen($str)>$length ) {
    $str = substr($str,0,$length).' ...';
  }}}

  return $str;
}

/* ============
 * QTconv
 * ============ */

function QTconv($str,$to='1',$bConvAmp=false,$bDroptags=true,$onerror=null)
{
  if ( !is_string($str) ) { if ( isset($onerror) ) return $onerror; die('QTconv: arg #1 must be a string'); }
  if ( empty($str) ) return $str;
  if ( !is_string($to) ) { if ( isset($onerror) ) return $onerror; die('QTconv: arg #2 must be a string'); }
  if ( !is_bool($bConvAmp) ) { if ( isset($onerror) ) return $onerror; die('QTconv: arg #3 must be a boolean'); }
  if ( !is_bool($bDroptags) ) { if ( isset($onerror) ) return $onerror; die('QTconv: arg #4 must be a boolean'); }

  // optional drop tags

  if ( $bDroptags ) $str = strip_tags($str);

  // optional force convert & (to disallow symbol)

  if ( $to=='3' && $bConvAmp ) $to='4';

  // U special for username and password
  // I special for input form: convert & to &amp; but not &quote; nor &#039;
  // 1 converts "          // -1 converts &quot;
  // 2 converts " '        // -2 converts &quot; &#039;
  // 3 converts " ' < >    // -3 converts &quot; &#039; &lt; &gt;
  // 4 converts " ' < > &  // -4 converts &quot; &#039; &lt; &gt; &amp;
  // 5 converts to htmlentities but restore the &amp; > &
  // 6 converts to htmlentities
  // K special for keycode
  // F special for filename
  // T convert to time HHMMSS (from HHMM,HH:MM[:SS],...) add 00 if no second

  switch ($to)
  {
  case 'U':
    return substr(htmlspecialchars(trim($str),ENT_QUOTES),0,24);
    break;
  case 'I':
    if ( strstr($str,'&') )
    {
    $str = str_replace('&','&amp;',$str);
    $str = str_replace('&amp;quot;','&quot;',$str);
    $str = str_replace('&amp;#039;','&#039;',$str);
    }
    break;
  case '1':
    $str = str_replace('"','&quot;',$str);
    break;
  case '2':
    $str = str_replace('"','&quot;',$str);
    $str = str_replace("'",'&#039;',$str);
    break;
  case '3':
    $str = str_replace('"','&quot;',$str);
    $str = str_replace("'",'&#039;',$str);
    $str = str_replace('<','&lt;',$str);
    $str = str_replace('>','&gt;',$str);
    break;
  case '4':
    $str = htmlspecialchars($str,ENT_QUOTES);
    break;
  case '5':
    $str = htmlentities($str,ENT_QUOTES);
    if ( strstr($str,'&') ) $str = str_replace('&amp;','&', $str);
    break;
  case '6':
    $str = htmlentities($str,ENT_QUOTES);
    break;
  case '-1':
    $str = str_replace('&quot;','"',$str);
    break;
  case '-2':
    $str = str_replace('&quot;','"',$str);
    $str = str_replace('&#039;',"'",$str);
    break;
  case '-3':
    $str = str_replace('&quot;','"',$str);
    $str = str_replace('&#039;',"'",$str);
    $str = str_replace('&lt;','<',$str);
    $str = str_replace('&gt;','>',$str);
    break;
  case '-4':
    $str = str_replace('&quot;','"', $str);
    $str = str_replace('&#039;',"'", $str);
    if ( strstr($str,'&') )
    {
    $str = str_replace('&amp;','&', $str);
    $str = str_replace('&#39;',"'", $str);
    $str = str_replace('&lt;','<', $str);
    $str = str_replace('&gt;','>', $str);
    }
    break;
  case 'K':
    $str=strtr($str,'','eeeeeeeeaaaaaaaaaaiiiiiiiioooooooooouuuuuuuu');
    $str=strtolower($str);
    $str=preg_replace('/[^a-z0-9_\-\.]/i', '_', $str);
    break;
  case 'T':
    $str = strtr(trim($str),':,.;-HhMmSsUu','             ');
    if ( !strstr(trim($str),' ') && strlen($str)>5 ) $str = substr($str,0,2).' '.substr($str,2,2).' '.substr($str,-2,2);
    if ( !strstr(trim($str),' ') && strlen($str)>3 ) $str = substr($str,0,2).' '.substr($str,2,2);
    $arr = explode(' ',$str);
    $str = $arr[0].$arr[1].(count($arr)>2 ? $arr[2] : '00');
    break;
  }
  if ( strlen($str)>4000 ) $str = substr($str,0,4000);
  return trim($str);
}

/* ============
 * QTinvert
 * ------------
 * This will invert a value (see the list in the code). Return NULL for unknown values.
 * Value must be uppercase
 * ============ */

function QTinvert($str,$onerror=null)
{
  switch($str)
  {
  case 'ASC':  return 'DESC'; break;
  case 'DESC': return 'ASC';  break;
  case 'Y':    return 'N';    break;
  case 'N':    return 'Y';    break;
  case 'YES':  return 'NO';   break;
  case 'NO':   return 'YES';  break;
  case '1':    return '0';    break;
  case '0':    return '1';    break;
  case 1:      return 0;      break;
  case 0:      return 1;      break;
  }
  return NULL;
}

/* ============
 * QTispassword / islogin / ismail /isbetween / isvaliddate
 * ------------
 * These functions shows an error message when the principal argument(s) is not of the correct type.
 * About login/password:
 *   Return FALSE if the text is not trimmed
 *   Return FALSE when text includes unacceptable characters
 *     a login can contain the ' caracter while a password cannot.
 *     both login and password cannot contain " < > \ /
 *     for caracters after z, only a few accents are supported .
 * About validdate:
 *   This function will check date like YYYYMMDD (as string or as number). Options allow also to rejet past/futur year.
 * ============ */

function QTislogin($str,$intMin=4,$intMax=24,$onerror=null)
{
  if ( !is_string($str) ) { if ( isset($onerror) ) return $onerror; die('QTislogin: arg #1 must be a string'); }
  if ( !is_numeric($intMin) ) { if ( isset($onerror) ) return $onerror; die('QTislogin: arg #2 must be a numeric'); }
  if ( !is_numeric($intMax) ) { if ( isset($onerror) ) return $onerror; die('QTislogin: arg #3 must be a numeric'); }

  if ( $str!=trim($str) ) return false;
  if ( strstr($str,'\\') ) return false; //' check this
  if ( strstr($str,'<') ) return false;
  if ( strstr($str,'>') ) return false;
  if ( !ereg('^[#-z ߧ\!]+$',$str) ) return false;
  if ( $str!=strip_tags($str) ) return false;
  if ( strlen($str)>$intMax ) return false;
  if ( strlen($str)<$intMin ) return false;
  return true;
}
function QTispassword($str,$intMin=4,$intMax=24,$onerror=null)
{
  if ( !is_string($str) ) { if ( isset($onerror) ) return $onerror; die('QTispassword: arg #1 must be a string'); }
  if ( !is_numeric($intMin) ) { if ( isset($onerror) ) return $onerror; die('QTispassword: arg #2 must be a numeric'); }
  if ( !is_numeric($intMax) ) { if ( isset($onerror) ) return $onerror; die('QTispassword: arg #3 must be a numeric'); }

  // password cannot contain apostrophe while login can
  if ( strstr($str,"'") ) return false;
  // uses QTislogin
  if ( !QTislogin($str,$intMin,$intMax,$onerror) ) return false;
  return true;
}
function QTismail($str,$onerror=null)
{
  if ( !is_string($str) ) { if ( isset($onerror) ) return $onerror; die('QTismail: arg #1 must be a string'); }

  if ( $str!=trim($str) ) return false;
  if ( $str!=strip_tags($str) ) return false;
  if ( !ereg('^.+@.+\..+$',$str) ) return false;
  return true;
}
function QTisbetween($intValue,$intMin=0,$intMax=99999,$onerror=null)
{
  if ( $intValue=='') return false;
  if ( !is_numeric($intValue) ) { if ( isset($onerror) ) return $onerror; die('QTisbetween: arg #1 must be a numeric (or a number as string)'); }
  if ( !is_numeric($intMin) ) { if ( isset($onerror) ) return $onerror; die('QTisbetween: arg #2 must be a numeric (or a number as string)'); }
  if ( !is_numeric($intMax) ) { if ( isset($onerror) ) return $onerror; die('QTisbetween: arg #3 must be a numeric (or a number as string)'); }

  if ( $intValue<$intMin ) return false;
  if ( $intValue>$intMax ) return false;
  return true;
}
function QTisvaliddate($d,$bPast=true,$bFutur=false,$onerror=null) // allow past year, disallow futur year
{
  if ( is_string($d) ) { if ( substr($d,0,6)=='Cannot' ) return false; }
  if ( !is_numeric($d) ) { if ( isset($onerror) ) return $onerror; die('QTisvaliddate: arg #1 must be a number like YYYYMMDD (as number or as string)'); }
  if ( !is_bool($bPast) ) { if ( isset($onerror) ) return $onerror; die('QTisvaliddate: arg #2 must be a bolean'); }
  if ( !is_bool($bFutur) ) { if ( isset($onerror) ) return $onerror; die('QTisvaliddate: arg #3 must be a bolean'); }

  $str = strval($d);
  if ( strlen($str)!=8 ) { if ( isset($onerror) ) return $onerror; die('QTisvaliddate: arg #1 must be a number like YYYYMMDD (as number or as string)'); }
  $intY = intval(substr($str,0,4));
  $intM = intval(substr($str,4,2));
  $intD = intval(substr($str,-2,2));
  if ( $intY<1900 ) return false;
  if ( $intM<1 || $intM>12 ) return false;
  if ( $intD<1 || $intD>31 ) return false;
  if ( !$bPast ) { if ( $intY<date('Y') ) return false; }
  if ( !$bFutur ) { if ( $intY>date('Y') ) return false; }
  if ( !checkdate($intM,$intD,$intY) ) return false;
  return true;
}
function QTisvalidtime($d,$onerror=null)
{
  if ( is_string($d) ) { if ( substr($d,0,6)=='Cannot' ) return false; }
  if ( !is_numeric($d) ) { if ( isset($onerror) ) return $onerror; die('QTisvaliddate: arg #1 must be a time like HHMM or HHMMSS (as number or as string)'); }

  $d = strval($d);
  if ( strlen($d)!=4 && strlen($d)!=6 ) { if ( isset($onerror) ) return $onerror; die('QTisvaliddate: arg #1 must be a time like HHMM or HHMMSS (as number or as string)'); }
  if ( !QTisbetween(substr($d,0,2),0,23) ) return false;
  if ( !QTisbetween(substr($d,2,2),0,59) ) return false;
  if ( strlen($d)==6 ) { if ( !QTisbetween(substr($d,4,2),0,59) ) return false; }
  return true;
}

?>