<?php

/* ============
 * qt_lib_graph.php
 * ------------
 * version: 2.5 build:20080805
 * This is a library of public class
 * ------------
 * QTsimplegraph()
 * ------------
 * NOTE:
 * the function row_count have been removed because it is not supported by odbc
 * ============ */

// @arrValues: Array of values. Use the index as label). Maximum 55 values.
// @bCumul: Show as cumulative
// @intWidth: Width of the whole graph (in pixel).
// @intHeight: Maximum height of the bars (in pixel).
// @intLabel: Add the labels (n characters) at the bottom of the bars. 0 means no label
// @bValue: Add the value (or prercent) on top of the bars. [False|True|"P"]
// @strTitle: Add a title on top
// @strSeriename: Add a seriename at the bottom

function QTsimplegraph($arrValues=array('A'=>100,'B'=>20,'C'=>30,'D'=>50,'E'=>0),$bCumul=false,$intWidth=100,$intHeight=100,$intLabel=2,$bValue=true,$strTitle='',$strSeriename='',$onerror=null)
{

  // CHECKS

  if ( !is_array($arrValues) ) { if ( isset($onerror) ) return $onerror; return 'Arg #1 must be an array'; }

  $intCount = count($arrValues);
  if ( $intCount>55 ) { if ( isset($onerror) ) return $onerror; return 'maxumum 55 values...'; }
  if ( $intWidth<50 ) { if ( isset($onerror) ) return $onerror; return 'minimum width:50px...'; }
  $intColwidth = intval( ($intWidth-10)/$intCount );
  $intTotal = array_sum($arrValues);
  if ( $bCumul )
  {
    $i=0;
    foreach ( $arrValues as $strKey => $aValue )
    {
      $i += $aValue;
      $arrValues[$strKey]=$i;
    }
  }
  $intMax = max($arrValues);
  $arrPercents = array_map( create_function('$n', 'return ($n==0 ? 0 : $n/'.$intTotal.');'), $arrValues );
  $arrPercmaxs = array_map( create_function('$n', 'return ($n==0 ? 0 : $n/'.$intMax.');'), $arrValues );

  // START GRAPH

  echo '<table cellspacing="0" class="qtgraph" style="width:',$intWidth,'px">',N;

  // TITLE

  if ( !empty($strTitle) )
  {
    echo '<tr class="qtgraph_title">',N;
    echo '<td class="qtgraph_title" colspan="',$intCount,'">',$strTitle,'</td>',N;
    echo '</tr>',N;
  }

  // VALUES

  if ( $bValue )
  {
    echo '<tr class="qtgraph_value">',N;
    if ( $bValue==='P' )
    {
      foreach ($arrPercents as $iPercent)
      {
      echo '<td class="qtgraph_value">',intval($iPercent*100),'%</td>',N;
      }
    }
    else
    {
      foreach ($arrValues as $iValue)
      {
      echo '<td class="qtgraph_value">',$iValue,'</td>',N;
      }
    }
    echo '</tr>',N;
  }

  // BARS

  echo '<tr class="qtgraph_bar">',N;
  if ( $bValue==='P' )
  {
    foreach ($arrPercents as $iPercent)
    {
      $intPx = intval($iPercent*$intHeight); if ( $intPx==0 ) $intPx=1;
      echo '<td class="qtgraph_bar" style="height:',$intHeight,'px;">';
      echo '<img class="qtgraph_bar" src="bin/qt_lib_graph.gif" style="width:',$intColwidth,'px; height:',$intPx,'px;"/>';
      echo '</td>',N;
    }
  }
  else
  {
    foreach ($arrPercmaxs as $iPercent)
    {
      $intPx = intval($iPercent*$intHeight); if ( $intPx==0 ) $intPx=1;
      echo '<td class="qtgraph_bar" style="height:',$intHeight,'px;">';
      echo '<img class="qtgraph_bar" src="bin/qt_lib_graph.gif" style="width:',$intColwidth,'px; height:',$intPx,'px;"/>';
      echo '</td>',N;
    }
  }

  echo '</tr>';

  // LABELS

  if ( $intLabel>0 )
  {
    echo '<tr class="qtgraph_label">',N;
    foreach ($arrValues as $strLabel => $iValue)
    {
    echo '<td class="qtgraph_label">',substr($strLabel,0,$intLabel),'</td>',N;
    }
    echo '</tr>',N;
  }

  // SERIENAME

  if ( !empty($strSeriename) )
  {
    echo '<tr class="qtgraph_serie">',N;
    echo '<td class="qtgraph_serie" colspan="',$intCount,'">',$strSeriename,'</td>',N;
    echo '</tr>',N;
  }

  echo '</table>';

}

?>